/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.rule;

import com.newtouch.base.model.DsnRules;
import com.newtouch.nms.sip.model.DsnStructureRules;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.rule.RuleInfo;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;

public class StructureRule
implements Comparable {
    private DsnStructureRules structureRule;
    private RuleInfo ruleInfo;

    public StructureRule load(DsnStructureRules dsnStructureRules) {
        this.structureRule = dsnStructureRules;
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        String ruleId = "Y".equals(this.structureRule.getIsQuote()) ? this.structureRule.getQuoteRuleId() : this.structureRule.getRuleId();
        DsnRules rule = utils.queryRuleByRuleId(ruleId);
        RuleInfo info = new RuleInfo();
        if (rule != null) {
            this.ruleInfo = info.load(rule);
        }
        return this;
    }

    public void merge(StructureRule ruleNode) {
        this.structureRule = ProductEqualsUtils.merge(this.structureRule, ruleNode.getStructureRule());
        this.ruleInfo = ProductEqualsUtils.merge(this.ruleInfo, ruleNode.getRuleInfo(), RuleInfo.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        update.update((AbsModel)this.structureRule);
        if (this.ruleInfo != null) {
            this.ruleInfo.save();
        }
    }

    public TreeNode fetchTreeNode() {
        TreeNode node = new TreeNode(CompareEnum.NodeType.RULE_DETAIL.getTag() + this.structureRule.getSerno(), CompareEnum.NodeType.RULE_DETAIL.getLable());
        if (this.structureRule != null) {
            node.getChildren().add(new TreeNode(this.structureRule.getSerno(), this.structureRule, CompareEnum.NodeType.STRUCTURE));
        }
        if (this.ruleInfo != null) {
            node.getChildren().add(this.ruleInfo.fetchTreeNode());
        }
        return node;
    }

    public DsnStructureRules getStructureRule() {
        return this.structureRule;
    }

    public void setStructureRule(DsnStructureRules structureRule) {
        this.structureRule = structureRule;
    }

    public RuleInfo getRuleInfo() {
        return this.ruleInfo;
    }

    public void setRuleInfo(RuleInfo ruleInfo) {
        this.ruleInfo = ruleInfo;
    }

    public int hashCode() {
        return this.structureRule.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        ProductUpdateUtils.UpdateFlag flag = (ProductUpdateUtils.UpdateFlag)((Object)this.structureRule.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        if (flag == ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

