/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.rule;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.transfer.domain.rule.RuleNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class InitRule {
    private DsnStructure initRule;
    private List<RuleNode> ruleList;

    String getRuleType() {
        return NodeType.INIT_RULE.code();
    }

    public InitRule load(String upNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.initRule = utils.queryStructure(upNode, this.getRuleType());
        if (this.initRule == null) {
            return this;
        }
        List<DsnStructure> ruleStructureList = utils.queryStructures(this.initRule.getNodeNo());
        this.ruleList = new ArrayList<RuleNode>();
        for (DsnStructure ruleStructure : ruleStructureList) {
            RuleNode ruleNode = new RuleNode();
            ruleNode.load(ruleStructure);
            this.ruleList.add(ruleNode);
        }
        return this;
    }

    public void merge(InitRule rule) {
        this.initRule = ProductEqualsUtils.merge(this.initRule, rule.getInitRule());
        this.ruleList = ProductEqualsUtils.merge(this.ruleList, rule.getRuleList(), RuleNode.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.initRule);
        }
        if (this.ruleList != null) {
            this.ruleList.forEach(ruleNode -> ruleNode.save());
        }
    }

    public DsnStructure getInitRule() {
        return this.initRule;
    }

    public void setInitRule(DsnStructure initRule) {
        this.initRule = initRule;
    }

    public List<RuleNode> getRuleList() {
        return this.ruleList;
    }

    public void setRuleList(List<RuleNode> ruleList) {
        this.ruleList = ruleList;
    }
}

