/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.attribute.Attribute;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class RiskDetail {
    private DsnStructure riskDetail;
    private List<Attribute> attributeList = new ArrayList<Attribute>();
    private SipRisks risk;

    public RiskDetail load(String upNode) {
        return this.load(upNode, NodeType.N_RISK_DETAIL.code());
    }

    public RiskDetail load(String upNode, String detailType) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.riskDetail = utils.queryStructure(upNode, detailType);
        if (this.riskDetail == null) {
            return this;
        }
        utils.queryStructures(this.riskDetail.getNodeNo()).forEach(dsnAttr -> {
            Attribute attr = new Attribute();
            attr.load((DsnStructure)dsnAttr);
            this.attributeList.add(attr);
        });
        this.risk = utils.queryRisk(this.riskDetail.getNodeNo());
        return this;
    }

    public void merge(RiskDetail detail) {
        this.riskDetail = ProductEqualsUtils.merge(this.riskDetail, detail.getRiskDetail());
        this.attributeList = ProductEqualsUtils.merge(this.attributeList, detail.getAttributeList(), Attribute.class);
        this.risk = ProductEqualsUtils.merge(this.risk, detail.getRisk());
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.riskDetail != null && !ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.riskDetail);
        }
        if (this.attributeList != null && !ProductEqualsUtils.isPropose(source)) {
            this.attributeList.forEach(attr -> attr.save());
        }
        if (this.risk != null && !ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.risk);
        }
    }

    public TreeNode fetchTreeNode() {
        if (this.riskDetail == null) {
            return null;
        }
        TreeNode node = new TreeNode(CompareEnum.NodeType.DETAIL.getTag() + this.riskDetail.getSerno(), CompareEnum.NodeType.DETAIL.getLable());
        node.getChildren().add(new TreeNode(this.riskDetail.getSerno(), this.riskDetail, CompareEnum.NodeType.STRUCTURE));
        if (this.attributeList != null && this.attributeList.size() > 0) {
            TreeNode riskAttr = new TreeNode(CompareEnum.NodeType.ATTRIBUTES.getTag() + this.riskDetail.getSerno(), CompareEnum.NodeType.ATTRIBUTES.getLable());
            node.getChildren().add(riskAttr);
            this.attributeList.forEach(attr -> riskAttr.getChildren().add(attr.fetchTreeNode()));
        }
        node.getChildren().add(new TreeNode(this.risk.getSerno(), this.risk, CompareEnum.NodeType.INFO));
        return node;
    }

    public DsnStructure getRiskDetail() {
        return this.riskDetail;
    }

    public void setRiskDetail(DsnStructure riskDetail) {
        this.riskDetail = riskDetail;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<Attribute> attributeList) {
        this.attributeList = attributeList;
    }

    public SipRisks getRisk() {
        return this.risk;
    }

    public void setRisk(SipRisks risk) {
        this.risk = risk;
    }
}

