/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.transfer.domain.risk.LiabilityRisk;
import com.newtouch.nms.sip.product.transfer.domain.risk.LiabilityRiskNode;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;

public class ExemptRisk
extends LiabilityRisk {
    private LiabilityRiskNode liabilityNode;

    @Override
    public ExemptRisk load(DsnStructure riskNode) {
        super.load(riskNode);
        this.liabilityNode = new LiabilityRiskNode();
        this.liabilityNode.setRisk(this.getBaseRisk());
        this.liabilityNode.load(this.getRiskNode().getNodeNo());
        return this;
    }

    public void merge(ExemptRisk exemptRisk) {
        super.merge(exemptRisk);
        this.liabilityNode = ProductEqualsUtils.merge(this.liabilityNode, exemptRisk.getLiabilityNode(), LiabilityRiskNode.class);
    }

    @Override
    public void save() {
        super.save();
        if (this.liabilityNode != null && !this.isOnlyReslation()) {
            this.liabilityNode.save();
        }
    }

    @Override
    public TreeNode fetchTreeNode() {
        TreeNode treeNode = super.fetchTreeNode();
        treeNode.getChildren().add(this.liabilityNode.fetchTreeNode());
        return treeNode;
    }

    @Override
    public String detailNodeType() {
        return NodeType.N_RISK_DETAIL.code();
    }

    public LiabilityRiskNode getLiabilityNode() {
        return this.liabilityNode;
    }

    public void setLiabilityNode(LiabilityRiskNode liabilityNode) {
        this.liabilityNode = liabilityNode;
    }
}

