/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.risk.AccyRisk;
import com.newtouch.nms.sip.product.transfer.domain.risk.LiabilityRisk;
import com.newtouch.nms.sip.product.transfer.domain.risk.Risk;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class AccyRiskNode {
    private Risk risk;
    private DsnStructure accyRiskNode;
    private List<AccyRisk> accyRiskList;

    public AccyRiskNode load(String upNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.accyRiskNode = utils.queryStructure(upNode, "n_accy_risks");
        if (this.accyRiskNode != null) {
            List<DsnStructure> dsnAccyRiskList = utils.queryStructures(this.accyRiskNode.getNodeNo());
            this.accyRiskList = new ArrayList<AccyRisk>();
            for (DsnStructure accyRisk : dsnAccyRiskList) {
                AccyRisk risk = new AccyRisk();
                risk.setMainRisk(this.risk);
                risk.load(accyRisk);
                this.accyRiskList.add(risk);
            }
        }
        return this;
    }

    public void merge(AccyRiskNode accyRiskNode) {
        this.accyRiskNode = ProductEqualsUtils.merge(this.accyRiskNode, accyRiskNode.getAccyRiskNode());
        this.accyRiskList = ProductEqualsUtils.merge(this.accyRiskList, accyRiskNode.getAccyRiskList(), AccyRisk.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.accyRiskNode);
        }
        if (this.accyRiskList != null) {
            this.accyRiskList.forEach(risk -> risk.save());
        }
    }

    public TreeNode fetchTreeNode() {
        if (this.accyRiskNode == null) {
            return null;
        }
        TreeNode treeNode = new TreeNode(CompareEnum.NodeType.ACCY_RISK.getTag() + this.accyRiskNode.getSerno(), CompareEnum.NodeType.ACCY_RISK.getLable());
        treeNode.getChildren().add(new TreeNode(this.accyRiskNode.getSerno(), this.accyRiskNode, CompareEnum.NodeType.STRUCTURE));
        if (this.accyRiskList != null && this.accyRiskList.size() > 0) {
            TreeNode accyRiskList = new TreeNode(CompareEnum.NodeType.ACCY_RISK_ARRAY.getTag() + this.accyRiskNode.getSerno(), CompareEnum.NodeType.ACCY_RISK_ARRAY.getLable());
            treeNode.getChildren().add(accyRiskList);
            for (LiabilityRisk liabilityRisk : this.accyRiskList) {
                accyRiskList.getChildren().add(liabilityRisk.fetchTreeNode());
            }
        }
        return treeNode;
    }

    public void setRisk(Risk risk) {
        this.risk = risk;
    }

    public Risk getRisk() {
        return this.risk;
    }

    public DsnStructure getAccyRiskNode() {
        return this.accyRiskNode;
    }

    public void setAccyRiskNode(DsnStructure accyRiskNode) {
        this.accyRiskNode = accyRiskNode;
    }

    public List<AccyRisk> getAccyRiskList() {
        return this.accyRiskList;
    }

    public void setAccyRiskList(List<AccyRisk> accyRiskList) {
        this.accyRiskList = accyRiskList;
    }
}

