/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.schedul;

import com.newtouch.nms.sip.product.schedul.IScheduledFunction;
import com.uniapis.cache.redis.RedisPasswordDecode;
import com.uniapis.logger.Ulog;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTaskUtils {
    @Autowired
    private RedisPasswordDecode decode;
    @Autowired
    private RedissonClient redissonClient;

    public void addTask(String lockKey, int waitTimeout, int leaseTime, IScheduledFunction function) {
        RLock rLock = this.redissonClient.getLock(lockKey);
        try {
            boolean res = rLock.tryLock((long)waitTimeout, (long)leaseTime, TimeUnit.SECONDS);
            if (res) {
                function.scheduledTaskFunction();
            }
        }
        catch (Exception e) {
            Ulog.info((String)("\u6355\u83b7\u5f02\u5e38" + e.getMessage()));
            e.printStackTrace();
            throw new RuntimeException("aquire lock fail");
        }
        finally {
            if (rLock != null && rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }
}

