/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.rate.controller;

import com.newtouch.nms.sip.design.tree.services.IPublicTreeService;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.rate.services.IRateService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.utils.JsonUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RateController {
    @Autowired
    private IPublicTreeService pubTree;
    @Autowired
    private IRateService rateService;

    @RequestMapping(value={"/goRateDetail.do"})
    public String goRateDetailQuery(HttpServletRequest request, HttpServletResponse response, Model model) {
        DsnStructure node = (DsnStructure)RequestUtils.getRequestMap((HttpServletRequest)request, DsnStructure.class);
        ReturnMsg msg = this.rateService.rateDetailQuery(node);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doRateDetail.do"})
    public String doRateDetailQuery(HttpServletRequest request, HttpServletResponse response, Model model) {
        Map paramMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        paramMap.remove("uploadService");
        paramMap.remove("downloadService");
        paramMap.remove("fileType");
        paramMap.remove("order");
        paramMap.remove("nowPage");
        paramMap.remove("row4Page");
        paramMap.remove("queryTerms");
        paramMap.remove("funcID");
        paramMap.remove("rqstType");
        ReturnMsg msg = this.rateService.queryRateDetail(paramMap);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doAttrDel.do"})
    public String doAttrDel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map paramMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg returnMsg = this.rateService.delRate(paramMap);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/goRateModify.do"})
    @ResponseBody
    public String doRateModify(HttpServletRequest request, HttpServletResponse response, Model model) {
        RequestMap paramMap = RequestUtils.getRequest((HttpServletRequest)request);
        Map<String, Object> map = this.rateService.goRateModify(paramMap.get("node_no"));
        Return msg = new Return();
        msg.setDataTable(map);
        return RequestUtils.return2Json((ReturnMsg)msg.msg());
    }

    @RequestMapping(value={"/doRateSelfAdd.do", "/doAttrAdd.do"})
    public String doRateSelfAdd(HttpServletRequest request, HttpServletResponse response, Model model) {
        RequestMap paramMap = RequestUtils.getRequest((HttpServletRequest)request);
        String serno = paramMap.get("serno");
        String nodeNo = paramMap.get("node_no");
        String rateCode = paramMap.get("rate_code");
        String rateName = paramMap.get("rate_name");
        String rateOrder = paramMap.get("rate_order");
        String rateIndex = paramMap.get("rate_index");
        String bizType = paramMap.get("biz_type");
        String riskNo = paramMap.get("risk_no");
        String riskName = paramMap.get("risk_name");
        String rateType = paramMap.get("rate_type");
        ReturnMsg msg = this.rateService.doRateSelfAdd(serno, nodeNo, rateCode, rateName, rateOrder, rateIndex, bizType, riskNo, riskName, rateType);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goDropRateTables.do"})
    public String goDelRisks(HttpServletRequest request, HttpServletResponse response) {
        DsnStructure node = (DsnStructure)RequestUtils.getRequestMap((HttpServletRequest)request, DsnStructure.class);
        Return msg = this.rateService.doDelRateNode(node, true);
        return RequestUtils.return2Json((ReturnMsg)msg.msg());
    }

    @RequestMapping(value={"/doDelRateData.do"})
    public String doDelRateData(HttpServletRequest request, HttpServletResponse response) {
        DsnStructure node = (DsnStructure)RequestUtils.getRequestMap((HttpServletRequest)request, DsnStructure.class);
        Return msg = this.rateService.doDelRateNode(node, false);
        return RequestUtils.return2Json((ReturnMsg)msg.msg());
    }

    @RequestMapping(value={"/doDelTargeData.do"})
    public String doDelTargeData(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        Return msg = this.rateService.goDropTargTable(param);
        return RequestUtils.return2Json((ReturnMsg)msg.msg());
    }

    @RequestMapping(value={"/doRateListQuery.do"})
    public String doRateListQuery(HttpServletRequest request, HttpServletResponse response) {
        RequestMap paramMap = RequestUtils.getRequest((HttpServletRequest)request);
        String upNodeSelect = paramMap.get("up_node_select");
        ReturnMsg msg = this.rateService.doRateListQuery(upNodeSelect);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doRateSelfAddNew.do", "/doAttrAdd.do"})
    public String doRateSelfAddNew(HttpServletRequest request, HttpServletResponse response, Model model) {
        DsnStructure structure = (DsnStructure)RequestUtils.getRequestMap((HttpServletRequest)request, DsnStructure.class);
        DsnStructure dsnStructure = (DsnStructure)RequestUtils.getRequestMap((Map)this.pubTree.addTreeNode(structure).getDataTable(), DsnStructure.class);
        String serno = structure.getSerno();
        String nodeNo = dsnStructure.getNodeNo();
        String rateCode = (String)structure.getOtherProperty("rate_code");
        String rateName = (String)structure.getOtherProperty("rate_name");
        String rateOrder = (String)structure.getOtherProperty("rate_order");
        String rateIndex = (String)structure.getOtherProperty("rate_index");
        String bizType = (String)structure.getOtherProperty("biz_type");
        String riskNo = (String)structure.getOtherProperty("risk_no");
        String riskName = (String)structure.getOtherProperty("risk_name");
        String rateType = (String)structure.getOtherProperty("rate_type");
        ReturnMsg msg = this.rateService.doRateSelfAdd(serno, nodeNo, rateCode, rateName, rateOrder, rateIndex, bizType, riskNo, riskName, rateType);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doMultiDelRateData.do"})
    public String doMultiDelRateData(HttpServletRequest request, HttpServletResponse response) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        List nodeList = JsonUtils.listMap2ListClass((List)((List)requestMap.get("node_list")), DsnStructure.class);
        ReturnMsg msg = this.rateService.doMultiDelRateNode(nodeList, false);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/clearRateRecord.do"})
    public String clearRateRecord(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map paramMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg returnMsg = this.rateService.clearRateRecord(paramMap);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }
}

