/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.premium.utils;

import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.premium.services.IPremiumCalcService;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PremiumCalc {
    @Autowired
    private AbsModelRepository dao;
    private static final String FEE_KEY = PremiumCalc.class.getName() + ".callPremium.RateAttr";

    public void calcPremium(Map<String, Object> context, String feeId, String formula, String rateField, String valueKey) {
        String key = rateField.split("\\$")[0];
        Map<String, Object> rate = this.queryRate(context, feeId, this.dao);
        rateField = this.replaceParam(rateField, context);
        Ulog.info((String)rateField);
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object rateValue = rate.get(rateField.toLowerCase());
        if (StrUtils.isNull((Object)rateValue)) {
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u8d39\u7387");
        }
        JexlExpression e = jexl.createExpression(formula);
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            jc.set(entry.getKey(), entry.getValue());
        }
        jc.set(key, rateValue);
        Ulog.info((String)("\u8d39\u7387\uff1a" + key + " =  " + rateValue));
        Ulog.info((String)("\u516c\u5f0f\uff1a" + formula + "  \u53c2\u6570\u503c\uff1a" + JsonUtils.toJson(context)));
        Object o = e.evaluate((JexlContext)jc);
        Ulog.info((String)("callPremium===\u6761\u4ef6\u89e3\u6790\u7ed3\u679c " + o + " \u6761\u4ef6\u8868\u8fbe\u5f0f = " + e.getParsedText()));
        context.put(valueKey, o);
    }

    public void calcPremium(Map<String, Object> context, String feeId, String divisor, String unit, String rateField, String rateCoefficient, String valueKey) {
        this.calcPremiumDynScale(context, feeId, divisor, unit, rateField, rateCoefficient, valueKey, "0");
    }

    public void calcPremiumDynScale(Map<String, Object> context, String feeId, String divisor, String unit, String rateField, String rateCoefficient, String valueKey, String scale) {
        String key = rateField.split("\\$")[0];
        Map<String, Object> rate = this.queryRate(context, feeId, this.dao);
        rateField = this.replaceParam(rateField, context);
        Ulog.info((String)rateField);
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object rateValue = rate.get(rateField.toLowerCase());
        if (StrUtils.isNull((Object)rateValue)) {
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u8d39\u7387");
        }
        divisor = context.get(divisor).toString();
        rateCoefficient = context.get(rateCoefficient).toString();
        String formula = divisor + "/" + unit + "*" + rateField + "/" + rateCoefficient;
        JexlExpression e = jexl.createExpression(formula);
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            jc.set(entry.getKey(), entry.getValue());
        }
        jc.set(key, rateValue);
        Ulog.info((String)("\u8d39\u7387\uff1a" + key + " =  " + rateValue));
        Ulog.info((String)("\u516c\u5f0f\uff1a" + formula + "  \u53c2\u6570\u503c\uff1a" + JsonUtils.toJson(context)));
        Object o = e.evaluate((JexlContext)jc);
        Ulog.info((String)("calcPremium===\u6761\u4ef6\u89e3\u6790\u7ed3\u679c " + o + " \u6761\u4ef6\u8868\u8fbe\u5f0f = " + e.getParsedText()));
        BigDecimal b = new BigDecimal(o.toString());
        double f1 = b.setScale((int)Integer.valueOf(scale), 4).doubleValue();
        Ulog.info((String)("calcPremium===\u56db\u820d\u4e94\u5165\u7ed3\u679c " + f1));
        context.put(valueKey, f1);
    }

    public String getCountWay(Map<String, Object> context, String attrNo) {
        String str = StrUtils.trimStr((Object)context.get(attrNo));
        return "'" + str + "'";
    }

    public String getRate(Map<String, Object> context, String feeId, String rateField) {
        Map<String, Object> rate = this.queryRate(context, feeId, this.dao);
        Object rateValue = rate.get(rateField.toLowerCase());
        if (StrUtils.isNull((Object)rateValue)) {
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u8d39\u7387");
        }
        return StrUtils.trimStr((Object)rateValue);
    }

    public void calcDynamicPremium(Map<String, Object> context, String valueKey, String ... args) {
        this.calcDynamicPremiumScale(context, valueKey, "0", args);
    }

    public void calcDynamicPremiumScale(Map<String, Object> context, String valueKey, String scale, String ... args) {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        StringBuffer sb = new StringBuffer();
        for (String arg : args) {
            sb.append(arg);
            if (StrUtils.isNull((Object)StrUtils.trimStr((Object)context.get(arg)))) continue;
            jc.set(arg, (Object)StrUtils.trimStr((Object)context.get(arg)));
        }
        String formula = sb.toString();
        JexlExpression e = jexl.createExpression(formula);
        Ulog.info((String)("\u516c\u5f0f\uff1a" + formula + "  \u53c2\u6570\u503c\uff1a" + JsonUtils.toJson(context)));
        Object o = e.evaluate((JexlContext)jc);
        Ulog.info((String)("calcDynamicPremium===\u6761\u4ef6\u89e3\u6790\u7ed3\u679c " + o + " \u6761\u4ef6\u8868\u8fbe\u5f0f = " + e.getParsedText()));
        BigDecimal b = new BigDecimal(o.toString());
        double f1 = b.setScale((int)Integer.valueOf(scale), 4).doubleValue();
        Ulog.info((String)("calcDynamicPremium===\u56db\u820d\u4e94\u5165\u7ed3\u679c " + f1));
        context.put(valueKey, f1);
    }

    public void calcAmount(Map<String, Object> context, String feeId, String divisor, String unit, String rateField, String rateCoefficient, String valueKey) {
        this.calcAmountDynScale(context, feeId, divisor, unit, rateField, rateCoefficient, valueKey, "0");
    }

    public void calcAmountDynScale(Map<String, Object> context, String feeId, String divisor, String unit, String rateField, String rateCoefficient, String valueKey, String scale) {
        String key = rateField.split("\\$")[0];
        Map<String, Object> rate = this.queryRate(context, feeId, this.dao);
        rateField = this.replaceParam(rateField, context);
        Ulog.info((String)rateField);
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object rateValue = rate.get(rateField.toLowerCase());
        if (StrUtils.isNull((Object)rateValue)) {
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u8d39\u7387");
        }
        String formula = divisor + "/" + unit + "*" + rateField + "/" + rateCoefficient;
        JexlExpression e = jexl.createExpression(formula);
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            if (StrUtils.isNull((Object)StrUtils.trimStr((Object)entry.getValue()))) continue;
            jc.set(entry.getKey(), entry.getValue());
        }
        jc.set(key, rateValue);
        Ulog.info((String)("\u8d39\u7387\uff1a" + key + " =  " + rateValue));
        Ulog.info((String)("\u516c\u5f0f\uff1a" + formula + "  \u53c2\u6570\u503c\uff1a" + JsonUtils.toJson(context)));
        Object o = e.evaluate((JexlContext)jc);
        Ulog.info((String)("calcAmount===\u6761\u4ef6\u89e3\u6790\u7ed3\u679c " + o + " \u6761\u4ef6\u8868\u8fbe\u5f0f = " + e.getParsedText()));
        BigDecimal b = new BigDecimal(o.toString());
        double f1 = b.setScale((int)Integer.valueOf(scale), 4).doubleValue();
        Ulog.info((String)("calcAmount===\u56db\u820d\u4e94\u5165\u7ed3\u679c " + f1));
        context.put(valueKey, f1);
    }

    private String replaceParam(String text, Map<String, Object> param) {
        Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = text.replace(m.group(0), StrUtils.trimStr((Object)param.get(m.group(1))));
        }
        return text;
    }

    private Map<String, Object> queryRate(Map<String, Object> context, String feeId, AbsModelRepository dao) {
        String riskCode = StrUtils.trimStr((Object)context.get("risk_code"));
        Map<String, List<String>> rateAttr = this.queryRateAttr(feeId, riskCode, dao);
        StringBuilder querySql = new StringBuilder("select * from " + rateAttr.get("tableName").get(0) + " WHERE 1=1 ");
        AbsModelRepository.Args args = dao.args(new Object[0]);
        List<String> input = rateAttr.get("input");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : context.keySet()) {
            map.put(key.toLowerCase(), context.get(key));
        }
        for (String inputKey : input) {
            if (inputKey.endsWith("_gt") || inputKey.endsWith("_lt")) {
                String originInput = inputKey.replaceAll("_gt", "").replaceAll("_lt", "");
                if (StrUtils.isNull((Object)map.get(originInput).toString())) continue;
                querySql.append(" AND CAST(? AS INTEGER) BETWEEN " + originInput + "_gt" + " AND " + originInput + "_lt");
                args.args().add(map.get(originInput));
                continue;
            }
            if (StrUtils.isNull((Object)map.get(inputKey).toString())) continue;
            querySql.append(" AND " + inputKey.toLowerCase() + " = ?");
            args.args().add(map.get(inputKey));
        }
        querySql.append(" \uff03NOTCHECK");
        List mapList = dao.findAll(querySql.toString(), new AbsModelRepository.Args[]{args});
        if (mapList.isEmpty()) {
            return new HashMap<String, Object>();
        }
        return (Map)mapList.get(0);
    }

    private Map<String, Object> queryRateFromRedis(Map<String, Object> context, String feeId, AbsModelRepository dao) {
        Set keys = CacheManager.keys((String)("dsn_rate_*" + feeId));
        if (keys.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8d39\u7387\u4fe1\u606f");
        }
        HashMap<String, List> rateAttr = new HashMap<String, List>();
        ArrayList tableNameKeys = new ArrayList(keys);
        rateAttr.put("tableName", tableNameKeys);
        List inputKeys = (List)CacheManager.getHash((String)((String)tableNameKeys.get(0)), (String)"input", List.class);
        rateAttr.put("input", inputKeys);
        List outputKeys = (List)CacheManager.getHash((String)((String)tableNameKeys.get(0)), (String)"output", List.class);
        rateAttr.put("output", outputKeys);
        StringJoiner sj = new StringJoiner("_");
        List rateList = null;
        for (Object input : inputKeys) {
            String inputKey = StrUtils.trimStr(input);
            sj.add(context.get(inputKey).toString());
            rateList = (List)CacheManager.getHash((String)((String)tableNameKeys.get(0)), (String)sj.toString(), List.class);
        }
        List mapList = JsonUtils.json2List((String)JsonUtils.toJson(rateList), Map.class);
        if (mapList.isEmpty()) {
            return new HashMap<String, Object>();
        }
        return (Map)mapList.get(0);
    }

    private Map<String, List<String>> queryRateAttr(String feeId, String riskCode, AbsModelRepository dao) {
        DsnDynamicData ddd = new DsnDynamicData(true);
        ddd.setField2(feeId);
        ddd.setRelateTab("dsn_structure");
        ddd.setRelateField("node_no");
        ddd.setField5(riskCode);
        ddd = (DsnDynamicData)dao.findOne((AbsModel)ddd);
        String nodeNo = ddd.getRelateFk();
        DsnStructure ds = new DsnStructure(true);
        ds.setUpNode(nodeNo);
        List dsList = dao.findAll((AbsModel)ds);
        Map<String, List<DsnStructure>> dsGroup = dsList.stream().collect(Collectors.groupingBy(DsnStructure::getNodeType));
        List<String> input = this.queryAttr(dsGroup.get("input").get(0), dao);
        List<String> output = this.queryAttr(dsGroup.get("output").get(0), dao);
        HashMap<String, List<String>> rate = new HashMap<String, List<String>>();
        rate.put("input", input);
        rate.put("output", output);
        DsnStructure rateNode = new DsnStructure(true);
        rateNode.setNodeNo(nodeNo);
        rateNode = (DsnStructure)dao.findOne((AbsModel)rateNode);
        ArrayList<String> tableName = new ArrayList<String>();
        tableName.add(rateNode.getRelateTab());
        rate.put("tableName", tableName);
        CacheManager.put((String)(FEE_KEY + "." + feeId), (Object)JsonUtils.toJson(rate));
        return rate;
    }

    private List<String> queryAttr(DsnStructure node, AbsModelRepository dao) {
        String sql = "SELECT dba.* FROM dsn_structure ds, dsn_biz_attribute dba       WHERE ds.node_no = dba.biz_uuid         AND ds.node_type = ?         AND ds.node_seq like ? ORDER BY dba.display_order";
        List dsnList = dao.findAll(sql, DsnBizAttribute.class, Boolean.valueOf(false), new AbsModelRepository.Args[]{dao.args(new Object[]{"attr4Rate", node.getNodeSeq() + "%"})});
        return dsnList.stream().map(DsnBizAttribute::getAttrNo).collect(Collectors.toList());
    }

    public void calcWaiverPremium(Map<String, Object> context, String feeId, String formula, String rateField, String valueKey, String recFee, String sumFee, String sumCdtions) {
        String key = rateField.split("\\$")[0];
        Map<String, Object> rate = this.queryRate(context, feeId, this.dao);
        List allRisk = (List)context.get("allRisk");
        Map bbr = (Map)context.get("bbr");
        context.putAll(bbr);
        String mainRiskCode = StrUtils.trimStr((Object)context.get("mainRiskCode"));
        Map mainRisk = allRisk.stream().filter(risk -> mainRiskCode.equals(risk.get("polCode"))).findFirst().get();
        String premium = Stream.of(StrUtils.trimStr(mainRisk.get("premium")), StrUtils.trimStr(mainRisk.get("initial_premium")), "0").filter(v -> !StrUtils.isNull((Object)v)).findFirst().get();
        if (!StrUtils.isNull((Object)recFee)) {
            Map<String, String> imIpMap = this.getImIpMap(allRisk, null);
            Map newMainRisk = ClassUtils.cloneMap((Map)mainRisk);
            JexlEngine jexl = new JexlBuilder().create();
            MapContext jc = new MapContext();
            Object rateValue = rate.get(rateField.toLowerCase());
            if (StrUtils.isNull((Object)rateValue)) {
                throw new BusinessException("\u672a\u67e5\u627e\u5230\u8d39\u7387");
            }
            jc.set(key, rateValue);
            JexlExpression e = jexl.createExpression(formula);
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                jc.set(entry.getKey(), entry.getValue());
            }
            Ulog.info((String)("\u8d39\u7387\uff1a" + key + " =  " + rateValue));
            Ulog.info((String)("\u516c\u5f0f\uff1a" + formula + "  \u53c2\u6570\u503c\uff1a" + JsonUtils.toJson(context)));
            Object o = e.evaluate((JexlContext)jc);
            Ulog.info((String)("callPremium===\u6761\u4ef6\u89e3\u6790\u7ed3\u679c " + o + " \u6761\u4ef6\u8868\u8fbe\u5f0f = " + e.getParsedText()));
            String ia = StrUtils.trimStr((Object)o);
            if (Double.parseDouble(ia) <= 0.0) {
                ia = "0";
            }
            if (!ia.equals(newMainRisk.get("insured_amount"))) {
                newMainRisk.remove("faceAmnt");
                newMainRisk.remove("initial_premium");
                newMainRisk.put("insured_amount", ia);
                IPremiumCalcService pcs = (IPremiumCalcService)SpringContext.getBean(IPremiumCalcService.class);
                Return msg = new Return();
                pcs.calcPremium(bbr, (PremiumCalc)SpringContext.getBean(PremiumCalc.class), msg, newMainRisk, null);
            }
            premium = Stream.of(StrUtils.trimStr(newMainRisk.get("premium")), StrUtils.trimStr(newMainRisk.get("initial_premium")), "0").filter(v -> !StrUtils.isNull((Object)v)).findFirst().get();
        }
        context.put("insured_amount", premium);
        if (!StrUtils.isNull((Object)sumFee)) {
            List<Map<String, Object>> newRiskList = allRisk.stream().filter(risk -> !mainRiskCode.equals(risk.get("polCode"))).collect(Collectors.toList());
            Map<String, Object> imIpMap = this.getImIpMap(newRiskList, sumCdtions);
            imIpMap.put("ip@" + mainRiskCode, premium);
            String sumIp = StrUtils.trimStr((Object)this.eval(imIpMap, sumFee));
            if (Double.parseDouble(sumIp) <= 0.0) {
                sumIp = "0";
            }
            context.put("insured_amount", sumIp);
        }
        Double insured_amount = Double.parseDouble(context.get("insured_amount").toString());
        context.put("insured_amount", StrUtils.trimStr((Object)insured_amount));
        this.calcPremium(context, feeId, formula, rateField, valueKey);
    }

    private Map<String, String> getImIpMap(List<Map<String, Object>> allRisk, String sumCdtions) {
        return allRisk.stream().map(risk -> {
            Object o;
            if (!StrUtils.isNull((Object)sumCdtions) && (o = this.eval((Map<String, Object>)risk, sumCdtions)) instanceof Boolean && !((Boolean)o).booleanValue()) {
                return new HashMap();
            }
            String polCode = StrUtils.trimStr(risk.get("polCode"));
            HashMap<String, String> map = new HashMap<String, String>();
            String ip = Stream.of(StrUtils.trimStr(risk.get("premium")), StrUtils.trimStr(risk.get("initial_premium")), "0").filter(v -> !StrUtils.isNull((Object)v)).findFirst().get();
            String im = Stream.of(StrUtils.trimStr(risk.get("faceAmnt")), StrUtils.trimStr(risk.get("insured_amount")), "0").filter(v -> !StrUtils.isNull((Object)v)).findFirst().get();
            map.put("ia@" + polCode, im);
            map.put("ip@" + polCode, ip);
            return map;
        }).reduce((m1, m2) -> {
            m2.putAll(m1);
            return m2;
        }).get();
    }

    private Object eval(Map<String, Object> context, String formula) {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        JexlExpression e = jexl.createExpression(formula);
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            jc.set(entry.getKey(), entry.getValue());
        }
        Object o = e.evaluate((JexlContext)jc);
        Ulog.info((String)("callPremium===\u6761\u4ef6\u89e3\u6790\u7ed3\u679c " + o + " \u6761\u4ef6\u8868\u8fbe\u5f0f = " + e.getParsedText()));
        return o;
    }

    public void calcPremiumXJG(Map<String, Object> context, String feeId, String divisor, String unit, String rateField, String rateCoefficient, String valueKey) {
        String key = rateField.split("\\$")[0];
        Map<String, Object> rate = this.queryRate(context, feeId, this.dao);
        rateField = this.replaceParam(rateField, context);
        Ulog.info((String)rateField);
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object rateValue = rate.get(rateField.toLowerCase());
        if (StrUtils.isNull((Object)rateValue)) {
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u8d39\u7387");
        }
        String formula = divisor + "/" + unit + "*" + rateField + "*" + rateCoefficient;
        JexlExpression e = jexl.createExpression(formula);
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            jc.set(entry.getKey(), entry.getValue());
        }
        jc.set(key, rateValue);
        Ulog.info((String)("\u8d39\u7387\uff1a" + key + " =  " + rateValue));
        Ulog.info((String)("\u516c\u5f0f\uff1a" + formula + "  \u53c2\u6570\u503c\uff1a" + JsonUtils.toJson(context)));
        Object o = e.evaluate((JexlContext)jc);
        Ulog.info((String)("calcPremium===\u6761\u4ef6\u89e3\u6790\u7ed3\u679c " + o + " \u6761\u4ef6\u8868\u8fbe\u5f0f = " + e.getParsedText()));
        BigDecimal b = new BigDecimal(o.toString());
        double f1 = b.setScale(2, 4).doubleValue();
        Ulog.info((String)("calcPremium===\u56db\u820d\u4e94\u5165\u7ed3\u679c " + f1));
        context.put(valueKey, f1);
    }

    public void calcPremium389(Map<String, Object> context, String feeId, String unit, String rateField, String valueKey) {
        String key = rateField.split("\\$")[0];
        Map<String, Object> rate = this.queryRate(context, feeId, this.dao);
        rateField = this.replaceParam(rateField, context);
        Ulog.info((String)rateField);
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object rateValue = rate.get(rateField.toLowerCase());
        if (StrUtils.isNull((Object)rateValue)) {
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u8d39\u7387");
        }
        String formula = unit + "*" + rateField;
        JexlExpression e = jexl.createExpression(formula);
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            jc.set(entry.getKey(), entry.getValue());
        }
        jc.set(key, rateValue);
        Ulog.info((String)("\u8d39\u7387\uff1a" + key + " =  " + rateValue));
        Ulog.info((String)("\u516c\u5f0f\uff1a" + formula + "  \u53c2\u6570\u503c\uff1a" + JsonUtils.toJson(context)));
        Object o = e.evaluate((JexlContext)jc);
        Ulog.info((String)("calcPremium===\u6761\u4ef6\u89e3\u6790\u7ed3\u679c " + o + " \u6761\u4ef6\u8868\u8fbe\u5f0f = " + e.getParsedText()));
        BigDecimal b = new BigDecimal(o.toString());
        double f1 = b.setScale(2, 4).doubleValue();
        Ulog.info((String)("calcPremium===\u56db\u820d\u4e94\u5165\u7ed3\u679c " + f1));
        context.put(valueKey, f1);
    }
}

