/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.material.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.config.SyAccountConfig;
import com.newtouch.base.utils.PdfPngUtils;
import com.newtouch.base.utils.SysTradeLog;
import com.newtouch.base.utils.SystemAbutmentUtil;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.nms.sip.model.SipProductMaterial;
import com.newtouch.nms.sip.model.SipProductMaterialRelation;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.SysEnumConf;
import com.newtouch.nms.sip.model.enums.MaterialSource;
import com.newtouch.nms.sip.product.enums.SmsEnum;
import com.newtouch.nms.sip.product.material.param.MaterialFileInfo;
import com.newtouch.nms.sip.product.material.param.MaterialProductInfo;
import com.newtouch.nms.sip.product.material.param.SyncPdMaterialParam;
import com.newtouch.nms.sip.product.material.service.ProductMaterialService;
import com.newtouch.nms.sip.vo.AddPdMaterialVo;
import com.newtouch.nms.sip.vo.DeletePdMaterialVo;
import com.newtouch.nms.sip.vo.ExSipProductMaterialVo;
import com.newtouch.nms.sip.vo.RealProductMaterialVo;
import com.newtouch.nms.sip.vo.SipProductMaterialVo;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Env;
import com.uniapis.logger.Ulog;
import com.uniapis.model.sys.SysEnum;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.HttpUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProductMaterialServiceImpl
implements ProductMaterialService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private HWYObsSDKUtis hwyObsSDKUtis;
    @Autowired
    private SystemAbutmentUtil systemAbutmentUtil;
    @Autowired
    private SyAccountConfig syAccountConfig;
    @Value(value="${core.solvencyUrl}")
    private String solvencyUrl;
    @Autowired
    private PdfPngUtils pdfPngUtils;
    private static final String ALLOW_SUFFIX = ".zip";
    private static Map<String, String> map = new HashMap<String, String>(){
        {
            this.put("103", "insuranceTerms");
            this.put("105", "insureRule");
            this.put("106", "insureResponsibility");
            this.put("107", "exemptionLiability");
            this.put("108", "productManual");
            this.put("109", "health");
            this.put("110", "contractRule");
            this.put("111", "annuity");
            this.put("112", "rate");
            this.put("113", "wbs_rate");
            this.put("114", "cashValue");
            this.put("812", "baoquanRule");
        }
    };

    @Override
    public ReturnMsg queryPdMaterialList(SipProductMaterialVo sipProductMaterialVo) {
        Return msg = new Return();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        stringBuilder.append("select spm.*,spmr.risk_no,spmr.policy_id,spmr.risk_name,spmr.risk_uuid,spmr.delivery_platform,spmr.state,spmr.stop_date,spmr.serno as risk_serno ");
        stringBuilder.append("from sip_product_material_relation spmr left join sip_product_material spm on spmr.material_id = spm.material_id ");
        stringBuilder.append("where spmr.data_flag  = ? ");
        list.add("1");
        if (!StrUtils.isNull((Object)sipProductMaterialVo.getRiskNo()) && StrUtils.isNull((Object)sipProductMaterialVo.getRiskType())) {
            stringBuilder.append("and spmr.risk_no = ? ");
            list.add(sipProductMaterialVo.getRiskNo());
        }
        if (!StrUtils.isNull((Object)sipProductMaterialVo.getMaterialCode())) {
            stringBuilder.append("and spm.material_code = ? ");
            list.add(sipProductMaterialVo.getMaterialCode());
        }
        if (!StrUtils.isNull((Object)sipProductMaterialVo.getState())) {
            stringBuilder.append("and spmr.state = ? ");
            list.add(sipProductMaterialVo.getState());
        }
        if (!StrUtils.isNull((Object)sipProductMaterialVo.getRiskName())) {
            stringBuilder.append("and spmr.risk_name like ? ");
            list.add("%" + sipProductMaterialVo.getRiskName() + "%");
        }
        if (!StrUtils.isNull((Object)sipProductMaterialVo.getMaterialAliasing())) {
            stringBuilder.append("and spm.material_aliasing like ? ");
            list.add("%" + sipProductMaterialVo.getMaterialAliasing() + "%");
        }
        if (!StrUtils.isNull((Object)sipProductMaterialVo.getVersion())) {
            stringBuilder.append("and spm.version like ? ");
            list.add("%" + sipProductMaterialVo.getVersion() + "%");
        }
        if (!StrUtils.isNull((Object)sipProductMaterialVo.getDeliveryPlatform())) {
            stringBuilder.append("and spmr.delivery_platform = ? ");
            list.add(sipProductMaterialVo.getDeliveryPlatform());
        }
        if (!StrUtils.isNull((Object)sipProductMaterialVo.getRiskType()) && StrUtils.isNull((Object)sipProductMaterialVo.getRiskNo())) {
            stringBuilder.append("and spmr.risk_no like ? ");
            list.add("%" + sipProductMaterialVo.getRiskType() + "%");
        }
        stringBuilder.append("order by spm.mdf_date desc");
        List pdMaterialList = "Y".equals(sipProductMaterialVo.getAllFlag()) ? this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)}) : this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(list)});
        msg.getDataTable().put("pdMaterialList", pdMaterialList);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskList(String riskName) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer("SELECT * FROM sip_risks WHERE data_flag = ? AND risk_no IS NOT NULL AND policy_id IS NOT NULL ");
        list.add("1");
        if (!StrUtils.isNull((Object)riskName)) {
            stringBuffer.append("AND risk_name IS NOT NULL AND (risk_name like ? or risk_no like ? or policy_id like ?)");
            String riskNameStr = "%" + riskName + "%";
            list.add(riskNameStr);
            list.add(riskNameStr);
            list.add(riskNameStr);
        }
        stringBuffer.append(" \uff03NOTCHECK");
        List riskList = this.dao.findAll(stringBuffer.toString(), SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(list)});
        Return msg = new Return();
        msg.setDataList4includes(riskList, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk", "risk_uuid", "policy_id"});
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addPdMaterial(AddPdMaterialVo addPdMaterialVo) {
        Return msg = new Return();
        this.checkPdMaterialValue(addPdMaterialVo, "add", msg);
        String materialId = UUID.uuid();
        String newMaterialPath = addPdMaterialVo.getMaterialPath();
        SipProductMaterial sipProductMaterial = new SipProductMaterial();
        BeanUtils.copyProperties((Object)addPdMaterialVo, (Object)sipProductMaterial);
        sipProductMaterial.setMaterialId(materialId);
        String materialSource = addPdMaterialVo.getMaterialSource();
        if (MaterialSource.TEXTMapping.getCode().equals(materialSource)) {
            ReturnMsg returnMsg = this.textConvertHtml(sipProductMaterial, msg);
        }
        if (StrUtils.isNull((Object)sipProductMaterial.getMaterialType())) {
            String materialPath = sipProductMaterial.getMaterialPath();
            String materialType = materialPath.substring(materialPath.lastIndexOf(".") + 1);
            sipProductMaterial.setMaterialType(materialType);
        }
        if (MaterialSource.OLDMapping.getCode().equals(materialSource)) {
            String[] splitPath = newMaterialPath.split("\\.");
            String newMaterialPathCopy = this.obsConfig.getObsSplitPath() + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "." + splitPath[1];
            InputStream inStreamNew = this.hwyObsSDKUtis.getObject(newMaterialPath);
            String newFileNasPath = newMaterialPath.replace(this.obsConfig.getObsSplitPath(), this.syAccountConfig.getUploadUrl());
            String newFileObsPath = newMaterialPath.replace(this.obsConfig.getObsSplitPath(), this.obsConfig.getObsPath());
            String newFileNasPathCopy = newMaterialPathCopy.replace(this.obsConfig.getObsSplitPath(), this.syAccountConfig.getUploadUrl());
            String newFileObsPathCopy = newMaterialPathCopy.replace(this.obsConfig.getObsSplitPath(), this.obsConfig.getObsPath());
            try {
                File fileNew2 = new File(newFileNasPathCopy);
                FileUtils.copyInputStreamToFile((InputStream)inStreamNew, (File)fileNew2);
                Ulog.info((String)("nas\u6587\u4ef6\u8def\u5f84--->" + fileNew2.getAbsolutePath()));
                Ulog.info((String)("obs\u6587\u4ef6\u8def\u5f84--->" + newFileObsPathCopy));
            }
            catch (Exception e) {
                msg.setFailMsg(new Message("100000", "\u7cfb\u7edf\u5f02\u5e38"));
            }
            sipProductMaterial.setMaterialPath(newMaterialPathCopy);
            addPdMaterialVo.setMaterialPath(newMaterialPathCopy);
        }
        ArrayList<SipProductMaterialRelation> relationList = new ArrayList<SipProductMaterialRelation>();
        List riskVoList = addPdMaterialVo.getRiskVoList();
        String riskUuids = "";
        for (AddPdMaterialVo.RiskVo riskVo : riskVoList) {
            SipProductMaterialRelation sipProductMaterialRelation = new SipProductMaterialRelation();
            BeanUtils.copyProperties((Object)riskVo, (Object)sipProductMaterialRelation);
            sipProductMaterialRelation.setMaterialId(materialId);
            sipProductMaterialRelation.setState("INIT");
            sipProductMaterialRelation.setDeliveryPlatform(addPdMaterialVo.getDeliveryPlatform());
            relationList.add(sipProductMaterialRelation);
            riskUuids = riskUuids + riskVo.getRiskUuid();
        }
        this.dao.save(relationList);
        if (MaterialSource.PDFPNGHTMLMapping.getCode().equals(materialSource)) {
            String saveMaterialPath = this.pdfPngUtils.pdfpngAndHtml(newMaterialPath, riskUuids, addPdMaterialVo.getMaterialCode());
            sipProductMaterial.setMaterialPath(saveMaterialPath);
            sipProductMaterial.setMaterialType("html");
        }
        this.dao.save((AbsModel)sipProductMaterial);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updatePdMaterial(AddPdMaterialVo addPdMaterialVo) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)addPdMaterialVo.getMaterialId()) || StrUtils.isNull((Object)addPdMaterialVo.getRiskSerno())) {
            msg.setFailMsg(new Message("300012", "\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        String materialSource = addPdMaterialVo.getMaterialSource();
        String materialId = addPdMaterialVo.getMaterialId();
        String newMaterialPath = addPdMaterialVo.getMaterialPath();
        SipProductMaterialRelation sipProductMaterialSelect = new SipProductMaterialRelation();
        sipProductMaterialSelect.where().addEq(SipProductMaterialRelation.MATERIAL_ID, (Object)materialId);
        sipProductMaterialSelect.where().addEq(SipProductMaterialRelation.SERNO, (Object)addPdMaterialVo.getRiskSerno());
        SipProductMaterialRelation sipProductMaterialDb = (SipProductMaterialRelation)this.dao.findOne((AbsModel)sipProductMaterialSelect);
        if (StrUtils.isNull((Object)sipProductMaterialDb)) {
            msg.setFailMsg(new Message("300012", "\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        if ("ON".equals(sipProductMaterialDb.getState())) {
            msg.setFailMsg(new Message("300014", "\u8d44\u6599\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u7f16\u8f91\uff01"));
            return msg.msg();
        }
        this.checkPdMaterialValue(addPdMaterialVo, "update", msg);
        SipProductMaterial sipProductMaterialOld = new SipProductMaterial();
        sipProductMaterialOld.where().addEq(SipProductMaterial.MATERIAL_ID, (Object)materialId);
        SipProductMaterial sipProductMaterialRes = (SipProductMaterial)this.dao.findOne((AbsModel)sipProductMaterialOld);
        String oldMaterialPath = sipProductMaterialRes.getMaterialPath();
        SipProductMaterial sipProductMaterial = new SipProductMaterial();
        BeanUtils.copyProperties((Object)addPdMaterialVo, (Object)sipProductMaterial);
        sipProductMaterial.where().addEq(SipProductMaterial.MATERIAL_ID, (Object)materialId);
        if (MaterialSource.TEXTMapping.getCode().equals(materialSource)) {
            ReturnMsg returnMsg = this.textConvertHtml(sipProductMaterial, msg);
        }
        if (StrUtils.isNull((Object)sipProductMaterial.getMaterialType())) {
            String materialPath = sipProductMaterial.getMaterialPath();
            String materialType = materialPath.substring(materialPath.lastIndexOf(".") + 1);
            sipProductMaterial.setMaterialType(materialType);
        }
        if (MaterialSource.OLDMapping.getCode().equals(materialSource) && !Objects.equals(newMaterialPath, oldMaterialPath)) {
            String[] splitPath = newMaterialPath.split("\\.");
            String newMaterialPathCopy = this.obsConfig.getObsSplitPath() + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "." + splitPath[1];
            InputStream inStreamNew = this.hwyObsSDKUtis.getObject(newMaterialPath);
            String newFileNasPath = newMaterialPath.replace(this.obsConfig.getObsSplitPath(), this.syAccountConfig.getUploadUrl());
            String newFileObsPath = newMaterialPath.replace(this.obsConfig.getObsSplitPath(), this.obsConfig.getObsPath());
            String newFileNasPathCopy = newMaterialPathCopy.replace(this.obsConfig.getObsSplitPath(), this.syAccountConfig.getUploadUrl());
            String newFileObsPathCopy = newMaterialPathCopy.replace(this.obsConfig.getObsSplitPath(), this.obsConfig.getObsPath());
            try {
                File fileNew2 = new File(newFileNasPathCopy);
                FileUtils.copyInputStreamToFile((InputStream)inStreamNew, (File)fileNew2);
                Ulog.info((String)("nas\u6587\u4ef6\u8def\u5f84--->" + fileNew2.getAbsolutePath()));
                Ulog.info((String)("obs\u6587\u4ef6\u8def\u5f84--->" + newFileObsPathCopy));
            }
            catch (Exception e) {
                msg.setFailMsg(new Message("100000", "\u7cfb\u7edf\u5f02\u5e38"));
            }
            sipProductMaterial.setMaterialPath(newMaterialPathCopy);
            addPdMaterialVo.setMaterialPath(newMaterialPathCopy);
        }
        if (MaterialSource.PDFPNGHTMLMapping.getCode().equals(materialSource) && !Objects.equals(newMaterialPath, oldMaterialPath)) {
            String riskUuids = sipProductMaterialDb.getRiskUuid();
            String saveMaterialPath = this.pdfPngUtils.pdfpngAndHtml(newMaterialPath, riskUuids, addPdMaterialVo.getMaterialCode());
            sipProductMaterial.setMaterialPath(saveMaterialPath);
            sipProductMaterial.setMaterialType("html");
        }
        SipProductMaterialRelation sipProductMaterialRelation = new SipProductMaterialRelation();
        sipProductMaterialRelation.setDeliveryPlatform(addPdMaterialVo.getDeliveryPlatform());
        sipProductMaterialRelation.where().addEq(SipProductMaterialRelation.MATERIAL_ID, (Object)materialId);
        sipProductMaterialRelation.where().addEq(SipProductMaterialRelation.SERNO, (Object)addPdMaterialVo.getRiskSerno());
        this.dao.update((AbsModel)sipProductMaterialRelation);
        this.dao.update((AbsModel)sipProductMaterial);
        if (sipProductMaterialDb.getRiskNo().startsWith("common_")) {
            SipProductMaterial spm = new SipProductMaterial();
            spm.where().addEq(SipProductMaterial.MATERIAL_SOURCE_ID, (Object)materialId);
            spm.where().addEq(SipProductMaterial.MATERIAL_SOURCE, (Object)MaterialSource.OLDMapping.getCode());
            spm.setMaterialPath(sipProductMaterial.getMaterialPath());
            spm.setMaterialType(sipProductMaterial.getMaterialType());
            spm.setMaterialText(sipProductMaterial.getMaterialText());
            this.dao.update((AbsModel)spm);
        }
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg renewPdMaterial(AddPdMaterialVo renewPdMaterialVo) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)renewPdMaterialVo.getMaterialId()) || StrUtils.isNull((Object)renewPdMaterialVo.getRiskSerno())) {
            msg.setFailMsg(new Message("300012", "\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        String materialId = renewPdMaterialVo.getMaterialId();
        SipProductMaterialRelation sipProductMaterialCheck = new SipProductMaterialRelation();
        sipProductMaterialCheck.where().addEq(SipProductMaterialRelation.MATERIAL_ID, (Object)materialId);
        sipProductMaterialCheck.where().addEq(SipProductMaterialRelation.SERNO, (Object)renewPdMaterialVo.getRiskSerno());
        SipProductMaterialRelation sipProductMaterialDb = (SipProductMaterialRelation)this.dao.findOne((AbsModel)sipProductMaterialCheck);
        if (StrUtils.isNull((Object)sipProductMaterialDb)) {
            msg.setFailMsg(new Message("300012", "\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        this.checkPdMaterialValue(renewPdMaterialVo, "renew", msg);
        if (MaterialSource.TEXTMapping.getCode().equals(renewPdMaterialVo.getMaterialSource())) {
            ReturnMsg returnMsg = this.textConvert(renewPdMaterialVo, msg);
        }
        SipProductMaterial sipProductMaterial = new SipProductMaterial();
        sipProductMaterial.where().addEq(SipProductMaterial.MATERIAL_ID, (Object)materialId);
        SipProductMaterial newMaterial = (SipProductMaterial)this.dao.findOne((AbsModel)sipProductMaterial);
        String oldMaterialPath = newMaterial.getMaterialPath();
        String newMaterialPath = renewPdMaterialVo.getMaterialPath();
        SipProductMaterialRelation sipProductMaterialRelation = new SipProductMaterialRelation();
        sipProductMaterialRelation.where().addEq(SipProductMaterialRelation.MATERIAL_ID, (Object)materialId);
        sipProductMaterialRelation.where().addEq(SipProductMaterialRelation.SERNO, (Object)renewPdMaterialVo.getRiskSerno());
        SipProductMaterialRelation newMaterialRelation = (SipProductMaterialRelation)this.dao.findOne((AbsModel)sipProductMaterialRelation);
        String materialIdNew = UUID.uuid();
        newMaterial.setMaterialId(materialIdNew);
        newMaterialRelation.setMaterialId(materialIdNew);
        newMaterial.setMaterialPath(newMaterialPath);
        newMaterial.setSerno(null);
        newMaterialRelation.setSerno(null);
        this.dao.save((AbsModel)newMaterial);
        this.dao.save((AbsModel)newMaterialRelation);
        SipProductMaterial sipProductMaterialOld = new SipProductMaterial();
        BeanUtils.copyProperties((Object)renewPdMaterialVo, (Object)sipProductMaterialOld);
        sipProductMaterialOld.setMaterialPath(oldMaterialPath);
        if (StrUtils.isNull((Object)sipProductMaterialOld.getMaterialType())) {
            String materialPath = sipProductMaterialOld.getMaterialPath();
            String materialType = materialPath.substring(materialPath.lastIndexOf(".") + 1);
            sipProductMaterialOld.setMaterialType(materialType);
        }
        sipProductMaterialOld.where().addEq(SipProductMaterial.MATERIAL_ID, (Object)materialId);
        this.dao.update((AbsModel)sipProductMaterialOld);
        InputStream inStreamNew = this.hwyObsSDKUtis.getObject(newMaterialPath);
        String newFileNasPath = newMaterialPath.replace(this.obsConfig.getObsSplitPath(), this.syAccountConfig.getUploadUrl());
        String newFileObsPath = newMaterialPath.replace(this.obsConfig.getObsSplitPath(), this.obsConfig.getObsPath());
        InputStream inStreamOld = this.hwyObsSDKUtis.getObject(oldMaterialPath);
        String oldFileNasPath = oldMaterialPath.replace(this.obsConfig.getObsSplitPath(), this.syAccountConfig.getUploadUrl());
        String oldFileObsPath = oldMaterialPath.replace(this.obsConfig.getObsSplitPath(), this.obsConfig.getObsPath());
        String[] splitNas = newFileNasPath.split("\\.");
        String newFileNasPath2 = splitNas[0] + "_2." + splitNas[1];
        String[] splitOBS = newFileObsPath.split("\\.");
        String newFileObsPath2 = splitOBS[0] + "_2." + splitOBS[1];
        if (!MaterialSource.OLDMapping.getCode().equals(renewPdMaterialVo.getMaterialSource())) {
            try {
                File fileNew2 = new File(newFileNasPath2);
                FileUtils.copyInputStreamToFile((InputStream)inStreamNew, (File)fileNew2);
                File fileNew = new File(newFileNasPath);
                Ulog.info((String)("nas\u6587\u4ef6\u8def\u5f84--->" + fileNew.getAbsolutePath()));
                System.out.println("nas\u6587\u4ef6\u8def\u5f84--->" + fileNew.getAbsolutePath());
                FileUtils.copyInputStreamToFile((InputStream)inStreamOld, (File)fileNew);
                Ulog.info((String)("ODS\u6587\u4ef6\u8def\u5f84--->" + newFileObsPath));
                System.out.println("ODS\u6587\u4ef6\u8def\u5f84--->" + newFileObsPath);
                fileNew2 = new File(newFileNasPath2);
                FileInputStream inStreamNew2 = new FileInputStream(fileNew2);
                File fileOld = new File(oldFileNasPath);
                Ulog.info((String)("nas\u6587\u4ef6\u8def\u5f84--->" + fileOld.getAbsolutePath()));
                System.out.println("nas\u6587\u4ef6\u8def\u5f84--->" + fileOld.getAbsolutePath());
                FileUtils.copyInputStreamToFile((InputStream)inStreamNew2, (File)fileOld);
                Ulog.info((String)("ODS\u6587\u4ef6\u8def\u5f84--->" + oldFileObsPath));
                System.out.println("ODS\u6587\u4ef6\u8def\u5f84--->" + oldFileObsPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                Ulog.info((String)("\u6587\u4ef6\u66f4\u65b0\u5f02\u5e38--->" + e.getMessage()));
                Ulog.debug((Object)e);
                msg.setFailMsg(new Message("100000", "\u7cfb\u7edf\u5f02\u5e38"));
            }
        }
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deletePdMaterial(DeletePdMaterialVo deletePdMaterialVo) {
        Return msg = new Return();
        if (CollectionUtils.isEmpty((Collection)deletePdMaterialVo.getRiskSernoList())) {
            msg.setFailMsg(new Message("300015", "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        SipProductMaterialRelation sipProductMaterialSelect = new SipProductMaterialRelation();
        sipProductMaterialSelect.where().addEq(SipProductMaterialRelation.STATE, (Object)"ON");
        sipProductMaterialSelect.where().addIn(SipProductMaterialRelation.SERNO, deletePdMaterialVo.getRiskSernoList());
        List sipProductMaterialDb = this.dao.findAll((AbsModel)sipProductMaterialSelect);
        if (CollectionUtils.isNotEmpty((Collection)sipProductMaterialDb)) {
            msg.setFailMsg(new Message("300016", "\u8d44\u6599\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u5220\u9664\uff01"));
            return msg.msg();
        }
        SipProductMaterialRelation sipProductMaterialDel = new SipProductMaterialRelation();
        sipProductMaterialDel.where().addIn(SipProductMaterialRelation.SERNO, deletePdMaterialVo.getRiskSernoList());
        this.dao.delete((AbsModel)sipProductMaterialDel);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updateMaterialState(AddPdMaterialVo addPdMaterialVo) {
        Return msg = new Return();
        String state = addPdMaterialVo.getState();
        if (StrUtils.isNull((Object)addPdMaterialVo.getMaterialId()) || StrUtils.isNull((Object)addPdMaterialVo.getRiskSerno()) || StrUtils.isNull((Object)state)) {
            msg.setFailMsg(new Message("300012", "\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        SipProductMaterialRelation sipProductMaterialRelation = new SipProductMaterialRelation();
        sipProductMaterialRelation.setState(state);
        if ("OFF".equals(state)) {
            sipProductMaterialRelation.setStopDate(new Date());
        } else {
            sipProductMaterialRelation.setStopDate(null);
        }
        sipProductMaterialRelation.where().addEq(SipProductMaterialRelation.MATERIAL_ID, (Object)addPdMaterialVo.getMaterialId());
        sipProductMaterialRelation.where().addEq(SipProductMaterialRelation.SERNO, (Object)addPdMaterialVo.getRiskSerno());
        this.dao.update((AbsModel)sipProductMaterialRelation);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg exportPdMaterial(DeletePdMaterialVo deletePdMaterialVo, HttpServletResponse response) {
        Return msg = new Return();
        if (CollectionUtils.isEmpty((Collection)deletePdMaterialVo.getRiskSernoList())) {
            msg.setFailMsg(new Message("300017", "\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("PDMATERIAL");
        task.setIsZipDel("0");
        task.setTaskType("EXP");
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String baseAddress = Env.env().baseDir() + "temp/pdMaterial/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList list = new ArrayList();
        stringBuilder.append("select spm.* ");
        stringBuilder.append("from sip_product_material spm ");
        stringBuilder.append("where spm.material_id in ( select distinct material_id from sip_product_material_relation where ");
        stringBuilder.append("serno  in ( ");
        List riskSernoList = deletePdMaterialVo.getRiskSernoList();
        for (int i = 0; i < riskSernoList.size(); ++i) {
            if (i == riskSernoList.size() - 1) {
                stringBuilder.append(" ?  ");
            } else {
                stringBuilder.append(" ?,  ");
            }
            list.add(riskSernoList.get(i));
        }
        stringBuilder.append("))");
        List materialList = this.dao.findAll(stringBuilder.toString(), ExSipProductMaterialVo.class, new AbsModelRepository.Args[]{this.dao.args(list)});
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            msg.setFailMsg(new Message("300017", "\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        try {
            for (ExSipProductMaterialVo sipProductMaterial : materialList) {
                String materialId = sipProductMaterial.getMaterialId();
                SipProductMaterialRelation spmr = new SipProductMaterialRelation();
                spmr.where().addEq(SipProductMaterialRelation.MATERIAL_ID, (Object)materialId);
                spmr.where().addIn(SipProductMaterialRelation.SERNO, riskSernoList);
                List spmrList = this.dao.findAll((AbsModel)spmr);
                sipProductMaterial.setSpmrList(spmrList);
                ArrayList<String> exList = new ArrayList<String>();
                exList.add(JsonUtils.toJson((Object)sipProductMaterial));
                com.uniapis.utils.FileUtils.writeFile((String)(baseAddress + "/" + materialId + "/" + materialId + ".json"), exList, (boolean)false);
                joiner.add(sipProductMaterial.getMaterialAliasing());
                String materialPath = sipProductMaterial.getMaterialPath();
                if (!StrUtils.isNull((Object)sipProductMaterial.getMaterialZipPath())) {
                    materialPath = sipProductMaterial.getMaterialZipPath();
                }
                String basePathStr = baseAddress + "/" + materialId + "/" + "fileList" + "/";
                try {
                    InputStream inStream = this.hwyObsSDKUtis.getObject(materialPath);
                    String filePath = basePathStr + materialPath;
                    File file = new File(filePath);
                    if (!file.getParentFile().exists() || !file.isDirectory()) {
                        file.getParentFile().mkdirs();
                    }
                    BufferedInputStream in = null;
                    BufferedOutputStream out = null;
                    in = new BufferedInputStream(inStream);
                    out = new BufferedOutputStream(new FileOutputStream(filePath));
                    int len = -1;
                    byte[] b = new byte[1024];
                    while ((len = in.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                    in.close();
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String materialSource = sipProductMaterial.getMaterialSource();
                if (!MaterialSource.PDFPNGHTMLMapping.getCode().equals(materialSource)) continue;
                this.pdfPngUtils.export(basePathStr, materialPath);
            }
            zipFile = baseAddress + currentTimeMillis + ALLOW_SUFFIX;
            Ulog.info((String)("zipFile----" + zipFile));
            String zip = com.uniapis.utils.FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".json", ".html", "pdf", "zip", "png"});
            Ulog.info((String)("zip----" + zip));
            File file = new File(zipFile);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ALLOW_SUFFIX, "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FINISH");
            task.setFinishDate(new Date());
            task.setZipPath(zipFile);
            this.dao.save((AbsModel)task);
        }
        catch (Exception e) {
            e.printStackTrace();
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FAIL");
            task.setErrorInfo(e.getMessage());
            task.setFinishDate(new Date());
            this.dao.save((AbsModel)task);
        }
        return null;
    }

    @Override
    public ReturnMsg uploadPdMaterial(MultipartFile zipFile) {
        Return msg = new Return();
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String baseAddress = Env.env().baseDir() + "temp/pdMaterial/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        msg = this.unzipFile(zipFile, baseAddress);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("300018", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01"));
            return msg.msg();
        }
        File importDir = new File(baseAddress);
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<File> jsonList = new ArrayList<File>();
        ArrayList<File> pngList = new ArrayList<File>();
        this.getAllFiles(importDir, jsonList, fileList, pngList);
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684json\u6587\u4ef6---" + JsonUtils.toJson(jsonList)));
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u5176\u4ed6\u6587\u4ef6---" + JsonUtils.toJson(fileList)));
        StringJoiner joiner = new StringJoiner(",");
        for (File jsonFile : jsonList) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String jsonStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u4ea7\u54c1\u8d44\u6599\u6570\u636e\u4e3a" + jsonStr));
                    ExSipProductMaterialVo exSipProductMaterialVo = (ExSipProductMaterialVo)JsonUtils.json2Class((String)jsonStr, ExSipProductMaterialVo.class);
                    SipProductMaterial spm = new SipProductMaterial();
                    BeanUtils.copyProperties((Object)exSipProductMaterialVo, (Object)spm);
                    SipProductMaterial spmOld = new SipProductMaterial();
                    joiner.add(spm.getMaterialAliasing());
                    spmOld.where().addEq(SipProductMaterial.MATERIAL_ID, (Object)spm.getMaterialId()).model();
                    this.dao.delete((AbsModel)spmOld);
                    this.dao.save((AbsModel)spm);
                    List spmrList = exSipProductMaterialVo.getSpmrList();
                    for (SipProductMaterialRelation spmr : spmrList) {
                        SipProductMaterialRelation spmrOld = new SipProductMaterialRelation();
                        spmrOld.where().addEq(SipProductMaterialRelation.SERNO, (Object)spmr.getSerno());
                        this.dao.delete((AbsModel)spmrOld);
                        this.dao.save((AbsModel)spmr);
                    }
                }
                catch (Throwable ch) {
                    throwable = ch;
                    throw ch;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch) {
                            throwable.addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                e.printStackTrace();
                msg.setFailMsg("\u4ea7\u54c1\u8d44\u6599\u5bfc\u5165\u5931\u8d25");
                return msg.msg();
            }
        }
        try {
            for (File file : fileList) {
                FileInputStream inputStream;
                String nasPath;
                String filePath;
                String[] str;
                String obsSplitPath;
                String path;
                if (file.getName().endsWith(ALLOW_SUFFIX)) {
                    path = file.getPath();
                    obsSplitPath = this.obsConfig.getObsSplitPath();
                    str = path.split(obsSplitPath);
                    filePath = str[str.length - 1];
                    nasPath = Env.env().baseDir() + filePath.replace(file.getName(), "");
                    inputStream = new FileInputStream(file);
                    ProductMaterialServiceImpl.unzip(inputStream, nasPath);
                    ArrayList files = new ArrayList();
                    try {
                        Files.walk(Paths.get(nasPath, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> files.add(new File(String.valueOf(p))));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    files.forEach(o -> {
                        String key = this.obsConfig.getObsPath() + o.getPath();
                    });
                    continue;
                }
                path = file.getPath();
                obsSplitPath = this.obsConfig.getObsSplitPath();
                str = path.split(obsSplitPath);
                filePath = str[str.length - 1];
                nasPath = Env.env().baseDir() + filePath;
                inputStream = new FileInputStream(file);
                File nasFile = new File(nasPath);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)nasFile);
                String string = this.obsConfig.getObsPath() + filePath;
            }
            if (CollectionUtils.isNotEmpty(pngList)) {
                this.pdfPngUtils.upload(pngList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.error((Throwable)e);
            e.printStackTrace();
            msg.setFailMsg("\u4ea7\u54c1\u8d44\u6599\u5bfc\u5165\u5931\u8d25");
            return msg.msg();
        }
        SipProductSyncTask task = new SipProductSyncTask();
        String taskName = joiner.toString();
        task.setFuncModule("PDMATERIAL");
        task.setIsZipDel("0");
        task.setTaskType("IMP");
        task.setTaskName(taskName);
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg dynamicPreviewHtml(String materialId) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)materialId)) {
            msg.setFailMsg(new Message("300019", "\u8bf7\u9009\u62e9\u8981\u9884\u89c8\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        SipProductMaterial spm = new SipProductMaterial();
        spm.where().addEq(SipProductMaterial.DATA_FLAG, (Object)"1");
        spm.where().addEq(SipProductMaterial.MATERIAL_ID, (Object)materialId);
        SipProductMaterial spmDb = (SipProductMaterial)this.dao.findOne((AbsModel)spm);
        if (StrUtils.isNull((Object)spmDb)) {
            msg.setFailMsg(new Message("300019", "\u8bf7\u9009\u62e9\u8981\u9884\u89c8\u7684\u8d44\u6599\uff01"));
            return msg.msg();
        }
        String materialCode = spmDb.getMaterialCode();
        String materialPath = spmDb.getMaterialPath();
        String isDynamic = spmDb.getIsDynamic();
        if ("Y".equals(isDynamic)) {
            Map<String, Object> resultMap = this.solvencylnfo();
            if (StrUtils.isNull(resultMap)) {
                msg.setFailMsg(new Message("300020", "\u83b7\u53d6\u52a8\u6001\u8d44\u6599\u5185\u5bb9\u5931\u8d25\uff01"));
                return msg.msg();
            }
            String solvencyYear = StrUtils.isNull((Object)resultMap.get("solvencyYear")) ? "" : resultMap.get("solvencyYear").toString();
            String solvencyQuarter = StrUtils.isNull((Object)resultMap.get("solvencyQuarter")) ? "" : resultMap.get("solvencyQuarter").toString();
            String solvencyRate = StrUtils.isNull((Object)resultMap.get("solvencyRate")) ? "" : resultMap.get("solvencyRate").toString();
            String evaluationYear = StrUtils.isNull((Object)resultMap.get("evaluationYear")) ? "" : resultMap.get("evaluationYear").toString();
            String evaluationQuarter = StrUtils.isNull((Object)resultMap.get("evaluationQuarter")) ? "" : resultMap.get("evaluationQuarter").toString();
            String evaluation = StrUtils.isNull((Object)resultMap.get("evaluation")) ? "" : resultMap.get("evaluation").toString();
            String cacheKye = "material_list:" + materialPath + "_" + solvencyYear + "_" + solvencyQuarter + "_" + solvencyRate + "_" + evaluationYear + "_" + evaluationQuarter + "_" + evaluation;
            Object object = CacheManager.get((String)cacheKye);
            if (!StrUtils.isNull((Object)object)) {
                msg.getDataTable().put("key", object.toString());
                msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
                return msg.msg();
            }
            InputStream inStream = this.hwyObsSDKUtis.getObject(materialPath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inStream));
            String oldHtml = "";
            try {
                String line;
                StringBuilder result = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    result.append(line);
                }
                oldHtml = result.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                Ulog.info((String)("\u8bfb\u53d6html\u6587\u4ef6\u5f02\u5e38--->" + e.getMessage()));
            }
            finally {
                try {
                    inStream.close();
                    bufferedReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String htmls = oldHtml.replaceAll("s_year", solvencyYear).replaceAll("s_quarter", solvencyQuarter).replaceAll("s_data", solvencyRate).replaceAll("e_year", evaluationYear).replaceAll("e_quarter", evaluationQuarter).replaceAll("e_data", evaluation);
            ArrayList<String> htmlList = new ArrayList<String>();
            htmlList.add(htmls);
            String filePath = "pdMaterial/temp/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + ".html";
            String nasPath = Env.env().baseDir() + filePath;
            File file = new File(nasPath);
            com.uniapis.utils.FileUtils.writeFile((String)nasPath, htmlList, (boolean)false);
            String key = this.obsConfig.getObsPath() + filePath;
            materialPath = key.replace(this.obsConfig.getObsPath(), this.obsConfig.getObsSplitPath());
            CacheManager.put((String)cacheKye, (Object)materialPath);
            msg.getDataTable().put("url", nasPath);
            msg.getDataTable().put("imagePath", key);
        }
        msg.getDataTable().put("key", materialPath);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRealPdMaterials(RealProductMaterialVo rpmv) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)rpmv) || CollectionUtils.isEmpty((Collection)rpmv.getRiskVoList()) && StrUtils.isNull((Object)rpmv.getProductUuid()) || StrUtils.isNull((Object)rpmv.getDeliveryPlatform())) {
            msg.setFailMsg(new Message("300021", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            return msg.msg();
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        stringBuilder.append("select spm.material_path,spm.material_source_id,spm.material_aliasing,spm.material_name,spm.display_order,spm.material_type, ");
        stringBuilder.append("spm.material_sub_code,spm.version,spm.is_dynamic,spm.material_id,spm.filing_number,spm.material_source,spm.material_code,spm.material_text, ");
        stringBuilder.append("spmr.risk_no,spmr.policy_id,spmr.risk_name,spmr.risk_uuid,spmr.delivery_platform,spmr.state,spmr.stop_date,spmr.serno as risk_serno ");
        stringBuilder.append("from sip_product_material_relation spmr left join sip_product_material spm on spmr.material_id = spm.material_id ");
        stringBuilder.append("where spmr.data_flag  = ? and spmr.state = ? ");
        list.add("1");
        list.add("ON");
        stringBuilder.append("and spmr.delivery_platform = ? ");
        list.add(rpmv.getDeliveryPlatform());
        stringBuilder.append("and risk_uuid  in ( ");
        if (CollectionUtils.isEmpty((Collection)rpmv.getRiskVoList())) {
            String productUuid = rpmv.getProductUuid();
            SipProductRisks sipProductRisks = new SipProductRisks();
            sipProductRisks.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUuid);
            List sprList = this.dao.findAll((AbsModel)sipProductRisks);
            ArrayList<String> riskUuidList = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)sprList)) {
                for (SipProductRisks risk : sprList) {
                    riskUuidList.add(risk.getRiskUuid());
                    SipRiskRelation srr = new SipRiskRelation();
                    srr.where().addEq(SipRiskRelation.MAIN_RISK, (Object)risk.getRiskUuid());
                    List srrList = this.dao.findAll((AbsModel)srr);
                    if (!CollectionUtils.isNotEmpty((Collection)sprList)) continue;
                    for (SipRiskRelation s : srrList) {
                        riskUuidList.add(s.getRiskUuid());
                        SipRiskRelation srrA = new SipRiskRelation();
                        srrA.where().addEq(SipRiskRelation.MAIN_RISK, (Object)s.getRiskUuid());
                        List srrAList = this.dao.findAll((AbsModel)srrA);
                        if (!CollectionUtils.isNotEmpty((Collection)srrAList)) continue;
                        for (SipRiskRelation sA : srrList) {
                            riskUuidList.add(sA.getRiskUuid());
                        }
                    }
                }
            }
            for (int i = 0; i < riskUuidList.size(); ++i) {
                if (list.contains(riskUuidList.get(i))) continue;
                if (i == riskUuidList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add((String)riskUuidList.get(i));
            }
        } else {
            List riskVoList = rpmv.getRiskVoList();
            for (int i = 0; i < riskVoList.size(); ++i) {
                if (i == riskVoList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add(((RealProductMaterialVo.RiskVo)riskVoList.get(i)).getRiskUuid());
            }
        }
        stringBuilder.append(") ");
        if (!StrUtils.isNull((Object)rpmv.getMaterialCode())) {
            stringBuilder.append(" and spm.material_code = ? ");
            list.add(rpmv.getMaterialCode());
        }
        stringBuilder.append("order by spm.material_code,spm.display_order");
        List pdMaterialList = this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
        if (CollectionUtils.isNotEmpty((Collection)pdMaterialList) && "Y".equals(rpmv.getIsGroup())) {
            Map pdMaterialMap = new HashMap();
            HashMap returnMap = new HashMap();
            String enumCode = "material_code";
            List enumList = (List)CacheManager.getHash((String)"enumType", (String)enumCode);
            if (CollectionUtils.isEmpty((Collection)enumList)) {
                ArrayList<String> args = new ArrayList<String>(Arrays.asList("1", enumCode));
                String sql = "select * from sys_enum e where e.up_enum in (select  m.enum_id from sys_enum m where m.data_flag = ? and m.enum_code = ?) order by e.enum_order ";
                enumList = this.dao.findAll(sql, SysEnumConf.class, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(args)});
                CacheManager.putHash((String)"enumType", (String)enumCode, (Object)enumList);
            }
            pdMaterialMap = pdMaterialList.stream().collect(Collectors.groupingBy(item -> String.valueOf(item.get("material_code")), HashMap::new, Collectors.toList()));
            for (Map.Entry entry : pdMaterialMap.entrySet()) {
                String key = (String)entry.getKey();
                HashMap<String, String> map = new HashMap<String, String>();
                SysEnumConf sysEnumConf = enumList.stream().filter(o -> o.getEnumCode().equals(key)).findAny().orElse(null);
                map.put("material_name", sysEnumConf.getEnumName());
                map.put("list", (String)entry.getValue());
                returnMap.put(key, map);
            }
            msg.getDataTable().put("pdMaterials", returnMap);
        } else {
            msg.getDataTable().put("pdMaterials", pdMaterialList);
        }
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public String syncPdMaterial(SyncPdMaterialParam param) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("success", "false");
        List risk_nos = param.getMaterialProductInfos().stream().map(MaterialProductInfo::getInternalId).collect(Collectors.toList());
        List risks = this.dao.findAll(SipRisks.n().where().addIn(SipRisks.RISK_NO, risk_nos).model());
        if (CollectionUtil.isEmpty((Collection)risks)) {
            resMap.put("errorMsg", "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return JsonUtils.toJson(resMap);
        }
        for (MaterialFileInfo materialFileInfo : param.getMaterialFileInfos()) {
            byte[] file1 = materialFileInfo.getContent();
            String fileName = materialFileInfo.getFileNameWithSuffix();
            String uuid = UUID.uuid();
            String fileName1 = uuid + ALLOW_SUFFIX;
            String contentType = "application/zip";
            MultipartFile file = null;
            try {
                file = ProductMaterialServiceImpl.convertToMultipartFile(file1, fileName1, contentType);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String materialId = UUID.uuid();
            String relativePath = "pdMaterial/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + materialId + "/";
            String absolutePath = Env.env().baseDir() + relativePath;
            Return msg = this.unzipFile(file, absolutePath);
            if (!msg.isSuccessflag()) {
                resMap.put("errorMsg", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
                return JsonUtils.toJson(resMap);
            }
            File importDir = new File(absolutePath);
            File html = this.getHtml(importDir);
            File zip = this.getZip(importDir);
            String htmlPath = html.getPath().replace(Env.env().baseDir(), "staticData/");
            String zipPath = zip.getPath().replace(Env.env().baseDir(), "staticData/");
            String materialCode = map.get(materialFileInfo.getDocType());
            String materialName = ((SysEnum)this.dao.findOne(SysEnum.n().where().addEq(SysEnum.ENUM_CODE, (Object)materialCode).model())).getEnumName();
            SipProductMaterial sipProductMaterial = new SipProductMaterial();
            sipProductMaterial.setMaterialId(materialId);
            sipProductMaterial.setMaterialCode(materialCode);
            sipProductMaterial.setMaterialName(materialName);
            sipProductMaterial.setMaterialSubCode("all");
            sipProductMaterial.setMaterialAliasing(fileName.replace(ALLOW_SUFFIX, ""));
            sipProductMaterial.setMaterialPath(htmlPath);
            sipProductMaterial.setMaterialZipPath(zipPath);
            sipProductMaterial.setMaterialType("html");
            sipProductMaterial.setMaterialSource("html");
            sipProductMaterial.setVersion(DateUtils.date2String((Date)new Date(), (String)"yyyyMMdd"));
            sipProductMaterial.setIsDynamic("N");
            sipProductMaterial.setDisplayOrder(Integer.valueOf(1));
            this.dao.save((AbsModel)sipProductMaterial);
            ArrayList sipProductMaterialRelations = new ArrayList();
            risks.stream().forEach(o -> {
                SipProductMaterialRelation sipProductMaterialRelation = new SipProductMaterialRelation();
                sipProductMaterialRelation.setRiskUuid(o.getRiskUuid());
                sipProductMaterialRelation.setRiskNo(o.getRiskNo());
                sipProductMaterialRelation.setPolicyId(o.getPolicyId());
                sipProductMaterialRelation.setRiskName(o.getRiskName());
                sipProductMaterialRelation.setState("INIT");
                sipProductMaterialRelation.setMaterialId(materialId);
                sipProductMaterialRelations.add(sipProductMaterialRelation);
            });
            this.dao.save(sipProductMaterialRelations);
        }
        resMap.put("success", "true");
        resMap.put("errorMsg", "");
        return JsonUtils.toJson(resMap);
    }

    public static MultipartFile convertToMultipartFile(byte[] fileContent, String fileName, String contentType) throws IOException {
        return new MockMultipartFile(fileName, fileName, contentType, fileContent);
    }

    public File getHtml(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getHtml(files[i]);
                continue;
            }
            String name = files[i].getName();
            if (!name.endsWith(".html")) continue;
            File file1 = files[i];
            return file1;
        }
        return null;
    }

    public File getZip(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getHtml(files[i]);
                continue;
            }
            String name = files[i].getName();
            if (!name.endsWith(ALLOW_SUFFIX)) continue;
            File file1 = files[i];
            return file1;
        }
        return null;
    }

    @Override
    public Map<String, Object> solvencylnfo() {
        Object solvencyObject = CacheManager.get((String)"solvencyInfo");
        Map resultMap = new HashMap();
        if (!StrUtils.isNull((Object)solvencyObject)) {
            resultMap = (Map)solvencyObject;
        } else {
            JSONObject reqJson = new JSONObject();
            reqJson.put("transRefGUID", (Object)UUID.uuid());
            reqJson.put("transType", (Object)"CBS_SOL_QY_001");
            reqJson.put("transExeDate", (Object)DateUtils.date2String((Date)new Date(), (String)"yyyy-MM-dd"));
            reqJson.put("transExeTime", (Object)DateUtils.date2String((Date)new Date(), (String)"HH:mm:ss"));
            reqJson.put("consumer", (Object)"13");
            String transno = UUID.shortUUID();
            SysTradeLog sysTradeLog = new SysTradeLog();
            sysTradeLog.setTransNo(transno);
            sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
            sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentSolvency.getType());
            sysTradeLog.setSystemNo(SmsEnum.callSystem.SystemCore.getType());
            sysTradeLog.setParamData(reqJson.toString());
            this.systemAbutmentUtil.insertSysTradeLog(sysTradeLog);
            String resultStr = HttpUtils.jsonPost((String)this.solvencyUrl, (String)reqJson.toString());
            sysTradeLog.setParamData(resultStr);
            sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
            this.systemAbutmentUtil.insertSysTradeLog(sysTradeLog);
            if (StrUtils.isNull((Object)resultStr)) {
                return null;
            }
            Map resultAllMap = JsonUtils.json2Map((String)resultStr);
            resultMap = (Map)resultAllMap.get("result");
            CacheManager.put((String)"solvencyInfo", resultMap, (int)43200);
        }
        return resultMap;
    }

    public static void unzip(InputStream zipFile, String destDir) {
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(zipFile, Charset.forName("GBK"));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                File file = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                entry = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        File file = new File("C:\\Users\\Administrator\\Desktop\\Desktop.zip");
        ProductMaterialServiceImpl.unzip(new FileInputStream(file), "C:\\Users\\Administrator\\Desktop");
    }

    private Return unzipFile(MultipartFile file, String path) {
        String fileName = file.getOriginalFilename();
        long fileSize = file.getSize();
        Return msg = this.checkFile(fileName, fileSize);
        try {
            File destFile = new File(path);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            File file1 = new File(path + fileName);
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)file1);
            com.uniapis.utils.FileUtils.unzip((InputStream)file.getInputStream(), (String)path);
            ArrayList<File> files = new ArrayList<File>();
            files.add(file1);
            try {
                Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> files.add(new File(String.valueOf(p))));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            files.forEach(o -> {
                String key = this.obsConfig.getObsPath() + o.getPath().replace(Env.env().baseDir(), "");
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    private Return checkFile(String fileName, long fileSize) {
        String suffix;
        Return msg = new Return();
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6");
        }
        if (ALLOW_SUFFIX.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6");
        }
        if (fileSize <= 0L) {
            msg.setFailMsg("\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB");
        }
        return msg;
    }

    public void getAllFiles(File dir, List<File> jsonList, List<File> fileList, List<File> pngList) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], jsonList, fileList, pngList);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(".json")) {
                File file1 = files[i];
                jsonList.add(file1);
            }
            if ((name.endsWith(".pdf") || name.endsWith(".html") || name.endsWith(ALLOW_SUFFIX)) && !name.startsWith("~")) {
                File file2 = files[i];
                fileList.add(file2);
            }
            if (name.endsWith(".png")) {
                File file3 = files[i];
                pngList.add(file3);
            }
            Ulog.info((Object)files[i]);
        }
    }

    private ReturnMsg textConvert(AddPdMaterialVo renewPdMaterialVo, Return msg) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE html>");
        stringBuilder.append("<html>");
        stringBuilder.append("<head>");
        stringBuilder.append("<meta charset=\"UTF-8\">");
        stringBuilder.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        stringBuilder.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
        stringBuilder.append("<title>");
        stringBuilder.append(renewPdMaterialVo.getMaterialAliasing());
        stringBuilder.append("</title>");
        stringBuilder.append("<style type=\"text/css\">\n\t* {\n\t\tmargin: 0;\n\t\tpadding: 0;\n\t}\n\n\tbody {\n\t\twidth: 100vw;\n\t}\n</style>");
        stringBuilder.append("</head>");
        stringBuilder.append("<body>");
        stringBuilder.append(renewPdMaterialVo.getMaterialText());
        stringBuilder.append("</body></html>");
        try {
            String filePath = "pdMaterial/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + ".html";
            String nasPath = Env.env().baseDir() + filePath;
            File file = new File(nasPath);
            String htmls = new String(stringBuilder.toString().getBytes("utf-8"), "utf-8");
            ArrayList<String> htmlList = new ArrayList<String>();
            htmlList.add(htmls);
            com.uniapis.utils.FileUtils.writeFile((String)nasPath, htmlList, (boolean)false);
            renewPdMaterialVo.setMaterialPath(this.obsConfig.getObsSplitPath() + filePath);
            renewPdMaterialVo.setMaterialType("html");
            String key = this.obsConfig.getObsPath() + filePath;
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg(new Message("300013", "\u5bcc\u6587\u672c\u8f6chtml\u5931\u8d25\uff01"));
            return msg.msg();
        }
    }

    private ReturnMsg textConvertHtml(SipProductMaterial sipProductMaterial, Return msg) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE html>");
        stringBuilder.append("<html>");
        stringBuilder.append("<head>");
        stringBuilder.append("<meta charset=\"UTF-8\">");
        stringBuilder.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        stringBuilder.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
        stringBuilder.append("<title>");
        stringBuilder.append(sipProductMaterial.getMaterialAliasing());
        stringBuilder.append("</title>");
        stringBuilder.append("<style type=\"text/css\">\n\t* {\n\t\tmargin: 0;\n\t\tpadding: 0;\n\t}\n\n\tbody {\n\t\twidth: 100vw;\n\t}\n</style>");
        stringBuilder.append("</head>");
        stringBuilder.append("<body>");
        stringBuilder.append(sipProductMaterial.getMaterialText());
        stringBuilder.append("</body></html>");
        try {
            String filePath = "pdMaterial/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + ".html";
            String nasPath = Env.env().baseDir() + filePath;
            File file = new File(nasPath);
            String htmls = new String(stringBuilder.toString().getBytes("utf-8"), "utf-8");
            ArrayList<String> htmlList = new ArrayList<String>();
            htmlList.add(htmls);
            com.uniapis.utils.FileUtils.writeFile((String)nasPath, htmlList, (boolean)false);
            sipProductMaterial.setMaterialPath(this.obsConfig.getObsSplitPath() + filePath);
            sipProductMaterial.setMaterialType("html");
            String key = this.obsConfig.getObsPath() + filePath;
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg(new Message("300013", "\u5bcc\u6587\u672c\u8f6chtml\u5931\u8d25\uff01"));
            return msg.msg();
        }
    }

    private ReturnMsg checkPdMaterialValue(AddPdMaterialVo addPdMaterialVo, String flag, Return msg) {
        if ("add".equals(flag) && CollectionUtils.isEmpty((Collection)addPdMaterialVo.getRiskVoList())) {
            msg.setFailMsg(new Message("300001", "\u8bf7\u9009\u62e9\u9669\u79cd\u540d\u79f0\uff01"));
            return msg.msg();
        }
        if (!"renew".equals(flag) && StrUtils.isNull((Object)addPdMaterialVo.getDeliveryPlatform())) {
            msg.setFailMsg(new Message("300002", "\u8bf7\u9009\u62e9\u6240\u5c5e\u5e73\u53f0\uff01"));
            return msg.msg();
        }
        if (!"renew".equals(flag) && StrUtils.isNull((Object)addPdMaterialVo.getMaterialCode())) {
            msg.setFailMsg(new Message("300003", "\u8bf7\u9009\u62e9\u8d44\u6599\u7c7b\u522b\uff01"));
            return msg.msg();
        }
        if (!"renew".equals(flag) && StrUtils.isNull((Object)addPdMaterialVo.getMaterialSubCode())) {
            msg.setFailMsg(new Message("300004", "\u8bf7\u9009\u62e9\u5b50\u7ea7\u7c7b\u522b\uff01"));
            return msg.msg();
        }
        if (!"renew".equals(flag) && StrUtils.isNull((Object)addPdMaterialVo.getMaterialSubCode())) {
            msg.setFailMsg(new Message("300004", "\u8bf7\u9009\u62e9\u5b50\u7ea7\u7c7b\u522b\uff01"));
            return msg.msg();
        }
        if (StrUtils.isNull((Object)addPdMaterialVo.getMaterialAliasing())) {
            msg.setFailMsg(new Message("300005", "\u8bf7\u8f93\u5165\u8d44\u6599\u540d\u79f0\uff01"));
            return msg.msg();
        }
        if (StrUtils.isNull((Object)addPdMaterialVo.getVersion())) {
            msg.setFailMsg(new Message("300006", "\u8bf7\u8f93\u5165\u7248\u672c\u53f7\uff01"));
            return msg.msg();
        }
        if (StrUtils.isNull((Object)addPdMaterialVo.getMaterialSource())) {
            msg.setFailMsg(new Message("300007", "\u8bf7\u9009\u62e9\u8d44\u6599\u6765\u6e90\uff01"));
            return msg.msg();
        }
        String materialSource = addPdMaterialVo.getMaterialSource();
        if ((MaterialSource.PDFMapping.getCode().equals(materialSource) || MaterialSource.HTMLMapping.getCode().equals(materialSource)) && StrUtils.isNull((Object)addPdMaterialVo.getMaterialPath())) {
            msg.setFailMsg(new Message("300008", "\u8bf7\u9009\u62e9\u4e0a\u4f20\u8d44\u6599\uff01"));
            return msg.msg();
        }
        if (MaterialSource.TEXTMapping.getCode().equals(materialSource) && StrUtils.isNull((Object)addPdMaterialVo.getMaterialText())) {
            msg.setFailMsg(new Message("300009", "\u8bf7\u8f93\u5165\u5bcc\u6587\u672c\u5185\u5bb9\uff01"));
            return msg.msg();
        }
        if (MaterialSource.OLDMapping.getCode().equals(materialSource) && StrUtils.isNull((Object)addPdMaterialVo.getMaterialSourceId())) {
            msg.setFailMsg(new Message("300010", "\u8bf7\u9009\u62e9\u5df2\u6709\u8d44\u6599\uff01"));
            return msg.msg();
        }
        if (StrUtils.isNull((Object)addPdMaterialVo.getDisplayOrder())) {
            msg.setFailMsg(new Message("300011", "\u8bf7\u8f93\u5165\u5c55\u793a\u987a\u5e8f\uff01"));
            return msg.msg();
        }
        return null;
    }
}

