/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.main.services.impl;

import com.newtouch.nms.sip.design.data.service.StructureService;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipOrganProductInfo;
import com.newtouch.nms.sip.model.SipOrganProducts;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.config.service.IProductConfigService;
import com.newtouch.nms.sip.product.main.services.IProductQueryDetailService;
import com.newtouch.nms.sip.product.structure.dao.IStructureDao;
import com.newtouch.nms.sip.product.structure.service.IStructureSearchService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductQueryDetailServiceImpl
implements IProductQueryDetailService {
    @Autowired(required=false)
    private AbsModelRepository dao;
    @Autowired
    private IStructureSearchService structureSearchService;
    @Autowired
    private StructureService structureService;
    @Autowired
    private IProductConfigService productConfigService;
    @Autowired
    private IStructureDao structureDaoImpl;
    @Autowired
    private AbsModelRepository sqlDao;

    @Override
    public ReturnMsg queryProductDetail(Map<String, Object> param) {
        Return msg = new Return();
        List<Map<String, Object>> productDetail = this.queryProductDetailByLevel(param);
        msg.setDataList(productDetail);
        return msg.msg();
    }

    private List<DsnBizAttribute> queryAllAttr(DsnStructure dsnNode) {
        String queryAttr = "SELECT * FROM dsn_biz_attribute  WHERE biz_uuid in        (SELECT node_no FROM dsn_structure WHERE up_node = ? )  ORDER BY display_order ";
        List allAttrList = this.dao.findAll(queryAttr, DsnBizAttribute.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{dsnNode.getNodeNo()})});
        this.initBizAttributeOptions(dsnNode, allAttrList);
        return allAttrList;
    }

    private void initBizAttributeOptions(DsnStructure dsnNode, List<DsnBizAttribute> allAttrList) {
        String queryAttrOptValue = " SELECT dbao.*    FROM dsn_biz_attribute dba, dsn_biz_attribute_option dbao   WHERE dba.biz_uuid = dbao.biz_uuid      AND dba.biz_uuid IN (SELECT node_no FROM dsn_structure WHERE up_node = ? )   ORDER BY dbao.option_order ";
        List attrOptValueList = this.dao.findAll(queryAttrOptValue, DsnBizAttributeOption.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{dsnNode.getNodeNo()})});
        Map<String, List<DsnBizAttributeOption>> optionGroup = attrOptValueList.stream().collect(Collectors.groupingBy(DsnBizAttributeOption::getBizUuid));
        for (DsnBizAttribute bizAttr : allAttrList) {
            if (optionGroup.get(bizAttr.getBizUuid()) == null) continue;
            bizAttr.putOtherProperty("attrOptValueList", optionGroup.get(bizAttr.getBizUuid()));
        }
    }

    public List<Map<String, Object>> queryProductDetailByLevel(Map<String, Object> param) {
        String productUuid = (String)param.get("product_uuid");
        List attrList = null;
        List<Map<String, Object>> optionList = null;
        StringBuilder str = new StringBuilder();
        str.append("SELECT attr.* FROM dsn_structure str   join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type = ? order by str.display_order");
        ArrayList<String> list = new ArrayList<String>();
        list.add(productUuid);
        list.add(NodeType.ATTR_DETAIL.code());
        attrList = this.dao.findAll(String.valueOf(str), new AbsModelRepository.Args[]{this.dao.args(list)});
        for (Map attr : attrList) {
            String ui_type = StrUtils.trimStr(attr.get("ui_type"));
            if ("date".equals(ui_type) || "text".equals(ui_type) || "number".equals(ui_type)) continue;
            String bizUuid = (String)attr.get("biz_uuid");
            optionList = this.queryAttrOption(bizUuid);
            attr.put("attrOption", optionList);
        }
        this.getFieldValueOrgan(attrList, param, productUuid);
        return attrList;
    }

    public DsnStructure getDsnStructureByUpNode(String nodeNo) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        return (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
    }

    private List<Map<String, Object>> queryAttrOption(String bizUuid) {
        List optionList = this.dao.findAll4Map((AbsModel)((DsnBizAttributeOption)DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizUuid).model()).setOrderBy(new Sort.Order[]{DsnBizAttributeOption.OPTION_ORDER.asc()}));
        return optionList;
    }

    private void getFieldValueOrgan(List<Map<String, Object>> attrList, Map<String, Object> param, String productUuid) {
        String addBatch;
        String organIds = (String)param.get("organ_id");
        String deliveryPlatform = (String)param.get("delivery_platform");
        String[] organIdList = organIds.split("#");
        String organId = organIdList[0];
        String channelNo = (String)param.get("channel_no");
        List productInfo = this.dao.findAll4Map(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)productUuid).model());
        Map product = productInfo.isEmpty() ? null : (Map)productInfo.get(0);
        for (Map<String, Object> attrValue : attrList) {
            String storedTab = StrUtils.trimStr((Object)attrValue.get("stored_tab"));
            String storedField = StrUtils.trimStr((Object)attrValue.get("stored_field"));
            String string = StrUtils.trimStr((Object)attrValue.get("attr_no"));
            if (!"sip_products".equalsIgnoreCase(storedTab) || null == product) continue;
            if ("product_no".equals(string)) {
                String productNo = StrUtils.trimStr(product.get("product_no"));
                attrValue.put("field_value", productNo);
                continue;
            }
            attrValue.put("field_value", product.get(storedField));
        }
        String curOrganId = "86";
        int endIndex = 2;
        while (!organId.equals(curOrganId)) {
            SipOrganProducts sipOrganProducts = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipOrganProducts.ORGAN_ID, (Object)curOrganId).addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo).addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid).addLike(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model());
            for (Map map : attrList) {
                map.put("allow_switch", map.get("allow_mdf"));
                if (sipOrganProducts == null) continue;
                this.detalFieldData(sipOrganProducts.getOrganPrdUuid(), map);
            }
            curOrganId = organId.substring(0, endIndex += 2).concat(curOrganId.substring(endIndex));
        }
        if (organId.equals(curOrganId)) {
            attrList.forEach(o -> o.put("allow_switch", o.get("allow_mdf")));
        }
        String organPrdUuid = "";
        String string = addBatch = param.containsKey("add_batch") && !StrUtils.isNull((Object)param.get("add_batch")) ? param.get("add_batch").toString() : "";
        if (StrUtils.isNull((Object)addBatch)) {
            SipOrganProducts sipOrganProducts = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipOrganProducts.ORGAN_ID, (Object)curOrganId).addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo).addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid).addEq(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model());
            if (!StrUtils.isNull((Object)sipOrganProducts)) {
                organPrdUuid = sipOrganProducts.getOrganPrdUuid();
            }
        } else {
            organPrdUuid = addBatch;
        }
        if (!StrUtils.isNull((Object)organPrdUuid)) {
            for (Map<String, Object> attrValue : attrList) {
                Map organProduct;
                String attrUuid = StrUtils.trimStr((Object)attrValue.get("attr_uuid"));
                List productOrganInfo = this.dao.findAll4Map(SipOrganProductInfo.n().where().addEq(SipOrganProductInfo.ORGAN_PRD_UUID, (Object)organPrdUuid).addEq(SipOrganProductInfo.ATTR_UUID, (Object)attrUuid).model());
                Map map = organProduct = productOrganInfo.isEmpty() ? null : (Map)productOrganInfo.get(0);
                if (null != organProduct) {
                    attrValue.put("field_value", organProduct.get("attr_value"));
                    attrValue.put("allow_switch", organProduct.get("allow_mdf"));
                }
                if (!attrValue.get("allow_mdf").equals("N")) continue;
                attrValue.put("allow_switch", "N");
            }
        }
    }

    private void detalFieldData(String organPrdUuid, Map<String, Object> attrValue) {
        String attrUuid = StrUtils.trimStr((Object)attrValue.get("attr_uuid"));
        if (!StrUtils.isNull((Object)organPrdUuid)) {
            Map organProduct;
            List productOrganInfo = this.dao.findAll4Map(SipOrganProductInfo.n().where().addEq(SipOrganProductInfo.ORGAN_PRD_UUID, (Object)organPrdUuid).addEq(SipOrganProductInfo.ATTR_UUID, (Object)attrUuid).model());
            Map map = organProduct = productOrganInfo.isEmpty() ? null : (Map)productOrganInfo.get(0);
            if (null != organProduct) {
                attrValue.put("field_value", organProduct.get("attr_value"));
                attrValue.put("allow_mdf", organProduct.get("allow_mdf"));
            }
        }
    }

    public List<Map<String, Object>> queryProductAttrByLevel(String productUuid, String organId, String channelNo, String nodeNo) {
        List<Map<String, Object>> optionList = null;
        DsnStructure dsnStructure = new DsnStructure();
        DsnStructure productAttr = this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.ATTR_DETAIL.code());
        String queryProduct = "SELECT * FROM dsn_structure str  join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type = ? order by str.display_order";
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(productAttr.getNodeNo());
        list.args().add(NodeType.ATTR.code());
        List productAttrInfo = this.dao.findAll(String.valueOf(queryProduct), new AbsModelRepository.Args[]{list});
        for (Map attrVo : productAttrInfo) {
            String bizUuid = (String)attrVo.get("biz_uuid");
            optionList = this.queryAttrOption(bizUuid);
            attrVo.put("attrOption", optionList);
            dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)StrUtils.trimStr(attrVo.get("node_no")));
            DsnStructure ruleNo = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
            HashMap ruleInfo = new HashMap();
            attrVo.put("ruleOption", ruleInfo);
        }
        return productAttrInfo;
    }

    public DsnStructure getDsnStructureByUpNodeAndNodeType(String nodeNo, String type) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)type);
        return (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
    }

    private SipProducts getProductInfo(String upNodeNo) {
        SipProducts sipProducts = null;
        DsnStructure sipProductsDetail = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD_DETAIL.code()).model());
        if (sipProductsDetail != null) {
            sipProducts = (SipProducts)this.dao.findOne(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)sipProductsDetail.getNodeNo()).model());
        }
        return sipProducts;
    }
}

