/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.tree.controller;

import com.newtouch.nms.sip.design.attribute.services.IAttributeService;
import com.newtouch.nms.sip.design.tree.services.IPublicTreeService;
import com.newtouch.nms.sip.model.DsnAttribute;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.rate.services.IRateService;
import com.newtouch.nms.sys.model.SysTreeMenu;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestParam;
import com.uniapis.web.utils.RequestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tree"})
public class PublicTreeController {
    @Autowired
    private IPublicTreeService pubTree;
    @Autowired
    private IRateService rateService;
    @Autowired
    private IAttributeService attrservice;

    @RequestMapping(value={"/goPublicTree.do"})
    public String goProductAdd(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReturnMsg msg = this.pubTree.queryTree(RequestUtils.getRequestMap((HttpServletRequest)request, (String)"node_no"));
        msg.getDataListIncludes().addAll(Arrays.asList("serno", "node_no", "node_name", "node_type", "display_order", "node_code", "node_seq", "up_node"));
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/getMainRiskByProductUuid.do"})
    public String getMainRiskByProductUuid(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String productUuid = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"product_uuid");
        if (StrUtils.isNull((Object)productUuid)) {
            throw new BusinessException("\u5165\u53c2productUuid\u4e3a\u7a7a");
        }
        ReturnMsg msg = this.pubTree.getMainRiskByProductUuid(productUuid);
        msg.getDataListIncludes().addAll(Arrays.asList("serno", "node_no", "node_name", "node_type", "display_order", "node_code", "node_seq", "up_node"));
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/getAccyRiskByProductUuid.do"})
    public String getAccyRiskByProductUuid(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String productUuid = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"product_uuid");
        if (StrUtils.isNull((Object)productUuid)) {
            throw new BusinessException("\u5165\u53c2productUuid\u4e3a\u7a7a");
        }
        ReturnMsg msg = this.pubTree.getAccyRiskByProductUuid(productUuid);
        msg.getDataListIncludes().addAll(Arrays.asList("serno", "node_no", "node_name", "node_type", "display_order", "node_code", "node_seq", "up_node"));
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/getAccyExemptByProductUuid.do"})
    public String getAccyExemptByProductUuid(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String productUuid = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"product_uuid");
        if (StrUtils.isNull((Object)productUuid)) {
            throw new BusinessException("\u5165\u53c2productUuid\u4e3a\u7a7a");
        }
        ReturnMsg msg = this.pubTree.getAccyExemptByProductUuid(productUuid);
        msg.getDataListIncludes().addAll(Arrays.asList("serno", "node_no", "node_name", "node_type", "display_order", "node_code", "node_seq", "up_node"));
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/getMainExemptByProductUuid.do"})
    public String getMainExemptByProductUuid(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String productUuid = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"product_uuid");
        if (StrUtils.isNull((Object)productUuid)) {
            throw new BusinessException("\u5165\u53c2productUuid\u4e3a\u7a7a");
        }
        ReturnMsg msg = this.pubTree.getMainExemptByProductUuid(productUuid);
        msg.getDataListIncludes().addAll(Arrays.asList("serno", "node_no", "node_name", "node_type", "display_order", "node_code", "node_seq", "up_node"));
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doReloadTree.do"})
    public String doReloadTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReturnMsg msg = this.pubTree.queryTree(RequestUtils.getRequestMap((HttpServletRequest)request, (String)"prdUUID4NodeNo"));
        msg.getDataListIncludes().add("serno");
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doTreeMenuQuery.do"})
    public String doTreeMenuQuery(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String node_type = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"node_type");
        String userNo = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"user_no");
        ReturnMsg msg = this.pubTree.queryTreeMenu(node_type, userNo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goDefNodeAdd.do"})
    public String goTreeNodeAdd(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        DsnStructure node = (DsnStructure)RequestUtils.getRequestMap((Map)param, DsnStructure.class);
        SysTreeMenu menuInfo = (SysTreeMenu)RequestUtils.getRequestMap((Map)((Map)param.get("menu_info")), SysTreeMenu.class);
        ReturnMsg msg = this.pubTree.queryRootMenu(node, menuInfo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doDefNodeAdd.do"})
    public String doTreeNodeAdd(HttpServletRequest request, HttpServletResponse response) {
        DsnStructure node = (DsnStructure)RequestUtils.getRequestMap((HttpServletRequest)request, DsnStructure.class);
        ReturnMsg msg = this.pubTree.addTreeNode(node);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doRiskAttibuteAddNew.do"})
    public String doAttibuteAddNew(HttpServletRequest request, HttpServletResponse response) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        RequestParam requestParam = RequestUtils.getRequestMap((Map)requestMap, (Class[])new Class[]{DsnStructure.class, DsnBizAttribute.class, DsnAttribute.class});
        DsnStructure structure = (DsnStructure)requestParam.getParam(0, DsnStructure.class);
        DsnStructure dsnStructure = (DsnStructure)RequestUtils.getRequestMap((Map)this.pubTree.addTreeNode(structure).getDataTable(), DsnStructure.class);
        DsnBizAttribute attribute = (DsnBizAttribute)requestParam.getParam(1, DsnBizAttribute.class);
        attribute.setDisplayOrder(dsnStructure.getDisplayOrder());
        DsnAttribute allattribute = (DsnAttribute)requestParam.getParam(2, DsnAttribute.class);
        List<Object> optionList = new ArrayList<DsnBizAttributeOption>();
        if (!StrUtils.isNull(requestMap.get("dsn_biz_attribute_option"))) {
            optionList = JsonUtils.listMap2ListClass((List)((List)requestMap.get("dsn_biz_attribute_option")), DsnBizAttributeOption.class);
        }
        ReturnMsg msg = this.attrservice.mdfAttribute(dsnStructure, attribute, allattribute, optionList);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doNodeDisplayOrderMdf.do"})
    public String doNodeDisplayOrderMdf(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        List structureList = JsonUtils.listMap2ListClass((List)((List)requestMap.get("structure_list")), DsnStructure.class);
        ReturnMsg msg = this.pubTree.doNodeDisplayOrderMdf(structureList);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

