/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.data.service.impl;

import com.newtouch.nms.sip.design.data.service.StructureService;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class StructureServiceImpl
implements StructureService {
    private static final String ATTR_LENGTH = "attr_length";
    @Autowired
    private AbsModelRepository dao;

    @Override
    public List<DsnStructure> getSubAttr(DsnStructure dsn) {
        DsnStructure detailAttr = new DsnStructure();
        detailAttr.where().addEq(DsnStructure.UP_NODE, (Object)dsn.getNodeNo());
        detailAttr.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
        return this.dao.findAll((AbsModel)detailAttr, Boolean.valueOf(false));
    }

    @Override
    public List<DsnStructure> getSubAttr(String nodeNo) {
        DsnStructure detailAttr = new DsnStructure();
        detailAttr.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        detailAttr.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
        return this.dao.findAll((AbsModel)detailAttr, Boolean.valueOf(false));
    }

    @Override
    public DsnStructure getOneDsnBySerno(String serno) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.SERNO, (Object)serno);
        return (DsnStructure)this.dao.findOne((AbsModel)dsn);
    }

    @Override
    public DsnStructure getOneDsnByNodeNo(String nodeNo) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        List queryList = this.dao.findAll((AbsModel)dsn);
        return (DsnStructure)queryList.get(0);
    }

    @Override
    public String getRiskUuidByNode(DsnStructure riskNode) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.UP_NODE, (Object)riskNode.getNodeNo());
        dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code());
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            throw new BusinessException("\u9669\u79cd[" + riskNode.getNodeName() + "]\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        return ((DsnStructure)queryList.get(0)).getNodeNo();
    }

    @Override
    public String getRiskUuidByNodeNo(String upRiskNodeNo) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.UP_NODE, (Object)upRiskNodeNo);
        dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code());
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            return null;
        }
        return ((DsnStructure)queryList.get(0)).getNodeNo();
    }

    @Override
    public List<DsnStructure> getSubNode(String upNodeNo) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.UP_NODE, (Object)upNodeNo);
        dsn.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
        return this.dao.findAll((AbsModel)dsn);
    }

    @Override
    public void delNodeBySerno(String serno) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.SERNO, (Object)serno);
        this.dao.delete((AbsModel)dsn);
    }

    @Override
    public int getMaxDisplayOrder(String upNodeNo) {
        DsnStructure maxOrder = new DsnStructure();
        maxOrder.where().addEq(DsnStructure.UP_NODE, (Object)upNodeNo);
        maxOrder.groupBy().max(DsnStructure.DISPLAY_ORDER);
        maxOrder = (DsnStructure)this.dao.findOne((AbsModel)maxOrder);
        Object maxDisplayOrder = maxOrder.getOtherProperty("max_display_order", String.class);
        return Integer.parseInt(StrUtils.isNull((Object)maxDisplayOrder) ? "0" : maxDisplayOrder.toString());
    }

    @Override
    public void bizAttributeFieldChange(Map<String, Object> tmpMap) {
        tmpMap.put("length", tmpMap.get(ATTR_LENGTH));
        tmpMap.put("interger", tmpMap.get("attr_integer"));
        tmpMap.put("attr_precision", tmpMap.get("attr_precision"));
    }

    @Override
    public void bizAttributeFieldChange2(Map<String, Object> tmpMap) {
        String attrLength = "";
        if (tmpMap.get(ATTR_LENGTH).toString() != null) {
            attrLength = tmpMap.get(ATTR_LENGTH).toString();
        }
        tmpMap.put("length", attrLength);
        String interger = "";
        if (tmpMap.get("attr_integer") != null) {
            interger = tmpMap.get("attr_integer").toString();
        }
        tmpMap.put("interger", interger);
        String attrPrecision = "";
        if (tmpMap.get("attr_precision") != null) {
            attrPrecision = tmpMap.get("attr_precision").toString();
        }
        tmpMap.put("attr_precision", attrPrecision);
    }
}

