/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.data.service.impl;

import com.newtouch.nms.sip.design.data.service.IDataService;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataServiceImpl
implements IDataService {
    @Autowired
    private AbsModelRepository dao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg getProductInfoData(Map<String, Object> paramMap) {
        Return msg = this.checkParam(paramMap);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        String organID = StrUtils.trimStr((Object)paramMap.get("organ_id"));
        String channelType = StrUtils.trimStr((Object)paramMap.get("channel_type"));
        String mdfDate = StrUtils.trimStr((Object)paramMap.get("mdf_date"));
        Map<String, Object> productOrganMap = this.getProductInfo(organID, channelType);
        String newMdfDate = "";
        if (null == productOrganMap || productOrganMap.isEmpty()) {
            msg = new Return();
            msg.setSuccessMsg("\u5728sip_products_organ\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u8bb0\u5f55\uff01");
            return msg.msg();
        }
        Date tmpMdfDate = (Date)productOrganMap.get("mdfDate");
        newMdfDate = DateUtils.date2String((Date)tmpMdfDate, (String)"yyyy-MM-dd HH:mm:ss");
        if (!StrUtils.isNull((Object)newMdfDate)) {
            if (newMdfDate.equals(mdfDate)) {
                msg = new Return();
                msg.setSuccessMsg("\u8bf7\u6c42\u7684mdfDate\u76f8\u540c\uff0c\u4e0d\u8fd4\u56de\u6570\u636e");
                return msg.msg();
            }
            Map redisData = this.getRedisData(organID, channelType, mdfDate);
            if (null == redisData || redisData.isEmpty()) {
                DataServiceImpl dataServiceImpl = this;
                synchronized (dataServiceImpl) {
                    redisData = this.getRedisData(organID, channelType, mdfDate);
                    if (null == redisData || redisData.isEmpty()) {
                        msg = new Return();
                        Map<String, Object> resultMap = this.queryDBData(organID, channelType, productOrganMap);
                        Ulog.info((String)"\u67e5\u8be2\u4e86\u6570\u636e\u5e93\u3002\u3002\u3002\n");
                        msg.setDataTable(resultMap);
                        String key = channelType + "_" + organID + "_" + mdfDate;
                        CacheManager.put((String)key, (Object)JsonUtils.toJson(resultMap), (int)300);
                        return msg.msg();
                    }
                    Ulog.info((String)"\u67e5\u8be2\u4e86\u7f13\u5b58\u3002\u3002\u3002\n");
                }
            } else {
                Ulog.info((String)"\u67e5\u8be2\u4e86\u7f13\u5b58\u3002\u3002\u3002\n");
            }
            msg = new Return();
            msg.setDataTable(redisData);
            return msg.msg();
        }
        return msg.msg();
    }

    private Map<String, Object> queryDBData(String organID, String channelType, Map<String, Object> productOrganMap) {
        List productList = (List)productOrganMap.get("productList");
        Date tmpMdfDate = (Date)productOrganMap.get("mdfDate");
        String mdfDate = DateUtils.date2String((Date)tmpMdfDate, (String)"yyyy-MM-dd HH:mm:ss");
        Map<String, Object> resultMap = this.getRiskInfo(productList, organID);
        resultMap.put("organ_id", organID);
        resultMap.put("channel_type", channelType);
        resultMap.put("mdf_date", mdfDate);
        return resultMap;
    }

    private Map<String, Object> getRiskInfo(List<String> productList, String organID) {
        HashSet<Map> sipProductRisksSet = new HashSet<Map>(16);
        SipProductRisks sipProductRisks4Query = null;
        List sipProductRisks4List = null;
        ArrayList prdOrganUUIDList = new ArrayList(10);
        HashSet<SipRisks> sipRisksSet = new HashSet<SipRisks>(16);
        HashSet<SipRiskRelation> riskRelationSet = new HashSet<SipRiskRelation>(16);
        HashSet<String> riskUUIDSet = new HashSet<String>(16);
        HashSet riskRelationSernoSet = new HashSet(16);
        for (String productUUID : productList) {
            SipProducts sip_products = this.getProductOfProposeFlag(productUUID);
            sipProductRisks4Query = new SipProductRisks();
            sipProductRisks4Query.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUUID);
            sipProductRisks4List = this.dao.findAll((AbsModel)sipProductRisks4Query);
            if (null == sipProductRisks4List || sipProductRisks4List.isEmpty()) continue;
            for (SipProductRisks sipProductRisks4Result : sipProductRisks4List) {
                Map sipProductRiskMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)sipProductRisks4Result));
                sipProductRiskMap.put("product_name", sip_products.getProductName());
                sipProductRisksSet.add(sipProductRiskMap);
                String riskUUID = sipProductRisks4Result.getRiskUuid();
                riskUUIDSet.add(riskUUID);
            }
        }
        for (String productUUID : prdOrganUUIDList) {
        }
        for (String riskRelationStr : riskRelationSernoSet) {
            SipRiskRelation sipRiskRelation = this.queryRiskRelation(riskRelationStr);
            if (null == sipRiskRelation) continue;
            riskRelationSet.add(sipRiskRelation);
        }
        for (String riskUUIDStr : riskUUIDSet) {
            SipRisks risk = this.queryRisks(riskUUIDStr);
            if (null == risk) continue;
            sipRisksSet.add(risk);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("sip_product_risks", sipProductRisksSet);
        resultMap.put("sip_risks", sipRisksSet);
        resultMap.put("sip_risk_relation", riskRelationSet);
        return resultMap;
    }

    private SipRisks queryRisks(String riskUUID) {
        SipRisks sipRisks4Query = new SipRisks();
        sipRisks4Query.where().addEq(SipRisks.RISK_UUID, (Object)riskUUID);
        SipRisks sipRisks4Result = (SipRisks)this.dao.findOne((AbsModel)sipRisks4Query);
        return null != sipRisks4Result && !StrUtils.isNull((Object)sipRisks4Result) ? sipRisks4Result : null;
    }

    private SipRiskRelation queryRiskRelation(String riskRelationSerno) {
        SipRiskRelation sipRiskRelation4Query = new SipRiskRelation();
        sipRiskRelation4Query.where().addEq(SipRiskRelation.SERNO, (Object)riskRelationSerno);
        SipRiskRelation sipRiskRelation4Result = (SipRiskRelation)this.dao.findOne((AbsModel)sipRiskRelation4Query);
        return null != sipRiskRelation4Result && !StrUtils.isNull((Object)sipRiskRelation4Result.getSerno()) ? sipRiskRelation4Result : null;
    }

    private SipProducts getProductOfProposeFlag(String productUUID) {
        SipProducts sipProducts4Query = new SipProducts();
        sipProducts4Query.where().addEq(SipProducts.PRODUCT_UUID, (Object)productUUID);
        SipProducts sipProducts4Result = (SipProducts)this.dao.findOne((AbsModel)sipProducts4Query);
        return sipProducts4Result;
    }

    public Map<String, Object> getProductInfo(String organID, String channelType) {
        HashMap resultMap = new HashMap(16);
        ArrayList productList = new ArrayList(10);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("     * ").append(" FROM ").append("     sip_products_organ organ ").append(" WHERE ").append("     organ_id = ? ").append(" AND ? = ( ").append("     SELECT ").append("         channel_type ").append("     FROM ").append("         sip_products_channel chann ").append("     WHERE ").append("         chann.prd_chanl_uuid = organ.prd_chanl_uuid ").append(" ) ").append(" ORDER BY ").append("     mdf_date DESC ");
        this.dao.findAll(sqlBuffer.toString(), new AbsModelRepository.Args[]{this.dao.args(new Object[]{organID, channelType})});
        return null;
    }

    private String getSuperiorOrganID(String organID) {
        return organID;
    }

    private Map getRedisData(String organID, String channelType, String mdfDate) {
        Set redisKeySet = CacheManager.keys((String)(channelType + "_" + organID + "*"));
        if (null == redisKeySet || redisKeySet.isEmpty()) {
            Ulog.info((String)("\u5728redis\u4e2d\u672a\u67e5\u8be2\u5230key\u503c\u4e3aorgan_id\u4e3a\u3010" + organID + "\u3011\uff0cchannelType\u4e3a\u3010" + channelType + "\u3011\u7ec4\u6210\u7684\u8bb0\u5f55"));
            return null;
        }
        String redisKey = channelType + "_" + organID + "_" + mdfDate;
        Map redisValue = JsonUtils.json2Map((String)StrUtils.trimStr((Object)CacheManager.get((String)redisKey)));
        return redisValue;
    }

    private Return checkParam(Map<String, Object> paramMap) {
        Return msg = new Return();
        String organID = StrUtils.trimStr((Object)paramMap.get("organ_id"));
        if (StrUtils.isNull((Object)organID)) {
            msg.setFailMsg("\u6ca1\u6709\u83b7\u53d6\u5230\u673a\u6784ID\uff01");
            return msg;
        }
        String channelID = StrUtils.trimStr((Object)paramMap.get("channel_type"));
        if (StrUtils.isNull((Object)channelID)) {
            msg.setFailMsg("\u6ca1\u6709\u83b7\u53d6\u5230\u6e20\u9053\u7c7b\u578b\uff01");
            return msg;
        }
        String mdfDate = StrUtils.trimStr((Object)paramMap.get("mdf_date"));
        if (!StrUtils.isNull((Object)mdfDate)) {
            try {
                DateUtils.string2Date((String)mdfDate, (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                msg.setFailMsg("\u65f6\u95f4\u6233\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6309\u3010yyyy-MM-dd\u3011\u6dfb\u52a0\u6b63\u786e\u7684\u65f6\u95f4");
                return msg;
            }
        }
        return msg;
    }

    @Override
    public ReturnMsg getMarkDownData(Map<String, Object> paramMap) {
        Return msg = new Return();
        if (paramMap.get("risk_no") == null || StrUtils.isNull((Object)paramMap.get("risk_no"))) {
            msg.setFailMsg("\u9669\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u9669\u79cd\u7f16\u7801");
        }
        String risk_no = (String)paramMap.get("risk_no");
        SipRisks risks = new SipRisks();
        risks.where().addEq(SipRisks.RISK_NO, (Object)risk_no);
        SipRisks riskDao = (SipRisks)this.dao.findOne((AbsModel)risks);
        if (null == riskDao || StrUtils.isNull((Object)riskDao.getSerno())) {
            msg.setFailMsg("\u9669\u79cd\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9669\u79cd\u7f16\u7801");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        StringBuffer sql = new StringBuffer("select attr.attr_no , attr.attr_name ,  markdown.text_key , markdown.text_value\nfrom dsn_biz_attribute attr , dsn_structure str , sip_risks risks ,dsn_dynamic_text_data markdown\nwhere attr.biz_uuid = str.node_no and risks.risk_uuid = str.up_node and attr.biz_uuid = markdown.text_key and attr.ui_type=? and risk_no = ? ");
        if (paramMap.get("attr_no") != null && !StrUtils.isNull((Object)paramMap.get("attr_no"))) {
            sql.append(" and attr.attr_no = ? ");
        }
        sql.append("order by attr.display_order");
        ArrayList<String> params = new ArrayList<String>();
        params.add("markdown");
        params.add(risk_no);
        if (paramMap.get("attr_no") != null && !StrUtils.isNull((Object)paramMap.get("attr_no"))) {
            params.add(StrUtils.trimStr((Object)paramMap.get("attr_no")));
        }
        List markdownList = this.dao.findAll(sql.toString(), new AbsModelRepository.Args[]{this.dao.args(params)});
        for (Map markdownMap : markdownList) {
            markdownMap.put("text_value", ((String)markdownMap.get("text_value")).replaceAll("<br>", "\n"));
        }
        msg.setDataList(markdownList);
        return msg.msg();
    }
}

