/*
 * Decompiled with CFR 0.152.
 */
package com.jingantech.ngiam.cas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jingantech.ngiam.CasRequestFailureException;
import com.jingantech.ngiam.CasResponseDataFormatException;
import com.jingantech.ngiam.Format;
import com.jingantech.ngiam.RequestBody;
import com.jingantech.ngiam.ResponseBody;
import com.jingantech.ngiam.util.HttpClientUtil;
import com.jingantech.ngiam.util.StringUtil;
import com.jingantech.ngiam.util.XmlUtil;
import java.io.IOException;

public class CasService {
    public static ResponseBody casValidate(String url, String ticket, String service, Format format) throws IOException {
        RequestBody request = new RequestBody(url, ticket, service, format);
        CasService.check(request);
        String result = null;
        result = url.indexOf("https") > -1 || url.indexOf("HTTPS") > -1 ? HttpClientUtil.httpsGet(request.toString()) : HttpClientUtil.httpGet(request.toString());
        if (StringUtil.isEmpty(result)) {
            throw new CasResponseDataFormatException("response data is empty!");
        }
        switch (format) {
            case json: {
                return CasService.parseJSON(result);
            }
            case xml: {
                return CasService.parseXML(result);
            }
        }
        throw new CasRequestFailureException("request format is error!");
    }

    private static void check(RequestBody requestBody) {
        if (requestBody == null) {
            throw new CasRequestFailureException("request param is not null!");
        }
        if (StringUtil.isEmpty(requestBody.getUrl())) {
            throw new CasRequestFailureException("request url is not empty!");
        }
        if (StringUtil.isEmpty(requestBody.getService())) {
            throw new CasRequestFailureException("request service is not empty!");
        }
        if (StringUtil.isEmpty(requestBody.getTicket())) {
            throw new CasRequestFailureException("request ticket is not empty!");
        }
        if (requestBody.getFormat() == null) {
            throw new CasRequestFailureException("request format is not empty!");
        }
    }

    private static ResponseBody parseJSON(String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        if (!jsonObject.containsKey((Object)"serviceResponse")) {
            throw new CasResponseDataFormatException(json);
        }
        JSONObject jsonBody = jsonObject.getJSONObject("serviceResponse");
        if (jsonBody.containsKey((Object)"authenticationFailure")) {
            Object obj = jsonBody.get((Object)"authenticationFailure");
            if (obj instanceof String) {
                throw new CasRequestFailureException((String)obj);
            }
            JSONObject failure = jsonBody.getJSONObject("authenticationFailure");
            if (failure.containsKey((Object)"description")) {
                throw new CasRequestFailureException(failure.getString("description"));
            }
            throw new CasRequestFailureException(json);
        }
        if (jsonBody.containsKey((Object)"authenticationSuccess")) {
            jsonBody = jsonBody.getJSONObject("authenticationSuccess");
            ResponseBody body = (ResponseBody)JSONObject.parseObject((String)jsonBody.toJSONString(), ResponseBody.class);
            return body;
        }
        throw new CasResponseDataFormatException(json);
    }

    private static ResponseBody parseXML(String xml) {
        String json = XmlUtil.xml2JsonString(xml);
        return CasService.parseJSON(json);
    }
}

