/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.propose;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.propose.RateInfo;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class RateGroup {
    private DsnStructure rateNode;
    private List<RateInfo> rateInfoList;

    public RateGroup load(String upNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.rateNode = utils.queryStructure(upNode, NodeType.N_RATE.code());
        if (this.rateNode != null) {
            List<DsnStructure> dsnRateList = utils.queryStructures(this.rateNode.getNodeNo());
            this.rateInfoList = new ArrayList<RateInfo>();
            for (DsnStructure accyRisk : dsnRateList) {
                RateInfo rate = new RateInfo();
                rate.load(accyRisk);
                this.rateInfoList.add(rate);
            }
        }
        return this;
    }

    public void merge(RateGroup rateGroup) {
        this.rateNode = ProductEqualsUtils.merge(this.rateNode, rateGroup.getRateNode());
        this.rateInfoList = ProductEqualsUtils.merge(this.rateInfoList, rateGroup.getRateInfoList(), RateInfo.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        if (this.rateInfoList != null) {
            this.rateInfoList.forEach(m -> m.save());
        }
        if (this.rateNode != null) {
            update.update((AbsModel)this.rateNode);
        }
    }

    public TreeNode fetchTreeNode() {
        TreeNode node = new TreeNode(CompareEnum.NodeType.FEE_RATE.getLable(), CompareEnum.NodeType.FEE_RATE.getLable());
        if (this.rateNode != null) {
            node.getChildren().add(new TreeNode(this.rateNode.getSerno(), this.rateNode, CompareEnum.NodeType.STRUCTURE));
        }
        if (this.rateInfoList != null && this.rateInfoList.size() > 0) {
            TreeNode rateGroup = new TreeNode(CompareEnum.NodeType.FEE_RATE_GROUP.getLable(), CompareEnum.NodeType.FEE_RATE_GROUP.getLable());
            node.getChildren().add(rateGroup);
            this.rateInfoList.forEach(m -> rateGroup.getChildren().add(m.fetchTreeNode()));
        }
        return node;
    }

    public DsnStructure getRateNode() {
        return this.rateNode;
    }

    public void setRateNode(DsnStructure rateNode) {
        this.rateNode = rateNode;
    }

    public List<RateInfo> getRateInfoList() {
        return this.rateInfoList;
    }

    public void setRateInfoList(List<RateInfo> rateInfoList) {
        this.rateInfoList = rateInfoList;
    }
}

