/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.product;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.product.ProductDetail;
import com.newtouch.nms.sip.product.transfer.domain.risk.MainRiskNode;
import com.newtouch.nms.sip.product.transfer.domain.rule.Rule;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.JsonUtils;

public class Product {
    private DsnStructure productStructure;
    private ProductDetail productDetail;
    private MainRiskNode mainRisk;
    private Rule rule;

    public void load(String prdUuid) {
        ProductQueryUtils query = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        DsnStructure dsnStructure = query.queryStructure(prdUuid);
        if (dsnStructure == null) {
            return;
        }
        String upNode = dsnStructure.getUpNode();
        this.productStructure = query.queryStructure(upNode);
        if (this.productStructure == null) {
            return;
        }
        this.productDetail = new ProductDetail();
        this.productDetail.load(upNode);
        this.mainRisk = new MainRiskNode();
        this.mainRisk.load(upNode, prdUuid);
    }

    public void loadPropose(String prdUuid) {
        ProductQueryUtils query = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.productStructure = query.queryStructure(prdUuid);
        if (this.productStructure == null) {
            return;
        }
        this.productDetail = new ProductDetail();
        this.mainRisk = new MainRiskNode();
        this.mainRisk.load(null, prdUuid);
        this.rule = new Rule();
        this.rule.load(prdUuid, "n_prd_rule");
    }

    public void merge(Product prd) {
        this.productStructure = ProductEqualsUtils.merge(this.productStructure, prd.getProductStructure());
        this.productDetail = ProductEqualsUtils.merge(this.productDetail, prd.getProductDetail(), ProductDetail.class);
        this.mainRisk = ProductEqualsUtils.merge(this.mainRisk, prd.getMainRisk(), MainRiskNode.class);
        this.rule = ProductEqualsUtils.merge(this.rule, prd.getRule(), Rule.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.productStructure != null && !ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.productStructure);
        }
        if (this.productDetail != null) {
            this.productDetail.save();
        }
        if (this.mainRisk != null) {
            this.mainRisk.save();
        }
        if (this.rule != null) {
            this.rule.save();
        }
    }

    public TreeNode fetchTreeNode() {
        TreeNode productNode = new TreeNode(this.productDetail.getProducts().getSerno(), this.productDetail.getProducts().getProductName());
        if (this.productStructure != null) {
            TreeNode productStructure = new TreeNode(this.productStructure.getSerno(), JsonUtils.toJson((Object)this.productStructure), CompareEnum.NodeType.STRUCTURE.getLable(), CompareEnum.NodeType.STRUCTURE.getTag(), null);
            productNode.getChildren().add(productStructure);
        }
        if (this.productDetail != null) {
            productNode.getChildren().add(this.productDetail.fetchTreeNode());
        }
        if (this.mainRisk != null) {
            productNode.getChildren().add(this.mainRisk.fetchTreeNode());
        }
        if (this.rule != null) {
            productNode.getChildren().add(this.rule.fetchTreeNode());
        }
        return productNode;
    }

    public ProductDetail getProductDetail() {
        return this.productDetail;
    }

    public void setProductDetail(ProductDetail productDetail) {
        this.productDetail = productDetail;
    }

    public MainRiskNode getMainRisk() {
        return this.mainRisk;
    }

    public void setMainRisk(MainRiskNode mainRisk) {
        this.mainRisk = mainRisk;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public DsnStructure getProductStructure() {
        return this.productStructure;
    }

    public void setProductStructure(DsnStructure productStructure) {
        this.productStructure = productStructure;
    }
}

