/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.schedul.controller;

import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.nms.sip.model.SipScheduledTask;
import com.newtouch.nms.sip.product.schedul.service.BackUpService;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"backUp"})
public class BackUpScheduledTaskController {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private BackUpService backUpService;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private HWYObsSDKUtis hwyObsSDKUtis;

    @PostMapping(value={"/mManualCall"})
    public String mManualCall() {
        Ulog.info((String)("\u624b\u52a8\u8c03\u7528\u6570\u636e\u5e93\u5907\u4efd\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb" + Thread.currentThread().getId()));
        User user = new User();
        user.setUserCode(String.valueOf(Thread.currentThread().getId()));
        user.setPkUuid(String.valueOf(Thread.currentThread().getId()));
        ThreadLocalContext.get().setUser(user);
        ReturnMsg msg = this.backUpService.databaseBackupNonDump();
        if (!msg.isSuccessflag()) {
            SipScheduledTask scheduledTask = new SipScheduledTask();
            scheduledTask.setTaskType("DBBACKUP");
            scheduledTask.setFinishDate(new Date());
            scheduledTask.setTaskState("N");
            scheduledTask.setErrorInfo(((Message)msg.getMsgList().get(0)).getMsgInfo());
            this.dao.save((AbsModel)scheduledTask);
            Ulog.info((String)("\u624b\u52a8\u8c03\u7528\u6570\u636e\u5e93\u5907\u4efd\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f" + Thread.currentThread().getId()));
            return RequestUtils.return2Json((ReturnMsg)msg);
        }
        SipScheduledTask scheduledTask = new SipScheduledTask();
        scheduledTask.setTaskType("DBBACKUP");
        scheduledTask.setFinishDate(new Date());
        if (!"0".equals(StrUtils.trimStr(msg.getDataTable().get("exitValue")))) {
            scheduledTask.setTaskState("N");
            scheduledTask.setErrorInfo(StrUtils.trimStr(msg.getDataTable().get("errorInfo")));
            this.dao.save((AbsModel)scheduledTask);
            return RequestUtils.return2Json((ReturnMsg)msg);
        }
        scheduledTask.setTaskState("Y");
        String filePath = StrUtils.trimStr(msg.getDataTable().get("filePath"));
        String obsFilePath = "db_backup/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + filePath.substring(filePath.lastIndexOf("/"));
        String key = this.obsConfig.getObsPath() + obsFilePath;
        String url = this.hwyObsSDKUtis.putObject(key, filePath, "Y");
        Ulog.info((String)("\u624b\u52a8\u8c03\u7528\u6570\u636e\u5e93\u5907\u4efd\u5b58\u653eobs\u5730\u5740" + url));
        scheduledTask.setFilePath(url);
        this.dao.save((AbsModel)scheduledTask);
        Ulog.info((String)("\u624b\u52a8\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f" + Thread.currentThread().getId()));
        msg.getDataTable().put("scheduledTask", scheduledTask);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

