/*
 * Decompiled with CFR 0.152.
 */
package com.jingantech.ngiam.util;

import com.jingantech.ngiam.CasRequestFailureException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String responseBody;
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response1) throws IOException {
                    int status = response1.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response1.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    throw new CasRequestFailureException("request error!");
                }
            };
            byte[] bytes = ((String)httpclient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler)).getBytes("ISO-8859-1");
            String string = responseBody = new String(bytes, "utf-8");
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsGet(String url) {
        CloseableHttpClient httpClient = null;
        HttpGet httpGet = null;
        String result = "";
        try {
            httpClient = (CloseableHttpClient)HttpClientUtil.wrapClient();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build();
            httpGet = new HttpGet(url);
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
        }
        catch (ClientProtocolException e) {
            result = "";
        }
        catch (IOException e) {
            result = "";
        }
        catch (Exception e) {
            result = "";
        }
        finally {
            try {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                result = "";
            }
        }
        return result;
    }

    public static HttpClient wrapClient() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLConnectionSocketFactory ssf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)ssf).build();
            return httpclient;
        }
        catch (Exception e) {
            return HttpClients.createDefault();
        }
    }
}

