/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.utils.obs;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.newtouch.nms.sip.product.conf.PrdSyAccountConf;
import com.newtouch.nms.sip.product.transfer.utils.obs.Chinese;
import com.newtouch.nms.sip.product.transfer.utils.obs.PrdHCPClients;
import com.uniapis.logger.Ulog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrdObjectStorageUploadUtils {
    @Autowired
    private PrdSyAccountConf prdSyAccountConf;
    @Autowired
    private PrdHCPClients PrdHCPClients;

    public String putObject(String key, File file) {
        return this.putObject(this.prdSyAccountConf.getNamespace(), key, file, null);
    }

    private String putObject(String bucketName, String key, File file, ObjectMetadata metadata) {
        AmazonS3 hs3Client = this.PrdHCPClients.getS3ClientSY();
        try {
            hs3Client.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(metadata).withCannedAcl(CannedAccessControlList.PublicRead));
            URL s3Url = hs3Client.getUrl(bucketName, key);
            Ulog.info((String)("S3 url is:" + s3Url.toString()));
            file.delete();
            return s3Url.toString();
        }
        catch (AmazonServiceException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SdkClientException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String putObjectExpiration(String key, File file, ObjectMetadata metadata, long time) {
        AmazonS3 hs3Client = this.PrdHCPClients.getS3ClientSY();
        try {
            hs3Client.putObject(new PutObjectRequest(this.prdSyAccountConf.getNamespace(), key, file).withMetadata(metadata));
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.prdSyAccountConf.getNamespace(), key).withMethod(HttpMethod.GET).withExpiration(new Date(System.currentTimeMillis() + time * 1000L));
            URL s3Url = hs3Client.generatePresignedUrl(request);
            Ulog.info((String)("S3 Expiration url is:" + s3Url.toExternalForm()));
            file.delete();
            return s3Url.toExternalForm();
        }
        catch (AmazonServiceException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SdkClientException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String trimStr(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public String putObject(Map<String, Object> metadata, String ... paths) {
        String file_storage_location = "objectStorage";
        Arrays.asList(paths).forEach(path -> {
            File file = new File(this.prdSyAccountConf.getObsUrl() + path);
            this.putObject((String)path, file, metadata);
        });
        return file_storage_location;
    }

    public void transferObjectStorage(Map<String, Object> metadata, String ... paths) {
        Arrays.asList(paths).forEach(path -> {
            File file = new File(this.prdSyAccountConf.getObsUrl() + path);
            this.putObject((String)path, file, metadata);
            file.delete();
        });
    }

    public String putObject(String key, byte[] data, Map<String, Object> metadata) {
        String file_storage_location = "objectStorage";
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        this.putObject(key, input, metadata);
        IOUtils.closeQuietly((InputStream)input);
        return file_storage_location;
    }

    public void putObject(String key, InputStream input, Map<String, Object> metadata) {
        this.putObject(this.prdSyAccountConf.getNamespace(), key, input, null);
    }

    public void putObject(String key, InputStream input) {
        this.putObject(this.prdSyAccountConf.getNamespace(), key, input, null);
    }

    private void putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) {
        AmazonS3 hs3Client = this.PrdHCPClients.getS3ClientSY();
        try {
            if (!input.markSupported()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = -1;
                while ((len = input.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
                baos.flush();
                input = new ByteArrayInputStream(baos.toByteArray());
            }
            if (metadata != null) {
                metadata.setContentLength((long)IOUtils.toByteArray((InputStream)input).length);
            }
            input.reset();
            hs3Client.putObject(bucketName, key, input, metadata);
        }
        catch (AmazonServiceException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SdkClientException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void putObject(String key, File file, Map<String, Object> metadata) {
        this.putObject(this.prdSyAccountConf.getNamespace(), key, file, null);
    }

    private /* synthetic */ void lambda$putObject$239(ObjectMetadata objectMetadata, String key1, Object value) {
        if (!Chinese.isChinese(this.trimStr(value))) {
            objectMetadata.addUserMetadata(key1, this.trimStr(value));
        }
    }

    private /* synthetic */ void lambda$putObject$238(ObjectMetadata objectMetadata, String key1, Object value) {
        if (!Chinese.isChinese(this.trimStr(value))) {
            objectMetadata.addUserMetadata(key1, this.trimStr(value));
        }
    }
}

