/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.utils;

import com.alibaba.fastjson.JSONObject;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.utils.StrUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class FileHttpUtils {
    public static String sendHttpPostRequest(String url, JSONObject jsonObject, File file) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.setCharset(Charset.forName("utf-8"));
        for (String key : jsonObject.keySet()) {
            entityBuilder.addTextBody(key, StrUtils.trimStr((Object)jsonObject.getString(key)));
        }
        entityBuilder.addPart("file", (ContentBody)new FileBody(file));
        httpPost.setEntity(entityBuilder.build());
        httpPost.setHeader("X-Auth-Token", StrUtils.trimStr(ThreadLocalContext.get().getUser().getUserExtendInfo().get("X-Auth-Token")));
        String responseJson = null;
        Ulog.info((String)("\u5206\u7ea7\u8fd0\u8425\u5e73\u53f0\u540c\u6b65\u4ea7\u54c1\u914d\u7f6e\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u5730\u5740\uff1a" + url));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        responseJson = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        Ulog.info((String)("\u5206\u7ea7\u8fd0\u8425\u5e73\u53f0\u540c\u6b65\u4ea7\u54c1\u914d\u7f6e\u4fe1\u606f\u63a5\u53e3\u53cd\u53c2\uff1a" + responseJson));
        return responseJson;
    }

    public static void inputStreamToFile(InputStream ins, File file) {
        BufferedOutputStream bos = null;
        BufferedInputStream bis = new BufferedInputStream(ins);
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = bis.read(buffer, 0, 8192)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u538b\u7f29\u51fa\u9519", (Throwable)e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
                ins = null;
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
                bos = null;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
                bis = null;
            }
        }
    }
}

