/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.propose;

import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.transfer.domain.propose.BenefitRules;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;

public class BenefitDetail
implements Comparable {
    private List<DsnStructure> benefitNode;
    private List<DsnDynamicData> benefitDynamicData;
    private BenefitRules benefitRules;

    public BenefitDetail load(String riskNode, String nodeType) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.benefitDynamicData = new ArrayList<DsnDynamicData>();
        this.benefitRules = new BenefitRules();
        ArrayList<DsnStructure> tables = new ArrayList<DsnStructure>();
        this.benefitNode = utils.queryStructures(riskNode);
        if ("n_liability_table".equals(nodeType)) {
            for (DsnStructure dsnStructure : this.benefitNode) {
                tables.addAll(utils.queryStructures(dsnStructure.getNodeNo()));
            }
        }
        this.benefitNode.addAll(tables);
        this.benefitRules.load(this.benefitNode);
        for (DsnStructure dsnStructure : this.benefitNode) {
            DsnDynamicData dynamicData = utils.queryDynamic(dsnStructure.getNodeNo());
            if (dynamicData == null || StrUtils.isNull((Object)dynamicData.getSerno())) continue;
            this.benefitDynamicData.add(dynamicData);
        }
        return this;
    }

    public void merge(BenefitDetail benefitDetail) {
        this.benefitNode = ProductEqualsUtils.merge(this.benefitNode, benefitDetail.getBenefitNode());
        this.benefitDynamicData = ProductEqualsUtils.merge(this.benefitDynamicData, benefitDetail.getBenefitDynamicData());
        this.benefitRules = ProductEqualsUtils.merge(this.benefitRules, benefitDetail.getBenefitRules(), BenefitRules.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        if (this.benefitNode != null) {
            this.benefitNode.forEach(n -> update.update((AbsModel)n));
        }
        if (this.benefitDynamicData != null) {
            this.benefitDynamicData.forEach(m -> update.update((AbsModel)m));
        }
        if (this.benefitRules != null) {
            this.benefitRules.save();
        }
    }

    public List<DsnStructure> getBenefitNode() {
        return this.benefitNode;
    }

    public void setBenefitNode(List<DsnStructure> benefitNode) {
        this.benefitNode = benefitNode;
    }

    public List<DsnDynamicData> getBenefitDynamicData() {
        return this.benefitDynamicData;
    }

    public void setBenefitDynamicData(List<DsnDynamicData> benefitDynamicData) {
        this.benefitDynamicData = benefitDynamicData;
    }

    public BenefitRules getBenefitRules() {
        return this.benefitRules;
    }

    public void setBenefitRules(BenefitRules benefitRules) {
        this.benefitRules = benefitRules;
    }

    public int compareTo(Object o) {
        return 0;
    }
}

