/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.structure.service.imp;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.structure.service.IStructureManagerService;
import com.newtouch.nms.sys.model.SysTreeMenu;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class StructureManagerManagerServiceImpl
implements IStructureManagerService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg doStructureTreeNodeAdd(Map<String, Object> param) {
        Return r = new Return();
        DsnStructure structure = new DsnStructure();
        String nodeNo = UUID.shortUUID();
        structure.setNodeNo(nodeNo);
        structure.setUpNode(StrUtils.trimStr((Object)param.get("node_no")));
        structure.setNodeType(StrUtils.trimStr((Object)param.get("node_type")));
        structure.setNodeSeq(StrUtils.trimStr((Object)param.get("node_seq")) + nodeNo + ".");
        structure.setNodeName(StrUtils.trimStr((Object)param.get("node_name")));
        int maxDisplayOrder = this.getMaxDisplayorder(structure.getUpNode());
        structure.setDisplayOrder(Integer.valueOf(maxDisplayOrder + 1));
        this.dao.save((AbsModel)structure);
        this.saveChildNode(structure);
        r.setDataTable(new Object[]{JsonUtils.toJson((Object)structure)});
        return r.msg();
    }

    private void saveChildNode(DsnStructure ds) {
        List<DsnStructure> nextNodeList = this.queryChildNode(ds.getNodeType(), ds.getNodeNo(), ds.getNodeSeq());
        if (!nextNodeList.isEmpty()) {
            this.dao.save(nextNodeList);
            for (DsnStructure dsNew : nextNodeList) {
                this.saveChildNode(dsNew);
            }
        }
    }

    public int getMaxDisplayorder(String upNodeNo) {
        DsnStructure maxOrder = new DsnStructure();
        maxOrder.where().addEq(DsnStructure.UP_NODE, (Object)upNodeNo);
        maxOrder.groupBy().max(DsnStructure.DISPLAY_ORDER);
        maxOrder = (DsnStructure)this.dao.findOne((AbsModel)maxOrder);
        Object maxDisplayOrder = maxOrder.getOtherProperty("max_display_order", String.class);
        return Integer.parseInt(StrUtils.isNull((Object)maxDisplayOrder) ? "0" : maxDisplayOrder.toString());
    }

    private List<DsnStructure> queryChildNode(String nodeType, String parentNodeNo, String parentNodeSeq) {
        if (StrUtils.isNull((Object)nodeType)) {
            return new ArrayList<DsnStructure>();
        }
        SysTreeMenu queryNode = new SysTreeMenu();
        queryNode.where().addEq(SysTreeMenu.UP_MENU, (Object)nodeType);
        queryNode.where().addEq(SysTreeMenu.MENU_TYPE, (Object)"node");
        queryNode.setOrderBy(new Sort.Order[]{SysTreeMenu.DISPLAY_ORDER.asc()});
        return this.dao.findAll((AbsModel)queryNode, Boolean.valueOf(false)).stream().map(node -> {
            DsnStructure nextNode = new DsnStructure();
            String nodeNo = UUID.shortUUID();
            nextNode.setNodeNo(nodeNo);
            nextNode.setNodeName(node.getMenuName());
            nextNode.setNodeType(node.getNodeType());
            nextNode.setUpNode(parentNodeNo);
            nextNode.setDisplayOrder(node.getDisplayOrder());
            nextNode.setNodeSeq(parentNodeSeq + nodeNo + ".");
            return nextNode;
        }).collect(Collectors.toList());
    }
}

