/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.services.impl;

import com.newtouch.nms.sip.design.data.service.StructureService;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.main.services.impl.ProductCopyServiceImpl;
import com.newtouch.nms.sip.product.risk.dao.IRiskDao;
import com.newtouch.nms.sip.product.risk.services.IRiskListQueryService;
import com.newtouch.nms.sip.product.structure.dao.IStructureDao;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.callback.RowCallback;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class RiskListQueryServiceImpl
implements IRiskListQueryService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IStructureDao structureDaoImpl;
    @Autowired
    private StructureService structureService;
    @Autowired
    @Lazy
    private IRiskDao riskDao;
    private final String allowSuffix = "png,gif,jpg,jpeg,bmp,tiff,txt,xml,pdf,zip,rar,doc,ppt,xls,docx,pptx,xlsx,html,htm,webp";
    private final long allowSize = 0x500000L;
    private final String FIELD_VALUE = "field_value";

    @Override
    public ReturnMsg queryMainRiskUnderProduct(String risk, String productUuid, String isMainRisk) {
        String sql = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid Not IN ( SELECT distinct sip_product_risks.risk_uuid FROM sip_product_risks WHERE sip_product_risks.product_uuid = ?) AND sip_risks.is_main_risk = ?  AND (  sip_risks.risk_no LIKE ? OR sip_risks.risk_name LIKE ?) AND sip_risks.data_flag = ?;";
        ArrayList<String> searchParam = new ArrayList<String>();
        searchParam.add(productUuid);
        searchParam.add(isMainRisk);
        searchParam.add("%" + risk + "%");
        searchParam.add("%" + risk + "%");
        searchParam.add("1");
        List riskList = this.dao.findAll(sql, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchParam)});
        Return msg = new Return();
        msg.setDataList4includes(riskList, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk", "risk_uuid"});
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRisk(String risk, String riskUuid, String isMainRisk) {
        String sql = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid Not IN ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ?AND ( sip_risks.risk_no LIKE ? OR sip_risks.risk_name LIKE ?)AND sip_risks.data_flag = ? ;";
        ArrayList<String> searchParam = new ArrayList<String>();
        searchParam.add(riskUuid);
        searchParam.add(isMainRisk);
        searchParam.add("%" + risk + "%");
        searchParam.add("%" + risk + "%");
        searchParam.add("1");
        List riskList = this.dao.findAll(sql, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchParam)});
        Return msg = new Return();
        msg.setDataList4includes(riskList, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk", "risk_uuid"});
        return msg.msg();
    }

    @Override
    public ReturnMsg queryMainRiskPage(String riskName, String riskNo, String isMainRisk) {
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)riskName)) {
            risk.where().addLike(SipRisks.RISK_NAME, (Object)riskName);
        }
        if (!StrUtils.isNull((Object)riskNo)) {
            risk.where().addLike(SipRisks.RISK_NO, (Object)riskNo);
        }
        if (!StrUtils.isNull((Object)isMainRisk)) {
            risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk);
        }
        risk.setOrderBy(new Sort.Order[]{SipRisks.MDF_DATE.desc()});
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        ArrayList mainRiskList = new ArrayList();
        List riskMainList = this.dao.findAll((AbsModel)risk, Boolean.valueOf(true));
        riskMainList.stream().forEach(mainRisk -> {
            HashMap<String, Object> mapMain = new HashMap<String, Object>();
            mapMain.put("risk_no", mainRisk.getRiskNo());
            mapMain.put("risk_name", mainRisk.getRiskName());
            mapMain.put("is_main_risk", mainRisk.getIsMainRisk());
            mapMain.put("risk_uuid", mainRisk.getRiskUuid());
            mapMain.put("template_product_uuid", mainRisk.getTemplateProductUuid());
            DsnStructure mainRiskDetailDsnStructure = new DsnStructure();
            mainRiskDetailDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)mainRisk.getRiskUuid());
            DsnStructure mainRiskDetailDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)mainRiskDetailDsnStructure);
            DsnStructure mainRiskDsnStructure = new DsnStructure();
            mainRiskDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)mainRiskDetailDsnStructureList.getUpNode());
            DsnStructure mainRiskDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)mainRiskDsnStructure);
            mapMain.put("dsn_structure", mainRiskDsnStructureList);
            String sqlSubRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchAddParam = new ArrayList<String>();
            searchAddParam.add(mainRisk.getRiskUuid());
            searchAddParam.add("A");
            searchAddParam.add("1");
            List riskSubList = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchAddParam)});
            ArrayList aRiskList = new ArrayList();
            riskSubList.stream().forEach(aRisk -> {
                HashMap<String, Object> mapAdd = new HashMap<String, Object>();
                mapAdd.put("risk_no", aRisk.getRiskNo());
                mapAdd.put("risk_name", aRisk.getRiskName());
                mapAdd.put("is_main_risk", aRisk.getIsMainRisk());
                mapAdd.put("risk_uuid", aRisk.getRiskUuid());
                mapAdd.put("template_product_uuid", aRisk.getTemplateProductUuid());
                DsnStructure addRiskDetailDsnStructure = new DsnStructure();
                addRiskDetailDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)aRisk.getRiskUuid());
                DsnStructure addRiskDetailDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)addRiskDetailDsnStructure);
                DsnStructure addRiskDsnStructure = new DsnStructure();
                addRiskDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)addRiskDetailDsnStructureList.getUpNode());
                addRiskDetailDsnStructure.where().addLike(DsnStructure.NODE_SEQ, (Object)mainRiskDsnStructureList.getNodeNo());
                DsnStructure addRiskDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)addRiskDsnStructure);
                mapAdd.put("dsn_structure", addRiskDsnStructureList);
                String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ? order by sip_risks.crt_date desc;";
                ArrayList<String> searchExeParam = new ArrayList<String>();
                searchExeParam.add(aRisk.getRiskUuid());
                searchExeParam.add("W");
                searchExeParam.add("1");
                List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExeParam)});
                ArrayList exemptsRiskList = new ArrayList();
                riskExemptsList.stream().forEach(exemptsRisk -> {
                    HashMap<String, String> mapExe = new HashMap<String, String>();
                    mapExe.put("risk_no", exemptsRisk.getRiskNo());
                    mapExe.put("risk_name", exemptsRisk.getRiskName());
                    mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                    mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                    mapExe.put("template_product_uuid", exemptsRisk.getTemplateProductUuid());
                    DsnStructure exemptsRiskDetailDsnStructure = new DsnStructure();
                    exemptsRiskDetailDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)exemptsRisk.getRiskUuid());
                    DsnStructure exemptsRiskDetailDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)exemptsRiskDetailDsnStructure);
                    DsnStructure exemptsRiskDsnStructure = new DsnStructure();
                    exemptsRiskDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)exemptsRiskDetailDsnStructureList.getUpNode());
                    exemptsRiskDsnStructure.where().addLike(DsnStructure.NODE_SEQ, (Object)addRiskDsnStructureList.getNodeNo());
                    DsnStructure exemptsRiskDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)exemptsRiskDsnStructure);
                    mapExe.put("dsn_structure", (String)exemptsRiskDsnStructureList);
                    exemptsRiskList.add(mapExe);
                });
                mapAdd.put("exempt_risk", exemptsRiskList);
                aRiskList.add(mapAdd);
            });
            mapMain.put("accy_risk", aRiskList);
            String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ? order by sip_risks.crt_date asc;";
            ArrayList<String> searchExemptsParam = new ArrayList<String>();
            searchExemptsParam.add(mainRisk.getRiskUuid());
            searchExemptsParam.add("W");
            searchExemptsParam.add("1");
            List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExemptsParam)});
            ArrayList exemptsRiskList = new ArrayList();
            riskExemptsList.stream().forEach(exemptsRisk -> {
                HashMap<String, String> mapExe = new HashMap<String, String>();
                mapExe.put("risk_no", exemptsRisk.getRiskNo());
                mapExe.put("risk_name", exemptsRisk.getRiskName());
                mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                mapExe.put("template_product_uuid", exemptsRisk.getTemplateProductUuid());
                DsnStructure exemptsRiskDetailDsnStructure = new DsnStructure();
                exemptsRiskDetailDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)exemptsRisk.getRiskUuid());
                DsnStructure exemptsRiskDetailDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)exemptsRiskDetailDsnStructure);
                DsnStructure exemptsRiskDsnStructure = new DsnStructure();
                exemptsRiskDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)exemptsRiskDetailDsnStructureList.getUpNode());
                exemptsRiskDsnStructure.where().addLike(DsnStructure.NODE_SEQ, (Object)mainRiskDsnStructureList.getNodeNo());
                DsnStructure exemptsRiskDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)exemptsRiskDsnStructure);
                mapExe.put("dsn_structure", (String)exemptsRiskDsnStructureList);
                exemptsRiskList.add(mapExe);
            });
            mapMain.put("exempt_risk", exemptsRiskList);
            mainRiskList.add(mapMain);
        });
        Return msg = new Return();
        msg.setDataList(mainRiskList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryMainRiskUnPage(String productUuid) {
        SipProductRisks risks = (SipProductRisks)SipProductRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)productUuid)) {
            risks.where().addLike(SipProductRisks.PRODUCT_UUID, (Object)productUuid);
        }
        risks.setOrderBy(new Sort.Order[]{SipProductRisks.MDF_DATE.desc()});
        List riskList = this.dao.findAll((AbsModel)risks);
        ArrayList mainRiskList = new ArrayList();
        riskList.stream().forEach(risk -> {
            SipRisks riskUuid = (SipRisks)SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)risk.getRiskUuid()).model();
            SipRisks mainRisk = (SipRisks)this.dao.findOne((AbsModel)riskUuid);
            HashMap<String, Object> mapMain = new HashMap<String, Object>();
            mapMain.put("risk_no", mainRisk.getRiskNo());
            mapMain.put("risk_name", mainRisk.getRiskName());
            mapMain.put("is_main_risk", mainRisk.getIsMainRisk());
            mapMain.put("risk_uuid", mainRisk.getRiskUuid());
            String sqlSubRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchAddParam = new ArrayList<String>();
            searchAddParam.add(mainRisk.getRiskUuid());
            searchAddParam.add("A");
            searchAddParam.add("1");
            List riskSubList = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchAddParam)});
            ArrayList aRiskList = new ArrayList();
            riskSubList.stream().forEach(aRisk -> {
                HashMap<String, Object> mapAdd = new HashMap<String, Object>();
                mapAdd.put("risk_no", aRisk.getRiskNo());
                mapAdd.put("risk_name", aRisk.getRiskName());
                mapAdd.put("is_main_risk", aRisk.getIsMainRisk());
                mapAdd.put("risk_uuid", aRisk.getRiskUuid());
                String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
                ArrayList<String> searchExeParam = new ArrayList<String>();
                searchExeParam.add(aRisk.getRiskUuid());
                searchExeParam.add("W");
                searchExeParam.add("1");
                List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExeParam)});
                ArrayList exemptsRiskList = new ArrayList();
                riskExemptsList.stream().forEach(exemptsRisk -> {
                    HashMap<String, String> mapExe = new HashMap<String, String>();
                    mapExe.put("risk_no", exemptsRisk.getRiskNo());
                    mapExe.put("risk_name", exemptsRisk.getRiskName());
                    mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                    mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                    exemptsRiskList.add(mapExe);
                });
                mapAdd.put("exempt_risk", exemptsRiskList);
                aRiskList.add(mapAdd);
            });
            mapMain.put("accy_risk", aRiskList);
            String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchExemptsParam = new ArrayList<String>();
            searchExemptsParam.add(mainRisk.getRiskUuid());
            searchExemptsParam.add("W");
            searchExemptsParam.add("1");
            List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExemptsParam)});
            ArrayList exemptsRiskList = new ArrayList();
            riskExemptsList.stream().forEach(exemptsRisk -> {
                HashMap<String, String> mapExe = new HashMap<String, String>();
                mapExe.put("risk_no", exemptsRisk.getRiskNo());
                mapExe.put("risk_name", exemptsRisk.getRiskName());
                mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                exemptsRiskList.add(mapExe);
            });
            mapMain.put("exempt_risk", exemptsRiskList);
            mainRiskList.add(mapMain);
        });
        Return msg = new Return();
        msg.setDataList(mainRiskList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskPage(String riskName, String riskNo, String isMainRisk) {
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)riskName)) {
            risk.where().addLike(SipRisks.RISK_NAME, (Object)riskName);
        }
        if (!StrUtils.isNull((Object)riskNo)) {
            risk.where().addLike(SipRisks.RISK_NO, (Object)riskNo);
        }
        if (!StrUtils.isNull((Object)isMainRisk)) {
            risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk);
        }
        risk.setOrderBy(new Sort.Order[]{SipRisks.MDF_DATE.desc()});
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        List riskList2 = this.dao.findAll((AbsModel)risk, Boolean.valueOf(true));
        ArrayList returnRiskList = new ArrayList();
        riskList2.stream().forEach(aRisk -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("risk_no", aRisk.getRiskNo());
            map.put("risk_name", aRisk.getRiskName());
            map.put("is_main_risk", aRisk.getIsMainRisk());
            map.put("risk_uuid", aRisk.getRiskUuid());
            map.put("template_product_uuid", aRisk.getTemplateProductUuid());
            DsnStructure riskDetailDsnStructure = new DsnStructure();
            riskDetailDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)aRisk.getRiskUuid());
            DsnStructure riskDetailDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)riskDetailDsnStructure);
            DsnStructure riskDsnStructure = new DsnStructure();
            riskDsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)riskDetailDsnStructureList.getUpNode());
            DsnStructure riskDsnStructureList = (DsnStructure)this.dao.findOne((AbsModel)riskDsnStructure);
            map.put("dsn_structure", (String)riskDsnStructureList);
            returnRiskList.add(map);
        });
        Return msg = new Return();
        msg.setDataList(returnRiskList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRisk4Ajax(DsnStructure node, String riskName) {
        String isMainRisk = "M";
        switch (NodeType.valueOf((String)node.getNodeType().toUpperCase())) {
            case N_SUB_RISKS: {
                isMainRisk = "S";
                break;
            }
            case N_ACCY_RISKS: {
                isMainRisk = "A";
                break;
            }
            case N_EXEMPT: {
                isMainRisk = "W";
            }
        }
        List riskNameList = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model());
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk).model();
        riskNameList.forEach(dsn -> risk.where().addNotIn(SipRisks.RISK_NAME, new String[]{dsn.getNodeName()}));
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        List riskList2 = this.dao.findAll((AbsModel)risk);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leftSelect", riskList2);
        map.put("ajaxtype", "select");
        map.put("blankline", false);
        Return msg = new Return();
        msg.getDataList().add(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg addRisk(DsnStructure node, Map<String, Object> paramMap) {
        Return msg = new Return();
        List rightSelectList = (List)paramMap.get("rigthSelect");
        if (null == rightSelectList || rightSelectList.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u9669\u79cd\uff01");
            return msg.msg();
        }
        int countNum = Integer.parseInt(((DsnStructure)this.dao.findOne(((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model()).groupBy().count(DsnStructure.NODE_NO))).getOtherProperty("count_node_num").toString());
        for (Map tmpMap : rightSelectList) {
            String riskNodeNo = StrUtils.trimStr(tmpMap.get("rigthSelect"));
            DsnStructure riskDetailsNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskNodeNo).model());
            DsnStructure riskNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskDetailsNode.getUpNode()).model());
            riskNode.setSerno(UUID.shortUUID());
            riskNode.setNodeSeq(node.getNodeSeq() + riskNode.getNodeNo() + ".");
            riskNode.setUpNode(node.getNodeNo());
            riskNode.setDisplayOrder(Integer.valueOf(countNum++));
            this.dao.save((AbsModel)riskNode);
            ProductCopyServiceImpl.saveRiskRelation(riskDetailsNode, this.dao);
        }
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg.msg();
    }
}

