/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.services.impl;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.product.risk.services.IRiskAddRelationService;
import com.newtouch.nms.sys.model.SysTreeMenu;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskAddRelationServiceImpl
implements IRiskAddRelationService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg addRiskRelation(String mainRisk, String riskUuid, String relationType) {
        Return msg = new Return();
        String sqlMainRiskNodeNo = "SELECT * FROM dsn_structure WHERE node_no IN (SELECT up_node FROM dsn_structure WHERE  node_no LIKE ?)AND up_node LIKE ?;";
        ArrayList<String> searchMainRiskNodeNo = new ArrayList<String>();
        searchMainRiskNodeNo.add(mainRisk);
        searchMainRiskNodeNo.add("%%");
        List mainRiskNodeNoList = this.dao.findAll(sqlMainRiskNodeNo, DsnStructure.class, new AbsModelRepository.Args[]{this.dao.args(searchMainRiskNodeNo)});
        String mainRiskNodeNo = ((DsnStructure)mainRiskNodeNoList.get(0)).getNodeNo();
        DsnStructure downRiskNode = new DsnStructure();
        downRiskNode.where().addLike(DsnStructure.UP_NODE, (Object)mainRiskNodeNo);
        switch (relationType) {
            case "n_accy_risks": {
                downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_accy_risks");
                break;
            }
            case "n_main_exempt": {
                downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_main_exempt");
                break;
            }
            case "n_accy_exempt": {
                downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_accy_exempt");
                break;
            }
            default: {
                msg.setFailMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9669\u79cd\u5173\u7cfb\uff01");
                return msg.msg();
            }
        }
        List downRiskNodeList = this.dao.findAll((AbsModel)downRiskNode);
        String sqlRiskUuidNodeNo = "SELECT * FROM dsn_structure WHERE node_no IN (SELECT up_node FROM dsn_structure WHERE  node_no LIKE ?)AND up_node LIKE ?;";
        ArrayList<String> searchRiskUuidNodeNo = new ArrayList<String>();
        searchRiskUuidNodeNo.add(riskUuid);
        searchRiskUuidNodeNo.add("%%");
        List riskUuidNodeNo = this.dao.findAll(sqlRiskUuidNodeNo, DsnStructure.class, new AbsModelRepository.Args[]{this.dao.args(searchRiskUuidNodeNo)});
        for (DsnStructure mainRiskNode : downRiskNodeList) {
            for (DsnStructure riskUuidNode : riskUuidNodeNo) {
                DsnStructure riskUuidDsn = new DsnStructure();
                riskUuidDsn.setUpNode(mainRiskNode.getNodeNo());
                riskUuidDsn.setSerno(UUID.shortUUID());
                riskUuidDsn.setNodeNo(riskUuidNode.getNodeNo());
                riskUuidDsn.setNodeName(riskUuidNode.getNodeName());
                riskUuidDsn.setNodeType(riskUuidNode.getNodeType());
                riskUuidDsn.setNodeSeq(mainRiskNode.getNodeSeq() + riskUuidNode.getNodeNo());
                riskUuidDsn.setDisplayOrder(Integer.valueOf(1));
                this.dao.save((AbsModel)riskUuidDsn);
            }
        }
        DsnStructure riskUuidUpNode = new DsnStructure();
        riskUuidUpNode.where().addLike(DsnStructure.NODE_NO, (Object)((DsnStructure)riskUuidNodeNo.get(0)).getUpNode());
        SipRiskRelation sipRiskRelation = new SipRiskRelation();
        sipRiskRelation.setSerno(riskUuidUpNode.getSerno());
        sipRiskRelation.setMainRisk(mainRisk);
        sipRiskRelation.setRiskUuid(riskUuid);
        switch (relationType) {
            case "n_accy_risks": {
                sipRiskRelation.setRelationType("ADDED");
                break;
            }
            case "n_main_exempt": {
                sipRiskRelation.setRelationType("EXEMPT");
                break;
            }
            case "n_accy_exempt": {
                sipRiskRelation.setRelationType("EXEMPT");
                break;
            }
            default: {
                msg.setFailMsg("relation\u8868\u9669\u79cd\u5173\u7cfb\u9519\u8bef\uff01");
                return msg.msg();
            }
        }
        this.dao.save((AbsModel)sipRiskRelation);
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg.msg();
    }

    public ReturnMsg addTreeNode(String mainRiskNodeNo, String riskUuidNodeNo, String mainRiskNodeSeq, String mainRiskNodeName, String relationType) {
        Return r = new Return();
        DsnStructure structure = new DsnStructure();
        String nodeNo = UUID.shortUUID();
        structure.setNodeNo(nodeNo);
        structure.setUpNode(mainRiskNodeNo);
        structure.setNodeType(riskUuidNodeNo);
        structure.setNodeSeq(mainRiskNodeSeq + riskUuidNodeNo + ".");
        switch (relationType) {
            case "ADDED": {
                structure.setNodeType("accy_risks");
                break;
            }
            case "EXEMPT": {
                structure.setNodeType("exempt_risks");
                break;
            }
            default: {
                return r.msg();
            }
        }
        structure.setNodeName(mainRiskNodeName);
        this.dao.save((AbsModel)structure);
        this.saveChildNode(structure);
        return r.msg();
    }

    private void saveChildNode(DsnStructure ds) {
        Return r = new Return();
        List<DsnStructure> nextNodeList = this.queryChildNode(ds.getNodeType(), ds.getNodeNo(), ds.getNodeSeq());
        if (!nextNodeList.isEmpty()) {
            this.dao.save(nextNodeList);
            for (DsnStructure dsNew : nextNodeList) {
                this.saveChildNode(dsNew);
            }
        }
    }

    private List<DsnStructure> queryChildNode(String node_type, String parentNodeNo, String parentNodeSeq) {
        SysTreeMenu queryNode = new SysTreeMenu();
        queryNode.where().addEq(SysTreeMenu.UP_MENU, (Object)node_type);
        queryNode.where().addEq(SysTreeMenu.MENU_TYPE, (Object)"node");
        List<DsnStructure> nextNodeList = this.dao.findAll((AbsModel)queryNode, Boolean.valueOf(false)).stream().map(node -> {
            DsnStructure nextNode = new DsnStructure();
            String nodeNo = UUID.shortUUID();
            nextNode.setNodeNo(nodeNo);
            nextNode.setNodeName(node.getMenuName());
            nextNode.setNodeType(node.getNodeType());
            nextNode.setUpNode(parentNodeNo);
            nextNode.setDisplayOrder(node.getDisplayOrder());
            nextNode.setNodeSeq(parentNodeSeq + nodeNo + ".");
            return nextNode;
        }).collect(Collectors.toList());
        return nextNodeList;
    }
}

