/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.rate.services.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.nms.sip.design.utils.ListUtil;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.excel.ExcelUtils;
import com.newtouch.nms.sip.product.excel.pojo.Excel;
import com.newtouch.nms.sip.product.excel.pojo.Sheet;
import com.newtouch.nms.sip.product.rate.services.IRateService;
import com.newtouch.nms.sip.product.risk.services.impl.RiskRelationServiceImpl;
import com.uniapis.cache.CacheManager;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.DBTypes;
import com.uniapis.repository.core.utils.DBFunction;
import com.uniapis.repository.core.utils.SqlMapper;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RateServiceImpl
implements IRateService {
    @Autowired
    private AbsModelRepository dao;
    private static final String TABLE_PREFIX = "dsn_rate_";
    private static String TABLE_FIELD_CACHE_LIST_KEY = "RateServiceImp.TABLE_FIELD_CACHE_KEY.";

    @Override
    public ReturnMsg queryRateDetail(Map<String, Object> paramMap) {
        Return msg = new Return();
        String tableName = StrUtils.trimStr((Object)paramMap.get("tableName"));
        paramMap.remove("tableName");
        StringBuilder whereSb = new StringBuilder();
        ArrayList<String> whereValue = new ArrayList<String>();
        List<Map<String, Object>> titleList = this.getExcelTitleMap(tableName);
        for (Map<String, Object> map2 : titleList) {
            msg.getDataTable().put((String)map2.get("nodeKey"), map2.get("nodeName"));
        }
        List keyList = titleList.stream().map(map -> StrUtils.trimStr(map.get("nodeKey"))).collect(Collectors.toList());
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (!keyList.contains(entry.getKey()) || StrUtils.isNull((Object)entry.getValue())) continue;
            whereSb.append(" AND  " + entry.getKey() + " LIKE ? ");
            whereValue.add("%" + entry.getValue() + "%");
        }
        keyList.add(0, "serno");
        Integer n = ThreadLocalContext.get().getPageCount().getRows4Page();
        Integer n2 = ThreadLocalContext.get().getPageCount().getNowPage();
        boolean aBoolean = false;
        if (n != null && n2 != null) {
            aBoolean = true;
        }
        String sql = " SELECT " + keyList.stream().collect(Collectors.joining(",")) + " FROM " + tableName + " WHERE 1=1 " + whereSb;
        List dataList = this.dao.findAll(sql + "\uff03NOTCHECK", Boolean.valueOf(aBoolean), new AbsModelRepository.Args[]{this.dao.args(whereValue)});
        msg.setDataList(dataList);
        return msg.msg();
    }

    @Override
    public ReturnMsg rateDetailQuery(DsnStructure node) {
        node = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)node.getNodeNo()).model());
        Return msg = new Return();
        if (StrUtils.isNull((Object)node.getRelateTab())) {
            msg.setFailMsg("\u8bf7\u5148\u914d\u7f6e\u8d39\u7387\u7f16\u7801\uff0c\u5e76\u6dfb\u52a0\u8f93\u5165\u8f93\u51fa\u9879\uff01");
            return msg.msg();
        }
        LinkedList<DsnBizAttribute> dsnList = new LinkedList<DsnBizAttribute>();
        DsnStructure inputDsnStruc = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addLikeR(DsnStructure.NODE_SEQ, (Object)node.getNodeSeq()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.INPUT.code()).model());
        String sql = "SELECT dba.* FROM dsn_structure ds, dsn_biz_attribute dba       WHERE ds.node_no = dba.biz_uuid         AND ds.node_type = ?         AND ds.node_seq like ? ORDER BY dba.display_order";
        List inDsnList = this.dao.findAll(sql, DsnBizAttribute.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{NodeType.ATTR4RATE.code(), inputDsnStruc.getNodeSeq() + "%"})});
        inDsnList.forEach(p -> p.getOtherProperty().put("length", "32"));
        dsnList.addAll(inDsnList);
        DsnStructure outputDsnStruc = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addLikeR(DsnStructure.NODE_SEQ, (Object)node.getNodeSeq()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.OUTPUT.code()).model());
        List outDsnList = this.dao.findAll(sql, DsnBizAttribute.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{NodeType.ATTR4RATE.code(), outputDsnStruc.getNodeSeq() + "%"})});
        dsnList.addAll(outDsnList);
        Map<String, List<DsnBizAttribute>> listMap = dsnList.stream().collect(Collectors.groupingBy(po -> po.getAttrNo()));
        if (dsnList.size() != listMap.size()) {
            msg.setFailMsg("\u8d39\u7387\u7f16\u7801\u5b58\u5728\u91cd\u590d\u9879");
            return msg.msg();
        }
        this.createTable(node, dsnList);
        ArrayList clmList = new ArrayList();
        inDsnList.forEach(attr -> {
            HashMap<String, String> clm = new HashMap<String, String>();
            clm.put("nodeKey", attr.getAttrNo().toLowerCase());
            clm.put("nodeName", attr.getAttrName());
            clm.put("nodeType", "input");
            clmList.add(clm);
        });
        outDsnList.forEach(attr -> {
            HashMap<String, String> clm = new HashMap<String, String>();
            clm.put("nodeKey", attr.getAttrNo().toLowerCase());
            clm.put("nodeName", attr.getAttrName());
            clm.put("nodeType", "output");
            clmList.add(clm);
        });
        CacheManager.put((String)(TABLE_FIELD_CACHE_LIST_KEY + "." + node.getRelateTab()), (Object)JsonUtils.toJson(clmList));
        msg.getDataTable().put("tableName", node.getRelateTab());
        msg.getDataTable().put("nodeList", clmList);
        return msg.msg();
    }

    private void createTable(DsnStructure node, List<DsnBizAttribute> attrList) {
        ArrayList list = new ArrayList();
        String rateIndex = StrUtils.trimStr((Object)this.goRateModify(node.getNodeNo()).get("rate_index"));
        try {
            SqlMapper sqlMapper = new SqlMapper();
            sqlMapper.setSql("SELECT * FROM " + node.getRelateTab());
            list.addAll(this.dao.findAll(sqlMapper.getSql() + " \uff03NOTCHECK", Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(sqlMapper.getValue())}));
        }
        catch (Exception e) {
            e.printStackTrace();
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dao.getJdbcTemplate().getDataSource());
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            this.createTable(node.getRelateTab(), rateIndex, attrList);
            return;
        }
        if (list.isEmpty()) {
            this.createTable(node.getRelateTab(), rateIndex, attrList);
            return;
        }
        Set dbSet = ((Map)list.get(0)).keySet();
        dbSet.removeAll(Arrays.asList("serno", "crt_date", "mdf_date", "crt_user", "mdf_user", "data_flag", "patch_memo", "rn"));
        int clmSize = dbSet.size();
        if (clmSize != attrList.size()) {
            this.createTable(node.getRelateTab(), rateIndex, attrList);
            return;
        }
        ArrayList clmList = new ArrayList();
        attrList.forEach(attr -> clmList.add(attr.getAttrNo().toLowerCase()));
        boolean isEqual = CollectionUtils.isEqualCollection(clmList, dbSet);
        if (!isEqual) {
            this.createTable(node.getRelateTab(), rateIndex, attrList);
        }
    }

    private void createTable(String tableName, String index, List<DsnBizAttribute> tableClm) {
        String driverName = "MYSQL";
        try {
            driverName = this.dao.getJdbcTemplate().getDataSource().getConnection().getMetaData().getDriverName();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuilder crtTabSql = new StringBuilder();
        if (driverName.startsWith(DBTypes.PostgreSQL.name())) {
            StringBuilder commentSql = new StringBuilder();
            crtTabSql.append("CREATE TABLE " + tableName + " ( ");
            crtTabSql.append("serno " + DBFunction.F.dataType(String.class, "32", this.dao.getDbType()) + " NOT NULL, ");
            commentSql.append("COMMENT ON COLUMN " + tableName + ".serno IS '01.serno';");
            for (DsnBizAttribute dsnBizAttribute : tableClm) {
                String s = StrUtils.isNull(dsnBizAttribute.getOtherProperty().get("length")) ? "4000" : StrUtils.trimStr(dsnBizAttribute.getOtherProperty().get("length"));
                crtTabSql.append(" " + dsnBizAttribute.getAttrNo().toLowerCase() + DBFunction.F.dataType(String.class, s, this.dao.getDbType()) + ", ");
                commentSql.append("COMMENT ON COLUMN " + tableName + "." + dsnBizAttribute.getAttrNo().toLowerCase() + " IS '" + dsnBizAttribute.getAttrName() + "';");
            }
            crtTabSql.append(" crt_date timestamp NOT NULL, ").append("  mdf_date timestamp NOT NULL, ").append("  crt_user " + DBFunction.F.dataType(String.class, "64", this.dao.getDbType()) + "  NOT NULL, ").append("  mdf_user " + DBFunction.F.dataType(String.class, "64", this.dao.getDbType()) + "  NOT NULL, ").append("  data_flag " + DBFunction.F.dataType(String.class, "4", this.dao.getDbType()) + "  NOT NULL, ").append("  patch_memo " + DBFunction.F.dataType(String.class, "32", this.dao.getDbType()));
            commentSql.append("COMMENT ON COLUMN " + tableName + ".crt_date IS '05.\u521b\u5efa\u65e5\u671f';").append("COMMENT ON COLUMN " + tableName + ".mdf_date IS '06.\u4fee\u6539\u65e5\u671f';").append("COMMENT ON COLUMN " + tableName + ".crt_user IS '07.\u521b\u5efa\u64cd\u4f5c\u5458';").append("COMMENT ON COLUMN " + tableName + ".mdf_user IS '08.\u4fee\u6539\u64cd\u4f5c\u5458';").append("COMMENT ON COLUMN " + tableName + ".data_flag IS '09.\u6709\u6548\u6027\u6807\u5fd7';").append("COMMENT ON COLUMN " + tableName + ".patch_memo IS '10.\u6570\u8865\u5907\u6ce8';");
            crtTabSql.append(");");
            crtTabSql.append(commentSql.toString());
            if (!StrUtils.isNull((Object)index)) {
                String[] indexArray;
                for (String aIndex : indexArray = index.split("\\|")) {
                    crtTabSql.append("CREATE INDEX " + UUID.shortUUID() + " ON " + tableName + "(" + aIndex + ");");
                }
            }
            Ulog.info((String)("\u8d39\u7387\u8be6\u60c5\u5efa\u8868sql==> " + crtTabSql));
        } else {
            crtTabSql.append("CREATE TABLE " + tableName + " ( ");
            crtTabSql.append("serno " + DBFunction.F.dataType(String.class, "32", this.dao.getDbType()) + " PRIMARY KEY NOT NULL COMMENT '01.serno', ");
            for (DsnBizAttribute attr : tableClm) {
                String string = StrUtils.isNull(attr.getOtherProperty().get("length")) ? "1024" : StrUtils.trimStr(attr.getOtherProperty().get("length"));
                crtTabSql.append(" " + attr.getAttrNo().toLowerCase() + DBFunction.F.dataType(String.class, string, this.dao.getDbType()) + "  COMMENT '" + attr.getAttrName() + "', ");
            }
            crtTabSql.append(" crt_date " + DBFunction.F.dataType(Timestamp.class, "", this.dao.getDbType()) + " NOT NULL COMMENT '05.\u521b\u5efa\u65e5\u671f', ").append("  mdf_date " + DBFunction.F.dataType(Timestamp.class, "", this.dao.getDbType()) + " NOT NULL COMMENT '06.\u4fee\u6539\u65e5\u671f', ").append("  crt_user " + DBFunction.F.dataType(String.class, "64", this.dao.getDbType()) + "  NOT NULL COMMENT '07.\u521b\u5efa\u64cd\u4f5c\u5458', ").append("  mdf_user " + DBFunction.F.dataType(String.class, "64", this.dao.getDbType()) + "  NOT NULL COMMENT '08.\u4fee\u6539\u64cd\u4f5c\u5458', ").append("  data_flag " + DBFunction.F.dataType(String.class, "4", this.dao.getDbType()) + "  NOT NULL COMMENT '09.\u6709\u6548\u6027\u6807\u5fd7', ").append("  patch_memo " + DBFunction.F.dataType(String.class, "32", this.dao.getDbType()) + " COMMENT '10.\u6570\u8865\u5907\u6ce8' ");
            if (!StrUtils.isNull((Object)index)) {
                String[] indexArray;
                for (String aIndex : indexArray = index.split("\\|")) {
                    crtTabSql.append(",  KEY  i" + UUID.shortUUID() + " (" + aIndex + ") ");
                }
            }
            crtTabSql.append(")");
            Ulog.info((String)("\u8d39\u7387\u8be6\u60c5\u5efa\u8868sql==> " + crtTabSql));
        }
        try {
            this.dao.getJdbcTemplate().execute("DROP TABLE IF EXISTS " + tableName);
        }
        catch (Exception indexArray) {
            // empty catch block
        }
        try {
            this.dao.getJdbcTemplate().execute(crtTabSql.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReturnMsg exportExcel(Map<String, Object> paramMap) {
        Return msg = new Return();
        String tableName = StrUtils.trimStr((Object)paramMap.get("tableName"));
        List<Map<String, Object>> list = this.getExcelTitleMap(tableName);
        Sheet sheet = new Sheet();
        sheet.setSheetName("sheet1");
        for (Map<String, Object> head : list) {
            sheet.addHead(StrUtils.trimStr((Object)head.get("nodeKey")), StrUtils.trimStr((Object)head.get("nodeName")));
        }
        Excel excel = new Excel();
        excel.addSheets(sheet);
        excel.setExcelName("ImportRateData.xls");
        msg.getDataTable().put("excel", excel);
        return msg.msg();
    }

    private List<Map<String, Object>> getExcelTitleMap(String tableName) {
        String json = (String)CacheManager.get((String)(TABLE_FIELD_CACHE_LIST_KEY + "." + tableName), String.class);
        return JsonUtils.json2List((String)json);
    }

    @Override
    public ReturnMsg importAttribute(Map<String, Object> paramMap) throws IOException {
        String tableName = StrUtils.trimStr((Object)paramMap.get("tableName"));
        List<Map<String, Object>> list = this.getExcelTitleMap(tableName);
        ArrayList arrayTitle = new ArrayList();
        ArrayList arrayName = new ArrayList();
        list.forEach(m -> {
            arrayTitle.add(StrUtils.trimStr(m.get("nodeKey")));
            arrayName.add(StrUtils.trimStr(m.get("nodeName")));
        });
        MultipartFile mFile = (MultipartFile)paramMap.get("file");
        String[] titles = arrayTitle.toArray(new String[0]);
        String[] titleName = arrayName.toArray(new String[0]);
        ExcelUtils excel = new ExcelUtils();
        excel.setExcleName(mFile.getOriginalFilename());
        Map<String, List<Map<String, Object>>> excelMap = excel.initSheet4Stream(mFile.getInputStream(), titles, titleName, false);
        List<Map<String, Object>> excelData = null;
        if (excelMap.size() >= 1) {
            String key = excelMap.keySet().iterator().next();
            excelData = excelMap.get(key);
        } else {
            excelData = excelMap.get("sheet1");
        }
        if (excelData == null || excelData.isEmpty()) {
            Return msg = new Return();
            msg.setFailMsg("\u5bfc\u5165\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u6570\u636e\uff01");
            return msg.msg();
        }
        return this.importData(excelData, tableName, titles);
    }

    private ReturnMsg valid(Map<String, List<Map<String, Object>>> excelMap, String[] titles, Map<String, Object> paramMap) {
        Return rm = new Return();
        rm.setAutoRollback(false);
        Message m = new Message();
        if (excelMap.get("sheet1").size() == 0) {
            m.setMsgRemark("\u5bfc\u5165\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5bfc\u5165\u6570\u636e\uff01");
            rm.setFailMsg(m);
            return rm.msg();
        }
        for (int i = 0; i < excelMap.get("sheet1").size(); ++i) {
            Map<String, Object> jkkvo = excelMap.get("sheet1").get(i);
            for (int o = 0; o < titles.length; ++o) {
                String code = titles[o];
                String cmount = StrUtils.trimStr((Object)jkkvo.get(code));
                if (!StrUtils.isNull((Object)cmount)) continue;
                m.setMsgRemark("\u7b2c" + (i + 1) + "\u884c\u5bfc\u5165\u6570\u636e\u5b58\u5728\u7a7a\u503c");
                rm.setFailMsg(m);
            }
        }
        return rm.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnMsg importData(List<Map<String, Object>> excelData, String tableName, String[] titles) {
        Return returnMsg = new Return();
        String timestamp = DateUtils.date2String((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        ArrayList insertList = new ArrayList();
        excelData.forEach(map -> {
            StringBuilder sql = new StringBuilder("INSERT INTO " + tableName + " (serno, crt_user, mdf_user, data_flag, crt_date, mdf_date");
            StringBuilder value = new StringBuilder(" VALUES('" + UUID.shortUUID() + "', '" + ThreadLocalContext.get().getUser().getPkUuid() + "', '" + ThreadLocalContext.get().getUser().getPkUuid() + "', '1', '" + timestamp + "', '" + timestamp + "'");
            for (String clm : titles) {
                sql.append(", " + clm);
                value.append(", '" + map.get(clm) + "'");
            }
            insertList.add(sql.append(") ").append((CharSequence)value).append(")").toString());
        });
        List<List<String>> taskList = ListUtil.splitList(insertList, 1000, String.class);
        Ulog.info((String)("\u6570\u636e\u603b\u91cf\u4e3a===>" + insertList.size() + "  \u5206\u7ec4\u6570\u91cf\u4e3a===>" + taskList.size()));
        ScheduledThreadPoolExecutor fixedThreadPool = new ScheduledThreadPoolExecutor(5, (ThreadFactory)new CustomizableThreadFactory("rateDataImport-%d"));
        CountDownLatch countDownLatch = new CountDownLatch(taskList.size());
        Timestamp start1 = DateUtils.sysTimestamp();
        for (List<String> date : taskList) {
            fixedThreadPool.execute(() -> {
                try {
                    this.dao.getJdbcTemplate().batchUpdate(date.toArray(new String[0]));
                }
                catch (Exception e) {
                    Ulog.error((Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Ulog.error((Throwable)e);
        }
        finally {
            Ulog.info((String)("excel\u6570\u636e\u5bfc\u5165\u5b8c\u6210,\u7528\u65f6[" + DateUtils.dateBetween((Date)new Date(), (Date)start1, (DateUtils.DateType)DateUtils.DateType.SS) + "]\u79d2"));
        }
        return returnMsg.msg();
    }

    @Override
    public ReturnMsg delRate(Map<String, Object> paramMap) {
        Return msg = new Return();
        List delList = (List)paramMap.get("checkbox");
        String tableName = StrUtils.trimStr((Object)paramMap.get("tableName"));
        ArrayList<String[]> sernoList = new ArrayList<String[]>();
        for (Map tmpMap : delList) {
            sernoList.add(new String[]{StrUtils.trimStr(tmpMap.get("serno"))});
        }
        String sql = "DELETE FROM " + tableName + " WHERE serno = ? ";
        try {
            this.dao.getJdbcTemplate().batchUpdate(sql, sernoList);
            msg.setSuccessMsg("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg("\u5220\u9664\u5931\u8d25\uff01");
        }
        return msg.msg();
    }

    @Override
    public Return doDelRateNode(DsnStructure node, boolean flag) {
        Return r = new Return();
        r.setAutoRollback(!flag);
        if (flag) {
            r.setSuccessMsg("\u8be5\u64cd\u4f5c\u5c06\u4f1a\u5220\u9664\u8be5\u8282\u70b9\u6240\u5728\u7684\u8d39\u7387\u4fe1\u606f<br />\u786e\u8ba4\u5220\u9664\u5417?");
            r.setDataTable(new Object[]{node});
            return r;
        }
        RiskRelationServiceImpl.queryChildNodeAndDel(node.getUpNode(), this.dao);
        this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)node.getNodeNo()).model());
        this.dao.delete(DsnDynamicData.n().where().addEq(DsnDynamicData.RELATE_FK, (Object)node.getNodeNo()).model());
        return r;
    }

    @Override
    public ReturnMsg doRateListQuery(String upNodeNo) {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT ddd.serno, ds.node_no, ds.node_seq, ds.display_order, ds.relate_tab, ddd.field_1 rate_name, ddd.field_2 rate_code, ddd.field_3 rate_order, ddd.field_4 rate_index, ddd.field_5 risk_no, ddd.field_6 risk_name, ddd.field_7 rate_type FROM dsn_structure ds, dsn_dynamic_data ddd WHERE ds.node_no = ddd.relate_fk AND ds.up_node = ? ORDER BY ddd.field_3 ASC");
        queryValue.add(upNodeNo);
        List list = this.dao.findAll(sql.toString(), new AbsModelRepository.Args[]{this.dao.args(queryValue)});
        Return r = new Return();
        r.setDataList4includes(list, new String[]{DsnStructure.SERNO.column(), DsnStructure.NODE_NO.column(), DsnStructure.NODE_SEQ.column(), DsnStructure.DISPLAY_ORDER.column(), DsnStructure.RELATE_TAB.column(), "rate_name", "rate_code", "rate_order", "rate_index", "risk_no", "risk_name", "rate_type"});
        return r.msg();
    }

    @Override
    public ReturnMsg doMultiDelRateNode(List<DsnStructure> nodeList, boolean flag) {
        for (DsnStructure node : nodeList) {
            this.doDelRateNode(node, flag);
        }
        Return r = new Return();
        return r.msg();
    }

    @Override
    public ReturnMsg updateRateIndex(DsnDynamicData dynamicData) {
        dynamicData.where().addEq(DsnDynamicData.RELATE_FK, (Object)dynamicData.getRelateFk());
        this.dao.update((AbsModel)dynamicData);
        Return r = new Return();
        return r.msg();
    }

    @Override
    public ReturnMsg clearRateRecord(Map<String, Object> paramMap) {
        String tableName = StrUtils.trimStr((Object)paramMap.get("tableName"));
        String sql = "TRUNCATE " + tableName;
        this.dao.getJdbcTemplate().update(sql);
        Return r = new Return();
        return r.msg();
    }

    @Override
    public Map<String, Object> goRateModify(String nodeNo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DsnDynamicData result = (DsnDynamicData)this.dao.findOne(DsnDynamicData.n().where().addEq(DsnDynamicData.RELATE_FK, (Object)nodeNo).model());
        if (StrUtils.isNull((Object)result.getSerno())) {
            Ulog.warn((String)("dsn_dynamic_data\u8868\u4e2d\u672a\u67e5\u5230relate_fk\u4e3a" + nodeNo + "\u7684\u8bb0\u5f55"));
        }
        resultMap.put("dsn_structure_serno", nodeNo);
        resultMap.put("rate_name", result.getField1());
        resultMap.put("rate_code", result.getField2());
        resultMap.put("rate_order", result.getField3());
        resultMap.put("rate_index", result.getField4());
        return resultMap;
    }

    @Override
    public ReturnMsg doRateSelfAdd(String serno, String nodeNo, String rateCode, String rateName, String rateOrder, String rateIndex, String bizType, String riskNo, String riskName, String rateType) {
        List dddList;
        Return msg = new Return();
        if (StrUtils.isNull((Object)rateName)) {
            msg.setFailMsg("\u8d39\u7387\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)rateCode)) {
            msg.setFailMsg("\u8d39\u7387\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if ("\u8d39\u7387\u7f16\u8f91".equals(bizType)) {
            DsnDynamicData ddd = new DsnDynamicData();
            ddd.where().addEq(DsnDynamicData.RELATE_FIELD, (Object)"dsn_structure").addEq(DsnDynamicData.RELATE_FIELD, (Object)"node_no").addEq(DsnDynamicData.RELATE_FK, (Object)nodeNo).addEq(DsnDynamicData.FIELD_2, (Object)rateCode).addNotEq(DsnDynamicData.SERNO, (Object)serno).addEq(DsnDynamicData.FIELD_5, (Object)riskNo);
            List dddList2 = this.dao.findAll((AbsModel)ddd);
            if (!dddList2.isEmpty()) {
                msg.setFailMsg("\u8d39\u7387\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d");
                return msg.msg();
            }
        }
        if (!(dddList = this.dao.findAll(DsnDynamicData.n().where().addEq(DsnDynamicData.RELATE_TAB, (Object)"dsn_structure").addEq(DsnDynamicData.RELATE_FIELD, (Object)"node_no").addNotEq(DsnDynamicData.RELATE_FK, (Object)nodeNo).addEq(DsnDynamicData.FIELD_2, (Object)rateCode).addEq(DsnDynamicData.FIELD_5, (Object)riskNo).model())).isEmpty()) {
            msg.setFailMsg("\u8d39\u7387\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d");
            return msg.msg();
        }
        this.dao.delete(DsnDynamicData.n().where().addEq(DsnDynamicData.RELATE_TAB, (Object)"dsn_structure").addEq(DsnDynamicData.RELATE_FIELD, (Object)"node_no").addEq(DsnDynamicData.RELATE_FK, (Object)nodeNo).model());
        DsnDynamicData rateData = new DsnDynamicData();
        rateData.setRelateTab("dsn_structure");
        rateData.setRelateField("node_no");
        rateData.setBizType("\u8d39\u7387\u7f16\u8f91");
        rateData.setRelateFk(nodeNo);
        rateData.setField1(rateName);
        rateData.setField2(rateCode);
        rateData.setField3(rateOrder);
        rateData.setField4(rateIndex);
        rateData.setField5(riskNo);
        rateData.setField6(riskName);
        rateData.setField7(rateType);
        this.dao.save((AbsModel)rateData);
        DsnStructure node = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeNo).model());
        if (node.getNodeType().equals(NodeType.RATE.code())) {
            if (!StrUtils.isNull((Object)node.getRelateTab()) && !node.getRelateTab().endsWith(rateCode.toLowerCase())) {
                try {
                    this.dao.getJdbcTemplate().execute("DROP TABLE " + node.getRelateTab());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String tableName = TABLE_PREFIX + riskNo + "_" + rateCode.toLowerCase();
            node.setRelateTab(tableName);
            node.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
            this.dao.update((AbsModel)node);
        }
        return msg.msg();
    }

    @Override
    public Return goDropTargTable(Map<String, Object> param) {
        Return r = new Return();
        if ("1".equals(param.get("flag"))) {
            r.setSuccessMsg("\u8be5\u64cd\u4f5c\u5c06\u4f1a\u5220\u9664\u8be5\u8282\u70b9\u6240\u5728\u7684\u6307\u6807\u4fe1\u606f<br />\u786e\u8ba4\u5220\u9664\u5417?");
            r.setDataTable(param);
            return r;
        }
        String nodeNo = StrUtils.trimStr((Object)param.get("node_no"));
        DsnDynamicData data = new DsnDynamicData();
        data.where().addEq(DsnDynamicData.RELATE_FIELD, (Object)nodeNo);
        this.dao.delete((AbsModel)data);
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        DsnStructure structure = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
        DsnRules rule = new DsnRules();
        rule.where().addEq(DsnRules.RELATE_FK, (Object)structure.getNodeNo());
        dsnStructure.clear();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        this.dao.delete((AbsModel)dsnStructure);
        dsnStructure.clear();
        dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        this.dao.delete((AbsModel)dsnStructure);
        dsnStructure.clear();
        r.setSuccessMsg("\u5229\u76ca\u6f14\u793a\u6307\u6807\u5220\u9664\u6210\u529f");
        return r;
    }
}

