/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.publish.controller;

import com.newtouch.nms.sip.product.publish.services.IProductPublishService;
import com.newtouch.nms.sip.vo.CancelPublishVo;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.utils.JsonUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProductPublishController {
    @Autowired
    private IProductPublishService publishService;

    @RequestMapping(value={"/channelList.do"})
    public String channelList(HttpServletRequest request, HttpServletResponse response) {
        ReturnMsg msg = this.publishService.channelList();
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/publish.do"})
    public String publish(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String productUuid = param.get("product_uuid");
        String channelNo = param.get("channel_no");
        String startTime = param.get("start_time");
        String endTime = param.get("end_time");
        String deliveryPlatform = param.get("delivery_platform");
        ReturnMsg msg = this.publishService.publish(productUuid, channelNo, startTime, endTime, deliveryPlatform);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/cancelPublish.do"})
    public String cancelPublish(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        CancelPublishVo cancelPublishVo = (CancelPublishVo)JsonUtils.map2Class((Map)param, CancelPublishVo.class);
        ReturnMsg msg = this.publishService.cancelPublish(cancelPublishVo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/publishList.do"})
    public String publishList(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String product_uuid = param.get("product_uuid");
        String deliveryPlatform = param.get("delivery_platform");
        ReturnMsg msg = this.publishService.publishList(product_uuid, deliveryPlatform);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/publishHistoryList.do"})
    public String publishHistoryList(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String product_uuid = param.get("product_uuid");
        ReturnMsg msg = this.publishService.publishHistory(product_uuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

