/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.main.services.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.nms.sip.design.product.utils.NodeSeqUtils;
import com.newtouch.nms.sip.design.rule.model.DsnRulesAndConst;
import com.newtouch.nms.sip.model.DsnAttribute;
import com.newtouch.nms.sip.model.DsnAttributeOption;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipOrganProducts;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipProductsChannel;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.main.services.ITestService;
import com.newtouch.nms.sip.product.main.services.impl.ProductListQueryServiceImpl;
import com.newtouch.nms.sip.product.structure.service.IStructureSearchService;
import com.newtouch.nms.sys.model.SysFileRepostry;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.callback.RowCallback;
import com.uniapis.util.date.DateUtil;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class TestServiceImpl
implements ITestService {
    @Autowired(required=false)
    private AbsModelRepository dao;
    @Autowired
    private IStructureSearchService structureSearchService;
    @Autowired
    private ProductListQueryServiceImpl productListQueryService;

    @Override
    public ReturnMsg cancelRisks(DsnStructure risk) {
        Return r = new Return();
        String node_seq = risk.getNodeSeq();
        String serno = risk.getSerno();
        DsnStructure ds = new DsnStructure();
        ds.where().addLikeR(DsnStructure.NODE_SEQ, (Object)node_seq);
        ds.where().addNotEq(DsnStructure.SERNO, (Object)serno);
        List dsList = this.dao.findAll((AbsModel)ds);
        if (dsList.isEmpty()) {
            DsnStructure ds1 = new DsnStructure();
            ds1.where().addEq(DsnStructure.SERNO, (Object)serno);
            r = this.maintainRelation(risk);
            if (!r.isSuccessflag()) {
                return r.msg();
            }
        } else {
            r.setFailMsg("\u8be5\u9669\u79cd\u662f\u65b0\u589e\u9669\u79cd,\u4e0d\u53ef\u53d6\u6d88\u9669\u79cd\u5173\u7cfb!");
        }
        return r.msg();
    }

    private Return maintainRelation(DsnStructure risk) {
        Return msg = new Return();
        String nodeNo = risk.getNodeNo();
        String parentNodeNo = risk.getUpNode();
        String nodeType = risk.getNodeType();
        Map<String, Object> nodeTypeMap = this.judgeHandleClass(nodeType, parentNodeNo, nodeNo);
        if (null == nodeTypeMap || nodeTypeMap.isEmpty()) {
            msg.setFailMsg("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8282\u70b9\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u67e5\u627e\u95ee\u9898\uff01");
            return msg;
        }
        String parentNodeType = StrUtils.trimStr((Object)nodeTypeMap.get("parent"));
        String currentNodeType = StrUtils.trimStr((Object)nodeTypeMap.get("current"));
        String mainRiskFlag = "main_risks";
        if (mainRiskFlag.equals(nodeType)) {
            ReturnMsg deleteFlag = this.maintainProductAndMainRisks(parentNodeType, currentNodeType);
            if (!deleteFlag.isSuccessflag()) {
                msg.setFailMsg("\u7ef4\u62a4\u4ea7\u54c1\u548c\u9669\u79cd\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6dfb\u52a0\u4e86\u5df2\u6709\u9669\u79cd\u540e\u662f\u5426\u70b9\u51fb\u4e86\"\u9669\u79cd\u8be6\u60c5\"\u4e2d\u7684\u4fdd\u5b58\u6309\u94ae\uff01");
            }
            return msg;
        }
        Map<String, Object> parentInfoMap = this.getParentInfo(parentNodeNo, parentNodeType);
        if (null != parentInfoMap && !parentInfoMap.isEmpty()) {
            String mainRisk = StrUtils.trimStr((Object)parentInfoMap.get("mainRisk"));
            String currentRiskUUID = this.getCurrentInfo(nodeNo, currentNodeType);
            if (!StrUtils.isNull((Object)currentRiskUUID)) {
                SipRiskRelation sipRiskRelation4Delete = new SipRiskRelation();
                sipRiskRelation4Delete.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRisk);
                sipRiskRelation4Delete.where().addEq(SipRiskRelation.RISK_UUID, (Object)currentRiskUUID);
                Return r = new Return();
                r.setSuccessMsg("\u5df2\u4eceSipRiskRelation\u5220\u9664\u8fd9\u6761\u4fe1\u606f");
                if (!r.msg().isSuccessflag()) {
                    msg.setFailMsg("\u7ef4\u62a4\u9669\u79cd\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6dfb\u52a0\u4e86\u5df2\u6709\u9669\u79cd\u540e\u662f\u5426\u70b9\u51fb\u4e86\"\u9669\u79cd\u8be6\u60c5\"\u4e2d\u7684\u4fdd\u5b58\u6309\u94ae\uff01");
                    return msg;
                }
            }
        }
        return msg;
    }

    private Map<String, Object> judgeHandleClass(String nodeType, String upNode, String nodeNo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        switch (nodeType) {
            case "main_risks": {
                DsnStructure dsnStructure1Query = this.getNodeInfo(upNode);
                if (null == dsnStructure1Query || StrUtils.isNull((Object)dsnStructure1Query.getSerno())) break;
                String[] nodeSeqArray = dsnStructure1Query.getNodeSeq().split("\\.");
                resultMap.put("parent", nodeSeqArray[0]);
                String risk_uuid = this.getCurrentInfo(nodeNo, "n_risk_detail");
                resultMap.put("current", risk_uuid);
                break;
            }
            default: {
                Ulog.info((String)"\u6839\u636e\u8282\u70b9\u7684nodeType\u672a\u627e\u5230\u5339\u914d\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        return resultMap;
    }

    private ReturnMsg maintainProductAndMainRisks(String productUUID, String riskUUID) {
        SipProductRisks sipProductRisks4Delete = new SipProductRisks();
        sipProductRisks4Delete.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUUID);
        sipProductRisks4Delete.where().addEq(SipProductRisks.RISK_UUID, (Object)riskUUID);
        Return r = new Return();
        r.setSuccessMsg("\u5df2\u4eceSipProductRisks\u5220\u9664\u8be5\u4ea7\u54c1\u548c\u4e3b\u9669");
        return r.msg();
    }

    public ReturnMsg saveProductDetails_old(String currentNodeNo, Map<String, Object> productDetailMap) throws Exception {
        String flag = StrUtils.trimStr((Object)productDetailMap.get("flag"));
        Return rn = new Return();
        if (StrUtils.isNull((Object)currentNodeNo)) {
            throw new BusinessException("[\u4ea7\u54c1\u8be6\u60c5]\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        String product_uuid = StrUtils.trimStr((Object)productDetailMap.get("product_uuid"));
        if (StrUtils.isNull((Object)product_uuid)) {
            throw new BusinessException("[\u4ea7\u54c1\u7f16\u7801]\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)currentNodeNo);
        dsnStructure.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
        List dsnStructureList = this.dao.findAll((AbsModel)dsnStructure);
        for (DsnStructure tmpDsn : dsnStructureList) {
            Map<String, String> attrMap = this.getAttrInfo(tmpDsn);
            String storedTab = attrMap.get("stored_tab");
            String storedField = attrMap.get("stored_field");
            for (Map.Entry<String, Object> entry : productDetailMap.entrySet()) {
                String entryKey = entry.getKey();
                String entryValue = StrUtils.trimStr((Object)entry.getValue());
                if (!storedField.equals(entryKey)) continue;
                if ("Dsn_Dynamic_Data".equalsIgnoreCase(storedTab)) {
                    this.storeValue4DsnDynamicData(storedTab, storedField, entryValue, currentNodeNo);
                    continue;
                }
                if (!"Sip_Products".equalsIgnoreCase(storedTab)) continue;
                try {
                    this.storeValue4SipProducts(storedTab, storedField, entryValue, product_uuid, flag);
                }
                catch (BusinessException e) {
                    if (e.getMessage().startsWith("9999")) {
                        rn.msg().setFailMessage(new Message("\u4fdd\u5b58\u6570\u636e\u5e94\u4e3a\u65e5\u671f\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u65e0\u8bef\u540e\u4fdd\u5b58"));
                    }
                    return rn.msg();
                }
            }
        }
        throw new BusinessException("122222222345678");
    }

    private Map<String, String> getAttrInfo(DsnStructure tmpDsn) {
        String relate_tab = tmpDsn.getRelateTab();
        if (StrUtils.isNull((Object)relate_tab)) {
            return null;
        }
        String relateFk = tmpDsn.getRelateFk();
        String relate_field = tmpDsn.getRelateField();
        StringBuilder str = new StringBuilder();
        str.append(" select * from ").append(relate_tab).append(" where ").append(relate_field).append(" = ?");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(relateFk);
        List attrList = this.dao.findAll(String.valueOf(str), new AbsModelRepository.Args[]{list});
        if (null == attrList || attrList.isEmpty()) {
            return null;
        }
        String stored_tab = StrUtils.trimStr(((Map)attrList.get(0)).get("stored_tab"));
        String stored_field = StrUtils.trimStr(((Map)attrList.get(0)).get("stored_field"));
        if (StrUtils.isNull((Object)stored_tab) || StrUtils.isNull((Object)stored_field)) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("stored_tab", stored_tab);
        result.put("stored_field", stored_field);
        return result;
    }

    private void storeValue4SipProducts(String storedTab, String storedField, String value, String productUuid, String flag) throws Exception, BusinessException {
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer insertBuffer = new StringBuffer();
        StringBuffer updateBuffer = new StringBuffer();
        if (storedField.toLowerCase().endsWith("_date")) {
            try {
                value = DateUtil.date2String((Date)DateUtil.string2Date((Object)value), (String)"yyyy-MM-dd HH:mm:ss");
                value = this.getFunctionStr2Date(value);
            }
            catch (Exception e) {
                throw new BusinessException(new Message("9999", "\u4fdd\u5b58\u6570\u636e\u5e94\u4e3a\u65e5\u671f\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u65e0\u8bef\u540e\u4fdd\u5b58"));
            }
        }
        queryBuffer.append("select * from ").append(storedTab).append(" where product_uuid = '").append(productUuid).append("'");
        Ulog.info((String)("\t\u52a8\u6001\u67e5\u8be2\u6570\u636e\u7684sql===>" + queryBuffer.toString()));
        List queryResultList = this.dao.getJdbcTemplate().queryForList(queryBuffer.toString());
        if (null == queryResultList || queryResultList.isEmpty()) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            insertBuffer.append(" insert into ").append(storedTab).append(" (product_uuid, ").append(" crt_date, mdf_date, crt_user, mdf_user, data_flag, ").append(storedField).append(" ) values( '").append(productUuid).append("', ").append(this.getFunctionStr2Date(date) + ", ").append(this.getFunctionStr2Date(date) + ", ").append(" 'login_user', 'login_user', '1', ").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(") ");
            Ulog.info((String)("\t\u52a8\u6001\u63d2\u5165\u6570\u636e\u7684sql===>" + insertBuffer.toString()));
            this.dao.getJdbcTemplate().execute(insertBuffer.toString());
        } else if (null == flag || "".equalsIgnoreCase(flag)) {
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            updateBuffer.append("update ").append(storedTab).append(" set ").append(storedField).append("=").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
            Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        } else {
            Map map = (Map)queryResultList.get(0);
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            if ("product_name".equalsIgnoreCase(storedField) || "product_no".equalsIgnoreCase(storedField) || StrUtils.isNull(map.get(storedField))) {
                updateBuffer.append("update ").append(storedTab).append(" set ").append(storedField).append("=").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
                Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            } else {
                updateBuffer.append("update ").append(storedTab).append(" set ").append(" mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
                Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            }
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        }
    }

    private void updateStructureName(String upNode, String nodeName) {
        DsnStructure struct = new DsnStructure();
        struct.setNodeName(nodeName);
        struct.where().addEq(DsnStructure.NODE_NO, (Object)upNode);
        this.dao.update((AbsModel)struct);
    }

    private void storeValue4DsnDynamicData(String storedTab, String stored_field, String value, String currentNodeNo) throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer insertBuffer = new StringBuffer();
        StringBuffer updateBuffer = new StringBuffer();
        if (stored_field.toLowerCase().endsWith("_date")) {
            value = DateUtil.date2String((Date)DateUtil.string2Date((Object)value), (String)"yyyy-MM-dd HH:mm:ss");
            value = this.getFunctionStr2Date(value);
        }
        queryBuffer.append("select * from ").append(storedTab).append(" where serno = '").append(currentNodeNo).append("'");
        Ulog.info((String)("\t\u52a8\u6001\u67e5\u8be2\u6570\u636e\u7684sql===>" + queryBuffer.toString()));
        List queryResultList = this.dao.getJdbcTemplate().queryForList(queryBuffer.toString());
        if (null == queryResultList || queryResultList.isEmpty()) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            insertBuffer.append(" insert into ").append(storedTab).append(" (serno, ").append(" crt_date, mdf_date, crt_user, mdf_user, data_flag, ").append(stored_field).append(" ) values( '").append(currentNodeNo).append("', ").append(this.getFunctionStr2Date(date) + " , ").append(this.getFunctionStr2Date(date) + " , ").append(" 'login_user', 'login_user', '1', ").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(") ");
            Ulog.info((String)("\t\u52a8\u6001\u63d2\u5165\u6570\u636e\u7684sql===>" + insertBuffer.toString()));
            this.dao.getJdbcTemplate().execute(insertBuffer.toString());
        } else {
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            updateBuffer.append("update ").append(storedTab).append(" set ").append(stored_field).append("=").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where serno ='").append(currentNodeNo).append("'");
            Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        }
    }

    public String getFunctionStr2Date(String dateStr) {
        return "to_timestamp('" + dateStr + "', 'YYYY-MM-DD HH24:MI:SS') ";
    }

    private Map<String, Object> getParentInfo(String parentNodeNo, String nodeType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DsnStructure dsnStructure = this.getNodeInfo(parentNodeNo);
        if (null != dsnStructure) {
            String[] nodeSeqArray = dsnStructure.getNodeSeq().split("\\.");
            String rootNodeNo = nodeSeqArray[0];
            String upNode = dsnStructure.getUpNode();
            DsnStructure dsnStructure2Query = new DsnStructure();
            dsnStructure2Query.where().addEq(DsnStructure.UP_NODE, (Object)upNode);
            dsnStructure2Query.where().addEq(DsnStructure.NODE_TYPE, (Object)nodeType);
            DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure2Query);
            if (null != dsnStructure4Result && !StrUtils.isNull((Object)dsnStructure4Result.getSerno())) {
                resultMap.put("mainRisk", dsnStructure4Result.getNodeNo());
                resultMap.put("rootNodeNo", rootNodeNo);
            }
        }
        return resultMap;
    }

    private String getCurrentInfo(String nodeNo, String nodeType) {
        DsnStructure dsnStructure3Query = new DsnStructure();
        dsnStructure3Query.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure3Query.where().addEq(DsnStructure.NODE_TYPE, (Object)nodeType);
        DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure3Query);
        return null == dsnStructure4Result ? null : dsnStructure4Result.getNodeNo();
    }

    private DsnStructure getNodeInfo(String nodeNo) {
        DsnStructure dsnStructure4Query = new DsnStructure();
        dsnStructure4Query.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure4Query);
        return null == dsnStructure4Result ? null : dsnStructure4Result;
    }

    public ReturnMsg queryProductList(String prd_name, String prd_no, String nowPage, String row4Page) {
        String sql = "SELECT risk_name,product_name,product_no,sip_product_risks.risk_uuid,sip_product_risks.product_uuid FROM sip_product_risks INNER JOIN sip_products on sip_products.product_uuid = sip_product_risks.product_uuid INNER JOIN sip_risks on sip_risks.risk_uuid = sip_product_risks.risk_uuid WHERE (product_name like ? or product_no = ?) and is_main_risk = ? ";
        ArrayList<String> searchParam = new ArrayList<String>();
        searchParam.add('%' + prd_name + '%');
        searchParam.add(prd_no);
        searchParam.add("M");
        ThreadLocalContext.get().getPageCount().setNowPage(Integer.valueOf(nowPage));
        ThreadLocalContext.get().getPageCount().setRows4Page(Integer.valueOf(row4Page));
        List proList = this.dao.findAll(sql, SipProducts.class, Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(searchParam)});
        Return msg = new Return();
        msg.setDataList4includes(proList, SipProducts.class, new String[]{"product_name", "product_no", "risk_name", "risk_uuid", "product_uuid"});
        return msg.msg();
    }

    public ReturnMsg doCancelProductRiskRelation_old(String node_no, String serno, String node_seq, String up_node, String node_type) {
        Return msg = new Return();
        String[] nodeSeqArray = node_seq.split("\\.");
        String pro_uuid = nodeSeqArray[0];
        if (!this.getProductConfigStatus_old(pro_uuid)) {
            DsnStructure dsn = new DsnStructure();
            dsn.where().addEq(DsnStructure.SERNO, (Object)serno);
            msg = this.maintainRelation_old(node_no, up_node, node_type);
        } else {
            msg.setFailMsg("\u8be5\u4ea7\u54c1\u5904\u4e8e\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u53ef\u53d6\u6d88\u5173\u8054");
        }
        return msg.msg();
    }

    public boolean getProductConfigStatus_old(String product_uuid) {
        boolean statusFlag = false;
        Date date = new Date();
        SipProductsChannel productsChannel = new SipProductsChannel();
        productsChannel.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)product_uuid);
        List channelProduct = this.dao.findAll((AbsModel)productsChannel);
        for (int i = 0; i < channelProduct.size(); ++i) {
            SipProductsChannel channel_Product = (SipProductsChannel)channelProduct.get(i);
            if (!date.after(channel_Product.getStartDate()) || !date.before(channel_Product.getEndDate())) continue;
            statusFlag = true;
            break;
        }
        return statusFlag;
    }

    private Return maintainRelation_old(String node_no, String up_node, String node_type) {
        Return msg = new Return();
        Map<String, Object> nodeTypeMap = this.judgeHandleClass(node_type, up_node, node_no);
        if (null == nodeTypeMap || nodeTypeMap.isEmpty()) {
            msg.setFailMsg("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8282\u70b9\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u67e5\u627e\u95ee\u9898\uff01");
            return msg;
        }
        String parentNodeType = StrUtils.trimStr((Object)nodeTypeMap.get("parent"));
        String currentNodeType = StrUtils.trimStr((Object)nodeTypeMap.get("current"));
        String mainRiskFlag = "main_risks";
        if (mainRiskFlag.equals(node_type)) {
            ReturnMsg deleteFlag = this.maintainProductAndMainRisks(parentNodeType, currentNodeType);
            if (deleteFlag.getMsgList().isEmpty()) {
                msg.setFailMsg("\u7ef4\u62a4\u4ea7\u54c1\u548c\u9669\u79cd\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6dfb\u52a0\u4e86\u5df2\u6709\u9669\u79cd\u540e\u662f\u5426\u70b9\u51fb\u4e86\"\u9669\u79cd\u8be6\u60c5\"\u4e2d\u7684\u4fdd\u5b58\u6309\u94ae\uff01");
            }
            return msg;
        }
        return msg;
    }

    private Map<String, Object> judgeHandleClass_old(String node_type, String up_node, String node_no) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        switch (node_type) {
            case "main_risks": {
                DsnStructure dsnStructure1Query = this.structureSearchService.getNodeInfo(up_node);
                if (null == dsnStructure1Query || StrUtils.isNull((Object)dsnStructure1Query.getSerno())) break;
                String[] nodeSeqArray = dsnStructure1Query.getNodeSeq().split("\\.");
                resultMap.put("parent", nodeSeqArray[0]);
                String risk_uuid = this.structureSearchService.getCurrentInfo(node_no, "n_risk_detail");
                resultMap.put("current", risk_uuid);
                break;
            }
            default: {
                Ulog.info((String)"\u6839\u636e\u8282\u70b9\u7684nodeType\u672a\u627e\u5230\u5339\u914d\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        return resultMap;
    }

    private ReturnMsg maintainProductAndMainRisks_old(String productUUID, String riskUUID) {
        SipProductRisks sipProductRisks4Delete = new SipProductRisks();
        sipProductRisks4Delete.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUUID);
        sipProductRisks4Delete.where().addEq(SipProductRisks.RISK_UUID, (Object)riskUUID);
        Return r = new Return();
        r.setSuccessMsg("\u5df2\u4eceSipProductRisks\u5220\u9664\u8be5\u4ea7\u54c1\u548c\u4e3b\u9669");
        return r.msg();
    }

    public ReturnMsg addMainRisk_test(Map<String, Object> paramMap) {
        Return msg = new Return();
        String node_no = StrUtils.trimStr((Object)paramMap.get("node_no"));
        String node_type = StrUtils.trimStr((Object)paramMap.get("node_type"));
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.NODE_NO, (Object)node_no);
        List queryList = this.dao.findAll((AbsModel)dsn);
        DsnStructure addRiskTopNode = (DsnStructure)queryList.get(0);
        List mainSelect = (List)paramMap.get("mainSelect");
        if (null == mainSelect || mainSelect.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u9669\u79cd\uff01");
            return msg.msg();
        }
        for (Map main_select : mainSelect) {
            String riskNodeSerno = StrUtils.trimStr(main_select.get("riskSerno"));
            DsnStructure dsn2 = new DsnStructure();
            dsn2.where().addEq(DsnStructure.SERNO, (Object)riskNodeSerno);
            DsnStructure toAddRiskNode = (DsnStructure)this.dao.findOne((AbsModel)dsn2);
            if (this.checkSubNodeisExit(addRiskTopNode, toAddRiskNode)) {
                msg.setFailMsg("\u6b64\u4e3b\u9669\u5df2\u5b58\u5728");
                continue;
            }
            if (this.checkSubNodeisExit(addRiskTopNode, toAddRiskNode)) continue;
            DsnStructure newAddRiskNode = this.saveNewRiskNode(toAddRiskNode, addRiskTopNode, node_type);
            this.handleRiskRelation(newAddRiskNode, node_type);
        }
        return msg.msg();
    }

    private boolean checkSubNodeisExit(DsnStructure addRiskTopNode, DsnStructure oldAddRiskNode) {
        addRiskTopNode.where().addEq(DsnStructure.UP_NODE, (Object)addRiskTopNode.getNodeNo());
        List subRiskNodes = this.dao.findAll((AbsModel)addRiskTopNode);
        if (subRiskNodes == null || subRiskNodes.isEmpty()) {
            return false;
        }
        for (DsnStructure subRiskNode : subRiskNodes) {
            if (!oldAddRiskNode.getNodeNo().equals(subRiskNode.getNodeNo())) continue;
            return true;
        }
        return false;
    }

    private DsnStructure saveNewRiskNode(DsnStructure oldNode, DsnStructure newUpNode, String newNodeType) {
        String oldNodeNo = oldNode.getNodeNo();
        oldNode.setSerno(UUID.shortUUID());
        oldNode.setNodeNo(oldNodeNo);
        oldNode.setUpNode(newUpNode.getNodeNo());
        oldNode.setNodeType(newNodeType);
        StringBuffer noSeq = new StringBuffer(newUpNode.getNodeSeq()).append(oldNodeNo).append(".");
        oldNode.setNodeSeq(noSeq.toString());
        return oldNode;
    }

    private void handleRiskRelation(DsnStructure riskNode, String newNodeType) {
        if (NodeType.MAIN_RISKS.code().equals(newNodeType)) {
            String[] nodeSeqs = riskNode.getNodeSeq().split("\\.");
            DsnStructure mainNode = this.structureSearchService.getOneDsnByNodeNo(nodeSeqs[2]);
            String mainUuid = this.structureSearchService.getRiskuuidByNode(mainNode);
            SipProductRisks product2RiskRelation = new SipProductRisks();
            product2RiskRelation.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)nodeSeqs[0]);
            product2RiskRelation.where().addEq(SipProductRisks.RISK_UUID, (Object)mainUuid);
            this.dao.delete((AbsModel)product2RiskRelation);
            SipProductRisks product2RiskSave = new SipProductRisks();
            product2RiskSave.setProductUuid(nodeSeqs[0]);
            product2RiskSave.setRiskUuid(mainUuid);
            this.dao.save((AbsModel)product2RiskSave);
        }
    }

    public ReturnMsg cancelRiskRelation(DsnStructure risk) {
        Return msg = new Return();
        List dss = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)risk.getNodeNo()).model());
        if (dss.size() == 1) {
            msg.setFailMsg("\u65e0\u6cd5\u64cd\u4f5c\u53d6\u6d88\u9669\u79cd\u5173\u7cfb\uff01");
            return msg.msg();
        }
        TestServiceImpl.delRiskRelation(risk, this.dao);
        this.dao.delete(risk.where().addEq(DsnStructure.SERNO, (Object)risk.getSerno()).model());
        return msg.msg();
    }

    private static void delRiskRelation(DsnStructure node, AbsModelRepository dao) {
        String[] nodeSeqArray = node.getNodeSeq().split("\\.");
        boolean isMainRiks = nodeSeqArray.length == 4;
        String serno = nodeSeqArray[nodeSeqArray.length - 2];
        if (isMainRiks) {
            dao.delete(SipProductRisks.n().where().addEq(SipProductRisks.SERNO, (Object)serno).model());
            return;
        }
        dao.delete(SipRiskRelation.n().where().addEq(SipRiskRelation.SERNO, (Object)serno).model());
    }

    public ReturnMsg delProduct(Map<String, Object> param) {
        Return r = new Return();
        List newListParam = (List)param.get("checkbox");
        for (Map tempMap : newListParam) {
            if ("ALL".equals(StrUtils.trimStr(tempMap.get("open_state"))) || "PART".equals(StrUtils.trimStr(tempMap.get("open_state")))) {
                r.setFailMsg("\u5f00\u653e\u72b6\u6001\u4e3a\u90e8\u5206\u9500\u552e\u548c\u5168\u90e8\u9500\u552e\u7684\u4ea7\u54c1\u4e0d\u80fd\u5220\u9664");
                break;
            }
            String product_uuid = StrUtils.trimStr(tempMap.get("true_product_uuid"));
            SipProducts sp = new SipProducts();
            sp.where().addEq(SipProducts.PRODUCT_UUID, (Object)product_uuid);
            this.dao.delete((AbsModel)sp);
            List subNodes = null;
            for (DsnStructure subNode : subNodes) {
                String nodeType = subNode.getNodeType();
                if (NodeType.PRD_DETAIL.code().equals(nodeType)) {
                    this.deleteAttrDetail(subNode.getNodeSeq(), "attr_detail");
                }
                if (!NodeType.N_RISK.code().equals(nodeType)) continue;
            }
            DsnStructure dsn = new DsnStructure();
            dsn.where().addEq(DsnStructure.NODE_NO, (Object)product_uuid);
            this.dao.delete((AbsModel)dsn);
        }
        return r.msg();
    }

    private Return deleteAttrDetail(String node_seq, String node_type) {
        Return r = new Return();
        DsnStructure attr_detail = new DsnStructure();
        attr_detail.where().addLikeR(DsnStructure.NODE_SEQ, (Object)node_seq);
        attr_detail.where().addEq(DsnStructure.NODE_TYPE, (Object)node_type);
        List attr_detailList = this.dao.findAll((AbsModel)attr_detail);
        r = this.deleteAttribute(attr_detailList, node_type);
        attr_detail.where().addLikeR(DsnStructure.NODE_SEQ, (Object)node_seq);
        attr_detail.where().addEq(DsnStructure.NODE_TYPE, (Object)node_type);
        this.dao.delete((AbsModel)attr_detail);
        return r;
    }

    private Return deleteAttribute(List<DsnStructure> attrList, String node_type) {
        Return r = new Return();
        for (DsnStructure detail : attrList) {
            DsnBizAttribute attr_biz = new DsnBizAttribute();
            attr_biz.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)detail.getNodeNo());
            attr_biz = (DsnBizAttribute)this.dao.findOne((AbsModel)attr_biz);
            attr_biz.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)detail.getNodeNo());
            this.dao.delete((AbsModel)attr_biz);
            DsnBizAttributeOption biz_option = new DsnBizAttributeOption();
            biz_option.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)detail.getNodeNo());
            this.dao.delete((AbsModel)biz_option);
            DsnAttribute attr = new DsnAttribute();
            attr.where().addEq(DsnAttribute.ATTR_UUID, (Object)attr_biz.getAttrUuid());
            attr = (DsnAttribute)this.dao.findOne((AbsModel)attr);
            attr.where().addEq(DsnAttribute.ATTR_UUID, (Object)attr_biz.getAttrUuid());
            this.dao.delete((AbsModel)attr);
            DsnAttributeOption dsn_option = new DsnAttributeOption();
            dsn_option.where().addEq(DsnAttributeOption.ATTR_UUID, (Object)attr.getAttrUuid());
            this.dao.delete((AbsModel)dsn_option);
            DsnStructure rule = new DsnStructure();
            rule.where().addEq(DsnStructure.UP_NODE, (Object)detail.getNodeNo());
            if (!"attr4Liability".equals(node_type)) {
                if (!StrUtils.isNull((Object)(rule = (DsnStructure)this.dao.findOne((AbsModel)rule)).getNodeNo())) {
                    // empty if block
                }
            } else {
                List list = this.dao.findAll((AbsModel)rule);
            }
            DsnStructure dsn = new DsnStructure();
            dsn.where().addEq(DsnStructure.NODE_SEQ, (Object)detail.getNodeSeq());
            this.dao.delete((AbsModel)dsn);
        }
        return r;
    }

    public ReturnMsg addMainRisk(Map<String, Object> paramMap) {
        Return msg = new Return();
        String product_uuid = StrUtils.trimStr((Object)paramMap.get("product_uuid"));
        List riskList = (List)paramMap.get("risk_list");
        for (Map risk_list : riskList) {
            String risk_uuid = StrUtils.trimStr(risk_list.get("risk_uuid"));
            SipProductRisks sip = new SipProductRisks();
            sip.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid);
            sip.where().addEq(SipProductRisks.RISK_UUID, (Object)risk_uuid);
            List result = this.dao.findAll((AbsModel)sip);
            if (result.isEmpty()) {
                SipProductRisks Sip = new SipProductRisks();
                Sip.where().addEq(SipProductRisks.RISK_UUID, (Object)risk_uuid);
                SipProductRisks risk = (SipProductRisks)this.dao.findOne((AbsModel)Sip);
                DsnStructure dsn_risk = new DsnStructure();
                dsn_risk.where().addEq(DsnStructure.SERNO, (Object)risk.getSerno());
                DsnStructure toAddRisk = (DsnStructure)this.dao.findOne((AbsModel)dsn_risk);
                DsnStructure dsn_pro_detail = new DsnStructure();
                dsn_pro_detail.where().addEq(DsnStructure.NODE_NO, (Object)product_uuid);
                DsnStructure prdDetailNode = (DsnStructure)this.dao.findOne((AbsModel)dsn_pro_detail);
                DsnStructure dsn_pro = new DsnStructure();
                dsn_pro.where().addEq(DsnStructure.NODE_NO, (Object)prdDetailNode.getUpNode());
                DsnStructure dsnPrdNode = (DsnStructure)this.dao.findOne((AbsModel)dsn_pro);
                DsnStructure dsn_n_risk = new DsnStructure();
                dsn_n_risk.where().addEq(DsnStructure.UP_NODE, (Object)dsnPrdNode.getNodeNo());
                dsn_n_risk.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk");
                DsnStructure dsnNRiskNode = (DsnStructure)this.dao.findOne((AbsModel)dsn_n_risk);
                DsnStructure pro_detail = new DsnStructure();
                dsn_pro_detail.where().addEq(DsnStructure.NODE_NO, (Object)product_uuid);
                DsnStructure prdDetail = (DsnStructure)this.dao.findOne((AbsModel)dsn_pro_detail);
                DsnStructure pro = new DsnStructure();
                dsn_pro.where().addEq(DsnStructure.NODE_NO, (Object)prdDetail.getUpNode());
                DsnStructure PrdNode = (DsnStructure)this.dao.findOne((AbsModel)dsn_pro);
                DsnStructure n_risk = new DsnStructure();
                dsn_n_risk.where().addEq(DsnStructure.UP_NODE, (Object)dsnPrdNode.getNodeNo());
                dsn_n_risk.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk");
                String oldUpNode = StrUtils.trimStr((Object)paramMap.get("prd_node_no"));
                DsnStructure UpNode = new DsnStructure();
                UpNode.where().addEq(DsnStructure.UP_NODE, (Object)oldUpNode);
                UpNode.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk");
                DsnStructure dsnStructure = (DsnStructure)this.dao.findOne((AbsModel)UpNode);
                continue;
            }
            msg.setFailMsg("\u8be5\u9669\u79cd\u5df2\u5b58\u5728\uff01");
        }
        return msg.msg();
    }

    public ReturnMsg queryRisk4Ajax(DsnStructure node, String riskName) {
        String isMainRisk = "M";
        switch (NodeType.valueOf((String)node.getNodeType().toUpperCase())) {
            case N_SUB_RISKS: {
                isMainRisk = "S";
                break;
            }
            case N_ACCY_RISKS: {
                isMainRisk = "A";
                break;
            }
            case N_EXEMPT: {
                isMainRisk = "W";
            }
        }
        List riskNameList = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model());
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk).model();
        riskNameList.forEach(dsn -> risk.where().addNotIn(SipRisks.RISK_NAME, new String[]{dsn.getNodeName()}));
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        List riskList2 = this.dao.findAll((AbsModel)risk);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leftSelect", riskList2);
        map.put("ajaxtype", "select");
        map.put("blankline", false);
        Return msg = new Return();
        msg.getDataList().add(map);
        return msg.msg();
    }

    public ReturnMsg addRisk(DsnStructure node, Map<String, Object> paramMap) {
        Return msg = new Return();
        List rightSelectList = (List)paramMap.get("rigthSelect");
        if (null == rightSelectList || rightSelectList.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u9669\u79cd\uff01");
            return msg.msg();
        }
        int countNum = Integer.parseInt(((DsnStructure)this.dao.findOne(((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model()).groupBy().count(DsnStructure.NODE_NO))).getOtherProperty("count_node_num").toString());
        for (Map tmpMap : rightSelectList) {
            String riskNodeNo = StrUtils.trimStr(tmpMap.get("rigthSelect"));
            DsnStructure riskDetailsNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskNodeNo).model());
            DsnStructure riskNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskDetailsNode.getUpNode()).model());
            riskNode.setSerno(UUID.shortUUID());
            riskNode.setNodeSeq(node.getNodeSeq() + riskNode.getNodeNo() + ".");
            riskNode.setUpNode(node.getNodeNo());
            riskNode.setDisplayOrder(Integer.valueOf(countNum++));
            this.dao.save((AbsModel)riskNode);
            this.saveRiskRelation(riskDetailsNode, this.dao);
        }
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg.msg();
    }

    public void saveRiskRelation(DsnStructure node, AbsModelRepository dao) {
        List relationList = dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)node.getUpNode()).model());
        SipRiskRelation srr = SipRiskRelation.n();
        HashMap<String, Object> nodeSernoMap = new HashMap<String, Object>();
        for (Object ds : relationList) {
            nodeSernoMap.put(ds.getSerno(), ds);
            srr.where().addIn(SipRiskRelation.SERNO, new String[]{ds.getSerno()});
        }
        List srrList = dao.findAll((AbsModel)srr);
        for (SipRiskRelation aSrr : srrList) {
            nodeSernoMap.remove(aSrr.getSerno());
        }
        Collection dsnList = nodeSernoMap.values();
        for (DsnStructure dsn : dsnList) {
            node.setNodeSeq(dsn.getNodeSeq() + node.getNodeNo() + ".");
            this.saveRelation(dsn.getSerno(), node, dao);
        }
    }

    private ReturnMsg saveRelation(String serno, DsnStructure node, AbsModelRepository dao) {
        boolean isMainRiks;
        Return r = new Return();
        String[] nodeSeqArray = node.getNodeSeq().split("\\.");
        boolean bl = isMainRiks = nodeSeqArray.length == 4;
        if (isMainRiks) {
            SipProductRisks spr = SipProductRisks.n();
            spr.setSerno(serno);
            String prdNodeNo = NodeSeqUtils.getPrdNodeNo(node.getNodeSeq());
            DsnStructure prdStructure2 = (DsnStructure)dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)prdNodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD_DETAIL.code()).model());
            spr.setProductUuid(prdStructure2.getNodeNo());
            spr.setRiskUuid(node.getNodeNo());
            dao.save((AbsModel)spr);
            return r.msg();
        }
        r.setFailMsg("\u65e0\u6cd5\u6dfb\u52a0\u4e3b\u9669\uff01");
        return r.msg();
    }

    public ReturnMsg queryDetailsInfo(DsnStructure dsnNode) {
        Return msg = new Return();
        List allAttrList = null;
        if (allAttrList.isEmpty()) {
            return msg.msg();
        }
        Map attrGroup = null;
        block14: for (Map.Entry attrEntry : attrGroup.entrySet()) {
            switch (((String)attrEntry.getKey()).toLowerCase()) {
                case "sip_risks": {
                    SipRisks attrValueMap = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)dsnNode.getNodeNo()).model());
                    break;
                }
                case "sip_products": {
                    SipProducts product = (SipProducts)this.dao.findOne(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)dsnNode.getNodeNo()).model());
                    break;
                }
                case "dsn_dynamic_data": {
                    DsnDynamicData dynamicData = (DsnDynamicData)this.dao.findOne(DsnDynamicData.n().where().addEq(DsnDynamicData.RELATE_TAB, (Object)dsnNode.getRelateTab()).addEq(DsnDynamicData.RELATE_FIELD, (Object)dsnNode.getRelateField()).addEq(DsnDynamicData.RELATE_FK, (Object)dsnNode.getNodeNo()).model());
                    break;
                }
                case "dsn_dynamic_text_data": {
                    break;
                }
                case "sys_file_repostry": {
                    SysFileRepostry sfr = SysFileRepostry.n();
                    for (DsnBizAttribute attr : (List)attrEntry.getValue()) {
                        sfr.where().addEq(SysFileRepostry.FILE_NO, (Object)attr.getBizUuid());
                        SysFileRepostry file = (SysFileRepostry)this.dao.findOne((AbsModel)sfr);
                        attr.getOtherProperty().put("field_value", ClassUtils.getProperty((Object)file, (String)attr.getStoredField()));
                        attr.getOtherProperty().put("node_no", attr.getBizUuid());
                        attr.getOtherProperty().put("file_no_url", attr.getBizUuid());
                        attr.getOtherProperty().put("file_name", file.getFileName());
                    }
                    continue block14;
                }
                default: {
                    Ulog.error((String)("\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u5b58\u50a8\u8868\u662f[" + (String)attrEntry.getKey() + "]\u672a\u627e\u5230\u8be5\u5c5e\u6027\u6240\u914d\u7f6e\u7684\u5b58\u50a8\u8868\uff01\uff01\uff01"));
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", allAttrList);
        DsnStructure dsnStructure = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)dsnNode.getNodeNo()).model());
        map.put("node_no", dsnStructure.getNodeNo());
        map.put("node_seq", dsnStructure.getNodeSeq());
        map.put("up_node", dsnStructure.getUpNode());
        msg.setDataTable(map);
        return msg.msg();
    }

    public ReturnMsg deleteProduct(Map<String, Object> param) {
        Return r = new Return();
        List proListParam = (List)param.get("product_list");
        for (Map proMap : proListParam) {
            String product_uuid = StrUtils.trimStr(proMap.get("product_uuid"));
            boolean productChannelStatus = this.getProductConfigStatus(product_uuid);
            if (!productChannelStatus) {
                SipProductRisks proRisk = new SipProductRisks();
                proRisk.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid);
                if (this.dao.findAll((AbsModel)proRisk).isEmpty()) {
                    SipProducts sip = new SipProducts();
                    sip.where().addEq(SipProducts.PRODUCT_UUID, (Object)product_uuid);
                    this.dao.delete((AbsModel)sip);
                    DsnStructure dsn_prd_detail = new DsnStructure();
                    dsn_prd_detail.where().addEq(DsnStructure.NODE_NO, (Object)product_uuid);
                    DsnStructure dsn_prd_attr_detail = new DsnStructure();
                    dsn_prd_attr_detail.where().addEq(DsnStructure.UP_NODE, (Object)product_uuid);
                    dsn_prd_attr_detail.where().addEq(DsnStructure.NODE_TYPE, (Object)"attr_detail");
                    DsnStructure dsn_prd = new DsnStructure();
                    dsn_prd.where().addEq(DsnStructure.NODE_NO, (Object)dsn_prd_detail.getUpNode());
                    DsnStructure dsn_n_risk = new DsnStructure();
                    dsn_n_risk.where().addEq(DsnStructure.UP_NODE, (Object)dsn_prd.getNodeNo());
                    dsn_n_risk.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk");
                    DsnStructure dsn_main_risks = new DsnStructure();
                    dsn_main_risks.where().addEq(DsnStructure.UP_NODE, (Object)dsn_n_risk.getNodeNo());
                    dsn_main_risks.where().addEq(DsnStructure.NODE_TYPE, (Object)"main_risks");
                    this.dao.delete((AbsModel)dsn_prd_detail);
                    this.dao.delete((AbsModel)dsn_prd_attr_detail);
                    this.dao.delete((AbsModel)dsn_prd);
                    this.dao.delete((AbsModel)dsn_n_risk);
                    this.dao.delete((AbsModel)dsn_main_risks);
                    SipOrganProducts organProducts = new SipOrganProducts();
                    organProducts.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)product_uuid);
                    this.dao.delete((AbsModel)organProducts);
                    SipProductsChannel productsChannel = new SipProductsChannel();
                    productsChannel.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)productsChannel);
                    List attr_list = this.dao.findAll((AbsModel)dsn_prd_attr_detail);
                    attr_list.stream().forEach(attr_detail -> {
                        DsnBizAttribute bizAttribute = new DsnBizAttribute();
                        bizAttribute.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)attr_detail.getNodeNo());
                        DsnAttribute attribute = new DsnAttribute();
                        attribute.where().addEq(DsnAttribute.ATTR_UUID, (Object)bizAttribute.getAttrUuid());
                        DsnAttributeOption attributeOption = new DsnAttributeOption();
                        attributeOption.where().addEq(DsnAttributeOption.ATTR_UUID, (Object)bizAttribute.getAttrUuid());
                        this.dao.delete((AbsModel)attribute);
                        this.dao.delete((AbsModel)attributeOption);
                        this.dao.delete((AbsModel)bizAttribute);
                        DsnBizAttributeOption bizAttributeOption = new DsnBizAttributeOption();
                        bizAttributeOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)attr_detail.getNodeNo());
                        this.dao.delete((AbsModel)bizAttributeOption);
                    });
                    continue;
                }
                r.setFailMsg("\u8be5\u4ea7\u54c1\u4e0b\u8fd8\u6709\u4e3b\u9669\u672a\u53d6\u6d88\u5173\u8054\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
                continue;
            }
            r.setFailMsg("\u8be5\u4ea7\u54c1\u5904\u4e8e\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
        }
        return r.msg();
    }

    public boolean getProductConfigStatus(String product_uuid) {
        boolean statusFlag = false;
        Date date = new Date();
        SipProductsChannel productsChannel = new SipProductsChannel();
        productsChannel.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)product_uuid);
        List channelProduct = this.dao.findAll((AbsModel)productsChannel);
        for (int i = 0; i < channelProduct.size(); ++i) {
            SipProductsChannel channel_Product = (SipProductsChannel)channelProduct.get(i);
            if (!date.after(channel_Product.getStartDate()) || !date.before(channel_Product.getEndDate())) continue;
            statusFlag = true;
            break;
        }
        return statusFlag;
    }

    public ReturnMsg delRule(DsnStructure structure) {
        String userNo = ThreadLocalContext.get().getUser().getUserCode();
        Return r = new Return();
        this.dao.update("DELETE FROM dsn_rules_const WHERE rule_id IN (SELECT rule_id FROM dsn_rules WHERE relate_fk = ?)", new Object[]{structure.getNodeNo()});
        this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)structure.getNodeNo()).model());
        this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)structure.getNodeNo()).model());
        r.setSuccessMsg("\u5220\u9664\u89c4\u5219\u6210\u529f");
        return r.msg();
    }

    public ReturnMsg saveRulesInfo(List<DsnRulesAndConst> rules, String nodeNo, String flag) {
        Return result = new Return();
        if (StrUtils.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        this.saveRules(rules, nodeNo);
        List<DsnRules> ruleInfoList = this.queryDsnRules(nodeNo, flag);
        result.setDataList(ruleInfoList, DsnRules.class);
        return result.msg();
    }

    private List<DsnRules> queryDsnRules(String nodeNo, String flag) {
        DsnRules rule = (DsnRules)DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)nodeNo).model();
        if (!"1".equals(flag)) {
            rule.where().addEq(DsnRules.STATUS, (Object)"1");
        }
        rule.setOrderBy(new Sort.Order[]{DsnRules.SCHEDULE_ORDER.asc()});
        List ruleInfoList = this.dao.findAll((AbsModel)rule);
        return ruleInfoList;
    }

    private void saveRules(List<DsnRulesAndConst> ruleList, String nodeNo) {
        if (ruleList == null || ruleList.isEmpty()) {
            return;
        }
        String userNo = ThreadLocalContext.get().getUser().getUserCode();
        this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)nodeNo).model());
        for (DsnRulesAndConst rule : ruleList) {
            rule.setRelateFk(nodeNo);
            if (StrUtils.isNull((Object)rule.getRuleId())) {
                rule.setRuleId(UUID.shortUUID());
            }
            this.saveRuleConst(rule);
            rule.checkValue();
            this.dao.save((AbsModel)rule);
        }
    }

    private void saveRuleConst(DsnRulesAndConst rule) {
        Map<String, Object> json2Map = rule.getConstMap();
        if (json2Map == null || json2Map.isEmpty()) {
            return;
        }
        this.dao.delete(DsnRulesConst.n().where().addEq(DsnRulesConst.RULE_ID, (Object)rule.getRuleId()).model());
        for (Map.Entry<String, Object> entry : json2Map.entrySet()) {
            if ("####".equals(entry.getKey())) {
                throw new BusinessException(new Message("\u5e38\u91cf\u89c4\u5219\u4fdd\u5b58\u5165\u53c2\u9519\u8bef"));
            }
            DsnRulesConst ruleConst = DsnRulesConst.n();
            ruleConst.setConstId(entry.getKey());
            ruleConst.setConstMapping(StrUtils.trimStr((Object)entry.getValue()));
            ruleConst.setRuleId(rule.getRuleId());
            this.dao.save((AbsModel)ruleConst);
        }
    }

    public ReturnMsg queryAllRulesInfoByNodeNo(String nodeNo, String flag) {
        Return result = new Return();
        if (StrUtils.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        DsnRules rule = ((DsnRules)DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)nodeNo).model()).setOrderBy(new Sort.Order[]{DsnRules.SCHEDULE_ORDER.asc()});
        if (!"1".equals(flag)) {
            rule.where().addEq(DsnRules.STATUS, (Object)"1");
        }
        List ruleInfoList = this.dao.findAll((AbsModel)rule);
        result.setDataList(ruleInfoList, DsnRules.class);
        return result.msg();
    }

    public ReturnMsg saveRulesInfo_old(List<DsnRulesAndConst> rules, String nodeNo, String flag) {
        Return result = new Return();
        if (StrUtils.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        this.saveRules_old(rules, nodeNo);
        List<DsnRules> ruleInfoList = this.queryDsnRules_old(nodeNo, flag);
        result.setDataList(ruleInfoList, DsnRules.class);
        return result.msg();
    }

    private List<DsnRules> queryDsnRules_old(String nodeNo, String flag) {
        DsnRules rule = (DsnRules)DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)nodeNo).model();
        if (!"1".equals(flag)) {
            rule.where().addEq(DsnRules.STATUS, (Object)"1");
        }
        rule.setOrderBy(new Sort.Order[]{DsnRules.SCHEDULE_ORDER.asc()});
        List ruleInfoList = this.dao.findAll((AbsModel)rule);
        return ruleInfoList;
    }

    private void saveRules_old(List<DsnRulesAndConst> ruleList, String nodeNo) {
        if (ruleList == null || ruleList.isEmpty()) {
            return;
        }
        String userNo = ThreadLocalContext.get().getUser().getUserCode();
        this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)nodeNo).model());
        for (DsnRulesAndConst rule : ruleList) {
            rule.setRelateFk(nodeNo);
            if (StrUtils.isNull((Object)rule.getRuleId())) {
                rule.setRuleId(UUID.shortUUID());
            }
            this.saveRuleConst_old(rule);
            rule.checkValue();
            this.dao.save((AbsModel)rule);
        }
    }

    private void saveRuleConst_old(DsnRulesAndConst rule) {
        Map<String, Object> json2Map = rule.getConstMap();
        if (json2Map == null || json2Map.isEmpty()) {
            return;
        }
        this.dao.delete(DsnRulesConst.n().where().addEq(DsnRulesConst.RULE_ID, (Object)rule.getRuleId()).model());
        for (Map.Entry<String, Object> entry : json2Map.entrySet()) {
            if ("####".equals(entry.getKey())) {
                throw new BusinessException(new Message("\u5e38\u91cf\u89c4\u5219\u4fdd\u5b58\u5165\u53c2\u9519\u8bef"));
            }
            DsnRulesConst ruleConst = DsnRulesConst.n();
            ruleConst.setConstId(entry.getKey());
            ruleConst.setConstMapping(StrUtils.trimStr((Object)entry.getValue()));
            ruleConst.setRuleId(rule.getRuleId());
            this.dao.save((AbsModel)ruleConst);
        }
    }

    public ReturnMsg queryAllRulesInfoByNodeNo_old(String nodeNo) {
        Return result = new Return();
        if (StrUtils.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        DsnStructure nRuleNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code()).model());
        if (StrUtils.isNull((Object)nRuleNode)) {
            return result.msg();
        }
        List eventNodes = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nRuleNode.getNodeNo()).model());
        if (StrUtils.isNull((Object)eventNodes) || eventNodes.isEmpty()) {
            return result.msg();
        }
        String nodes = StrUtils.joinString((List)JsonUtils.json2List((String)JsonUtils.toJson((Object)eventNodes)), (String)"node_no");
        String sql = "select\n\tds.*,\n\tds2.node_name as event_type\nFROM\n\tdsn_structure ds\nleft join dsn_structure ds2 on\n\tds.up_node = ds2.node_no\nWHERE\n\tds.up_node IN ('" + nodes + "')";
        List rules = this.dao.findAll(sql, Boolean.valueOf(true), new AbsModelRepository.Args[0]);
        result.setDataList(rules);
        return result.msg();
    }

    private void storeValue4DsnDynamicData_old(String storedTab, String stored_field, String value, String currentNodeNo) throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer insertBuffer = new StringBuffer();
        StringBuffer updateBuffer = new StringBuffer();
        if (stored_field.toLowerCase().endsWith("_date")) {
            value = DateUtil.date2String((Date)DateUtil.string2Date((Object)value), (String)"yyyy-MM-dd HH:mm:ss");
            value = this.getFunctionStr2Date(value);
        }
        queryBuffer.append("select * from ").append(storedTab).append(" where serno = '").append(currentNodeNo).append("'");
        Ulog.info((String)("\t\u52a8\u6001\u67e5\u8be2\u6570\u636e\u7684sql===>" + queryBuffer.toString()));
        List queryResultList = this.dao.getJdbcTemplate().queryForList(queryBuffer.toString());
        if (null == queryResultList || queryResultList.isEmpty()) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            insertBuffer.append(" insert into ").append(storedTab).append(" (serno, ").append(" crt_date, mdf_date, crt_user, mdf_user, data_flag, ").append(stored_field).append(" ) values( '").append(currentNodeNo).append("', ").append(this.getFunctionStr2Date(date) + " , ").append(this.getFunctionStr2Date(date) + " , ").append(" 'login_user', 'login_user', '1', ").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(") ");
            Ulog.info((String)("\t\u52a8\u6001\u63d2\u5165\u6570\u636e\u7684sql===>" + insertBuffer.toString()));
            this.dao.getJdbcTemplate().execute(insertBuffer.toString());
        } else {
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            updateBuffer.append("update ").append(storedTab).append(" set ").append(stored_field).append("=").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where serno ='").append(currentNodeNo).append("'");
            Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        }
    }

    private void storeValue4SipProducts_old(String storedTab, String storedField, String value, String productUuid, String flag) throws Exception, BusinessException {
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer insertBuffer = new StringBuffer();
        StringBuffer updateBuffer = new StringBuffer();
        if (storedField.toLowerCase().endsWith("_date")) {
            try {
                value = DateUtil.date2String((Date)DateUtil.string2Date((Object)value), (String)"yyyy-MM-dd HH:mm:ss");
                value = this.getFunctionStr2Date(value);
            }
            catch (Exception e) {
                throw new BusinessException(new Message("9999", "\u4fdd\u5b58\u6570\u636e\u5e94\u4e3a\u65e5\u671f\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u65e0\u8bef\u540e\u4fdd\u5b58"));
            }
        }
        queryBuffer.append("select * from ").append(storedTab).append(" where product_uuid = '").append(productUuid).append("'");
        Ulog.info((String)("\t\u52a8\u6001\u67e5\u8be2\u6570\u636e\u7684sql===>" + queryBuffer.toString()));
        List queryResultList = this.dao.getJdbcTemplate().queryForList(queryBuffer.toString());
        if (null == queryResultList || queryResultList.isEmpty()) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            insertBuffer.append(" insert into ").append(storedTab).append(" (product_uuid, ").append(" crt_date, mdf_date, crt_user, mdf_user, data_flag, ").append(storedField).append(" ) values( '").append(productUuid).append("', ").append(this.getFunctionStr2Date(date) + ", ").append(this.getFunctionStr2Date(date) + ", ").append(" 'login_user', 'login_user', '1', ").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(") ");
            Ulog.info((String)("\t\u52a8\u6001\u63d2\u5165\u6570\u636e\u7684sql===>" + insertBuffer.toString()));
            this.dao.getJdbcTemplate().execute(insertBuffer.toString());
        } else if (null == flag || "".equalsIgnoreCase(flag)) {
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            updateBuffer.append("update ").append(storedTab).append(" set ").append(storedField).append("=").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
            Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        } else {
            Map map = (Map)queryResultList.get(0);
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            if ("product_name".equalsIgnoreCase(storedField) || "product_no".equalsIgnoreCase(storedField) || StrUtils.isNull(map.get(storedField))) {
                updateBuffer.append("update ").append(storedTab).append(" set ").append(storedField).append("=").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
                Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            } else {
                updateBuffer.append("update ").append(storedTab).append(" set ").append(" mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
                Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            }
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        }
    }

    private void modifyProductTreeRootName_old(String productName, String nodeNo) {
        DsnStructure dsnStructure4Query = new DsnStructure();
        dsnStructure4Query.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure4Query);
        if (null != dsnStructure4Result && !StrUtils.isNull((Object)dsnStructure4Result.getSerno())) {
            String nodeSeq = dsnStructure4Result.getNodeSeq();
            String[] nodeSeqArray = nodeSeq.split("\\.");
            DsnStructure dsnStructure4Update = new DsnStructure();
            dsnStructure4Update.setNodeName(productName);
            dsnStructure4Update.where().addEq(DsnStructure.NODE_NO, (Object)nodeSeqArray[0]);
            this.dao.update((AbsModel)dsnStructure4Update);
        }
    }
}

