/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.insure.service;

import com.newtouch.nms.sip.product.cache.service.IProductCacheService;
import com.newtouch.nms.sip.product.insure.service.IProductInsureService;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductInsureServiceImpl
implements IProductInsureService {
    @Autowired
    private IProductCacheService productCacheService;

    @Override
    public ReturnMsg getProductList(Map<String, Object> requestMap) {
        Object proMap;
        Return msg = new Return();
        User user = ThreadLocalContext.get().getUser();
        String organId = "1000000";
        String channelNo = "1";
        String deliveryPlatform = StrUtils.trimStr((Object)requestMap.get("delivery_platform"));
        ReturnMsg map = this.productCacheService.queryProductListCache(organId, channelNo, deliveryPlatform);
        List mapList = map.getDataList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String productNo = (String)requestMap.get("product_no");
        int nowPage = (Integer)requestMap.get("nowPage");
        int rows4Page = (Integer)requestMap.get("rows4Page");
        String productName = (String)requestMap.get("product_name");
        String riskCode = (String)requestMap.get("risk_code");
        if (!StrUtils.isNull((Object)riskCode)) {
            riskCode = riskCode.toUpperCase();
        }
        String shelfYear = (String)requestMap.get("shelf_year");
        String productSaleChannel = (String)requestMap.get("product_sale_channel");
        String shelfDateStart = (String)requestMap.get("shelf_date_start");
        String shelfDateEnd = (String)requestMap.get("shelf_date_end");
        Iterator iterable = mapList.iterator();
        while (iterable.hasNext()) {
            proMap = (Map)iterable.next();
            if (StrUtils.isNull(proMap.get("shelf_date"))) {
                iterable.remove();
                continue;
            }
            String proName = (String)proMap.get("product_name");
            if (!"Y".equals(proMap.get("isUniversal")) && !"Y".equals(proMap.get("isDividend")) && proName.indexOf("\u5e74\u91d1") < 0) {
                iterable.remove();
                continue;
            }
            String[] riskCodeArr = StrUtils.trimStr(proMap.get("riskCode")).split(",");
            if ("Y".equals(proMap.get("isUniversal")) && riskCodeArr.length == 1) {
                iterable.remove();
                continue;
            }
            if (!StrUtils.isNull((Object)productNo) && ((String)proMap.get("product_no")).indexOf(productNo) < 0) {
                iterable.remove();
                continue;
            }
            if (!StrUtils.isNull((Object)productName) && ((String)proMap.get("product_name")).indexOf(productName) < 0) {
                iterable.remove();
                continue;
            }
            if (!StrUtils.isNull((Object)riskCode) && ((String)proMap.get("riskCode")).indexOf(riskCode) < 0) {
                iterable.remove();
                continue;
            }
            if (!StrUtils.isNull((Object)shelfYear) && !((String)proMap.get("shelf_date")).substring(0, 4).equals(shelfYear)) {
                iterable.remove();
                continue;
            }
            if (StrUtils.isNull((Object)shelfDateStart) || StrUtils.isNull((Object)shelfDateEnd)) continue;
            try {
                Date startDate = sdf.parse(shelfDateStart);
                Date endDate = sdf.parse(shelfDateEnd);
                Date shelfDate = sdf.parse((String)proMap.get("shelf_date"));
                if (startDate.getTime() <= shelfDate.getTime() && endDate.getTime() >= shelfDate.getTime()) continue;
                iterable.remove();
            }
            catch (ParseException e) {
                map.setFailMessage(new Message("ErrorMsg", "\u65e5\u671f\u683c\u5f0f\u4e0d\u5339\u914d\uff0c\u67e5\u8be2\u5931\u8d25"));
                return map;
            }
        }
        if ("shelf_date".equals(requestMap.get("sort_mode"))) {
            proMap = mapList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Map<String, Object>>(new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    Date date1 = DateUtils.str2Timestamp((String)((String)o1.get("shelf_date")));
                    Date date2 = DateUtils.str2Timestamp((String)((String)o2.get("shelf_date")));
                    return DateUtils.compareDate((Date)date1, (Date)date2);
                }
            })), ArrayList::new));
        }
        if (mapList.size() > rows4Page) {
            List pageList;
            if (rows4Page * nowPage < mapList.size()) {
                pageList = mapList.subList((nowPage - 1) * rows4Page, rows4Page * nowPage);
                msg.setDataList(pageList);
            } else {
                pageList = mapList.subList((nowPage - 1) * rows4Page, mapList.size());
                msg.setDataList(pageList);
            }
        } else {
            msg.setDataList(mapList);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProductRiskList(Map<String, Object> param) {
        Return msg = new Return();
        String agent_code = StrUtils.trimStr((Object)param.get("agent_code"));
        String agent_cate = StrUtils.trimStr((Object)param.get("agent_cate"));
        String organ_id = StrUtils.trimStr((Object)param.get("organ_id"));
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        String sx_organ_id = StrUtils.trimStr((Object)param.get("sx_organ_id"));
        String sx_agent_cate = StrUtils.trimStr((Object)param.get("sx_agent_cate"));
        String agencyCode = StrUtils.trimStr((Object)param.get("agencyCode"));
        if (StrUtils.isNull((Object)organ_id) || StrUtils.isNull((Object)agent_cate)) {
            msg.setFailMsg("\u6e20\u9053\u6216\u8005\u673a\u6784id\u4e0d\u53ef\u4e3a\u7a7a");
            return msg.msg();
        }
        if (agent_code.startsWith("1") || agent_code.startsWith("2")) {
            agent_cate = agent_cate.equals("21900") ? "21900" : agent_code.substring(0, 1) + "_" + sx_agent_cate;
            if (!StrUtils.isNull((Object)sx_organ_id)) {
                organ_id = sx_organ_id;
            }
        } else if (agent_code.toUpperCase().startsWith("A")) {
            agent_cate = "A";
            organ_id = agencyCode;
        }
        String organId = organ_id;
        String channelNo = agent_cate;
        channelNo = "1";
        List<Map<String, Object>> proposeProductList = this.productCacheService.getProductListCache(organId, channelNo, deliveryPlatform);
        Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + JsonUtils.toJson(proposeProductList)));
        Iterator<Map<String, Object>> iterator = proposeProductList.iterator();
        while (iterator.hasNext()) {
            SimpleDateFormat df;
            String format;
            Map<String, Object> productMap = iterator.next();
            if ("E".equals(StrUtils.trimStr((Object)productMap.get("state")))) {
                iterator.remove();
            }
            if ((format = (df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(new Date())).compareTo(StrUtils.trimStr((Object)productMap.get("pol_start_date"))) > 0 && format.compareTo(StrUtils.trimStr((Object)productMap.get("pol_end_date"))) <= 0) continue;
            iterator.remove();
        }
        String sortMode = StrUtils.trimStr((Object)param.get("sort_mode"));
        List sortedList = null;
        switch (sortMode) {
            case "recommend": {
                sortedList = proposeProductList.stream().sorted(Comparator.comparing(map -> Integer.parseInt(map.get("sale_volume").toString()))).collect(Collectors.toList());
                if (sortedList.size() > 5) {
                    sortedList.subList(0, 5);
                }
                Set<String> set = proposeProductList.stream().collect(Collectors.groupingBy(p -> p.get("product_no").toString())).keySet();
                List listTemp = proposeProductList.stream().filter(p -> {
                    Date now = new Date();
                    Date shelfDate = DateUtils.str2Timestamp((String)p.get("shelf_date").toString());
                    Date endDate = DateUtils.addDate((Date)shelfDate, (DateUtils.DateType)DateUtils.DateType.DAY, (int)90);
                    return DateUtils.compareDate((Date)now, (Date)endDate) < 0;
                }).collect(Collectors.toList());
                for (Map p2 : listTemp) {
                    if (set.contains(p2.get("product_no").toString())) continue;
                    sortedList.add(p2);
                    set.add(p2.get("product_no").toString());
                }
                break;
            }
            case "salevolume": {
                break;
            }
            case "shelfdate": {
                sortedList = proposeProductList.stream().sorted(Comparator.comparing(map -> map.get("pol_start_date").toString(), (x, y) -> {
                    Date date1 = DateUtils.str2Timestamp((String)x, (String)"yyyy-MM-dd");
                    Date date2 = DateUtils.str2Timestamp((String)y, (String)"yyyy-MM-dd");
                    return DateUtils.compareDate((Date)date2, (Date)date1);
                })).collect(Collectors.toList());
                break;
            }
        }
        msg.setDataList(sortedList);
        return msg.msg();
    }
}

