/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.detail.service.impl;

import com.newtouch.nms.sip.design.data.service.StructureService;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.detail.service.IProductDetailsService;
import com.newtouch.nms.sip.product.risk.services.IRiskService;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.util.date.DateUtil;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.StrUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductDetailsServiceImpl
implements IProductDetailsService {
    @Autowired
    private IRiskService riskService;
    @Autowired
    private StructureService nodeService;
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg saveProductDetails(String currentNodeNo, Map<String, Object> productDetailMap) throws Exception {
        String flag = StrUtils.trimStr((Object)productDetailMap.get("flag"));
        Return rn = new Return();
        if (StrUtils.isNull((Object)currentNodeNo)) {
            throw new BusinessException("[\u4ea7\u54c1\u8be6\u60c5]\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        String product_uuid = StrUtils.trimStr((Object)productDetailMap.get("product_uuid"));
        if (StrUtils.isNull((Object)product_uuid)) {
            throw new BusinessException("[\u4ea7\u54c1\u7f16\u7801]\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)currentNodeNo);
        dsnStructure.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
        List dsnStructureList = this.dao.findAll((AbsModel)dsnStructure);
        for (DsnStructure tmpDsn : dsnStructureList) {
            Map<String, String> attrMap = this.getAttrInfo(tmpDsn);
            String storedTab = attrMap.get("stored_tab");
            String storedField = attrMap.get("stored_field");
            for (Map.Entry<String, Object> entry : productDetailMap.entrySet()) {
                String entryKey = entry.getKey();
                String entryValue = StrUtils.trimStr((Object)entry.getValue());
                if (!storedField.equals(entryKey)) continue;
                if ("Dsn_Dynamic_Data".equalsIgnoreCase(storedTab)) {
                    this.storeValue4DsnDynamicData(storedTab, storedField, entryValue, currentNodeNo);
                } else if ("Sip_Products".equalsIgnoreCase(storedTab)) {
                    try {
                        this.storeValue4SipProducts(storedTab, storedField, entryValue, product_uuid, flag);
                    }
                    catch (BusinessException e) {
                        if (e.getMessage().startsWith("9999")) {
                            rn.msg().setFailMessage(new Message("\u4fdd\u5b58\u6570\u636e\u5e94\u4e3a\u65e5\u671f\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u65e0\u8bef\u540e\u4fdd\u5b58"));
                        }
                        return rn.msg();
                    }
                }
                if (!"Sip_Products".equalsIgnoreCase(storedField) || !"product_name".equals(storedField)) continue;
                this.modifyProductTreeRootName(entryValue, currentNodeNo);
            }
        }
        this.riskService.saveMarkDown(currentNodeNo, productDetailMap);
        throw new BusinessException("122222222345678");
    }

    private void updateStructureName(String upNode, String nodeName) {
        DsnStructure struct = new DsnStructure();
        struct.setNodeName(nodeName);
        struct.where().addEq(DsnStructure.NODE_NO, (Object)upNode);
        this.dao.update((AbsModel)struct);
    }

    @Override
    public ReturnMsg getProductDetails(DsnStructure dsnStructure) {
        Return msg = new Return();
        String upNode = dsnStructure.getNodeNo();
        StringBuilder str1 = new StringBuilder();
        str1.append(" select up_node as product_uuid from dsn_structure WHERE node_no = ? ");
        AbsModelRepository.Args list1 = this.dao.args(new Object[0]);
        list1.args().add(upNode);
        List productUUIDList = this.dao.findAll(String.valueOf(str1), new AbsModelRepository.Args[]{list1});
        if (null != productUUIDList && !productUUIDList.isEmpty()) {
            Map attrValueMap = productUUIDList.isEmpty() ? null : (Map)productUUIDList.get(0);
            msg.setDataTable(attrValueMap);
        }
        StringBuilder queryAttr = new StringBuilder();
        queryAttr.append("select * from dsn_biz_attribute where biz_uuid in ( SELECT node_no from dsn_structure where up_node = ? ) order by display_order ");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(upNode);
        List attrList = this.dao.findAll(String.valueOf(queryAttr), new AbsModelRepository.Args[]{list});
        if (attrList.isEmpty()) {
            this.riskService.getFileInfo(attrList, upNode);
            msg.setDataList(attrList);
            return msg.msg();
        }
        attrList.forEach(tmpMap -> {
            Map attrValueMap;
            this.nodeService.bizAttributeFieldChange2((Map<String, Object>)tmpMap);
            DsnBizAttributeOption bizAttributeOption = new DsnBizAttributeOption();
            bizAttributeOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, tmpMap.get("biz_uuid"));
            List attrOptValueList = this.dao.findAll4Map((AbsModel)bizAttributeOption);
            if (!attrOptValueList.isEmpty()) {
                tmpMap.put("attrOptValueList", attrOptValueList);
            }
            String stored_tab = StrUtils.trimStr(tmpMap.get("stored_tab"));
            String stored_field = StrUtils.trimStr(tmpMap.get("stored_field"));
            AbsModelRepository.Args queryAttrList1 = this.dao.args(new Object[0]);
            StringBuilder queryAttrValueBuffer = new StringBuilder();
            if ("sip_products".equalsIgnoreCase(stored_tab)) {
                queryAttrValueBuffer.append(" SELECT     *   FROM    sip_products    WHERE   product_uuid in ( ").append("         SELECT ").append("             up_node ").append("         FROM    dsn_structure    WHERE    node_no = ?     ) ");
                queryAttrList1.args().add(StrUtils.trimStr(tmpMap.get("biz_uuid")));
            } else if ("dsn_dynamic_data".equalsIgnoreCase(stored_tab)) {
                queryAttrValueBuffer.append("SELECT * from dsn_dynamic_data where data_flag = ? and serno = ?");
                queryAttrList1.args().add("1");
                queryAttrList1.args().add(upNode);
            } else if ("sys_file_repostry".equalsIgnoreCase(stored_tab)) {
                queryAttrValueBuffer.append("SELECT * from sys_file_repostry where file_no = ?");
                queryAttrList1.args().add(upNode);
            } else if (!"dsn_dynamic_text_data".equalsIgnoreCase(stored_tab)) {
                throw new BusinessException("\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u5b58\u50a8\u8868\u662f[" + stored_tab + "]\u672a\u627e\u5230\u8be5\u5c5e\u6027\u6240\u914d\u7f6e\u7684\u5b58\u50a8\u8868\uff01\uff01\uff01");
            }
            List reslutList = this.dao.findAll(String.valueOf(queryAttrValueBuffer), new AbsModelRepository.Args[]{list});
            Map map = attrValueMap = reslutList.isEmpty() ? null : (Map)reslutList.get(0);
            if (null != attrValueMap && !attrValueMap.isEmpty()) {
                tmpMap.put("field_value", attrValueMap.get(stored_field));
            }
        });
        this.riskService.getFileInfo(attrList, upNode);
        msg.setDataList(attrList);
        return msg.msg();
    }

    private List<DsnBizAttribute> queryAllAttr(DsnStructure dsnNode) {
        String queryAttr = "SELECT * FROM dsn_biz_attribute  WHERE biz_uuid in        (SELECT node_no FROM dsn_structure WHERE up_node = ? )  ORDER BY display_order ";
        List allAttrList = this.dao.findAll(queryAttr, DsnBizAttribute.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{dsnNode.getNodeNo()})});
        this.initBizAttributeOptions(dsnNode, allAttrList);
        return allAttrList;
    }

    private Map<String, List<DsnBizAttribute>> groupbyAttr4Table(List<DsnBizAttribute> allAttrList) {
        Map<String, List<DsnBizAttribute>> attrGroup = allAttrList.stream().collect(Collectors.groupingBy(DsnBizAttribute::getStoredTab));
        return attrGroup;
    }

    private void setAttrValue(List<DsnBizAttribute> attrList, Object attrValueMap) {
        for (DsnBizAttribute bizAttr : attrList) {
            bizAttr.getOtherProperty().put("field_value", ClassUtils.getProperty((Object)attrValueMap, (String)bizAttr.getStoredField()));
        }
    }

    private void initBizAttributeOptions(DsnStructure dsnNode, List<DsnBizAttribute> allAttrList) {
        String queryAttrOptValue = " SELECT dbao.*    FROM dsn_biz_attribute dba, dsn_biz_attribute_option dbao   WHERE dba.biz_uuid = dbao.biz_uuid      AND dba.biz_uuid IN (SELECT node_no FROM dsn_structure WHERE up_node = ? )   ORDER BY dbao.option_order ";
        List attrOptValueList = this.dao.findAll(queryAttrOptValue, DsnBizAttributeOption.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{dsnNode.getNodeNo()})});
        Map<String, List<DsnBizAttributeOption>> optionGroup = attrOptValueList.stream().collect(Collectors.groupingBy(DsnBizAttributeOption::getBizUuid));
        for (DsnBizAttribute bizAttr : allAttrList) {
            if (optionGroup.get(bizAttr.getBizUuid()) == null) continue;
            bizAttr.putOtherProperty("attrOptValueList", optionGroup.get(bizAttr.getBizUuid()));
        }
    }

    private Map<String, String> getAttrInfo(DsnStructure tmpDsn) {
        String relate_tab = tmpDsn.getRelateTab();
        if (StrUtils.isNull((Object)relate_tab)) {
            return null;
        }
        String relateFk = tmpDsn.getRelateFk();
        String relate_field = tmpDsn.getRelateField();
        StringBuilder str = new StringBuilder();
        str.append(" select * from ").append(relate_tab).append(" where ").append(relate_field).append(" = ?");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(relateFk);
        List attrList = this.dao.findAll(String.valueOf(str), new AbsModelRepository.Args[]{list});
        if (null == attrList || attrList.isEmpty()) {
            return null;
        }
        String stored_tab = StrUtils.trimStr(((Map)attrList.get(0)).get("stored_tab"));
        String stored_field = StrUtils.trimStr(((Map)attrList.get(0)).get("stored_field"));
        if (StrUtils.isNull((Object)stored_tab) || StrUtils.isNull((Object)stored_field)) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("stored_tab", stored_tab);
        result.put("stored_field", stored_field);
        return result;
    }

    private void storeValue4DsnDynamicData(String storedTab, String stored_field, String value, String currentNodeNo) throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer insertBuffer = new StringBuffer();
        StringBuffer updateBuffer = new StringBuffer();
        if (stored_field.toLowerCase().endsWith("_date")) {
            value = DateUtil.date2String((Date)DateUtil.string2Date((Object)value), (String)"yyyy-MM-dd HH:mm:ss");
            value = this.getFunctionStr2Date(value);
        }
        queryBuffer.append("select * from ").append(storedTab).append(" where serno = '").append(currentNodeNo).append("'");
        Ulog.info((String)("\t\u52a8\u6001\u67e5\u8be2\u6570\u636e\u7684sql===>" + queryBuffer.toString()));
        List queryResultList = this.dao.getJdbcTemplate().queryForList(queryBuffer.toString());
        if (null == queryResultList || queryResultList.isEmpty()) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            insertBuffer.append(" insert into ").append(storedTab).append(" (serno, ").append(" crt_date, mdf_date, crt_user, mdf_user, data_flag, ").append(stored_field).append(" ) values( '").append(currentNodeNo).append("', ").append(this.getFunctionStr2Date(date) + " , ").append(this.getFunctionStr2Date(date) + " , ").append(" 'login_user', 'login_user', '1', ").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(") ");
            Ulog.info((String)("\t\u52a8\u6001\u63d2\u5165\u6570\u636e\u7684sql===>" + insertBuffer.toString()));
            this.dao.getJdbcTemplate().execute(insertBuffer.toString());
        } else {
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            updateBuffer.append("update ").append(storedTab).append(" set ").append(stored_field).append("=").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where serno ='").append(currentNodeNo).append("'");
            Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        }
    }

    private void storeValue4SipProducts(String storedTab, String storedField, String value, String productUuid, String flag) throws Exception, BusinessException {
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer insertBuffer = new StringBuffer();
        StringBuffer updateBuffer = new StringBuffer();
        if (storedField.toLowerCase().endsWith("_date")) {
            try {
                value = DateUtil.date2String((Date)DateUtil.string2Date((Object)value), (String)"yyyy-MM-dd HH:mm:ss");
                value = this.getFunctionStr2Date(value);
            }
            catch (Exception e) {
                throw new BusinessException(new Message("9999", "\u4fdd\u5b58\u6570\u636e\u5e94\u4e3a\u65e5\u671f\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u65e0\u8bef\u540e\u4fdd\u5b58"));
            }
        }
        queryBuffer.append("select * from ").append(storedTab).append(" where product_uuid = '").append(productUuid).append("'");
        Ulog.info((String)("\t\u52a8\u6001\u67e5\u8be2\u6570\u636e\u7684sql===>" + queryBuffer.toString()));
        List queryResultList = this.dao.getJdbcTemplate().queryForList(queryBuffer.toString());
        if (null == queryResultList || queryResultList.isEmpty()) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            insertBuffer.append(" insert into ").append(storedTab).append(" (product_uuid, ").append(" crt_date, mdf_date, crt_user, mdf_user, data_flag, ").append(storedField).append(" ) values( '").append(productUuid).append("', ").append(this.getFunctionStr2Date(date) + ", ").append(this.getFunctionStr2Date(date) + ", ").append(" 'login_user', 'login_user', '1', ").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(") ");
            Ulog.info((String)("\t\u52a8\u6001\u63d2\u5165\u6570\u636e\u7684sql===>" + insertBuffer.toString()));
            this.dao.getJdbcTemplate().execute(insertBuffer.toString());
        } else if (null == flag || "".equalsIgnoreCase(flag)) {
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            updateBuffer.append("update ").append(storedTab).append(" set ").append(storedField).append("=").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
            Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        } else {
            Map map = (Map)queryResultList.get(0);
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            if ("product_name".equalsIgnoreCase(storedField) || "product_no".equalsIgnoreCase(storedField) || StrUtils.isNull(map.get(storedField))) {
                updateBuffer.append("update ").append(storedTab).append(" set ").append(storedField).append("=").append(storedField.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
                Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            } else {
                updateBuffer.append("update ").append(storedTab).append(" set ").append(" mdf_date=").append(this.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(productUuid).append("'");
                Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            }
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        }
    }

    public String getFunctionStr2Date(String dateStr) {
        return "to_timestamp('" + dateStr + "', 'YYYY-MM-DD HH24:MI:SS') ";
    }

    private void modifyProductTreeRootName(String productName, String nodeNo) {
        DsnStructure dsnStructure4Query = new DsnStructure();
        dsnStructure4Query.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure4Query);
        if (null != dsnStructure4Result && !StrUtils.isNull((Object)dsnStructure4Result.getSerno())) {
            String nodeSeq = dsnStructure4Result.getNodeSeq();
            String[] nodeSeqArray = nodeSeq.split("\\.");
            DsnStructure dsnStructure4Update = new DsnStructure();
            dsnStructure4Update.setNodeName(productName);
            dsnStructure4Update.where().addEq(DsnStructure.NODE_NO, (Object)nodeSeqArray[0]);
            this.dao.update((AbsModel)dsnStructure4Update);
        }
    }
}

