/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.product.detail.services.impl;

import com.newtouch.nms.sip.design.product.detail.services.IDetailsService;
import com.newtouch.nms.sip.design.product.utils.NodeSeqUtils;
import com.newtouch.nms.sip.design.utils.ObjAttrConvertUtil;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.product.main.services.impl.ProductCopyServiceImpl;
import com.newtouch.nms.sys.model.SysFileRepostry;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class DetailsServiceImpl
implements IDetailsService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg saveProductDetails(DsnStructure node, Map<String, Object> paramMap) {
        String current_node_no = node.getNodeNo();
        Return rn = new Return();
        if (StrUtils.isNull((Object)current_node_no)) {
            rn.setFailMsg("[\u4ea7\u54c1\u8be6\u60c5]\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!rn.isSuccessflag()) {
            return rn.msg();
        }
        List<DsnBizAttribute> allAttrList = this.queryAllAttr(node);
        Map<String, List<DsnBizAttribute>> attrGroup = this.groupbyAttr4Table(allAttrList);
        String paramJson = JsonUtils.toJson(paramMap);
        block14: for (Map.Entry<String, List<DsnBizAttribute>> attrEntry : attrGroup.entrySet()) {
            switch (attrEntry.getKey().toLowerCase()) {
                case "sip_risks": {
                    SipRisks risk = (SipRisks)JsonUtils.json2Class((String)paramJson, SipRisks.class);
                    risk.setRiskUuid(current_node_no);
                    SipRisks risk2 = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)node.getNodeNo()).model());
                    risk.setTemplateProductUuid(risk2.getTemplateProductUuid());
                    this.dao.delete(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)node.getNodeNo()).model());
                    this.dao.save((AbsModel)risk);
                    ProductCopyServiceImpl.saveRiskRelation(node, this.dao);
                    this.updateStructureName(node.getUpNode(), risk.getRiskName());
                    if (StrUtils.isNull((Object)risk.getRiskNo()) || StrUtils.isNull((Object)risk2.getRiskNo()) || risk.getRiskNo().equals(risk2.getRiskNo())) continue block14;
                    this.updateRateDynamic(risk, risk2);
                    break;
                }
                case "sip_products": {
                    SipProducts product = (SipProducts)JsonUtils.json2Class((String)paramJson, SipProducts.class);
                    product.setProductUuid(NodeSeqUtils.getProductUuid(node.getNodeSeq()));
                    SipProducts productDb = (SipProducts)this.dao.findOne(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)node.getNodeNo()).model());
                    this.dao.delete(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)node.getNodeNo()).model());
                    product.setIsMaster(productDb.getIsMaster());
                    this.dao.save((AbsModel)product);
                    this.updateStructureName(node.getNodeSeq(), product.getProductName());
                    break;
                }
                case "dsn_dynamic_data": {
                    DsnDynamicData dynData = (DsnDynamicData)JsonUtils.json2Class((String)paramJson, DsnDynamicData.class);
                    dynData.setRelateTab(node.getRelateTab());
                    dynData.setRelateField(node.getRelateField());
                    dynData.setRelateFk(node.getNodeNo());
                    dynData.setSerno(node.getNodeNo());
                    this.dao.delete(DsnDynamicData.n().where().addEq(DsnDynamicData.SERNO, (Object)node.getNodeNo()).model());
                    this.dao.save((AbsModel)dynData);
                    break;
                }
                case "dsn_dynamic_text_data": {
                    break;
                }
                case "sys_file_repostry": {
                    SysFileRepostry sfr = SysFileRepostry.n();
                    for (DsnBizAttribute attr : attrEntry.getValue()) {
                        sfr.where().addEq(SysFileRepostry.FILE_NO, (Object)attr.getBizUuid());
                        SysFileRepostry file = (SysFileRepostry)this.dao.findOne((AbsModel)sfr);
                        attr.getOtherProperty().put("field_value", ClassUtils.getProperty((Object)file, (String)attr.getStoredField()));
                        attr.getOtherProperty().put("node_no", attr.getBizUuid());
                        attr.getOtherProperty().put("file_no_url", attr.getBizUuid());
                        attr.getOtherProperty().put("file_name", file.getFileName());
                    }
                    continue block14;
                }
                default: {
                    Ulog.error((String)("\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u5b58\u50a8\u8868\u662f[" + attrEntry.getKey() + "]\u672a\u627e\u5230\u8be5\u5c5e\u6027\u6240\u914d\u7f6e\u7684\u5b58\u50a8\u8868\uff01\uff01\uff01"));
                }
            }
        }
        return rn.msg();
    }

    private void updateRateDynamic(SipRisks risk, SipRisks risk2) {
        List dynamicDataList = this.dao.findAll(DsnDynamicData.n().where().addEq(DsnDynamicData.FIELD_5, (Object)risk2.getRiskNo()).model());
        for (DsnDynamicData data : dynamicDataList) {
            DsnStructure stru = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)data.getRelateFk()).model());
            String newRelateTab = stru.getRelateTab().replace(risk2.getRiskNo(), risk.getRiskNo());
            String sql = "ALTER TABLE " + stru.getRelateTab() + " RENAME TO " + newRelateTab + ";";
            try {
                this.dao.getJdbcTemplate().execute(sql);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
            stru.where().addEq(DsnStructure.NODE_NO, (Object)data.getRelateFk());
            stru.setRelateTab(newRelateTab);
            this.dao.update((AbsModel)stru);
            data.where().addEq(DsnDynamicData.SERNO, (Object)data.getSerno());
            data.setField5(risk.getRiskNo());
            this.dao.update((AbsModel)data);
        }
    }

    private void updateStructureName(String upNode, String nodeName) {
        DsnStructure struct = new DsnStructure();
        struct.setNodeName(nodeName);
        struct.where().addEq(DsnStructure.NODE_NO, (Object)upNode);
        this.dao.update((AbsModel)struct);
    }

    @Override
    public ReturnMsg queryDetailsInfo(DsnStructure dsnNode) {
        Return msg = new Return();
        List<DsnBizAttribute> allAttrList = this.queryAllAttr(dsnNode);
        if (allAttrList.isEmpty()) {
            return msg.msg();
        }
        Map<String, List<DsnBizAttribute>> attrGroup = this.groupbyAttr4Table(allAttrList);
        block14: for (Map.Entry<String, List<DsnBizAttribute>> attrEntry : attrGroup.entrySet()) {
            switch (attrEntry.getKey().toLowerCase()) {
                case "sip_risks": {
                    SipRisks attrValueMap = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)dsnNode.getNodeNo()).model());
                    this.setAttrValue(attrEntry.getValue(), attrValueMap);
                    break;
                }
                case "sip_products": {
                    SipProducts product = (SipProducts)this.dao.findOne(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)dsnNode.getNodeNo()).model());
                    this.setAttrValue(attrEntry.getValue(), product);
                    break;
                }
                case "dsn_dynamic_data": {
                    DsnDynamicData dynamicData = (DsnDynamicData)this.dao.findOne(DsnDynamicData.n().where().addEq(DsnDynamicData.RELATE_TAB, (Object)dsnNode.getRelateTab()).addEq(DsnDynamicData.RELATE_FIELD, (Object)dsnNode.getRelateField()).addEq(DsnDynamicData.RELATE_FK, (Object)dsnNode.getNodeNo()).model());
                    this.setAttrValue(attrEntry.getValue(), dynamicData);
                    break;
                }
                case "dsn_dynamic_text_data": {
                    break;
                }
                case "sys_file_repostry": {
                    SysFileRepostry sfr = SysFileRepostry.n();
                    for (DsnBizAttribute attr : attrEntry.getValue()) {
                        sfr.where().addEq(SysFileRepostry.FILE_NO, (Object)attr.getBizUuid());
                        SysFileRepostry file = (SysFileRepostry)this.dao.findOne((AbsModel)sfr);
                        attr.getOtherProperty().put("field_value", ClassUtils.getProperty((Object)file, (String)attr.getStoredField()));
                        attr.getOtherProperty().put("node_no", attr.getBizUuid());
                        attr.getOtherProperty().put("file_no_url", attr.getBizUuid());
                        attr.getOtherProperty().put("file_name", file.getFileName());
                    }
                    continue block14;
                }
                default: {
                    Ulog.error((String)("\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u5b58\u50a8\u8868\u662f[" + attrEntry.getKey() + "]\u672a\u627e\u5230\u8be5\u5c5e\u6027\u6240\u914d\u7f6e\u7684\u5b58\u50a8\u8868\uff01\uff01\uff01"));
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", allAttrList);
        DsnStructure dsnStructure = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)dsnNode.getNodeNo()).model());
        map.put("node_no", dsnStructure.getNodeNo());
        map.put("node_seq", dsnStructure.getNodeSeq());
        map.put("up_node", dsnStructure.getUpNode());
        msg.setDataTable(map);
        return msg.msg();
    }

    private List<DsnBizAttribute> queryAllAttr(DsnStructure dsnNode) {
        String queryAttr = "SELECT * FROM dsn_biz_attribute  WHERE biz_uuid in        (SELECT node_no FROM dsn_structure WHERE up_node = ? )  ORDER BY display_order ";
        List allAttrList = this.dao.findAll(queryAttr, DsnBizAttribute.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{dsnNode.getNodeNo()})});
        this.initBizAttributeOptions(dsnNode, allAttrList);
        return allAttrList;
    }

    private Map<String, List<DsnBizAttribute>> groupbyAttr4Table(List<DsnBizAttribute> allAttrList) {
        Map<String, List<DsnBizAttribute>> attrGroup = allAttrList.stream().collect(Collectors.groupingBy(DsnBizAttribute::getStoredTab));
        return attrGroup;
    }

    private void setAttrValue(List<DsnBizAttribute> attrList, Object attrValueMap) {
        for (DsnBizAttribute bizAttr : attrList) {
            String storedField = ObjAttrConvertUtil.fieldToProperty(bizAttr.getStoredField());
            bizAttr.getOtherProperty().put("field_value", ClassUtils.getProperty((Object)attrValueMap, (String)storedField));
        }
    }

    private void initBizAttributeOptions(DsnStructure dsnNode, List<DsnBizAttribute> allAttrList) {
        String queryAttrOptValue = " SELECT dbao.*    FROM dsn_biz_attribute dba, dsn_biz_attribute_option dbao   WHERE dba.biz_uuid = dbao.biz_uuid      AND dba.biz_uuid IN (SELECT node_no FROM dsn_structure WHERE up_node = ? )   ORDER BY dbao.option_order ";
        List attrOptValueList = this.dao.findAll(queryAttrOptValue, DsnBizAttributeOption.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{dsnNode.getNodeNo()})});
        Map<String, List<DsnBizAttributeOption>> optionGroup = attrOptValueList.stream().collect(Collectors.groupingBy(DsnBizAttributeOption::getBizUuid));
        for (DsnBizAttribute bizAttr : allAttrList) {
            if (optionGroup.get(bizAttr.getBizUuid()) == null) continue;
            bizAttr.putOtherProperty("attrOptValueList", optionGroup.get(bizAttr.getBizUuid()));
        }
    }
}

