/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.attribute.controller;

import com.newtouch.nms.sip.design.attribute.services.IAttributeService;
import com.newtouch.nms.sip.design.tree.services.IPublicTreeService;
import com.newtouch.nms.sip.model.DsnAttribute;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.rate.services.IRateService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestParam;
import com.uniapis.web.utils.RequestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AttrbuteController {
    @Autowired
    private IPublicTreeService pubTree;
    @Autowired
    private IAttributeService attrservice;
    @Autowired
    private IRateService rateService;

    @RequestMapping(value={"/queryDsnAttrByName.do"})
    public String doQueryDsnAttrByName(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String checked = param.get("checked");
        String upNode = param.get("up_node_select");
        String upName = param.get("up_name_select");
        String queryName = param.get("attr_name_query");
        String queryNo = param.get("attr_no_query");
        if ("0".equals(queryName)) {
            queryName = "";
        }
        ReturnMsg msg = this.attrservice.queryExistAttr(checked, upNode, upName, queryName, queryNo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/queryDsnAttrByRisk.do"})
    public String doQueryDsnAttrByRisk(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String nodeNo = param.get("node_no");
        ReturnMsg msg = this.attrservice.queryAttrList(nodeNo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/queryDsnAttrByRate.do"})
    public String queryDsnAttrByRate(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        Return r = new Return();
        ReturnMsg msg = this.pubTree.queryTree(param.get("node_no"));
        List structureList = msg.getDataList(DsnStructure.class);
        DsnStructure inputStructure = (DsnStructure)structureList.stream().filter(p -> NodeType.INPUT.code().equals(p.getNodeType())).collect(Collectors.toList()).get(0);
        DsnStructure outputStructure = (DsnStructure)structureList.stream().filter(p -> NodeType.OUTPUT.code().equals(p.getNodeType())).collect(Collectors.toList()).get(0);
        ReturnMsg intputMsg = this.attrservice.queryAttrList(inputStructure.getNodeNo());
        r.getDataTable().put("input", intputMsg.getDataList());
        r.getDataTable().put("input_structure", inputStructure);
        ReturnMsg outputMsg = this.attrservice.queryAttrList(outputStructure.getNodeNo());
        r.getDataTable().put("output", outputMsg.getDataList());
        r.getDataTable().put("output_structure", outputStructure);
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/doDsnSelectAttrAdd.do"})
    public String doDsnSelectAttrAdd(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String upNode = param.get("up_node_select");
        String rightSelect = param.get("rightSelect");
        ReturnMsg msg = this.attrservice.selectAttrToSave(rightSelect, upNode);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doDelAttrDetail.do"})
    public String doAttrDetailDel(HttpServletRequest request, HttpServletResponse response) {
        DsnStructure param = (DsnStructure)RequestUtils.getRequestMap((HttpServletRequest)request, DsnStructure.class);
        ReturnMsg msg = this.attrservice.bizAttrInfoDel(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doMultiDelAttrDetail.do"})
    public String doMultiDelAttrDetail(HttpServletRequest request, HttpServletResponse response) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        List structureList = JsonUtils.listMap2ListClass((List)((List)requestMap.get("structure_list")), DsnStructure.class);
        for (DsnStructure structure : structureList) {
            this.attrservice.bizAttrInfoDel(structure);
        }
        ReturnMsg msg = new Return().msg();
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doAttrOptionDel.do"})
    public String doAttrOptionDel(HttpServletRequest request, HttpServletResponse response) {
        String optionNo = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"option_no");
        ReturnMsg msg = this.attrservice.attrOptionInfoDel(optionNo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goValidateAttrNo.do"})
    public String validateAttrNo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String attrNo = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_no");
        ReturnMsg msg = this.attrservice.doValidateAttrNo(attrNo);
        if (msg.getDataList().size() > 0) {
            response.getWriter().write("false");
        } else {
            response.getWriter().write("true");
        }
        return null;
    }

    @RequestMapping(value={"/goValidateAttrName.do"})
    public String validateAttrName(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String nodeName = param.get("node_name");
        ReturnMsg msg = this.attrservice.doValidateAttrName(nodeName);
        if (msg.getDataList().size() > 0) {
            response.getWriter().write("false");
        } else {
            response.getWriter().write("true");
        }
        return null;
    }

    @RequestMapping(value={"/validateOptionName.do"})
    public String validateOptionName(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        if (StrUtils.isNull(param.get("attr_uuid")) || StrUtils.isNull(param.get("option_name"))) {
            response.getWriter().write("true");
        } else {
            ReturnMsg msg = this.attrservice.validateOptionName(param);
            if (msg.getDataList().size() > 0) {
                response.getWriter().write("false");
            } else {
                response.getWriter().write("true");
            }
        }
        return null;
    }

    @RequestMapping(value={"/validateOptionValue.do"})
    public String validateOptionValue(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        if (StrUtils.isNull(param.get("attr_uuid")) || StrUtils.isNull(param.get("option_value"))) {
            response.getWriter().write("true");
        } else {
            ReturnMsg msg = this.attrservice.validateOptionValue(param);
            if (msg.getDataList().size() > 0) {
                response.getWriter().write("false");
            } else {
                response.getWriter().write("true");
            }
        }
        return null;
    }

    @RequestMapping(value={"/validateOptionOrder.do"})
    public String validateOptionOrder(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        if (StrUtils.isNull(param.get("attr_uuid")) || StrUtils.isNull(param.get("option_order"))) {
            response.getWriter().write("true");
        } else {
            ReturnMsg msg = this.attrservice.validateOptionOrder(param);
            if (msg.getDataList().size() > 0) {
                response.getWriter().write("false");
            } else {
                response.getWriter().write("true");
            }
        }
        return null;
    }

    @RequestMapping(value={"/attr/goAttrbuteMdf.do"})
    public String goAttributAdd(HttpServletRequest request, HttpServletResponse response) {
        String nodeNo = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"node_no");
        ReturnMsg msg = this.attrservice.mdfAttributeInit(nodeNo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/attr/doAttrbuteMdf.do"})
    public String doAttrbuteMdf(HttpServletRequest request, HttpServletResponse response) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        RequestParam requestParam = RequestUtils.getRequestMap((Map)requestMap, (Class[])new Class[]{DsnStructure.class, DsnBizAttribute.class, DsnAttribute.class});
        DsnStructure structure = (DsnStructure)requestParam.getParam(0, DsnStructure.class);
        DsnBizAttribute attribute = (DsnBizAttribute)requestParam.getParam(1, DsnBizAttribute.class);
        DsnAttribute allattribute = (DsnAttribute)requestParam.getParam(2, DsnAttribute.class);
        List<Object> optionList = new ArrayList<DsnBizAttributeOption>();
        if (!StrUtils.isNull(requestMap.get("dsn_biz_attribute_option"))) {
            optionList = JsonUtils.listMap2ListClass((List)((List)requestMap.get("dsn_biz_attribute_option")), DsnBizAttributeOption.class);
        }
        ReturnMsg msg = this.attrservice.mdfAttribute(structure, attribute, allattribute, optionList);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/attr/doAttributeOptionQuery.do"})
    public String doAttributeOptionQuery(HttpServletRequest request, HttpServletResponse response) {
        String attr_uuid = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_uuid");
        ReturnMsg msg = this.attrservice.queryAttributeOption(attr_uuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/attr/doBizAttributeOptionQuery.do"})
    public String doBizAttributeOptionQuery(HttpServletRequest request, HttpServletResponse response) {
        String bizUuid = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"biz_uuid");
        ReturnMsg msg = this.attrservice.queryBizAttributeOption(bizUuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/queryAttrListByRuleNode.do"})
    public String queryAttrListByRuleNode(HttpServletRequest request) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String relateFk = StrUtils.trimStr(requestMap.get("relate_fk"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relate_fk", relateFk);
        String nodeNo = this.attrservice.getAttrNodeNo(map);
        ReturnMsg msg = this.attrservice.queryAttrList(nodeNo);
        List dataList = msg.getDataList();
        List collect = dataList.stream().map(opt -> {
            HashMap hashMap = new HashMap();
            hashMap.put("option_name", opt.get("attr_name"));
            hashMap.put("option_value", opt.get("attr_no"));
            hashMap.put("display_order", opt.get("display_order"));
            return hashMap;
        }).collect(Collectors.toList());
        Return r = new Return();
        r.setDataList(collect);
        r.getDataTable().put("option_type", "value");
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/queryOptionValueJson.do"})
    public String queryOptionValueJson(HttpServletRequest request) {
        Return r = new Return();
        r.getDataTable().put("option_type", "option");
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String relateFk = StrUtils.trimStr(requestMap.get("relate_fk"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relate_fk", relateFk);
        String nodeNo = this.attrservice.getAttrNodeNo(map);
        ReturnMsg attrList = this.attrservice.queryAttrList(nodeNo);
        List dataList = attrList.getDataList();
        List paramsList = JsonUtils.json2List((String)JsonUtils.toJson(requestMap.get("fact_paramsList")));
        map.putAll((Map)paramsList.stream().filter(p -> StrUtils.trimStr(p.get("param_code")).startsWith("key")).collect(Collectors.toList()).get(0));
        List collect = dataList.stream().filter(p -> StrUtils.trimStr(map.get("value")).replaceAll("'", "").equals(StrUtils.trimStr(p.get("attr_no")))).collect(Collectors.toList());
        if (collect == null || collect.isEmpty()) {
            return RequestUtils.return2Json((ReturnMsg)r.msg());
        }
        Map map1 = (Map)collect.get(0);
        ReturnMsg msg = this.attrservice.queryBizAttributeOption(StrUtils.trimStr(map1.get("node_no")));
        String json = JsonUtils.toJson(msg.getDataTable().get("dsn_biz_attribute_option"), (String[])new String[]{"serno", "crt_user", "crt_date", "biz_uuid", "data_flag", "is_mapping", "option_no", "rn"});
        r.setDataList(JsonUtils.json2List((String)json));
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/queryOptionValue.do"})
    public String queryOptionValue(HttpServletRequest request) {
        Return r = new Return();
        r.getDataTable().put("option_type", "value");
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String relateFk = StrUtils.trimStr(requestMap.get("relate_fk"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relate_fk", relateFk);
        String nodeNo = this.attrservice.getAttrNodeNo(map);
        ReturnMsg attrList = this.attrservice.queryAttrList(nodeNo);
        List dataList = attrList.getDataList();
        List paramsList = JsonUtils.json2List((String)JsonUtils.toJson(requestMap.get("fact_paramsList")));
        map.putAll((Map)paramsList.stream().filter(p -> StrUtils.trimStr(p.get("param_code")).startsWith("key")).collect(Collectors.toList()).get(0));
        List collect = dataList.stream().filter(p -> StrUtils.trimStr(map.get("value")).replaceAll("'", "").equals(StrUtils.trimStr(p.get("attr_no")))).collect(Collectors.toList());
        if (collect == null || collect.isEmpty()) {
            return RequestUtils.return2Json((ReturnMsg)r.msg());
        }
        Map map1 = (Map)collect.get(0);
        ReturnMsg msg = this.attrservice.queryBizAttributeOption(StrUtils.trimStr(map1.get("node_no")));
        r.setDataList(JsonUtils.json2List((String)JsonUtils.toJson(msg.getDataTable().get("dsn_biz_attribute_option"))));
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/queryRiskAttrByProductUuid.do"})
    public String queryRiskAttrByProductUuid(HttpServletRequest request) {
        String productUuid = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"product_uuid");
        ReturnMsg msg = this.attrservice.queryRiskAttrByProductUuid(productUuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

