/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.rms.user.servers.impl;

import com.newtouch.base.enums.RmsUserSourceEnum;
import com.uniapis.cache.CacheManager;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.callback.RowCallback;
import com.uniapis.rms.config.RmsConfig;
import com.uniapis.rms.constants.RmsEnum;
import com.uniapis.rms.login.servers.ILoginService;
import com.uniapis.rms.model.RmsGrantRoles;
import com.uniapis.rms.model.RmsPasswordHist;
import com.uniapis.rms.model.RmsResourcesAuth;
import com.uniapis.rms.model.RmsUser;
import com.uniapis.rms.model.RmsUserRoles;
import com.uniapis.rms.param.RmsLimitVo;
import com.uniapis.rms.user.servers.IUserService;
import com.uniapis.utils.CodecUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserServiceImpl
implements IUserService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private RmsConfig nacosConfig;
    @Autowired
    private ILoginService loginService;

    @Override
    public ReturnMsg addUser(RmsUser user) {
        user.setPkUuid(UUID.shortUUID());
        user.setUserState(RmsEnum.BusinessStatus.EFCTIV.getType());
        user.setUserSource(RmsUserSourceEnum.xt.getCode());
        Return msg = user.checkValue();
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        UserServiceImpl.setPassword(user);
        RmsUser oldUser = (RmsUser)this.dao.findOne(RmsUser.n().where().addEq(RmsUser.USER_ID, (Object)user.getUserId()).addEq(RmsUser.DATA_FLAG, (Object)"1").model());
        if (!StrUtils.isNull((Object)((Object)oldUser))) {
            return msg.setFailMsg("\u767b\u5f55\u7528\u6237\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u5176\u4ed6\u7684\u767b\u5f55\u7528\u6237\u540d").msg();
        }
        this.dao.save((AbsModel)user);
        this.dao.save((AbsModel)RmsPasswordHist.n().setPkUuid(user.getPkUuid()).setUserPwd(user.getUserPwd()));
        return msg.msg();
    }

    private boolean checkPassword(String password) {
        String pattern = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[$@$!#%*?&-])[A-Za-z\\d$@$!#%*?&-]{8,}";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(password);
        return m.matches();
    }

    @Override
    public ReturnMsg delUser(String pkUuid) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)pkUuid)) {
            msg.setFailMsg("\u7528\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pkUuid.equals(this.nacosConfig.getAdminAccount())) {
            msg.setFailMsg("\u6b64\u8d26\u53f7\u65e0\u6cd5\u5220\u9664");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        this.dao.delete((AbsModel)RmsUser.n(true).setPkUuid(pkUuid));
        this.dao.delete((AbsModel)RmsUserRoles.n((boolean)true).setPkUuid(pkUuid));
        this.dao.delete((AbsModel)RmsPasswordHist.n((boolean)true).setPkUuid(pkUuid));
        this.dao.delete((AbsModel)RmsGrantRoles.n((boolean)true).setPkUuid(pkUuid));
        this.dao.delete((AbsModel)RmsResourcesAuth.n((boolean)true).setRelateTab("rms_user").setRelateField("pk_uuid").setRelateFk(pkUuid));
        return msg.msg();
    }

    @Override
    public ReturnMsg delUserByIds(List<String> pkUuids) {
        String pkUuid;
        ReturnMsg result;
        Return msg = new Return();
        if (CollectionUtils.isEmpty(pkUuids)) {
            msg.setFailMsg("\u7528\u6237\u7f16\u53f7\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pkUuids.contains(this.nacosConfig.getAdminAccount())) {
            msg.setFailMsg("\u5220\u9664\u8d26\u53f7\u4e2d\u5305\u542b\u65e0\u6cd5\u5220\u9664\u7684\u7528\u6237");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        Iterator<String> var3 = pkUuids.iterator();
        do {
            if (var3.hasNext()) continue;
            return msg.msg();
        } while ((result = this.delUser(pkUuid = var3.next())).isSuccessflag());
        return result;
    }

    @Override
    public ReturnMsg queryUser(RmsUser user) {
        RmsLimitVo limitVo;
        RmsUser userQuery = RmsUser.n();
        userQuery.select(RmsUser.PK_UUID, RmsUser.USER_ID, RmsUser.USER_NAME, RmsUser.ORGAN_ID, RmsUser.ORGAN_NAME, RmsUser.USER_STATE, RmsUser.PATCH_MEMO, RmsUser.USER_SOURCE, RmsUser.MAIL);
        String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
        if (!this.nacosConfig.getAdminAccount().equals(ThreadLocalContext.get().getUser().getPkUuid()) && Objects.nonNull(limitVo = (RmsLimitVo)CacheManager.get((String)("USER_LIMIT_" + pkUuid))) && !CollectionUtils.isEmpty((Map)limitVo.getResourceLimitMap()) && !CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get("ORGAN")))) {
            List organIds = ((List)limitVo.getResourceLimitMap().get("ORGAN")).stream().map(o -> String.valueOf(o.get("data_id"))).collect(Collectors.toList());
            userQuery.where().addIn(RmsUser.ORGAN_ID, organIds);
        }
        if (!StrUtils.isNull((Object)user.getUserId())) {
            userQuery.where().addLike(RmsUser.USER_ID, (Object)user.getUserId());
        }
        if (!StrUtils.isNull((Object)user.getOrganId())) {
            userQuery.where().addEq(RmsUser.ORGAN_ID, (Object)user.getOrganId());
        }
        if (!StrUtils.isNull((Object)user.getUserName())) {
            userQuery.where().addLike(RmsUser.USER_NAME, (Object)user.getUserName());
        }
        userQuery.where().setCheckWhere(false);
        userQuery.setOrderBy(RmsUser.CRT_DATE.desc());
        userQuery.where().addCallback((RowCallback & Serializable)(row, data, index) -> {
            RmsUserRoles userCount = (RmsUserRoles)this.dao.findOne(((RmsUserRoles)RmsUserRoles.n((boolean)true).setPkUuid(row.getPkUuid()).groupBy().field(new Field[]{RmsUserRoles.PK_UUID})).groupBy().count(RmsUserRoles.ROLE_ID));
            if (Objects.nonNull(userCount)) {
                row.putOtherProperty("roles", userCount.getOtherProperty("count_role_id"));
            }
        });
        List users = this.dao.findAll((AbsModel)userQuery, Boolean.valueOf(true));
        Return msg = new Return();
        msg.setDataList(users, RmsUser.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfUser(RmsUser user) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)user.getPkUuid())) {
            msg.setFailMsg("\u7528\u6237\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        user.where().addEq(RmsUser.PK_UUID, (Object)user.getPkUuid());
        Set userChgClm = user.where().getChangeColumn();
        userChgClm.remove(RmsUser.PK_UUID);
        userChgClm.remove(RmsUser.USER_PWD);
        userChgClm.remove(RmsUser.USER_STATE);
        this.dao.update((AbsModel)user);
        CacheManager.remove((String)("USER_INFO_" + user.getPkUuid()));
        CacheManager.remove((String)("USER_LIMIT_" + user.getPkUuid()));
        return msg.msg();
    }

    @Override
    public ReturnMsg resetPassword(String pkUuid, String userPwd) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)pkUuid)) {
            msg.setFailMsg("\u7528\u6237\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)userPwd)) {
            msg.setFailMsg("\u7528\u6237\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        RmsUser updUser = RmsUser.n().setUserPwd(userPwd).setPkUuid(pkUuid);
        UserServiceImpl.setPassword(updUser);
        updUser.where().addEq(RmsUser.PK_UUID, (Object)pkUuid);
        this.dao.update((AbsModel)updUser);
        return msg.msg();
    }

    public static void setPassword(RmsUser user) {
        user.setUserPwd(CodecUtils.md5((String)(CodecUtils.md5((String)user.getUserPwd()) + user.getPkUuid())));
    }

    @Override
    public ReturnMsg mdfPassword(String pkUuid, String oldPwd, String newPwd) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)pkUuid)) {
            msg.setFailMsg("\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)oldPwd)) {
            msg.setFailMsg("\u539f\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)newPwd)) {
            msg.setFailMsg("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        RmsUser oldPwdUser = RmsUser.n(true).setUserPwd(oldPwd).setPkUuid(pkUuid);
        UserServiceImpl.setPassword(oldPwdUser);
        oldPwdUser = (RmsUser)this.dao.findOne((AbsModel)oldPwdUser);
        if (oldPwdUser == null) {
            msg.setFailMsg("\u539f\u5bc6\u7801\u9519\u8bef");
            return msg.msg();
        }
        RmsUser newPwdUser = RmsUser.n().setUserPwd(newPwd).setPkUuid(pkUuid);
        UserServiceImpl.setPassword(newPwdUser);
        newPwdUser.where().addEq(RmsUser.PK_UUID, (Object)pkUuid);
        this.dao.update((AbsModel)newPwdUser);
        return msg.msg();
    }

    @Override
    public ReturnMsg getUserInfo() {
        Return msg = new Return();
        String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
        RmsUser rmsUser = this.loginService.getUserInfoByUserId(pkUuid);
        RmsLimitVo limitVo = (RmsLimitVo)CacheManager.get((String)("USER_LIMIT_" + pkUuid));
        if (Objects.nonNull(limitVo)) {
            rmsUser.putOtherProperty("rolesList", limitVo.getRolesList());
        }
        return msg.setDataTable(new Object[]{rmsUser}).msg();
    }
}

