/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.structure.service.imp;

import com.newtouch.base.service.RuleUsedService;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.DsnStructureRules;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.structure.service.IStructureRulesService;
import com.newtouch.nms.sip.vo.DsnStructureRulesVo;
import com.newtouch.nms.sip.vo.SelectDSRulesVo;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureRulesServiceImpl
implements IStructureRulesService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private RuleUsedService ruleUsedService;

    @Override
    public ReturnMsg addSelectStructureRules(SelectDSRulesVo selectDSRulesVo) {
        String[] split;
        Return msg = new Return();
        String selectRuleList = selectDSRulesVo.getSelectRuleList();
        String attrNode = selectDSRulesVo.getAttrNode();
        if (StrUtils.isNull((Object)attrNode) || StrUtils.isNull((Object)selectRuleList)) {
            msg.setFailMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        DsnStructure dsnStructure = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)attrNode).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code()).model());
        if (dsnStructure == null) {
            msg.setFailMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        for (String ruleId : split = selectRuleList.split(",")) {
            DsnStructureRules dsnStructureRules = (DsnStructureRules)this.dao.findOne(DsnStructureRules.n().where().addEq(DsnStructureRules.RULE_ID, (Object)ruleId).addEq(DsnStructureRules.DATA_FLAG, (Object)"1").model());
            if (dsnStructureRules == null) {
                msg.setFailMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
                return msg.msg();
            }
            dsnStructureRules.setSerno(null);
            dsnStructureRules.setNodeNo(dsnStructure.getNodeNo());
            dsnStructureRules.setRuleId(UUID.uuid());
            dsnStructureRules.setIsQuote("Y");
            dsnStructureRules.setQuoteRuleId(ruleId);
            dsnStructureRules.setRuleBelongs(selectDSRulesVo.getRuleBelongs());
            dsnStructureRules.setRiskUuid(selectDSRulesVo.getRiskUuid());
            this.dao.save((AbsModel)dsnStructureRules);
        }
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addStructureRules(DsnStructureRulesVo dsnStructureRulesVo) {
        Return msg = new Return();
        String attrNode = dsnStructureRulesVo.getAttrNode();
        if (StrUtils.isNull((Object)attrNode)) {
            msg.setFailMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        DsnStructure dsnStructure = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)attrNode).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code()).model());
        if (dsnStructure == null) {
            msg.setFailMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        DsnStructureRules dsnStructureRules = new DsnStructureRules();
        BeanUtils.copyProperties((Object)dsnStructureRulesVo, (Object)dsnStructureRules);
        String ruleId = UUID.uuid();
        dsnStructureRules.setRuleId(ruleId);
        dsnStructureRules.setNodeNo(dsnStructure.getNodeNo());
        this.dao.save((AbsModel)dsnStructureRules);
        msg.getDataTable().put("dsnStructureRules", dsnStructureRules);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updateStructureRules(DsnStructureRulesVo dsnStructureRulesVo) {
        Return msg = new Return();
        String nodeNo = dsnStructureRulesVo.getNodeNo();
        String ruleId = dsnStructureRulesVo.getRuleId();
        if (StrUtils.isNull((Object)nodeNo) || StrUtils.isNull((Object)ruleId)) {
            msg.setFailMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        DsnStructureRules dsnStructureRules = (DsnStructureRules)this.dao.findOne(DsnStructureRules.n().where().addEq(DsnStructureRules.NODE_NO, (Object)nodeNo).addEq(DsnStructureRules.RULE_ID, (Object)ruleId).model());
        if (dsnStructureRules == null) {
            msg.setFailMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        BeanUtils.copyProperties((Object)dsnStructureRulesVo, (Object)dsnStructureRules);
        dsnStructureRules.where().addEq(DsnStructureRules.NODE_NO, (Object)nodeNo).addEq(DsnStructureRules.RULE_ID, (Object)ruleId);
        this.dao.update((AbsModel)dsnStructureRules);
        msg.getDataTable().put("dsnStructureRules", dsnStructureRules);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteStructureRules(String selectRuleList) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)selectRuleList)) {
            msg.setFailMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        String[] selectRuleListStr = selectRuleList.split(",");
        ArrayList<String> delId = new ArrayList<String>();
        for (String ruleId : selectRuleListStr) {
            DsnStructureRules dsnStructureRules = (DsnStructureRules)this.dao.findOne(DsnStructureRules.n().where().addEq(DsnStructureRules.RULE_ID, (Object)ruleId).model());
            if (dsnStructureRules == null) continue;
            String isQuote = dsnStructureRules.getIsQuote();
            if (!"Y".equals(isQuote)) {
                DsnStructureRules quoteStructureRules = (DsnStructureRules)this.dao.findOne(DsnStructureRules.n().where().addEq(DsnStructureRules.QUOTE_RULE_ID, (Object)ruleId).model());
                if (quoteStructureRules != null) {
                    msg.setFailMsg(new Message("8000001", "\u6240\u9009\u5220\u9664\u7684\u89c4\u5219\u5b58\u5728\u88ab\u5f15\u7528\u7684\u89c4\u5219\uff0c\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u540e\u518d\u8fdb\u884c\u5220\u9664\uff01"));
                    return msg.msg();
                }
                this.ruleUsedService.deleteRuleInfoByRuleId(ruleId);
            }
            delId.add(ruleId);
        }
        if (CollectionUtils.isNotEmpty(delId)) {
            this.dao.delete(DsnStructureRules.n().where().addIn(DsnStructureRules.RULE_ID, delId).model());
        }
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskNonReferencedRules(String riskUuid, String attrName, String ruleName) {
        Return msg = new Return();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT\nb.rule_id,\trisk.risk_name,\n\tdb.attr_name,\n\tb.rule_name,\n\tb.event_type,\n\tCASE\nWHEN b.event_type = ? THEN\n\t ? \nWHEN b.event_type = ?  THEN\n\t ? \nWHEN b.event_type = ? THEN\n\t ? \nWHEN b.event_type = ? THEN\n\t ? \nWHEN b.event_type = ? THEN\n\t ? \nWHEN b.event_type = ? THEN\n\t ? \nWHEN b.event_type = ?  THEN\n\t ? \nWHEN b.event_type = ?  THEN\n\t ? \nWHEN b.event_type = ?  THEN\n\t ? \nELSE\n\t ? \nEND AS event_type_name,\n dsn.node_name,\n b.organ_id,\n string_agg(\n\torg.company_name,','\n) AS merged_company_names,\n b.channel_no,\n string_agg(conf.enum_name,',') AS merged_channel_no,\n b.start_date,\n b.end_date,\n b.schedule_order,\n b. STATUS,\n b.use_scene,\n b.version_no,\n b.is_quote,\n b.quote_rule_id,\n b.event_object,\n b.up_attr,\n b.rule_belongs\nFROM\n\tdsn_structure_rules b\nJOIN sip_risks risk ON b.risk_uuid = risk.risk_uuid\nJOIN dsn_structure dsn ON b.node_no = dsn.node_no\nLEFT JOIN dsn_biz_attribute db ON db.biz_uuid = dsn.up_node\nLEFT JOIN ws_life_t_company_organ org ON position(org.organ_id in b.organ_id) > 0\nLEFT JOIN sys_enum_conf conf ON conf.up_enum = ? \nAND position(conf.enum_code in b.channel_no) > 0\nWHERE\n\tb.risk_uuid =  ? ");
        list.add("init_rule");
        list.add("\u521d\u59cb\u5316\u89c4\u5219");
        list.add("value_change_rule");
        list.add("\u503c\u6539\u53d8\u89c4\u5219");
        list.add("select_risk_rule");
        list.add("\u9669\u79cd\u9009\u62e9\u89c4\u5219");
        list.add("cancel_risk_rule");
        list.add("\u53d6\u6d88\u9009\u62e9\u89c4\u5219");
        list.add("add_prd_rule");
        list.add("\u6dfb\u52a0\u4ea7\u54c1\u89c4\u5219");
        list.add("del_prd_rule");
        list.add("\u5220\u9664\u4ea7\u54c1\u89c4\u5219");
        list.add("fee_rule");
        list.add("\u7b97\u8d39\u89c4\u5219");
        list.add("fee_finish_rule");
        list.add("\u4fdd\u8d39\u8ba1\u7b97\u540e\u89c4\u5219");
        list.add("next_rule");
        list.add("\u4e0b\u4e00\u6b65\u89c4\u5219");
        list.add("\u672a\u77e5");
        list.add("channel_type");
        list.add(riskUuid);
        if (!StrUtils.isNull((Object)ruleName)) {
            sql.append(" AND b.rule_name LIKE ? ");
            list.add("%" + ruleName + "%");
        }
        if (!StrUtils.isNull((Object)attrName)) {
            sql.append("AND db.attr_name LIKE ?");
            list.add("%" + attrName + "%");
        }
        sql.append("AND b.is_quote != ? \nGROUP BY\n\trisk.risk_name,\n\tdb.attr_name,\n\tb.rule_name,\n\tb.event_type,\n\tdsn.node_name,\n\tb.organ_id,\n\tb.channel_no,\n\tb.start_date,\n\tb.end_date,\n\tb.schedule_order,\n\tb.STATUS,\n\tb.use_scene,\n\tb.version_no,\n\tb.is_quote,\n\tb.quote_rule_id,\n\tb.event_object,\nb.up_attr,b.rule_id,b.rule_belongs ");
        list.add("Y");
        List result = this.dao.findAll(sql.toString(), Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(list)});
        msg.getDataTable().put("dsnStructureRules", result);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }
}

