/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.controller;

import com.newtouch.nms.sip.design.product.detail.services.IDetailsService;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.product.risk.services.IRiskListQueryService;
import com.newtouch.nms.sip.product.risk.services.IRiskService;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/riskQuery")
public class RiskListQueryController {
    @Autowired
    private IRiskService riskServiceImp;
    @Autowired
    private IRiskListQueryService riskListQueryServiceImp;
    @Autowired
    private IDetailsService detailsService;

    @RequestMapping(value={"/doQueryMainRiskUnderProduct.do"})
    public String doQueryMainRiskUnderProduct(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String risk = param.get("risk");
        String riskUuid = param.get("product_uuid");
        String isMainRisk = param.get("is_main_risk");
        ReturnMsg msg = this.riskListQueryServiceImp.queryMainRiskUnderProduct(risk, riskUuid, isMainRisk);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doRiskQuery.do"})
    public String doRiskQuery(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String risk = param.get("risk");
        String riskUuid = param.get("risk_uuid");
        String isMainRisk = param.get("is_main_risk");
        ReturnMsg msg = this.riskListQueryServiceImp.queryRisk(risk, riskUuid, isMainRisk);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doMainRiskQueryPage.do"})
    public String queryMainRiskPage(HttpServletRequest request, HttpServletResponse response) {
        RequestMap paramMap = RequestUtils.getRequest((HttpServletRequest)request);
        SipRisks risk = (SipRisks)RequestUtils.getRequestMap((Map)paramMap.getParam(), SipRisks.class);
        ReturnMsg msg = this.riskListQueryServiceImp.queryMainRiskPage(risk.getRiskName(), risk.getRiskNo(), risk.getIsMainRisk());
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doMainRiskQueryUnPage.do"})
    public String queryMainRiskUnPage(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String productUuid = param.get("product_uuid");
        ReturnMsg msg = this.riskListQueryServiceImp.queryMainRiskUnPage(productUuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doRiskQueryPage.do"})
    public String queryRiskPage(HttpServletRequest request, HttpServletResponse response) {
        RequestMap paramMap = RequestUtils.getRequest((HttpServletRequest)request);
        SipRisks risk = (SipRisks)RequestUtils.getRequestMap((Map)paramMap.getParam(), SipRisks.class);
        ReturnMsg msg = this.riskListQueryServiceImp.queryRiskPage(risk.getRiskName(), risk.getRiskNo(), risk.getIsMainRisk());
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

