/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.tree.services.impl;

import com.newtouch.nms.sip.design.tree.services.IPublicTreeService;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sys.model.SysTreeMenu;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class PublicTreeServiceImpl
implements IPublicTreeService {
    @Autowired
    private AbsModelRepository dao;
    private final List<String> FOLDER_NODETYPE_LIST = new ArrayList<String>();

    PublicTreeServiceImpl() {
        this.FOLDER_NODETYPE_LIST.add(NodeType.MAIN_RISKS.code());
        this.FOLDER_NODETYPE_LIST.add(NodeType.PRD_DETAIL.code());
        this.FOLDER_NODETYPE_LIST.add(NodeType.N_RISK.code());
        this.FOLDER_NODETYPE_LIST.add(NodeType.ACCY_RISKS.code());
        this.FOLDER_NODETYPE_LIST.add(NodeType.N_MAIN_EXEMPT.code());
        this.FOLDER_NODETYPE_LIST.add(NodeType.SUB_RISKS.code());
        this.FOLDER_NODETYPE_LIST.add(NodeType.N_PRD_GROUP.code());
    }

    @Override
    public ReturnMsg queryTree(String nodeNo) {
        List dsnList = this.dao.findAll((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        dsnList.addAll(this.getAllNextNode(nodeNo));
        Return msg = new Return();
        msg.setDataList(dsnList, DsnStructure.class);
        msg.getDataTable().put("prdUUID4NodeNo", nodeNo);
        return msg.msg();
    }

    @Override
    public ReturnMsg getMainRiskByProductUuid(String productUuid) {
        DsnStructure dsnStructure = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)productUuid).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        DsnStructure dsnStructure2 = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)dsnStructure.getUpNode()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.MAIN_RISKS.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        DsnStructure dsnStructure3 = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)dsnStructure2.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        Return msg = new Return();
        msg.getDataTable().put("main_risk", dsnStructure2);
        msg.getDataTable().put("n_risk_detail", dsnStructure3);
        return msg.msg();
    }

    @Override
    public ReturnMsg getAccyExemptByProductUuid(String productUuid) {
        DsnStructure dsnStructure = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)productUuid).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        List sourceNodeList = this.dao.findAll((AbsModel)((DsnStructure)DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)dsnStructure.getUpNode()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.EXEMPT.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.NODE_SEQ.desc()}));
        String nodeSeq = sourceNodeList.stream().map(DsnStructure::getNodeSeq).max(Comparator.comparing(String::length)).orElse(null);
        DsnStructure sourceNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_SEQ, (Object)nodeSeq).model());
        DsnStructure dsnStructure3 = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)sourceNode.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        Return msg = new Return();
        msg.getDataTable().put("exempt", sourceNode);
        msg.getDataTable().put("n_risk_detail", dsnStructure3);
        return msg.msg();
    }

    @Override
    public ReturnMsg getMainExemptByProductUuid(String productUuid) {
        DsnStructure dsnStructure = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)productUuid).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        List sourceNodeList = this.dao.findAll((AbsModel)((DsnStructure)DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)dsnStructure.getUpNode()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.EXEMPT.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.NODE_SEQ.desc()}));
        String nodeSeq = sourceNodeList.stream().map(DsnStructure::getNodeSeq).min(Comparator.comparing(String::length)).orElse(null);
        DsnStructure sourceNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_SEQ, (Object)nodeSeq).model());
        DsnStructure dsnStructure3 = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)sourceNode.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        Return msg = new Return();
        msg.getDataTable().put("exempt", sourceNode);
        msg.getDataTable().put("n_risk_detail", dsnStructure3);
        return msg.msg();
    }

    @Override
    public ReturnMsg getAccyRiskByProductUuid(String productUuid) {
        DsnStructure dsnStructure = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)productUuid).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        DsnStructure dsnStructure2 = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)dsnStructure.getUpNode()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.ACCY_RISKS.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        DsnStructure dsnStructure3 = (DsnStructure)this.dao.findOne((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)dsnStructure2.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        Return msg = new Return();
        msg.getDataTable().put("accy_risks", dsnStructure2);
        msg.getDataTable().put("n_risk_detail", dsnStructure3);
        return msg.msg();
    }

    private List<DsnStructure> getAllNextNode(String nodeNo) {
        List structureList = this.dao.findAll((AbsModel)((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nodeNo).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        if (structureList.isEmpty()) {
            return structureList;
        }
        ArrayList<DsnStructure> newStructureList = new ArrayList<DsnStructure>(structureList);
        for (DsnStructure structure : structureList) {
            String nodeType = structure.getNodeType();
            if (this.FOLDER_NODETYPE_LIST.contains(nodeType)) {
                structure.putOtherProperty("isParent", (Object)"true");
            }
            if (NodeType.RISK_ROOT_LIST.contains(nodeType)) continue;
            newStructureList.addAll(this.getAllNextNode(structure.getNodeNo()));
        }
        return newStructureList;
    }

    @Override
    public ReturnMsg queryRootMenu(DsnStructure node, SysTreeMenu menuInfo) {
        if (menuInfo == null || StrUtils.isNull((Object)menuInfo.getNodeType())) {
            return new Return().msg();
        }
        Return ret = new Return();
        ret.getDataTable().put("node_name", menuInfo.getMenuName() + "\u540d\u79f0");
        ret.getDataTable().put("node_no", node.getNodeNo());
        ret.getDataTable().put("node_type", menuInfo.getNodeType());
        ret.getDataTable().put("up_node", node.getNodeNo());
        ret.getDataTable().put("node_seq", node.getNodeSeq());
        return ret.msg();
    }

    @Override
    public ReturnMsg queryTreeMenu(String node_type, String userNo) {
        if (StrUtils.isNull((Object)node_type)) {
            return new Return().msg();
        }
        SysTreeMenu menu = new SysTreeMenu(true);
        menu.setUpMenu(node_type);
        menu.setMenuType("menu");
        menu.setOrderBy(new Sort.Order[]{SysTreeMenu.DISPLAY_ORDER.asc()});
        Return ret = new Return();
        List all = this.dao.findAll((AbsModel)menu, Boolean.valueOf(false));
        ret.setDataList(all, SysTreeMenu.class);
        return ret.msg();
    }

    @Override
    public ReturnMsg addTreeNode(DsnStructure node) {
        Return r = new Return();
        DsnStructure structure = new DsnStructure();
        String node_no = UUID.shortUUID();
        structure.setNodeNo(node_no);
        structure.setUpNode(node.getNodeNo());
        structure.setNodeType(node.getNodeType());
        structure.setNodeSeq(node.getNodeSeq() + node_no + ".");
        structure.setNodeName(node.getNodeName());
        DsnStructure maxOrder = new DsnStructure();
        maxOrder.where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo());
        maxOrder.groupBy().max(DsnStructure.DISPLAY_ORDER);
        maxOrder = (DsnStructure)this.dao.findOne((AbsModel)maxOrder);
        Object maxDisplayOrderObj = maxOrder.getOtherProperty("max_display_order", String.class);
        Integer maxDisplayOrder = Integer.parseInt(StrUtils.isNull((Object)maxDisplayOrderObj) ? "0" : maxDisplayOrderObj.toString());
        structure.setDisplayOrder(Integer.valueOf(maxDisplayOrder + 1));
        this.dao.save((AbsModel)structure);
        this.saveChildNode(structure);
        r.setDataTable(new Object[]{structure});
        return r.msg();
    }

    @Override
    public void saveChildNode(DsnStructure ds) {
        Return r = new Return();
        List<DsnStructure> nextNodeList = this.queryChildNode(ds.getNodeType(), ds.getNodeNo(), ds.getNodeSeq());
        if (nextNodeList.isEmpty()) {
            return;
        }
        this.dao.save(nextNodeList);
        for (DsnStructure dsNew : nextNodeList) {
            this.saveChildNode(dsNew);
        }
    }

    private List<DsnStructure> queryChildNode(String nodeType, String parentNodeNo, String parentNodeSeq) {
        if (StrUtils.isNull((Object)nodeType)) {
            return new ArrayList<DsnStructure>();
        }
        SysTreeMenu queryNode = new SysTreeMenu();
        queryNode.where().addEq(SysTreeMenu.UP_MENU, (Object)nodeType);
        queryNode.where().addEq(SysTreeMenu.MENU_TYPE, (Object)"node");
        queryNode.setOrderBy(new Sort.Order[]{SysTreeMenu.DISPLAY_ORDER.asc()});
        List<DsnStructure> nextNodeList = this.dao.findAll((AbsModel)queryNode, Boolean.valueOf(false)).stream().map(node -> {
            DsnStructure nextNode = new DsnStructure();
            String nodeNo = UUID.shortUUID();
            nextNode.setNodeNo(nodeNo);
            nextNode.setNodeName(node.getMenuName());
            nextNode.setNodeType(node.getNodeType());
            nextNode.setUpNode(parentNodeNo);
            nextNode.setDisplayOrder(node.getDisplayOrder());
            nextNode.setNodeSeq(parentNodeSeq + nodeNo + ".");
            return nextNode;
        }).collect(Collectors.toList());
        return nextNodeList;
    }

    @Override
    public ReturnMsg doChooseRequired(Map<String, Object> param) {
        String isRequired = StrUtils.trimStr((Object)param.get("is_required"));
        String node_no = StrUtils.trimStr((Object)param.get("node_no"));
        String up_node = StrUtils.trimStr((Object)param.get("up_node"));
        DsnStructure risk = new DsnStructure();
        risk.where().addEq(DsnStructure.UP_NODE, (Object)node_no);
        risk.where().addIn(DsnStructure.NODE_TYPE, new String[]{"n_accy_detail", "n_exempt_detail"});
        risk = (DsnStructure)this.dao.findOne((AbsModel)risk);
        String upNode = ((DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)up_node).model())).getUpNode();
        List dsn = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNode).addIn(DsnStructure.NODE_TYPE, new String[]{"n_risk_detail", "n_accy_detail"}).model());
        DsnStructure main = (DsnStructure)dsn.get(0);
        SipRiskRelation relation = new SipRiskRelation();
        relation.setMainRisk(StrUtils.trimStr((Object)DsnStructure.n().getNodeNo()));
        relation.setRiskUuid(risk.getNodeNo());
        relation.setIsRequired(isRequired);
        relation.setRelationType("n_accy_detail".equals(risk.getNodeType()) ? "ADDED" : "EXEMPT");
        this.dao.save((AbsModel)relation);
        return new Return().msg();
    }

    @Override
    public ReturnMsg doNodeDisplayOrderMdf(List<DsnStructure> structureList) {
        for (DsnStructure structure : structureList) {
            DsnStructure dsnStructure = DsnStructure.n();
            dsnStructure.setNodeNo(structure.getNodeNo());
            dsnStructure.setDisplayOrder(structure.getDisplayOrder());
            dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)dsnStructure.getNodeNo());
            this.dao.update((AbsModel)dsnStructure);
        }
        return new Return().msg();
    }
}

