/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.risk.MainRisk;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class MainRiskNode {
    private DsnStructure mainRiskNode;
    private List<MainRisk> mainRiskList;

    public MainRiskNode load(String upNode, String prdUuid) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.mainRiskNode = utils.queryStructure(upNode, NodeType.N_RISK.code());
        if (this.mainRiskNode != null) {
            List<DsnStructure> dsnMainRiskList = utils.queryStructures(this.mainRiskNode.getNodeNo());
            this.mainRiskList = new ArrayList<MainRisk>();
            for (DsnStructure mainRisk : dsnMainRiskList) {
                MainRisk risk = new MainRisk();
                risk.setProductUuid(prdUuid);
                risk.load(mainRisk);
                this.mainRiskList.add(risk);
            }
        }
        return this;
    }

    public void merge(MainRiskNode mainRiskNode) {
        this.mainRiskNode = ProductEqualsUtils.merge(this.mainRiskNode, mainRiskNode.getMainRiskNode());
        this.mainRiskList = ProductEqualsUtils.merge(this.mainRiskList, mainRiskNode.getMainRiskList(), MainRisk.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.mainRiskNode);
        }
        if (this.mainRiskList != null) {
            this.mainRiskList.forEach(m -> m.save());
        }
    }

    public TreeNode fetchTreeNode() {
        if (this.mainRiskNode == null) {
            return null;
        }
        TreeNode mainRiskNode = new TreeNode(CompareEnum.NodeType.MAIN_RISK.getTag() + this.mainRiskNode.getSerno(), CompareEnum.NodeType.MAIN_RISK.getLable());
        mainRiskNode.getChildren().add(new TreeNode(this.mainRiskNode.getSerno(), this.mainRiskNode, CompareEnum.NodeType.STRUCTURE));
        if (this.mainRiskList != null && this.mainRiskList.size() > 0) {
            TreeNode mainRiskList = new TreeNode(CompareEnum.NodeType.MAIN_RISK_ARRAY.getTag() + this.mainRiskNode.getSerno(), CompareEnum.NodeType.MAIN_RISK_ARRAY.getLable());
            mainRiskNode.getChildren().add(mainRiskList);
            for (MainRisk risk : this.mainRiskList) {
                mainRiskList.getChildren().add(risk.fetchTreeNode());
            }
        }
        return mainRiskNode;
    }

    public DsnStructure getMainRiskNode() {
        return this.mainRiskNode;
    }

    public void setMainRiskNode(DsnStructure mainRiskNode) {
        this.mainRiskNode = mainRiskNode;
    }

    public List<MainRisk> getMainRiskList() {
        return this.mainRiskList;
    }

    public void setMainRiskList(List<MainRisk> mainRiskList) {
        this.mainRiskList = mainRiskList;
    }
}

