/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.services.impl;

import com.newtouch.base.service.RuleUsedService;
import com.newtouch.nms.sip.design.data.service.StructureService;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipOrganProductInfo;
import com.newtouch.nms.sip.model.SipOrganProducts;
import com.newtouch.nms.sip.model.SipOrganRiskInfo;
import com.newtouch.nms.sip.model.SipOrganRiskRelation;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.config.service.IProductConfigService;
import com.newtouch.nms.sip.product.main.services.impl.ProductCopyServiceImpl;
import com.newtouch.nms.sip.product.risk.dao.IRiskDao;
import com.newtouch.nms.sip.product.risk.services.IRiskService;
import com.newtouch.nms.sip.product.structure.dao.IStructureDao;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.callback.RowCallback;
import com.uniapis.util.date.DateUtil;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RiskServiceImpl
implements IRiskService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private RuleUsedService ruleUsedService;
    @Autowired
    private IStructureDao structureDaoImpl;
    @Autowired
    private StructureService structureService;
    @Autowired
    private IProductConfigService configService;
    @Autowired
    @Lazy
    private IRiskDao riskDao;
    private final String allowSuffix = "png,gif,jpg,jpeg,bmp,tiff,txt,xml,pdf,zip,rar,doc,ppt,xls,docx,pptx,xlsx,html,htm,webp";
    private final long allowSize = 0x500000L;
    private final String FIELD_VALUE = "field_value";

    @Override
    public ReturnMsg queryMainRiskUnderProduct(String risk, String productUuid, String isMainRisk) {
        String sql = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid Not IN ( SELECT distinct sip_product_risks.risk_uuid FROM sip_product_risks WHERE sip_product_risks.product_uuid = ?) AND sip_risks.is_main_risk = ?  AND (  sip_risks.risk_no LIKE ? OR sip_risks.risk_name LIKE ?) AND sip_risks.data_flag = ?;";
        ArrayList<String> searchParam = new ArrayList<String>();
        searchParam.add(productUuid);
        searchParam.add(isMainRisk);
        searchParam.add("%" + risk + "%");
        searchParam.add("%" + risk + "%");
        searchParam.add("1");
        List riskList = this.dao.findAll(sql, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchParam)});
        Return msg = new Return();
        msg.setDataList4includes(riskList, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk", "risk_uuid"});
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRisk(String risk, String riskUuid, String isMainRisk) {
        String sql = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid Not IN ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ?AND ( sip_risks.risk_no LIKE ? OR sip_risks.risk_name LIKE ?)AND sip_risks.data_flag = ? ;";
        ArrayList<String> searchParam = new ArrayList<String>();
        searchParam.add(riskUuid);
        searchParam.add(isMainRisk);
        searchParam.add("%" + risk + "%");
        searchParam.add("%" + risk + "%");
        searchParam.add("1");
        List riskList = this.dao.findAll(sql, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchParam)});
        Return msg = new Return();
        msg.setDataList4includes(riskList, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk"});
        return msg.msg();
    }

    @Override
    public ReturnMsg queryMainRiskPage(String riskName, String riskNo, String isMainRisk, String row4Page, String nowPage) {
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)riskName)) {
            risk.where().addLike(SipRisks.RISK_NAME, (Object)riskName);
        }
        if (!StrUtils.isNull((Object)riskNo)) {
            risk.where().addLike(SipRisks.RISK_NO, (Object)riskNo);
        }
        if (!StrUtils.isNull((Object)isMainRisk)) {
            risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk);
        }
        risk.setOrderBy(new Sort.Order[]{SipRisks.MDF_DATE.desc()});
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        ThreadLocalContext.get().getPageCount().setNowPage(Integer.valueOf(nowPage));
        ThreadLocalContext.get().getPageCount().setRows4Page(Integer.valueOf(row4Page));
        ArrayList mainRiskList = new ArrayList();
        List riskMainList = this.dao.findAll((AbsModel)risk, Boolean.valueOf(true));
        riskMainList.stream().forEach(mainRisk -> {
            HashMap<String, Object> mapMain = new HashMap<String, Object>();
            mapMain.put("risk_no", mainRisk.getRiskNo());
            mapMain.put("risk_name", mainRisk.getRiskName());
            mapMain.put("is_main_risk", mainRisk.getIsMainRisk());
            mapMain.put("risk_uuid", mainRisk.getRiskUuid());
            String sqlSubRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchAddParam = new ArrayList<String>();
            searchAddParam.add(mainRisk.getRiskUuid());
            searchAddParam.add("A");
            searchAddParam.add("1");
            List riskSubList = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchAddParam)});
            ArrayList aRiskList = new ArrayList();
            riskSubList.stream().forEach(aRisk -> {
                HashMap<String, Object> mapAdd = new HashMap<String, Object>();
                mapAdd.put("risk_no", aRisk.getRiskNo());
                mapAdd.put("risk_name", aRisk.getRiskName());
                mapAdd.put("is_main_risk", aRisk.getIsMainRisk());
                mapAdd.put("risk_uuid", aRisk.getRiskUuid());
                String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
                ArrayList<String> searchExeParam = new ArrayList<String>();
                searchExeParam.add(mainRisk.getRiskUuid());
                searchExeParam.add("W");
                searchExeParam.add("1");
                List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExeParam)});
                ArrayList exemptsRiskList = new ArrayList();
                riskExemptsList.stream().forEach(exemptsRisk -> {
                    HashMap<String, String> mapExe = new HashMap<String, String>();
                    mapExe.put("risk_no", exemptsRisk.getRiskNo());
                    mapExe.put("risk_name", exemptsRisk.getRiskName());
                    mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                    mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                    exemptsRiskList.add(mapExe);
                });
                mapAdd.put("exempt_risk", exemptsRiskList);
                aRiskList.add(mapAdd);
            });
            mapMain.put("accy_risk", aRiskList);
            String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchExemptsParam = new ArrayList<String>();
            searchExemptsParam.add(mainRisk.getRiskUuid());
            searchExemptsParam.add("W");
            searchExemptsParam.add("1");
            List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExemptsParam)});
            ArrayList exemptsRiskList = new ArrayList();
            riskExemptsList.stream().forEach(exemptsRisk -> {
                HashMap<String, String> mapExe = new HashMap<String, String>();
                mapExe.put("risk_no", exemptsRisk.getRiskNo());
                mapExe.put("risk_name", exemptsRisk.getRiskName());
                mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                exemptsRiskList.add(mapExe);
            });
            mapMain.put("exempt_risk", exemptsRiskList);
            mainRiskList.add(mapMain);
        });
        Return msg = new Return();
        msg.setDataList(mainRiskList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryMainRiskUnPage(String riskName, String riskNo, String isMainRisk) {
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)riskName)) {
            risk.where().addLike(SipRisks.RISK_NAME, (Object)riskName);
        }
        if (!StrUtils.isNull((Object)riskNo)) {
            risk.where().addLike(SipRisks.RISK_NO, (Object)riskNo);
        }
        if (!StrUtils.isNull((Object)isMainRisk)) {
            risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk);
        }
        risk.setOrderBy(new Sort.Order[]{SipRisks.MDF_DATE.desc()});
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        ArrayList mainRiskList = new ArrayList();
        List riskMainList = this.dao.findAll((AbsModel)risk);
        riskMainList.stream().forEach(mainRisk -> {
            HashMap<String, Object> mapMain = new HashMap<String, Object>();
            mapMain.put("risk_no", mainRisk.getRiskNo());
            mapMain.put("risk_name", mainRisk.getRiskName());
            mapMain.put("is_main_risk", mainRisk.getIsMainRisk());
            mapMain.put("risk_uuid", mainRisk.getRiskUuid());
            String sqlSubRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchAddParam = new ArrayList<String>();
            searchAddParam.add(mainRisk.getRiskUuid());
            searchAddParam.add("A");
            searchAddParam.add("1");
            List riskSubList = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchAddParam)});
            ArrayList aRiskList = new ArrayList();
            riskSubList.stream().forEach(aRisk -> {
                HashMap<String, Object> mapAdd = new HashMap<String, Object>();
                mapAdd.put("risk_no", aRisk.getRiskNo());
                mapAdd.put("risk_name", aRisk.getRiskName());
                mapAdd.put("is_main_risk", aRisk.getIsMainRisk());
                mapAdd.put("risk_uuid", aRisk.getRiskUuid());
                String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
                ArrayList<String> searchExeParam = new ArrayList<String>();
                searchExeParam.add(mainRisk.getRiskUuid());
                searchExeParam.add("W");
                searchExeParam.add("1");
                List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExeParam)});
                ArrayList exemptsRiskList = new ArrayList();
                riskExemptsList.stream().forEach(exemptsRisk -> {
                    HashMap<String, String> mapExe = new HashMap<String, String>();
                    mapExe.put("risk_no", exemptsRisk.getRiskNo());
                    mapExe.put("risk_name", exemptsRisk.getRiskName());
                    mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                    mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                    exemptsRiskList.add(mapExe);
                });
                mapAdd.put("exempt_risk", exemptsRiskList);
                aRiskList.add(mapAdd);
            });
            mapMain.put("accy_risk", aRiskList);
            String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchExemptsParam = new ArrayList<String>();
            searchExemptsParam.add(mainRisk.getRiskUuid());
            searchExemptsParam.add("W");
            searchExemptsParam.add("1");
            List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExemptsParam)});
            ArrayList exemptsRiskList = new ArrayList();
            riskExemptsList.stream().forEach(exemptsRisk -> {
                HashMap<String, String> mapExe = new HashMap<String, String>();
                mapExe.put("risk_no", exemptsRisk.getRiskNo());
                mapExe.put("risk_name", exemptsRisk.getRiskName());
                mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                exemptsRiskList.add(mapExe);
            });
            mapMain.put("exempt_risk", exemptsRiskList);
            mainRiskList.add(mapMain);
        });
        Return msg = new Return();
        msg.setDataList(mainRiskList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskPage(String riskName, String riskNo, String isMainRisk, String row4Page, String nowPage) {
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)riskName)) {
            risk.where().addLike(SipRisks.RISK_NAME, (Object)riskName);
        }
        if (!StrUtils.isNull((Object)riskNo)) {
            risk.where().addLike(SipRisks.RISK_NO, (Object)riskNo);
        }
        if (!StrUtils.isNull((Object)isMainRisk)) {
            risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk);
        }
        risk.setOrderBy(new Sort.Order[]{SipRisks.MDF_DATE.desc()});
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        ThreadLocalContext.get().getPageCount().setNowPage(Integer.valueOf(nowPage));
        ThreadLocalContext.get().getPageCount().setRows4Page(Integer.valueOf(row4Page));
        List riskList2 = this.dao.findAll((AbsModel)risk, Boolean.valueOf(true));
        Return msg = new Return();
        msg.setDataList4includes(riskList2, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk"});
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRisk4Ajax(DsnStructure node, String riskName) {
        String isMainRisk = "M";
        switch (NodeType.valueOf((String)node.getNodeType().toUpperCase())) {
            case N_SUB_RISKS: {
                isMainRisk = "S";
                break;
            }
            case N_ACCY_RISKS: {
                isMainRisk = "A";
                break;
            }
            case N_EXEMPT: {
                isMainRisk = "W";
            }
        }
        List riskNameList = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model());
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk).model();
        riskNameList.forEach(dsn -> risk.where().addNotIn(SipRisks.RISK_NAME, new String[]{dsn.getNodeName()}));
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        List riskList2 = this.dao.findAll((AbsModel)risk);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leftSelect", riskList2);
        map.put("ajaxtype", "select");
        map.put("blankline", false);
        Return msg = new Return();
        msg.getDataList().add(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg addRisk(DsnStructure node, Map<String, Object> paramMap) {
        Return msg = new Return();
        List rightSelectList = (List)paramMap.get("rigthSelect");
        if (null == rightSelectList || rightSelectList.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u9669\u79cd\uff01");
            return msg.msg();
        }
        int countNum = Integer.parseInt(((DsnStructure)this.dao.findOne(((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model()).groupBy().count(DsnStructure.NODE_NO))).getOtherProperty("count_node_num").toString());
        for (Map tmpMap : rightSelectList) {
            String riskNodeNo = StrUtils.trimStr(tmpMap.get("rigthSelect"));
            DsnStructure riskDetailsNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskNodeNo).model());
            DsnStructure riskNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskDetailsNode.getUpNode()).model());
            riskNode.setSerno(UUID.shortUUID());
            riskNode.setNodeSeq(node.getNodeSeq() + riskNode.getNodeNo() + ".");
            riskNode.setUpNode(node.getNodeNo());
            riskNode.setDisplayOrder(Integer.valueOf(countNum++));
            this.dao.save((AbsModel)riskNode);
            ProductCopyServiceImpl.saveRiskRelation(riskDetailsNode, this.dao);
        }
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg.msg();
    }

    @Override
    public ReturnMsg doValidateProductName(String nodeType, String nodeName) {
        Return msg = new Return();
        msg.setDataList(this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeType).addEq(DsnStructure.NODE_NAME, (Object)nodeName).model()), DsnStructure.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg delRiskCacheByNo(String riskNos) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)riskNos)) {
            msg.setFailMsg("riskNo\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        String[] riskNo = riskNos.split(",");
        List<String> strings = Arrays.asList(riskNo);
        List wRisks = this.dao.findAll(SipRisks.n().where().addIn(SipRisks.RISK_NO, strings).model());
        List relations = this.dao.findAll(SipRiskRelation.n().where().addIn(SipRiskRelation.RISK_UUID, wRisks.stream().map(SipRisks::getRiskUuid).collect(Collectors.toList())).model());
        List mRisks = this.dao.findAll(SipRisks.n().where().addIn(SipRisks.RISK_UUID, relations.stream().map(SipRiskRelation::getMainRisk).collect(Collectors.toList())).model());
        mRisks.forEach(o -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("flag", "1");
            map.put("product_code", "PK" + o.getRiskNo());
            this.configService.deleteReids(map, "eTong");
        });
        return msg.setSuccessMsg("\u6210\u529f").msg();
    }

    @Override
    public ReturnMsg saveRiskInfo(Map<String, Object> paramMap, SipRisks sipRisks4Save) {
        this.preDeal(sipRisks4Save);
        Return checkMsg = sipRisks4Save.checkValue();
        if (!checkMsg.isSuccessflag()) {
            return checkMsg.msg();
        }
        String currentNodeNo = StrUtils.trimStr((Object)paramMap.get("current_node_no"));
        String productNodeNo = StrUtils.trimStr((Object)paramMap.get("product_node_no"));
        String bizUUUD4RiskType = StrUtils.trimStr((Object)paramMap.get("bizUUUD4RiskType"));
        this.exchangFileInfo(currentNodeNo, paramMap);
        String riskName = sipRisks4Save.getRiskName();
        this.renameRiskNode(riskName, currentNodeNo);
        String isMainRisk = sipRisks4Save.getIsMainRisk();
        if (StrUtils.isNull((Object)isMainRisk)) {
            checkMsg.setFailMsg("\u3010\u662f\u5426\u4e3b\u9669\u3011|\u4e3b\u9644\u9669\u7c7b\u578b\u5fc5\u987b\u8bbe\u7f6e\uff01");
            return checkMsg.msg();
        }
        if ("M".equals(isMainRisk)) {
            this.maintainProductAndRiskRelation(productNodeNo, currentNodeNo);
        } else if ("A".equals(isMainRisk)) {
            this.maintainSipRiskRelation(paramMap);
        }
        if (StrUtils.isNull((Object)paramMap.get("no_channel"))) {
            String string = StrUtils.trimStr((Object)paramMap.get("parent_risk_uuid"));
        }
        this.dealdsn_dynamic_data(paramMap, currentNodeNo);
        sipRisks4Save.where().addEq(SipRisks.RISK_UUID, (Object)sipRisks4Save.getRiskUuid());
        SipRisks sipRisks = new SipRisks();
        sipRisks.where().addEq(SipRisks.RISK_UUID, (Object)sipRisks4Save.getRiskUuid());
        sipRisks.where().addBetween("ggggg", SipRisks.CRT_DATE, SipRisks.MDF_DATE);
        SipRisks old = (SipRisks)this.dao.findOne((AbsModel)sipRisks);
        if (StrUtils.isNull((Object)old.getSerno())) {
            this.dao.save((AbsModel)sipRisks4Save);
        } else {
            this.dao.update((AbsModel)sipRisks4Save);
        }
        return new Return().msg();
    }

    private void preDeal(SipRisks sipRisks4Save) {
        String endDate;
        String startDate;
        String riskName;
        String isMainRisk;
        String riskNo;
        String policyId = StrUtils.trimStr((Object)sipRisks4Save.getPolicyId());
        if (StrUtils.isNull((Object)policyId)) {
            sipRisks4Save.setPolicyId("\u672a\u77e5");
        }
        if (StrUtils.isNull((Object)(riskNo = StrUtils.trimStr((Object)sipRisks4Save.getRiskNo())))) {
            // empty if block
        }
        if (StrUtils.isNull((Object)(isMainRisk = StrUtils.trimStr((Object)sipRisks4Save.getIsMainRisk())))) {
            sipRisks4Save.setIsMainRisk("M");
        }
        if (StrUtils.isNull((Object)(riskName = StrUtils.trimStr((Object)sipRisks4Save.getRiskName())))) {
            // empty if block
        }
        if (StrUtils.isNull((Object)(startDate = StrUtils.trimStr((Object)sipRisks4Save.getStartDate())))) {
            sipRisks4Save.setStartDate(new java.util.Date());
        }
        if (StrUtils.isNull((Object)(endDate = StrUtils.trimStr((Object)sipRisks4Save.getEndDate())))) {
            sipRisks4Save.setEndDate(new java.util.Date());
        }
    }

    public void exchangFileInfo(String currentNodeNo, Map<String, Object> request) {
        DsnStructure dsnstructure = new DsnStructure();
        dsnstructure.setNodeNo(currentNodeNo);
        ReturnMsg returnMsg = this.queryRiskInfo(dsnstructure);
        if (returnMsg.isSuccessflag()) {
            List list_map = returnMsg.getDataList();
            list_map.parallelStream().forEach(param -> {
                if (param.get("ui_type").equals("file")) {
                    String tableParam = (String)param.get("attr_no");
                    String downLoadfileKey = (String)param.get("downLoadfileKey");
                    request.put(tableParam, downLoadfileKey);
                }
            });
        }
    }

    @Override
    public void saveMarkDown(String currentNodeNo, Map<String, Object> productDetailMap) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select attr.stored_field,attr.ui_type,attr.biz_uuid from dsn_biz_attribute attr , dsn_structure str").append(" where attr.biz_uuid = str.node_no and up_node = ? and attr.ui_type = ? ").append("order by attr.display_order ");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(currentNodeNo);
        list.args().add("markdown");
        List attrList = this.dao.findAll(String.valueOf(querySql), new AbsModelRepository.Args[]{list});
        HashMap<String, Map> uiTypeAttrMap = new HashMap<String, Map>();
        for (Map map : attrList) {
            uiTypeAttrMap.put((String)map.get("biz_uuid"), map);
        }
    }

    @Override
    public ReturnMsg queryRiskDetail(Map<String, Object> param) {
        Return msg = new Return();
        String productUuid = (String)param.get("product_uuid");
        String organIds = (String)param.get("organ_id");
        String[] organIdList = organIds.split("#");
        String organId = organIdList[0];
        String deliveryPlatform = (String)param.get("delivery_platform");
        String channelNo = (String)param.get("channel_no");
        List riskConfiguration = (List)param.get("risk_configuration");
        Map mainRiskMap = riskConfiguration.stream().collect(Collectors.toMap(p -> StrUtils.trimStr(p.get("risk_uuid")), Function.identity()));
        String addBatch = "";
        if (param.containsKey("add_batch")) {
            addBatch = (String)param.get("add_batch");
        }
        List<Map<String, Object>> mainRiskList = this.structureDaoImpl.queryMainRiskByProductUuid(productUuid);
        ArrayList mainRiskDetailList = new ArrayList();
        String finalAddBatch = addBatch;
        mainRiskList.forEach(map2 -> {
            HashMap<String, List<Map<String, Object>>> riskDetailMap = new HashMap<String, List<Map<String, Object>>>();
            String nodeNo = (String)map2.get("node_no");
            DsnStructure mainRiskStru = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
            if (!mainRiskMap.containsKey(mainRiskStru.getNodeNo())) {
                return;
            }
            List<Map<String, Object>> mainRiskDetail = this.queryRiskDetailByLevel(productUuid, organId, channelNo, nodeNo, NodeType.N_RISK_DETAIL.code(), deliveryPlatform, finalAddBatch);
            List<Map<String, Object>> mainRiskAttrDetail = this.queryRiskAttrByLevel(productUuid, organId, channelNo, nodeNo, deliveryPlatform, finalAddBatch);
            riskDetailMap.put("mainRiskDetail", mainRiskDetail);
            riskDetailMap.put("mainRiskAttrDetail", mainRiskAttrDetail);
            SipRisks mainRisk = this.getRiskInfo(nodeNo);
            riskDetailMap.put("riskInfo", (List<Map<String, Object>>)mainRisk);
            Map mainRiskObj = (Map)mainRiskMap.get(mainRisk.getRiskUuid());
            List addedList = (List)mainRiskObj.get("added");
            Map<Object, Object> addRiskMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)addedList)) {
                addRiskMap = addedList.stream().collect(Collectors.toMap(p -> StrUtils.trimStr(p.get("risk_uuid")), Function.identity()));
            }
            ArrayList accyRiskDetailList = new ArrayList();
            List<DsnStructure> accyDsnStructureList = this.structureDaoImpl.queryAccyRiskByMainRiskUuid(nodeNo);
            Map<Object, Object> finalAddRiskMap = addRiskMap;
            accyDsnStructureList.forEach(accy -> {
                HashMap<String, List<Map<String, Object>>> accyDetailMap = new HashMap<String, List<Map<String, Object>>>();
                String accyNodeNo = accy.getNodeNo();
                DsnStructure accyRiskStru = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)accyNodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
                if (!finalAddRiskMap.containsKey(accyRiskStru.getNodeNo())) {
                    return;
                }
                List<Map<String, Object>> accyRiskDetail = this.queryRiskDetailByLevel(productUuid, organId, channelNo, accyNodeNo, NodeType.N_RISK_DETAIL.code(), deliveryPlatform, finalAddBatch);
                accyDetailMap.put("accyRiskDetail", accyRiskDetail);
                List<Map<String, Object>> accyRiskAttrDetail = this.queryRiskAttrByLevel(productUuid, organId, channelNo, accyNodeNo, deliveryPlatform, finalAddBatch);
                accyDetailMap.put("accyRiskAttrDetail", accyRiskAttrDetail);
                SipRisks accyRisk = this.getRiskInfo(accyNodeNo);
                accyDetailMap.put("riskInfo", (List<Map<String, Object>>)accyRisk);
                Map accyRiskObj = (Map)finalAddRiskMap.get(accyRisk.getRiskUuid());
                List exemptList = (List)accyRiskObj.get("exempt");
                Map<Object, Object> exemptRiskMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)exemptList)) {
                    exemptRiskMap = exemptList.stream().collect(Collectors.toMap(p -> StrUtils.trimStr(p.get("risk_uuid")), Function.identity()));
                }
                ArrayList exemptRiskDetailList = new ArrayList();
                List<DsnStructure> exemptDsnStructureList = this.structureDaoImpl.queryExemptRiskByAccRiskUuid(accyNodeNo);
                Map<Object, Object> finalExemptRiskMap = exemptRiskMap;
                exemptDsnStructureList.forEach(exempt -> {
                    HashMap<String, List<Map<String, Object>>> exemptDetailMap = new HashMap<String, List<Map<String, Object>>>();
                    String exemptNodeNo = exempt.getNodeNo();
                    DsnStructure exemptRiskStru = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)exemptNodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
                    if (!finalExemptRiskMap.containsKey(exemptRiskStru.getNodeNo())) {
                        return;
                    }
                    List<Map<String, Object>> exemptRiskDetail = this.queryRiskDetailByLevel(productUuid, organId, channelNo, exemptNodeNo, NodeType.N_RISK_DETAIL.code(), deliveryPlatform, finalAddBatch);
                    exemptDetailMap.put("exemptRiskDetail", exemptRiskDetail);
                    List<Map<String, Object>> exemptRiskAttrDetail = this.queryRiskAttrByLevel(productUuid, organId, channelNo, exemptNodeNo, deliveryPlatform, finalAddBatch);
                    exemptDetailMap.put("exemptRiskAttrDetail", exemptRiskAttrDetail);
                    SipRisks exemptRisk = this.getRiskInfo(exemptNodeNo);
                    exemptDetailMap.put("riskInfo", (List<Map<String, Object>>)exemptRisk);
                    exemptRiskDetailList.add(exemptDetailMap);
                });
                accyDetailMap.put("exemptRisk", exemptRiskDetailList);
                accyRiskDetailList.add(accyDetailMap);
            });
            riskDetailMap.put("accyRisk", accyRiskDetailList);
            List exemptList = (List)mainRiskObj.get("exempt");
            Map<Object, Object> exemptRiskMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)exemptList)) {
                exemptRiskMap = exemptList.stream().collect(Collectors.toMap(p -> StrUtils.trimStr(p.get("risk_uuid")), Function.identity()));
            }
            ArrayList exemptRiskDetailList = new ArrayList();
            List<DsnStructure> exemptDsnStructureList = this.structureDaoImpl.queryExemptRiskByMainRiskUuid(nodeNo);
            Map<Object, Object> finalExemptRiskMap = exemptRiskMap;
            exemptDsnStructureList.forEach(exempt -> {
                HashMap<String, List<Map<String, Object>>> exemptDetailMap = new HashMap<String, List<Map<String, Object>>>();
                String exemptNodeNo = exempt.getNodeNo();
                DsnStructure exemptRiskStru = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)exemptNodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
                if (!finalExemptRiskMap.containsKey(exemptRiskStru.getNodeNo())) {
                    return;
                }
                List<Map<String, Object>> exemptRiskDetail = this.queryRiskDetailByLevel(productUuid, organId, channelNo, exemptNodeNo, NodeType.N_RISK_DETAIL.code(), deliveryPlatform, finalAddBatch);
                exemptDetailMap.put("exemptRiskDetail", exemptRiskDetail);
                List<Map<String, Object>> exemptRiskAttrDetail = this.queryRiskAttrByLevel(productUuid, organId, channelNo, exemptNodeNo, deliveryPlatform, finalAddBatch);
                exemptDetailMap.put("exemptRiskAttrDetail", exemptRiskAttrDetail);
                SipRisks exemptRisk = this.getRiskInfo(exemptNodeNo);
                exemptDetailMap.put("riskInfo", (List<Map<String, Object>>)exemptRisk);
                exemptRiskDetailList.add(exemptDetailMap);
            });
            riskDetailMap.put("exemptRisk", exemptRiskDetailList);
            mainRiskDetailList.add(riskDetailMap);
        });
        msg.getDataTable().put("riskDetail", mainRiskDetailList);
        return msg.msg();
    }

    private SipRisks getRiskInfo(String upNodeNo) {
        SipRisks sipRisk = null;
        DsnStructure nExemptRiskDetail = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
        if (nExemptRiskDetail != null) {
            sipRisk = (SipRisks)this.dao.findOne(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)nExemptRiskDetail.getNodeNo()).model());
        }
        return sipRisk;
    }

    private List<Map<String, Object>> queryExemptRisk(Map<String, Object> param, Map<String, Object> product) {
        ArrayList<Map<String, Object>> exemptList = new ArrayList<Map<String, Object>>();
        DsnStructure dsnStruct = new DsnStructure();
        String riskUuid = (String)param.get("risk_uuid");
        String source = (String)param.get("source");
        String organRiskUuid = (String)param.get("organ_prd_uuid");
        String productUuid = (String)param.get("product_uuid");
        String organId = (String)param.get("organ_id");
        String channelNo = (String)param.get("channel_no");
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)riskUuid);
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_EXEMPT.code());
        DsnStructure exemptRisk = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
        if (exemptRisk == null) {
            return exemptList;
        }
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)exemptRisk.getNodeNo());
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.EXEMPT.code());
        List exemptInfo = this.dao.findAll((AbsModel)dsnStruct);
        for (DsnStructure exempt : exemptInfo) {
            HashMap<String, Object> exemptResult = new HashMap<String, Object>();
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("organ_prd_uuid", organRiskUuid);
            String mainRisk = this.queryRiskInfoRoot(riskUuid, NodeType.N_RISK_DETAIL.code());
            String riskId = this.queryRiskInfoRoot(exempt.getNodeNo(), NodeType.N_RISK_DETAIL.code());
            request.put("main_risk", mainRisk);
            request.put("risk_uuid", riskId);
            SipOrganRiskRelation queryRiskReational = this.queryRiskReational(request);
            if (queryRiskReational == null || StrUtils.isNull((Object)queryRiskReational.getRiskUuid())) continue;
            SipRiskRelation companyReational = this.queryReational(request);
            exemptResult.put("riskRelation", queryRiskReational);
            exemptResult.put("companyRelation", companyReational);
            List<Map<String, Object>> exemptRiskDetail = this.riskDao.queryRiskDetail(param, exempt.getNodeNo(), NodeType.MAIN_EXEMPT.code());
            Map<String, Object> fieldValueApp = this.riskDao.getFieldValueApp(exemptRiskDetail);
            if (!"organ".equals(source)) {
                exemptResult.put("riskDetail", fieldValueApp);
            } else {
                exemptResult.put("riskDetail", exemptRiskDetail);
            }
            List<Map<String, Object>> queryRiskAttr = this.queryRiskAttrByLevel(productUuid, organId, channelNo, exempt.getNodeNo(), deliveryPlatform, organRiskUuid);
            this.dealAttrRuleNode(queryRiskAttr);
            dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)exempt.getNodeNo());
            dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code());
            DsnStructure rule = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
            if (rule != null) {
                String ruleNo = rule.getNodeNo();
                Map<String, Object> riskRule = this.riskDao.queryRuleNew(riskId, product, fieldValueApp);
                exemptResult.putAll(riskRule);
            }
            exemptResult.put("riskAttr", queryRiskAttr);
            List<Map<String, Object>> riskRate = this.riskDao.queryRiskRate(exempt.getNodeNo(), NodeType.N_RATE.code());
            exemptResult.put(NodeType.N_RATE.code(), riskRate);
            exemptList.add(exemptResult);
        }
        return exemptList;
    }

    private List<Map<String, Object>> querySubRisk(Map<String, Object> param, String riskUuid, Map<String, Object> product) {
        ArrayList<Map<String, Object>> subList = new ArrayList<Map<String, Object>>();
        DsnStructure dsnStruct = new DsnStructure();
        String source = (String)param.get("source");
        String organRiskUuid = (String)param.get("organ_prd_uuid");
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)riskUuid);
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_SUB_RISKS.code());
        DsnStructure subRisk = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)subRisk.getNodeNo());
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.SUB_RISKS.code());
        List subInfo = this.dao.findAll((AbsModel)dsnStruct);
        for (DsnStructure sub : subInfo) {
            HashMap<String, Object> subResult = new HashMap<String, Object>();
            dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)sub.getNodeNo());
            dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code());
            DsnStructure subRiskUuid = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
            param.put("subRiskUuid", subRiskUuid.getNodeNo());
            List<Map<String, Object>> subRiskDetail = this.riskDao.queryRiskDetail(param, sub.getNodeNo(), NodeType.N_RISK_DETAIL.code());
            Map<String, Object> fieldValueApp = this.riskDao.getFieldValueApp(subRiskDetail);
            if (!"organ".equals(source)) {
                String mainRisk = this.queryRiskInfoRoot(sub.getNodeNo(), NodeType.N_RISK_DETAIL.code());
                fieldValueApp.put("risk_uuid", mainRisk);
                subResult.put("riskDetail", fieldValueApp);
            } else {
                subResult.put("riskDetail", subRiskDetail);
            }
            List<Map<String, Object>> querySubAttr = this.riskDao.queryRiskAttr(param, sub.getNodeNo());
            for (Map<String, Object> attrRule : querySubAttr) {
                String string = JsonUtils.toJson((Object)attrRule.get("ruleOption"));
            }
            if ("app".equals(source) || "rule".equals(source)) {
                dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)sub.getNodeNo());
                dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code());
                DsnStructure rule = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
                String ruleNo = rule.getNodeNo();
                HashMap riskRule = new HashMap();
                subResult.put("riskRule", riskRule);
            }
            if ("relation".equals(source) || "app".equals(source)) {
                HashMap<String, Object> request = new HashMap<String, Object>();
                String mainRisk = this.queryRiskInfoRoot(riskUuid, NodeType.N_RISK_DETAIL.code());
                String riskId = this.queryRiskInfoRoot(sub.getNodeNo(), NodeType.N_RISK_DETAIL.code());
                request.put("organ_prd_uuid", organRiskUuid);
                request.put("main_risk", mainRisk);
                request.put("risk_uuid", riskId);
                SipOrganRiskRelation queryRiskReational = this.queryRiskReational(request);
                subResult.put("riskRelation", queryRiskReational);
            }
            subResult.put("riskAttr", querySubAttr);
            subList.add(subResult);
        }
        return subList;
    }

    private List<Map<String, Object>> queryAdditionalRisk(Map<String, Object> param, Map<String, Object> product) {
        ArrayList<Map<String, Object>> additionList = new ArrayList<Map<String, Object>>();
        DsnStructure dsnStruct = new DsnStructure();
        String riskUuid = (String)param.get("risk_uuid");
        String source = (String)param.get("source");
        String organRiskUuid = (String)param.get("organ_prd_uuid");
        String productUuid = (String)param.get("product_uuid");
        String organId = (String)param.get("organ_id");
        String channelNo = (String)param.get("channel_no");
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        String addBatch = StrUtils.trimStr((Object)param.get("add_batch"));
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)riskUuid);
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_ACCY_RISKS.code());
        DsnStructure additionalRisk = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)additionalRisk.getNodeNo());
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.ACCY_RISKS.code());
        List additionalInfo = this.dao.findAll((AbsModel)dsnStruct);
        for (DsnStructure addition : additionalInfo) {
            HashMap<String, Object> additional = new HashMap<String, Object>();
            if ("relation".equals(source) || "app".equals(source)) {
                HashMap<String, Object> request = new HashMap<String, Object>();
                request.put("organ_prd_uuid", organRiskUuid);
                String mainRisk = this.queryRiskInfoRoot(riskUuid, NodeType.N_RISK_DETAIL.code());
                String riskId = this.queryRiskInfoRoot(addition.getNodeNo(), NodeType.N_RISK_DETAIL.code());
                request.put("main_risk", mainRisk);
                request.put("risk_uuid", riskId);
                SipOrganRiskRelation queryRiskReational = this.queryRiskReational(request);
                if (queryRiskReational == null || StrUtils.isNull((Object)queryRiskReational.getRiskUuid())) continue;
                SipRiskRelation companyReational = this.queryReational(request);
                additional.put("riskRelation", queryRiskReational);
                additional.put("companyRelation", companyReational);
            }
            Map<String, Object> fieldValueApp = this.riskDao.queryRiskDetailInfo(param, addition.getNodeNo(), NodeType.N_RISK_DETAIL.code());
            dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)addition.getNodeNo());
            dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code());
            DsnStructure addRiskUuid = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
            String addUuid = addRiskUuid.getNodeNo();
            param.put("addRiskUuid", addUuid);
            param.put("risk_uuid", addition.getNodeNo());
            if (!"organ".equals(source)) {
                String mainRisk = this.queryRiskInfoRoot(addition.getNodeNo(), NodeType.N_RISK_DETAIL.code());
                fieldValueApp.put("risk_uuid", mainRisk);
                additional.put("riskDetail", fieldValueApp);
            } else {
                List<Map<String, Object>> queryRiskDetail = this.riskDao.queryRiskDetail(param, addition.getNodeNo(), NodeType.N_RISK_DETAIL.code());
                additional.put("riskDetail", queryRiskDetail);
            }
            List<Map<String, Object>> queryRiskAttr = this.queryRiskAttrByLevel(productUuid, organId, channelNo, addition.getNodeNo(), deliveryPlatform, organRiskUuid);
            this.dealAttrRuleNode(queryRiskAttr);
            if ("app".equals(source) || "rule".equals(source)) {
                dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)addition.getNodeNo());
                dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code());
                DsnStructure rule = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
                String ruleNo = rule.getNodeNo();
                Map<String, Object> riskRule = this.riskDao.queryRuleNew(addUuid, product, fieldValueApp);
                additional.putAll(riskRule);
                List<Map<String, Object>> riskRate = this.riskDao.queryRiskRate(addition.getNodeNo(), NodeType.N_RATE.code());
                additional.put(NodeType.N_RATE.code(), riskRate);
            }
            if (!"relation".equals(source)) {
                List<Map<String, Object>> queryAccyExemptRisk = this.queryAccyExemptRisk(param, product, deliveryPlatform);
                List<Map<String, Object>> querySubRisk = this.querySubRisk(param, addition.getNodeNo(), product);
                additional.put("riskAttr", queryRiskAttr);
                additional.put("pol_waiver_risk", queryAccyExemptRisk);
                additional.put("sub_risk", querySubRisk);
            }
            additionList.add(additional);
        }
        return additionList;
    }

    private List<Map<String, Object>> queryAccyExemptRisk(Map<String, Object> param, Map<String, Object> product, String deliveryPlatform) {
        ArrayList<Map<String, Object>> additionList = new ArrayList<Map<String, Object>>();
        DsnStructure dsnStruct = new DsnStructure();
        String riskUuid = (String)param.get("risk_uuid");
        String source = (String)param.get("source");
        String organRiskUuid = (String)param.get("organ_prd_uuid");
        String productUuid = (String)param.get("product_uuid");
        String organId = (String)param.get("organ_id");
        String channelNo = (String)param.get("channel_no");
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)riskUuid);
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_EXEMPT.code());
        DsnStructure additionalRisk = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)additionalRisk.getNodeNo());
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.EXEMPT.code());
        List exemptInfo = this.dao.findAll((AbsModel)dsnStruct);
        for (DsnStructure exempt : exemptInfo) {
            HashMap<String, Object> additional = new HashMap<String, Object>();
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("organ_prd_uuid", organRiskUuid);
            String mainRisk = this.queryRiskInfoRoot(riskUuid, NodeType.N_RISK_DETAIL.code());
            String riskId = this.queryRiskInfoRoot(exempt.getNodeNo(), NodeType.N_RISK_DETAIL.code());
            request.put("main_risk", mainRisk);
            request.put("risk_uuid", riskId);
            SipOrganRiskRelation queryRiskReational = this.queryRiskReational(request);
            if (queryRiskReational == null || StrUtils.isNull((Object)queryRiskReational.getRiskUuid())) continue;
            SipRiskRelation companyReational = this.queryReational(request);
            additional.put("riskRelation", queryRiskReational);
            additional.put("companyRelation", companyReational);
            List<Map<String, Object>> additionalRiskDetail = this.riskDao.queryRiskDetail(param, exempt.getNodeNo(), NodeType.N_ACCY_EXEMPT.code());
            Map<String, Object> fieldValueApp = this.riskDao.getFieldValueApp(additionalRiskDetail);
            if (!"rule".equals(source)) {
                if ("app".equals(source)) {
                    fieldValueApp.put("risk_uuid", riskId);
                    additional.put("riskDetail", fieldValueApp);
                } else {
                    additional.put("riskDetail", additionalRiskDetail);
                }
            }
            List<Map<String, Object>> queryRiskAttr = this.queryRiskAttrByLevel(productUuid, organId, channelNo, exempt.getNodeNo(), deliveryPlatform, organRiskUuid);
            additional.put("riskAttr", queryRiskAttr);
            this.dealAttrRuleNode(queryRiskAttr);
            List<Map<String, Object>> riskRate = this.riskDao.queryRiskRate(exempt.getNodeNo(), NodeType.N_RATE.code());
            additional.put(NodeType.N_RATE.code(), riskRate);
            dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)exempt.getNodeNo());
            dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code());
            DsnStructure rule = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
            if (rule != null) {
                String ruleNo = rule.getNodeNo();
                Map<String, Object> riskRule = this.riskDao.queryRuleNew(riskId, product, fieldValueApp);
                additional.putAll(riskRule);
            }
            additionList.add(additional);
        }
        return additionList;
    }

    public SipOrganRiskRelation queryRiskReational(Map<String, Object> param) {
        String organPrdUuid = (String)param.get("organ_prd_uuid");
        String mainRisk = (String)param.get("main_risk");
        String riskUuid = (String)param.get("risk_uuid");
        SipRiskRelation sipRelation = new SipRiskRelation();
        sipRelation.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRisk);
        sipRelation.where().addEq(SipRiskRelation.RISK_UUID, (Object)riskUuid);
        SipRiskRelation sipRiskRelation = (SipRiskRelation)this.dao.findOne((AbsModel)sipRelation);
        SipOrganRiskRelation relation = new SipOrganRiskRelation();
        relation.where().addEq(SipOrganRiskRelation.ORGAN_PRD_UUID, (Object)organPrdUuid);
        relation.where().addEq(SipOrganRiskRelation.RISK_UUID, (Object)riskUuid);
        relation.where().addEq(SipOrganRiskRelation.MAIN_RISK, (Object)mainRisk);
        SipOrganRiskRelation organRiskRelation = (SipOrganRiskRelation)this.dao.findOne((AbsModel)relation);
        if (organRiskRelation == null) {
            SipOrganRiskRelation organRiskRelation1 = new SipOrganRiskRelation();
            if (sipRiskRelation != null) {
                organRiskRelation1.setMainRisk(sipRiskRelation.getMainRisk());
                organRiskRelation1.setRiskUuid(sipRiskRelation.getRiskUuid());
                organRiskRelation1.setIsRequired(sipRiskRelation.getIsRequired());
                organRiskRelation1.setIsRecommend(sipRiskRelation.getIsRecommend());
            }
            return organRiskRelation1;
        }
        organRiskRelation.setRiskUuid(riskUuid);
        organRiskRelation.setMainRisk(mainRisk);
        if (StrUtils.isNull((Object)organRiskRelation.getIsRecommend())) {
            organRiskRelation.setIsRecommend(sipRiskRelation != null ? sipRiskRelation.getIsRecommend() : "");
        }
        if (StrUtils.isNull((Object)organRiskRelation.getIsRequired())) {
            organRiskRelation.setIsRequired(sipRiskRelation != null ? sipRiskRelation.getIsRequired() : "");
        }
        return organRiskRelation;
    }

    public Map<String, Object> queryRiskRule2222(String ruleNo, String orgProduct, Map<String, Object> parm, String attrNo) {
        HashMap<String, Object> riskRule = new HashMap<String, Object>();
        return riskRule;
    }

    public List<Map<String, Object>> queryRiskAttrByLevel(String productUuid, String organId, String channelNo, String nodeNo, String deliveryPlatform, String addBatch) {
        List<Map<String, Object>> optionList = null;
        DsnStructure dsnStructure = new DsnStructure();
        DsnStructure riskAttr = this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_ATTR.code());
        String queryProduct = "SELECT *,str.display_order as display_order FROM dsn_structure str  join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type = ? order by str.display_order";
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(riskAttr.getNodeNo());
        list.args().add(NodeType.ATTR.code());
        List riskAttrInfo = this.dao.findAll(queryProduct, new AbsModelRepository.Args[]{list});
        for (Map attrVo : riskAttrInfo) {
            String bizUuid = (String)attrVo.get("biz_uuid");
            optionList = this.queryAttrOption(bizUuid);
            attrVo.put("attrOption", optionList);
        }
        Map<String, Map> coll = riskAttrInfo.stream().collect(Collectors.groupingBy(map -> StrUtils.trimStr(map.get("attr_no")), Collectors.collectingAndThen(Collectors.toList(), val -> val != null && !val.isEmpty() ? (Map)val.get(0) : null)));
        DsnStructure nRiskDetailNode = this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        String curOrganId = "1000000";
        int endIndex = 1;
        while (true) {
            String organPrdUuid = "";
            if (!StrUtils.isNull((Object)addBatch) && organId.equals(curOrganId)) {
                organPrdUuid = addBatch;
            } else {
                SipOrganProducts sipOrganProducts = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipProducts.ORGAN_ID, (Object)curOrganId).addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo).addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid).addEq(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model());
                if (sipOrganProducts != null) {
                    organPrdUuid = sipOrganProducts.getOrganPrdUuid();
                }
            }
            if (!StrUtils.isNull((Object)organPrdUuid)) {
                List organRiskInfoList = this.dao.findAll(SipOrganRiskInfo.n().where().addEq(SipOrganRiskInfo.ORGAN_PRD_UUID, (Object)organPrdUuid).addEq(SipOrganRiskInfo.ATTR_TYPE, (Object)"riskAttr").addEq(SipOrganRiskInfo.RISK_UUID, (Object)nRiskDetailNode.getNodeNo()).addEq(SipOrganRiskInfo.DATA_FLAG, (Object)"1").model());
                Map<String, SipOrganRiskInfo> needReplaceCollect = organRiskInfoList.stream().collect(Collectors.groupingBy(SipOrganRiskInfo::getAttrNo, Collectors.collectingAndThen(Collectors.toList(), val -> val != null && !val.isEmpty() ? (SipOrganRiskInfo)val.get(0) : null)));
                for (Map.Entry<String, Map> next : coll.entrySet()) {
                    Map value = next.getValue();
                    SipOrganRiskInfo organRiskInfo = needReplaceCollect.get(next.getKey());
                    if (organRiskInfo == null) continue;
                    value.put("field_value", organRiskInfo.getAttrValue());
                    value.put("allow_mdf", organRiskInfo.getAllowMdf());
                    next.setValue(value);
                }
            }
            if (organId.equals(curOrganId)) break;
            curOrganId = organId.substring(0, endIndex += 2).concat(curOrganId.substring(endIndex));
        }
        return riskAttrInfo;
    }

    public Map<String, Object> getFieldValueApp2222(List<Map<String, Object>> attrList) {
        HashMap<String, Object> attrValueNew = new HashMap<String, Object>();
        for (Map<String, Object> attrValue : attrList) {
            String key = StrUtils.trimStr((Object)attrValue.get("attr_no"));
            Object value = attrValue.get("field_value");
            attrValueNew.put(key, value);
            if (!"risk_no".equals(key)) continue;
            attrValueNew.put("risk_code", value);
        }
        return attrValueNew;
    }

    public List<Map<String, Object>> queryRiskDetailByLevel(String productUuid, String organId, String channelNo, String nodeNo, String type, String deliveryPlatform, String addBatch) {
        DsnStructure riskVo = this.getDsnStructureInfo(nodeNo, type);
        if (riskVo == null) {
            return null;
        }
        List attrList = null;
        List<Map<String, Object>> optionList = null;
        StringBuilder str = new StringBuilder();
        str.append("SELECT attr.* FROM dsn_structure str   join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type = ? order by str.display_order");
        ArrayList<String> list = new ArrayList<String>();
        list.add(riskVo.getNodeNo());
        list.add(NodeType.ATTR_DETAIL.code());
        attrList = this.dao.findAll(String.valueOf(str), new AbsModelRepository.Args[]{this.dao.args(list)});
        for (Map attr : attrList) {
            String ui_type = StrUtils.trimStr(attr.get("ui_type"));
            if ("date".equals(ui_type) || "text".equals(ui_type) || "number".equals(ui_type)) continue;
            String bizUuid = (String)attr.get("biz_uuid");
            optionList = this.queryAttrOption(bizUuid);
            attr.put("attrOption", optionList);
        }
        this.getFieldValueOrgan(attrList, riskVo, organId, channelNo, productUuid, deliveryPlatform, addBatch);
        return attrList;
    }

    private List<Map<String, Object>> queryAttrOption(String bizUuid) {
        List optionList = this.dao.findAll4Map((AbsModel)((DsnBizAttributeOption)DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizUuid).model()).setOrderBy(new Sort.Order[]{DsnBizAttributeOption.OPTION_ORDER.asc()}));
        return optionList;
    }

    private void getFieldValueOrgan(List<Map<String, Object>> attrList, DsnStructure riskVo, String organId, String channelNo, String productUuid, String deliveryPlatform, String addBatch) {
        String nodeNo = riskVo.getNodeNo();
        List riskInfo = this.dao.findAll4Map(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)nodeNo).model());
        Map risk = riskInfo.isEmpty() ? null : (Map)riskInfo.get(0);
        for (Map<String, Object> attrValue : attrList) {
            String storedTab = StrUtils.trimStr((Object)attrValue.get("stored_tab"));
            String storedField = StrUtils.trimStr((Object)attrValue.get("stored_field"));
            String string = StrUtils.trimStr((Object)attrValue.get("attr_no"));
            if (!"sip_risks".equalsIgnoreCase(storedTab) || null == risk) continue;
            if ("risk_no".equals(string)) {
                String policyId = StrUtils.trimStr(risk.get("policy_code"));
                attrValue.put("field_value", policyId);
                continue;
            }
            attrValue.put("field_value", risk.get(storedField));
        }
        String curOrganId = "1000000";
        int endIndex = 1;
        while (!organId.equals(curOrganId)) {
            SipOrganProducts sipOrganProducts = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipOrganProducts.ORGAN_ID, (Object)curOrganId).addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo).addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid).addEq(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model());
            for (Map map : attrList) {
                map.put("allow_switch", map.get("allow_mdf"));
                if (sipOrganProducts == null) continue;
                this.detalFieldData(riskVo, sipOrganProducts.getOrganPrdUuid(), map);
            }
            curOrganId = organId.substring(0, endIndex += 2).concat(curOrganId.substring(endIndex));
        }
        if (organId.equals(curOrganId)) {
            attrList.forEach(o -> o.put("allow_switch", o.get("allow_mdf")));
        }
        String organPrdUuid = "";
        if (StrUtils.isNull((Object)addBatch)) {
            SipOrganProducts sipOrganProducts = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipOrganProducts.ORGAN_ID, (Object)curOrganId).addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo).addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid).addEq(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model());
            if (!StrUtils.isNull((Object)sipOrganProducts)) {
                organPrdUuid = sipOrganProducts.getOrganPrdUuid();
            }
        } else {
            organPrdUuid = addBatch;
        }
        if (!StrUtils.isNull((Object)organPrdUuid)) {
            for (Map<String, Object> map : attrList) {
                Map organProduct;
                String attrUuid = StrUtils.trimStr((Object)map.get("attr_uuid"));
                List productOrganInfo = this.dao.findAll4Map(SipOrganProductInfo.n().where().addEq(SipOrganProductInfo.ORGAN_PRD_UUID, (Object)organPrdUuid).addEq(SipOrganProductInfo.ATTR_UUID, (Object)attrUuid).model());
                productOrganInfo.addAll(this.dao.findAll4Map(SipOrganRiskInfo.n().where().addEq(SipOrganRiskInfo.ORGAN_PRD_UUID, (Object)organPrdUuid).addEq(SipOrganRiskInfo.RISK_UUID, (Object)nodeNo).addEq(SipOrganRiskInfo.ATTR_UUID, (Object)attrUuid).model()));
                Map map2 = organProduct = productOrganInfo.isEmpty() ? null : (Map)productOrganInfo.get(0);
                if (null != organProduct) {
                    map.put("field_value", organProduct.get("attr_value"));
                    map.put("allow_switch", organProduct.get("allow_mdf"));
                }
                if (!map.get("allow_mdf").equals("N")) continue;
                map.put("allow_switch", "N");
            }
        }
    }

    private void detalFieldData(DsnStructure riskVo, String organPrdUuid, Map<String, Object> attrValue) {
        String attrUuid = StrUtils.trimStr((Object)attrValue.get("attr_uuid"));
        if (!StrUtils.isNull((Object)organPrdUuid)) {
            Map organRisk;
            List riskOrganInfo = this.dao.findAll4Map(SipOrganRiskInfo.n().where().addEq(SipOrganRiskInfo.ORGAN_PRD_UUID, (Object)organPrdUuid).addEq(SipOrganRiskInfo.RISK_UUID, (Object)riskVo.getNodeNo()).addEq(SipOrganRiskInfo.ATTR_UUID, (Object)attrUuid).model());
            Map map = organRisk = riskOrganInfo.isEmpty() ? null : (Map)riskOrganInfo.get(0);
            if (null != organRisk) {
                attrValue.put("field_value", organRisk.get("attr_value"));
                attrValue.put("allow_mdf", organRisk.get("allow_mdf"));
            }
        }
    }

    private String queryRiskInfoRoot(String riskUuid, String type) {
        DsnStructure riskVo = this.getDsnStructureInfo(riskUuid, type);
        return riskVo.getNodeNo();
    }

    public DsnStructure getDsnStructureInfo(String nodeNo, String type) {
        if (NodeType.N_RISK_DETAIL.code().equals(type) || NodeType.N_ACCY_EXEMPT.code().equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        }
        if (NodeType.MAIN_EXEMPT.code().equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        }
        if (NodeType.N_ACCY_RISKS.code().equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        }
        if (NodeType.N_SUB_RISKS_DETAIL.code().equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        }
        return this.getDsnStructureByUpNode(nodeNo);
    }

    public DsnStructure getDsnStructureByUpNodeAndNodeType(String nodeNo, String type) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)type);
        return (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
    }

    public DsnStructure getDsnStructureByUpNode(String nodeNo) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        return (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
    }

    @Override
    public ReturnMsg queryRiskInfo(DsnStructure dsnStructure) {
        Return msg = new Return();
        String upNode = dsnStructure.getNodeNo();
        StringBuilder str = new StringBuilder();
        str.append("select * from dsn_biz_attribute where biz_uuid in ( SELECT node_no from dsn_structure where up_node = ? ) order by display_order ");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(upNode);
        List attrList = this.dao.findAll(String.valueOf(str), new AbsModelRepository.Args[]{list});
        attrList.stream().forEach(map -> this.structureService.bizAttributeFieldChange2((Map<String, Object>)map));
        if (null != attrList && !attrList.isEmpty()) {
            StringBuilder attrOptSql = new StringBuilder();
            attrOptSql.append(" select dbao.* from dsn_biz_attribute dba  left join dsn_biz_attribute_option dbao  on dba.biz_uuid=dbao.biz_uuid  where dba.biz_uuid in ( select node_no from dsn_structure where up_node = ? ) order by option_order ");
            AbsModelRepository.Args attrOptSqlList = this.dao.args(new Object[0]);
            attrOptSqlList.args().add(upNode);
            List attrOptValueList = this.dao.findAll(String.valueOf(attrOptSql), new AbsModelRepository.Args[]{list});
            SipRisks sipRisks = new SipRisks();
            sipRisks.where().addEq(SipRisks.RISK_UUID, (Object)upNode);
            List attrValueMapList = this.dao.findAll4Map((AbsModel)sipRisks);
            Map attrValueMap = (Map)attrValueMapList.get(0);
            if (null != attrValueMap && !attrValueMap.isEmpty()) {
                for (Map tmpMap : attrList) {
                    this.structureService.bizAttributeFieldChange2(tmpMap);
                    if (!"sip_risks".equalsIgnoreCase(StrUtils.trimStr(tmpMap.get("stored_tab")))) continue;
                    tmpMap.put("field_value", attrValueMap.get(tmpMap.get("stored_field")));
                    if (null == attrOptValueList || attrOptValueList.isEmpty()) continue;
                    tmpMap.put("attrOptValueList", this.getThisAttrOptValueList(StrUtils.trimStr(tmpMap.get("biz_uuid")), attrOptValueList));
                }
            }
            for (Map tmpMap : attrList) {
                List reslutList2;
                AbsModelRepository.Args dynamicSqlList;
                if (tmpMap.containsKey("field_value")) continue;
                if (null != attrOptValueList && !attrOptValueList.isEmpty()) {
                    tmpMap.put("attrOptValueList", this.getThisAttrOptValueList(StrUtils.trimStr(tmpMap.get("biz_uuid")), attrOptValueList));
                }
                String stored_tab = StrUtils.trimStr(tmpMap.get("stored_tab"));
                String stored_field = StrUtils.trimStr(tmpMap.get("stored_field"));
                StringBuilder queryAttrValueSql = new StringBuilder();
                if ("dsn_dynamic_data".equalsIgnoreCase(stored_tab)) {
                    queryAttrValueSql.append("SELECT " + stored_field + " from dsn_dynamic_data WHERE ").append(" data_flag = ? and relate_tab =?  and relate_field =?  and relate_fk =?  ");
                    dynamicSqlList = this.dao.args(new Object[0]);
                    dynamicSqlList.args().add("1");
                    dynamicSqlList.args().add("dsn_biz_attribute");
                    dynamicSqlList.args().add("biz_uuid");
                    dynamicSqlList.args().add(StrUtils.trimStr(tmpMap.get("biz_uuid")));
                } else if ("sys_file_repostry".equalsIgnoreCase(stored_tab)) {
                    queryAttrValueSql.append("SELECT * from sys_file_repostry where file_no = ?");
                    dynamicSqlList = this.dao.args(new Object[0]);
                    dynamicSqlList.args().add(upNode);
                } else if ("sip_risk_relation".equalsIgnoreCase(stored_tab)) {
                    String parentNo = StrUtils.trimStr(dsnStructure.getOtherProperty().get("tId"));
                    DsnStructure dsn = new DsnStructure();
                    dsn.where().addEq(DsnStructure.UP_NODE, (Object)parentNo);
                    dsn.where().addIn(DsnStructure.NODE_TYPE, new String[]{"n_risk_detail", "n_accy_detail"});
                    dsn = (DsnStructure)this.dao.findOne((AbsModel)dsn);
                    queryAttrValueSql.append("SELECT * from sip_risk_relation where risk_uuid = ?");
                    AbsModelRepository.Args dynamicSqlList2 = this.dao.args(new Object[0]);
                    dynamicSqlList2.args().add(upNode);
                    dynamicSqlList2.args().add(dsn.getNodeNo());
                } else {
                    if ("dsn_dynamic_text_data".equalsIgnoreCase(stored_tab)) continue;
                    Ulog.error((String)("\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u5b58\u50a8\u8868\u662f[" + stored_tab + "]\u672a\u627e\u5230\u8be5\u5c5e\u6027\u6240\u914d\u7f6e\u7684\u5b58\u50a8\u8868\uff01\uff01\uff01"));
                    continue;
                }
                if (null == (attrValueMap = (reslutList2 = this.dao.findAll(String.valueOf(queryAttrValueSql), new AbsModelRepository.Args[]{list})).isEmpty() ? null : (Map)reslutList2.get(0)) || attrValueMap.isEmpty()) continue;
                tmpMap.put("field_value", attrValueMap.get(Integer.parseInt(stored_field)));
            }
        }
        this.getFileInfo(attrList, upNode);
        msg.setDataList(attrList);
        return msg.msg();
    }

    private void renameRiskNode(String riskName, String riskDetailNodeno) {
        if (!StrUtils.isNull((Object)riskName)) {
            DsnStructure dsn = new DsnStructure();
            dsn.where().addEq(DsnStructure.NODE_NO, (Object)riskDetailNodeno);
            dsn = (DsnStructure)this.dao.findOne((AbsModel)dsn);
            dsn.where().addEq(DsnStructure.NODE_NO, (Object)dsn.getUpNode());
            List dsnList = this.dao.findAll((AbsModel)dsn);
            for (DsnStructure dsn1 : dsnList) {
                DsnStructure mdfDsn = new DsnStructure();
                mdfDsn.where().addEq(DsnStructure.NODE_NO, (Object)dsn1.getNodeNo());
                mdfDsn.where().addEq(DsnStructure.UP_NODE, (Object)dsn1.getUpNode());
                mdfDsn.where().addEq(DsnStructure.SERNO, (Object)dsn1.getSerno());
                mdfDsn.setNodeName(riskName);
                this.dao.update((AbsModel)mdfDsn);
            }
        }
    }

    @Override
    public List<Map<String, Object>> getFileInfo(List<Map<String, Object>> params, String currentNodeNo) {
        params.stream().forEach(x -> {
            if (x.get("ui_type").equals("file")) {
                x.put("node_no", x.get("biz_uuid"));
                x.put("file_no_url", x.get("biz_uuid"));
                x.put("file_name", this.findFileName((String)x.get("biz_uuid")));
            }
        });
        return params;
    }

    public String findFileName(String fileNo) {
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("SELECT s.file_name from sys_file_repostry s where file_no = ? ");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(fileNo);
        List attrList = this.dao.findAll(String.valueOf(sqlStr), new AbsModelRepository.Args[]{list});
        if (attrList != null && attrList.size() > 0) {
            return (String)((Map)attrList.get(0)).get("file_name");
        }
        return "";
    }

    private void maintainProductAndRiskRelation(String productNodeNo, String currentNodeNo) {
        SipProductRisks sip_product_risks4Query = new SipProductRisks();
        sip_product_risks4Query.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productNodeNo);
        sip_product_risks4Query.where().addEq(SipProductRisks.RISK_UUID, (Object)currentNodeNo);
        List sip_product_riskses = this.dao.findAll((AbsModel)sip_product_risks4Query);
        if (null == sip_product_riskses || sip_product_riskses.isEmpty()) {
            SipProductRisks sip_product_risks4Insert = new SipProductRisks();
            sip_product_risks4Insert.setProductUuid(productNodeNo);
            sip_product_risks4Insert.setRiskUuid(currentNodeNo);
            this.dao.save((AbsModel)sip_product_risks4Insert);
        } else {
            SipProductRisks sip_product_risks4Update = new SipProductRisks();
            sip_product_risks4Update.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productNodeNo);
            sip_product_risks4Update.where().addEq(SipProductRisks.RISK_UUID, (Object)currentNodeNo);
            this.dao.update((AbsModel)sip_product_risks4Update);
        }
    }

    public boolean checkMainRisk(String isMainRisk, String bizUUUD4RiskType) {
        boolean mainRiskFlag = false;
        List<DsnBizAttributeOption> dsnBizAttributeOptionList = this.queryDic4RiskType(bizUUUD4RiskType);
        if (null != dsnBizAttributeOptionList && !dsnBizAttributeOptionList.isEmpty()) {
            for (DsnBizAttributeOption dsnBizAttributeOption : dsnBizAttributeOptionList) {
                String optionValue = dsnBizAttributeOption.getOptionValue();
                String optionName = dsnBizAttributeOption.getOptionName();
                if (!isMainRisk.equals(optionValue) || !"\u4e3b\u9669".equals(optionName)) continue;
                mainRiskFlag = true;
            }
        } else if ("M".equals(StrUtils.trimStr((Object)isMainRisk)) || "1".equals(StrUtils.trimStr((Object)isMainRisk)) || "\u662f".equals(StrUtils.trimStr((Object)isMainRisk))) {
            mainRiskFlag = true;
        }
        return mainRiskFlag;
    }

    private List<DsnBizAttributeOption> queryDic4RiskType(String bizUUID) {
        DsnBizAttributeOption dsnBizAttributeOption4Query = new DsnBizAttributeOption();
        dsnBizAttributeOption4Query.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizUUID);
        List dsnBizAttributeOptionList = this.dao.findAll((AbsModel)dsnBizAttributeOption4Query);
        if (null != dsnBizAttributeOptionList && !dsnBizAttributeOptionList.isEmpty()) {
            return dsnBizAttributeOptionList;
        }
        return null;
    }

    private void maintainSipRiskRelation(Map<String, Object> paramMap) {
        String mainRisk = StrUtils.trimStr((Object)paramMap.get("parent_risk_uuid"));
        String riskUUID = StrUtils.trimStr((Object)paramMap.get("current_node_no"));
        String riskOrderRelation = StrUtils.trimStr((Object)paramMap.get("risk_order_relation"));
        String isMainRisk = StrUtils.trimStr((Object)paramMap.get("is_main_risk"));
        String bizUUUD4RiskType = StrUtils.trimStr((Object)paramMap.get("bizUUUD4RiskType"));
        String relationType = this.getRelationType(StrUtils.trimStr((Object)paramMap.get("bizUUUD4RiskType")), isMainRisk);
        String isRequired = StrUtils.trimStr((Object)paramMap.get("is_required"));
        String isRecommend = StrUtils.trimStr((Object)paramMap.get("is_recommend"));
        if ("S".equals(isRequired)) {
            isRequired = "N";
        } else if ("M".equals(isRequired)) {
            isRequired = "Y";
        }
        Date startDate = StrUtils.isNull((Object)paramMap.get("start_date")) ? DateUtil.sysDate() : DateUtil.object2Date((Object)paramMap.get("start_date"));
        Date endDate = StrUtils.isNull((Object)paramMap.get("end_date")) ? DateUtil.sysDate() : DateUtil.object2Date((Object)paramMap.get("end_date"));
        this.dealRiskRelation(mainRisk, riskUUID, riskOrderRelation, relationType, isRequired, isRecommend, startDate, endDate);
    }

    private String getRelationType(String bizUUUD4RiskType, String isMainRisk) {
        List<DsnBizAttributeOption> dsnBizAttributeOptionList = this.queryDic4RiskType(bizUUUD4RiskType);
        String relationType = "";
        if (null == dsnBizAttributeOptionList || dsnBizAttributeOptionList.isEmpty()) {
            relationType = "2".equals(isMainRisk) || "A".equals(isMainRisk) ? "ADDED" : ("3".equals(isMainRisk) || "W".equals(isMainRisk) ? "EXEMPT" : "");
        } else {
            for (DsnBizAttributeOption dsnBizAttributeOption : dsnBizAttributeOptionList) {
                String optionName = dsnBizAttributeOption.getOptionName();
                String optionValue = dsnBizAttributeOption.getOptionValue();
                if (optionName.equals("\u9644\u52a0\u9669") && isMainRisk.equals(optionValue)) {
                    relationType = "ADDED";
                    break;
                }
                if (optionName.equals("\u8c41\u514d\u9669") && isMainRisk.equals(optionValue)) {
                    relationType = "EXEMPT";
                    break;
                }
                if (!optionName.equals("\u5b50\u9669") || !isMainRisk.equals(optionValue)) continue;
                relationType = "SUB";
                break;
            }
        }
        return relationType;
    }

    private void dealdsn_dynamic_data(Map<String, Object> paramMap, String currentNodeNo) {
        StringBuilder str = new StringBuilder();
        str.append("select * from dsn_biz_attribute where biz_uuid in ( SELECT node_no from dsn_structure where up_node = ? )  and stored_tab = ?  order by display_order ");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(currentNodeNo);
        list.args().add("dsn_dynamic_data");
        List attrList = this.dao.findAll(String.valueOf(str), new AbsModelRepository.Args[]{list});
        if (attrList == null || attrList.isEmpty()) {
            return;
        }
        String biz_uuid = "";
        String storedField = "";
        for (Map dsn_biz_attribute : attrList) {
            if (StrUtils.isNull(dsn_biz_attribute.get("biz_uuid"))) continue;
            biz_uuid = StrUtils.trimStr(dsn_biz_attribute.get("biz_uuid"));
            DsnDynamicData dynamicData = new DsnDynamicData();
            dynamicData.where().addEq(DsnDynamicData.RELATE_TAB, (Object)"dsn_biz_attribute");
            dynamicData.where().addEq(DsnDynamicData.RELATE_FIELD, (Object)"biz_uuid");
            dynamicData.where().addEq(DsnDynamicData.RELATE_FK, (Object)biz_uuid);
            dynamicData = (DsnDynamicData)this.dao.findOne((AbsModel)dynamicData);
            if (!StrUtils.isNull((Object)dynamicData.getSerno())) {
                DsnDynamicData dsn_Dynamic4Delete = new DsnDynamicData();
                dsn_Dynamic4Delete.where().addEq(DsnDynamicData.SERNO, (Object)dynamicData.getSerno());
                this.dao.delete((AbsModel)dsn_Dynamic4Delete);
            }
            DsnDynamicData dynamicDataSave = new DsnDynamicData();
            dynamicDataSave.setRelateTab("dsn_biz_attribute");
            dynamicDataSave.setRelateField("biz_uuid");
            dynamicDataSave.setRelateFk(biz_uuid);
            storedField = StrUtils.trimStr(dsn_biz_attribute.get("stored_field"));
            try {
                BeanUtils.setProperty((Object)dynamicDataSave, (String)storedField.replace("_", ""), (Object)StrUtils.trimStr((Object)paramMap.get(storedField)));
            }
            catch (Exception e) {
                Ulog.error((String)("\u52a8\u6001\u8868\u5b58\u50a8\u9669\u79cd\u4fe1\u606f\u5f02\u5e38\uff1a\uff1a\u52a8\u6001\u8868\u5b57\u6bb5[" + storedField + "]\u5185\u5bb9\u3010" + StrUtils.trimStr((Object)paramMap.get("attr_no")) + "\u3011"));
                e.printStackTrace();
            }
            this.dao.save((AbsModel)dynamicDataSave);
        }
    }

    private void dealRiskRelation(String mainRiskUUid, String subRiskUUID, String riskOrderRelation, String relationType, String isRequired, String isRecommend, java.util.Date startDate, java.util.Date endDate) {
        SipRiskRelation sipRiskRelation4Query = new SipRiskRelation();
        sipRiskRelation4Query.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRiskUUid);
        sipRiskRelation4Query.where().addEq(SipRiskRelation.RISK_UUID, (Object)subRiskUUID);
        SipRiskRelation sipRiskRelation4Result = (SipRiskRelation)this.dao.findOne((AbsModel)sipRiskRelation4Query);
        if (!StrUtils.isNull((Object)isRequired)) {
            SipRiskRelation sipRiskRelation4Delete = new SipRiskRelation();
            sipRiskRelation4Delete.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRiskUUid);
            sipRiskRelation4Delete.where().addEq(SipRiskRelation.RISK_UUID, (Object)subRiskUUID);
            this.dao.delete((AbsModel)sipRiskRelation4Delete);
        }
        if (StrUtils.isNull((Object)sipRiskRelation4Result.getSerno()) || !StrUtils.isNull((Object)isRequired)) {
            SipRiskRelation sipRiskRelation4Insert = new SipRiskRelation();
            sipRiskRelation4Insert.setMainRisk(mainRiskUUid);
            sipRiskRelation4Insert.setRiskUuid(subRiskUUID);
            sipRiskRelation4Insert.setRelationType(relationType.equals("") ? "null" : relationType);
            sipRiskRelation4Insert.setIsRequired(isRequired);
            sipRiskRelation4Insert.setIsRecommend(isRecommend);
            this.dao.save((AbsModel)sipRiskRelation4Insert);
        }
    }

    private Object getThisAttrOptValueList(Object object, List<Map<String, Object>> attrOptValueList) {
        LinkedList<Map<String, Object>> thisAttrOptValueList = new LinkedList<Map<String, Object>>();
        for (Map<String, Object> attrOptValue : attrOptValueList) {
            if (!object.equals(attrOptValue.get("biz_uuid"))) continue;
            thisAttrOptValueList.add(attrOptValue);
        }
        return thisAttrOptValueList;
    }

    @Override
    public ReturnMsg queryRiskDetail(Map<String, Object> param, Map<String, Object> product) {
        String source = (String)param.get("source");
        String nodeNo = (String)param.get("risk_uuid");
        String useScene = StrUtils.trimStr((Object)param.get("use_scene"));
        String productUuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        String organId = StrUtils.trimStr((Object)param.get("organ_id"));
        String channelNo = StrUtils.trimStr((Object)param.get("channel_no"));
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        String organPrdUuid = StrUtils.trimStr((Object)param.get("organ_prd_uuid"));
        Return msg = new Return();
        Map<String, Object> fieldValueApp = this.riskDao.queryRiskDetailInfo(param, nodeNo, NodeType.N_RISK_DETAIL.code());
        if (!"organ".equals(source)) {
            msg.getDataTable().put("riskDetail", fieldValueApp);
        } else {
            List<Map<String, Object>> queryRiskDetail = this.queryRiskDetailByLevel(productUuid, organId, channelNo, nodeNo, NodeType.N_RISK_DETAIL.code(), deliveryPlatform, organPrdUuid);
            msg.getDataTable().put("riskDetail", queryRiskDetail);
        }
        if ("propose".equals(useScene) || "insure".equals(useScene)) {
            List<Map<String, Object>> riskRate = this.riskDao.queryRiskRate(nodeNo, NodeType.N_RATE.code());
            msg.getDataTable().put(NodeType.N_RATE.code(), riskRate);
        }
        DsnStructure mainRiskUuid = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code()).model());
        String mainUuid = mainRiskUuid.getNodeNo();
        param.put("mainRiskUuid", mainUuid);
        List<Map<String, Object>> queryRiskAttr = this.queryRiskAttrByLevel(productUuid, organId, channelNo, nodeNo, deliveryPlatform, organPrdUuid);
        this.dealAttrRuleNode(queryRiskAttr);
        msg.getDataTable().put("riskAttr", queryRiskAttr);
        if ("app".equals(source) || "rule".equals(source)) {
            DsnStructure rule = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code()).model());
            String ruleNo = rule.getNodeNo();
            Map<String, Object> riskRule = this.riskDao.queryRuleNew(mainUuid, product, fieldValueApp);
            msg.getDataTable().putAll(riskRule);
            List<Map<String, Object>> riskRate = this.riskDao.queryRiskRate(nodeNo, NodeType.N_RATE.code());
            msg.getDataTable().put(NodeType.N_RATE.code(), riskRate);
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("organ_prd_uuid", organPrdUuid);
        request.put("main_risk", mainUuid);
        request.put("risk_uuid", mainUuid);
        SipOrganRiskRelation queryRiskReational = this.queryRiskReational(request);
        if (queryRiskReational != null && !StrUtils.isNull((Object)queryRiskReational.getRiskUuid())) {
            msg.getDataTable().put("riskRelation", queryRiskReational);
        }
        List<Map<String, Object>> queryAdditionalRisk = this.queryAdditionalRisk(param, product);
        List<Map<String, Object>> querySubRisk = this.querySubRisk(param, nodeNo, product);
        msg.getDataTable().put("additional_risk", queryAdditionalRisk);
        param.put("risk_uuid", nodeNo);
        List<Map<String, Object>> queryExemptRisk = this.queryExemptRisk(param, product);
        msg.getDataTable().put("pol_waiver_risk", queryExemptRisk);
        msg.getDataTable().put("sub_risk", querySubRisk);
        return msg.msg();
    }

    private void dealAttrRule(Map<String, Object> param, Map<String, Object> product, Map<String, Object> fieldValueApp, List<Map<String, Object>> queryRiskAttr) {
        for (Map<String, Object> attrVo : queryRiskAttr) {
            DsnStructure dsnStructure = DsnStructure.n();
            dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)StrUtils.trimStr((Object)attrVo.get("node_no")));
            DsnStructure ruleNo = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
            Map<String, Object> ruleInfo = this.riskDao.queryRuleNew(ruleNo.getNodeNo(), product, fieldValueApp);
            attrVo.put("ruleOption", ruleInfo);
        }
    }

    private void dealAttrRuleNode(List<Map<String, Object>> queryRiskAttr) {
        for (Map<String, Object> attrVo : queryRiskAttr) {
            DsnStructure dsnStructure = DsnStructure.n();
            dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)StrUtils.trimStr((Object)attrVo.get("node_no")));
            dsnStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RULE.code());
            DsnStructure ruleNo = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
            attrVo.put("n_rule", ruleNo);
        }
    }

    public SipRiskRelation queryReational(Map<String, Object> param) {
        String organPrdUuid = (String)param.get("organ_prd_uuid");
        String mainRisk = (String)param.get("main_risk");
        String riskUuid = (String)param.get("risk_uuid");
        SipRiskRelation sipRiskRelation = (SipRiskRelation)this.dao.findOne(SipRiskRelation.n().where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRisk).addEq(SipRiskRelation.RISK_UUID, (Object)riskUuid).model());
        return sipRiskRelation;
    }
}

