/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.premium.services.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.base.utils.SysTradeLog;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.DsnStructureRules;
import com.newtouch.nms.sip.product.enums.SmsEnum;
import com.newtouch.nms.sip.product.premium.services.IPremiumCalcService;
import com.newtouch.nms.sip.product.premium.utils.PremiumCalc;
import com.uniapis.cache.CacheManager;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.rule.engine.Engine;
import com.uniapis.rule.engine.Rule;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.HttpUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PremiumCalcServiceImpl
implements IPremiumCalcService {
    private static Map<String, String> mappre;
    private static Map<String, String> mapjob;
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private RuleUsedService ruleUsedService;
    @Value(value="${cacl.CaclUrl}")
    private String caclUrl;
    @Value(value="${ETong.insertLog}")
    private String insertLog;
    private static final String INSURANCE_RULE;
    private Set<String> keySet = new HashSet<String>(Arrays.asList("conditions", "and", "or", "onSuccess", "onFailure", "fact", "operator", "value"));

    @Override
    public ReturnMsg calcPremium(Map<String, Object> bbr, Map<String, Object> tbr, List<Map<String, Object>> originalRiskList) {
        PremiumCalc calcPrem = (PremiumCalc)SpringContext.getBean(PremiumCalc.class);
        Return msg = new Return();
        HashMap<String, Map> allListMap = new HashMap<String, Map>();
        ArrayList<Map> waiverList = new ArrayList<Map>();
        List<Map<String, Object>> riskList = originalRiskList.stream().filter(p -> !"P".equals(p.get("risk_type"))).collect(Collectors.toList());
        for (Map map : riskList) {
            if ("N".equals(map.get("calc_premium"))) continue;
            if ("W".equals(StrUtils.trimStr(map.get("risk_type")))) {
                waiverList.add(map);
                continue;
            }
            this.calcPremium(bbr, calcPrem, msg, map, null);
            allListMap.put(StrUtils.trimStr(map.get("policy_code")), map);
        }
        for (Map map : waiverList) {
            String[] parentNodeSeqs = StrUtils.trimStr(map.get("parent_node_seq")).split(",");
            String waiveredRiskNo = parentNodeSeqs[parentNodeSeqs.length - 1];
            Map waiveredRisk = (Map)allListMap.get(waiveredRiskNo);
            if (waiveredRisk == null) continue;
            Map newRisk = ClassUtils.cloneMap((Map)map);
            String rateCoefficient = StrUtils.trimStr((Object)(StrUtils.isNull(waiveredRisk.get("rate_coefficient")) ? Integer.valueOf(1) : waiveredRisk.get("rate_coefficient")));
            String initialPremium = StrUtils.trimStr(waiveredRisk.get("initial_premium"));
            int multiRate = (int)Math.ceil(1.0 / Double.parseDouble(rateCoefficient));
            Double yearPremium = Double.valueOf(initialPremium) * (double)multiRate;
            newRisk.put("cvr_amount", yearPremium);
            if ("TBR".equals(newRisk.get("waiver_type"))) {
                this.calcPremium(tbr, calcPrem, msg, newRisk, riskList);
            } else {
                this.calcPremium(bbr, calcPrem, msg, newRisk, riskList);
            }
            map.putAll(newRisk);
        }
        this.sumPremium(riskList);
        msg.setDataList(riskList);
        return msg.msg();
    }

    @Override
    public void calcPremium(Map<String, Object> bbr, PremiumCalc calcPrem, Return msg, Map<String, Object> aRisk, List<Map<String, Object>> allRisk) {
        if (aRisk.isEmpty()) {
            return;
        }
        aRisk.putAll(bbr);
        String riskUuid = StrUtils.trimStr((Object)aRisk.get("risk_uuid"));
        if (StrUtils.isNull((Object)riskUuid)) {
            msg.setFailMsg(aRisk.get("subPolName") + "\u7684risk_uuid\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        List<Rule> ruleList = this.queryInsuranceRule(riskUuid);
        if (ruleList.isEmpty()) {
            msg.setFailMsg(aRisk.get("subPolName") + "\u4fdd\u8d39\u8ba1\u7b97\u89c4\u5219\u672a\u914d\u7f6e");
            return;
        }
        Engine engine = new Engine(ruleList);
        engine.addFunction("$prem", (Object)calcPrem);
        try {
            Object obj = null;
            if (allRisk == null) {
                obj = engine.run(aRisk);
            } else {
                aRisk.put("bbr", bbr);
                aRisk.put("allRisk", allRisk);
                obj = engine.run(aRisk);
                aRisk.remove("bbr");
                aRisk.remove("allRisk");
            }
            Ulog.info((String)JsonUtils.toJson((Object)obj));
        }
        catch (Exception e) {
            msg.setFailMsg(e.getMessage());
        }
    }

    @Override
    public ReturnMsg calcProductPremium(HttpServletRequest request) {
        Return msg = new Return();
        Map mp = RequestUtils.getRequestMap((HttpServletRequest)request);
        Date now = new Date();
        String premiumFlag = (String)mp.get("premium_flag");
        Map bbr = (Map)mp.get("bbr");
        Map tbr = (Map)mp.get("tbr");
        Map riskMap = (Map)bbr.get("riskMap");
        bbr.remove("riskMap");
        List riskList = (List)riskMap.get("value");
        List<Map<String, Object>> prdList = riskList.stream().filter(p -> !"P".equals(p.get("risk_type"))).collect(Collectors.toList());
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        if ("1".equals(premiumFlag)) {
            ReturnMsg msgcacl = this.calcPremium(bbr, tbr, prdList);
            msg.setDataList(msgcacl.getDataList());
        } else if ("2".equals(premiumFlag)) {
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            HashMap<String, Object> policy = new HashMap<String, Object>();
            ArrayList coverages = new ArrayList();
            ArrayList customers = new ArrayList();
            HashMap customerstbr = new HashMap();
            String idtbr = (String)tbr.get("party_uuid");
            customerstbr.put("gender", tbr.get("sex"));
            customerstbr.put("birthDate", tbr.get("birthdate"));
            customerstbr.put("socialSecurity", tbr.get("social_security"));
            customerstbr.put("customerId", idtbr);
            customers.add(customerstbr);
            HashMap customersbbr = new HashMap();
            String idbbr = (String)bbr.get("party_uuid");
            Integer order = (Integer)bbr.get("display_order");
            customersbbr.put("gender", bbr.get("sex"));
            customersbbr.put("birthDate", bbr.get("birthdate"));
            customersbbr.put("socialSecurity", bbr.get("social_security"));
            customersbbr.put("customerId", idbbr);
            customers.add(customersbbr);
            String validateDate = "";
            String masterId = "";
            for (Map<String, Object> coverage : prdList) {
                String riskType;
                String string = riskType = StrUtils.isNull((Object)((String)coverage.get("risk_type"))) ? "" : (String)coverage.get("risk_type");
                if (!StrUtils.isNull((Object)riskType) && !riskType.equals("") && riskType.equals("P")) continue;
                HashMap<String, Object> cov = new HashMap<String, Object>();
                String dutyType = StrUtils.isNull((Object)((String)coverage.get("duty_type"))) ? "" : (String)coverage.get("duty_type");
                if (dutyType.equals("WN")) continue;
                String payPeriod = StrUtils.isNull((Object)((String)coverage.get("pay_period"))) ? "" : (String)coverage.get("pay_period");
                String payYear = StrUtils.isNull((Object)((String)coverage.get("pay_year"))) ? "" : (String)coverage.get("pay_year");
                String endPeriod = StrUtils.isNull((Object)((String)coverage.get("payout_duration_mode"))) ? "" : (String)coverage.get("payout_duration_mode");
                String payEnsure = StrUtils.isNull((Object)((String)coverage.get("pay_ensure"))) ? "" : (String)coverage.get("pay_ensure");
                String payType = StrUtils.isNull((Object)((String)coverage.get("payout_type"))) ? "" : (String)coverage.get("payout_type");
                validateDate = StrUtils.isNull((Object)coverage.get("start_date")) ? "" : dateFmt.format(coverage.get("start_date"));
                String calcWay = StrUtils.isNull((Object)((String)coverage.get("count_way"))) ? "" : (String)coverage.get("count_way");
                String insType = StrUtils.isNull((Object)((String)coverage.get("is_main_risk"))) ? "" : (String)coverage.get("is_main_risk");
                String isWaiver = insType.equals("W") ? "Y" : "N";
                Integer unit = null;
                if (!Objects.isNull(coverage.get("intial_number_of_units")) && !coverage.get("intial_number_of_units").equals("")) {
                    unit = Integer.valueOf((String)coverage.get("intial_number_of_units"));
                }
                Double amount = null;
                if (!Objects.isNull(coverage.get("cvr_amount")) && !coverage.get("cvr_amount").equals("")) {
                    amount = Double.valueOf((String)coverage.get("cvr_amount"));
                }
                Double premium = null;
                if (!Objects.isNull(coverage.get("initial_premium")) && !coverage.get("initial_premium").equals("")) {
                    premium = Double.valueOf((String)coverage.get("initial_premium"));
                }
                Integer premiumYear = null;
                if (!Objects.isNull(coverage.get("payment_duration")) && !coverage.get("payment_duration").equals("")) {
                    premiumYear = Integer.valueOf((String)coverage.get("payment_duration"));
                }
                String chargePeriod = StrUtils.isNull((Object)((String)coverage.get("payment_duration_mode"))) ? "" : (String)coverage.get("payment_duration_mode");
                Integer chargeYear = null;
                if (!Objects.isNull(coverage.get("payment_duration")) && !coverage.get("payment_duration").equals("")) {
                    chargeYear = Integer.valueOf((String)coverage.get("payment_duration"));
                }
                String coveragePeriod = StrUtils.isNull((Object)((String)coverage.get("benefit_duration_mode"))) ? "" : (String)coverage.get("benefit_duration_mode");
                Integer coverageYear = null;
                if (!Objects.isNull(coverage.get("benefit_duration")) && !coverage.get("benefit_duration").equals("")) {
                    coverageYear = Integer.valueOf((String)coverage.get("benefit_duration"));
                }
                Integer chargeType = null;
                if (!Objects.isNull(coverage.get("charge_type")) && !coverage.get("charge_type").equals("")) {
                    chargeType = Integer.valueOf((String)coverage.get("charge_type"));
                }
                Integer benefitLevel = null;
                if (!Objects.isNull(coverage.get("premium_rate_level")) && !coverage.get("premium_rate_level").equals("")) {
                    benefitLevel = Integer.valueOf((String)coverage.get("premium_rate_level"));
                }
                String itemId = StrUtils.isNull((Object)((String)coverage.get("risk_code"))) ? "" : (String)coverage.get("risk_code");
                Integer renewal = 1;
                if (!Objects.isNull(coverage.get("renewal")) && !coverage.get("renewal").equals("")) {
                    renewal = Integer.valueOf((String)coverage.get("renewal"));
                }
                String socialSecurity = StrUtils.isNull((Object)((String)coverage.get("social_security"))) ? "" : (String)coverage.get("social_security");
                String internalId = StrUtils.isNull((Object)((String)coverage.get("policy_id"))) ? "" : (String)coverage.get("policy_id");
                String jobType = StrUtils.isNull((Object)((String)coverage.get("job_type_cls"))) ? "" : (String)coverage.get("job_type_cls");
                String nodeSeq = StrUtils.isNull((Object)((String)coverage.get("node_seq"))) ? "" : (String)coverage.get("node_seq");
                String[] nodeList = nodeSeq.split(",");
                List<String> nodeIdList = Arrays.asList(nodeList);
                BigDecimal payRate = null;
                if (!Objects.isNull(coverage.get("pay_rate")) && !coverage.get("pay_rate").equals("")) {
                    payRate = new BigDecimal((String)coverage.get("pay_rate"));
                }
                System.out.println(nodeIdList.get(1));
                if (!insType.equals("M")) {
                    masterId = nodeIdList.get(1);
                }
                cov.put("payPeriod", payPeriod);
                cov.put("payYear", payYear);
                cov.put("endPeriod", endPeriod);
                cov.put("payEnsure", payEnsure);
                cov.put("payType", payType);
                cov.put("validateDate", validateDate);
                cov.put("calcWay", calcWay.equals("3") ? "4" : calcWay);
                cov.put("insType", Integer.valueOf(mappre.get(insType)));
                cov.put("isWaiver", isWaiver);
                cov.put("unit", unit);
                cov.put("amount", amount);
                cov.put("premium", premium);
                cov.put("premiumYear", premiumYear);
                cov.put("chargePeriod", chargePeriod);
                cov.put("chargeYear", chargeYear);
                cov.put("coveragePeriod", coveragePeriod);
                cov.put("coverageYear", coverageYear);
                cov.put("chargeType", chargeType);
                cov.put("itemId", itemId);
                cov.put("masterId", masterId);
                cov.put("renewal", renewal);
                cov.put("socialSecurity", socialSecurity);
                cov.put("applyDate", dateFmt.format(now));
                cov.put("internalId", internalId);
                cov.put("payRate", payRate);
                cov.put("benefitLevel", benefitLevel);
                HashMap customersbbrjob = new HashMap();
                String idbbrjob = "";
                if (!StrUtils.isNull((Object)jobType) && !jobType.equals("")) {
                    idbbrjob = (String)bbr.get("party_uuid") + com.uniapis.utils.UUID.shortUUID();
                    customersbbrjob.put("gender", bbr.get("sex"));
                    customersbbrjob.put("birthDate", bbr.get("birthdate"));
                    customersbbrjob.put("socialSecurity", bbr.get("social_security"));
                    customersbbrjob.put("customerId", idbbrjob);
                    customersbbrjob.put("jobCate", bbr.get(mapjob.get(jobType)));
                    customers.add(customersbbrjob);
                }
                ArrayList insureds = new ArrayList();
                HashMap<String, Object> insured = new HashMap<String, Object>();
                if (customersbbrjob != null && customersbbrjob.size() > 0) {
                    insured.put("customerId", idbbrjob);
                } else {
                    insured.put("customerId", idbbr);
                }
                insured.put("insuredSeq", order);
                insureds.add(insured);
                cov.put("insureds", insureds);
                coverages.add(cov);
            }
            if (coverages.size() > 0) {
                policy.put("customers", customers);
                policy.put("coverages", coverages);
                policy.put("applyDate", dateFmt.format(now));
                policy.put("validateDate", validateDate);
                bodyMap.put("policy", policy);
                bodyMap.put("requestTime", now);
                bodyMap.put("calcType", "1");
                bodyMap.put("requestId", UUID.randomUUID());
                String resultStr = "";
                SysTradeLog sysTradeLog = new SysTradeLog();
                String transno = com.uniapis.utils.UUID.shortUUID();
                sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentBFJS.getType());
                sysTradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
                sysTradeLog.setParamData(JsonUtils.toJson(bodyMap));
                sysTradeLog.setTransNo(transno);
                sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
                this.insertSysETradeLog(sysTradeLog);
                resultStr = HttpUtils.jsonPost((String)this.caclUrl, (String)JsonUtils.toJson(bodyMap));
                Map result = JsonUtils.json2Map((String)resultStr);
                sysTradeLog.setParamData(resultStr);
                sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
                this.insertSysETradeLog(sysTradeLog);
                boolean success = (Boolean)result.get("success");
                if (!success) {
                    List messages = new ArrayList();
                    messages = (List)result.get("messages");
                    ArrayList<Message> fail = new ArrayList<Message>();
                    for (String o : messages) {
                        Message m = new Message();
                        System.out.println(o);
                        m.setMsgRemark(o);
                        fail.add(m);
                    }
                    msg.setFailMsg(fail);
                    return msg.msg();
                }
                Map date = (Map)result.get("result");
                List rescoverages = new ArrayList();
                Map respolicy = new HashMap();
                respolicy = (Map)date.get("policy");
                rescoverages = (List)respolicy.get("coverages");
                for (Map<String, Object> coverage : prdList) {
                    String dutyType = StrUtils.isNull((Object)((String)coverage.get("duty_type"))) ? "" : (String)coverage.get("duty_type");
                    if (dutyType.equals("WN")) continue;
                    String internalId = StrUtils.isNull((Object)((String)coverage.get("policy_id"))) ? "" : (String)coverage.get("policy_id");
                    for (Map factory : rescoverages) {
                        String riskno = StrUtils.isNull((Object)((String)factory.get("internalId"))) ? "" : (String)factory.get("internalId");
                        if (StrUtils.isNull((Object)riskno) || riskno.equals("") || !internalId.equals(riskno)) continue;
                        coverage.put("initial_premium", factory.get("premium"));
                        coverage.put("cvr_amount", factory.get("amount"));
                    }
                }
            }
            this.sumPremiumFactory(prdList);
            msg.setDataList(prdList);
        }
        return msg.msg();
    }

    public void insertSysETradeLog(SysTradeLog entry) {
        SysTradeLog sysTradeLogin = new SysTradeLog();
        sysTradeLogin.setBusinessId(com.uniapis.utils.UUID.shortUUID());
        if (!StrUtils.isNull((Object)entry.getCrtUser())) {
            ThreadLocalContext.get().getUser().setPkUuid(entry.getCrtUser());
        } else {
            ThreadLocalContext.get().getUser().setPkUuid("login_user");
        }
        if (StrUtils.isNull((Object)entry.getTransNo())) {
            throw new BusinessException("\u63a5\u53e3\u7c7b\u578b\u5173\u8054\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysTradeLogin.setTransNo(entry.getTransNo());
        if (StrUtils.isNull((Object)entry.getInterfaceNo())) {
            throw new BusinessException("\u63a5\u53e3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysTradeLogin.setInterfaceNo(entry.getInterfaceNo());
        if (StrUtils.isNull((Object)entry.getSystemNo())) {
            throw new BusinessException("\u5bf9\u63a5\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysTradeLogin.setSystemNo(entry.getSystemNo());
        if (StrUtils.isNull((Object)entry.getParamData())) {
            throw new BusinessException("\u5bf9\u63a5\u63a5\u53e3\u5165\u53c2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysTradeLogin.setParamData(entry.getParamData());
        if (StrUtils.isNull((Object)entry.getParamType())) {
            throw new BusinessException("\u5bf9\u63a5\u63a5\u53e3\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysTradeLogin.setParamType(entry.getParamType());
        if (!StrUtils.isNull((Object)entry.getAgentId())) {
            sysTradeLogin.setAgentId(entry.getAgentId());
        }
        Ulog.info((String)JsonUtils.toJson((Object)((Object)sysTradeLogin)));
        String msgProduct = "";
        HashMap<String, SysTradeLog> param = new HashMap<String, SysTradeLog>();
        param.put("sys_trade_log", sysTradeLogin);
        msgProduct = HttpUtils.jsonPost((String)this.insertLog, (String)JsonUtils.toJson(param));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReturnMsg calcProductPremiumList(HttpServletRequest request) {
        Return msg = new Return();
        Map mp = RequestUtils.getRequestMap((HttpServletRequest)request);
        Date now = new Date();
        String premiumFlag = (String)mp.get("premium_flag");
        List bbr = (List)mp.get("bbr");
        Map tbr = (Map)mp.get("tbr");
        Ulog.info((String)("\u4fdd\u8d39\u8ba1\u7b97\u63a5\u53e3\u5f00\u59cb" + (String)tbr.get("party_uuid")));
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        if ("2".equals(premiumFlag)) {
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            HashMap<String, Object> policy = new HashMap<String, Object>();
            List<Object> coverages = new ArrayList();
            ArrayList customers = new ArrayList();
            HashMap customerstbr = new HashMap();
            String idtbr = (String)tbr.get("party_uuid");
            customerstbr.put("gender", tbr.get("sex"));
            customerstbr.put("birthDate", tbr.get("birthdate"));
            customerstbr.put("socialSecurity", tbr.get("social_security"));
            customerstbr.put("customerId", idtbr);
            customers.add(customerstbr);
            String validateDate = "";
            String deWeight = "N";
            for (Map customer : bbr) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                String idbbr = (String)customer.get("party_uuid");
                Integer order = (Integer)customer.get("display_order");
                Integer age = (Integer)customer.get("age");
                hashMap.put("age", age);
                hashMap.put("gender", customer.get("sex"));
                hashMap.put("birthDate", customer.get("birthdate"));
                hashMap.put("socialSecurity", customer.get("social_security"));
                hashMap.put("customerId", idbbr);
                customers.add(hashMap);
                Map riskMap = (Map)customer.get("riskMap");
                if (riskMap == null) continue;
                String ismerge = StrUtils.isNull(customer.get("ismerge_checked")) ? "" : (String)customer.get("ismerge_checked");
                riskMap.remove("disabled");
                riskMap.remove("hidden");
                riskMap.remove("message");
                riskMap.remove("optional");
                List riskList = (List)riskMap.get("value");
                List prdList = riskList.stream().filter(p -> !"P".equals(p.get("risk_type"))).collect(Collectors.toList());
                String masterId = "";
                Map covlate = new HashMap();
                for (Object coverage : prdList) {
                    String dutyType;
                    String riskType;
                    String string = riskType = StrUtils.isNull((Object)((String)coverage.get("risk_type"))) ? "" : (String)coverage.get("risk_type");
                    if (!StrUtils.isNull((Object)riskType) && !riskType.equals("") && riskType.equals("P") || (dutyType = StrUtils.isNull((Object)((String)coverage.get("duty_type"))) ? "" : (String)coverage.get("duty_type")).equals("WN")) continue;
                    String mergeCalcFlag = StrUtils.isNull((Object)((String)coverage.get("merge_calc_flag"))) ? "" : (String)coverage.get("merge_calc_flag");
                    String string2 = StrUtils.isNull((Object)((String)coverage.get("policy_id"))) ? "" : (String)coverage.get("policy_id");
                    String jobType = StrUtils.isNull((Object)((String)coverage.get("job_type_cls"))) ? "" : (String)coverage.get("job_type_cls");
                    int n = 0;
                    if (mergeCalcFlag.equals("Y")) {
                        for (Map map2 : coverages) {
                            String riskcode = (String)map2.get("internalId");
                            if (!string2.equals(riskcode)) continue;
                            if (!StrUtils.isNull((Object)jobType) && !jobType.equals("")) {
                                hashMap.put("jobCate", bbr.get(Integer.parseInt(mapjob.get(jobType))));
                            }
                            List insureds = new ArrayList();
                            insureds = (List)map2.get("insureds");
                            HashMap<String, Object> insured = new HashMap<String, Object>();
                            insured.put("customerId", idbbr);
                            insured.put("insuredSeq", order);
                            insureds.add(insured);
                            ++n;
                            if (StrUtils.isNull((Object)ismerge) || ismerge.equals("") || !ismerge.equals("Y")) continue;
                            deWeight = "Y";
                            covlate = map2;
                            n = 100;
                        }
                    }
                    if (n != 0 && n != 100) continue;
                    String payPeriod = StrUtils.isNull((Object)((String)coverage.get("pay_period"))) ? "" : (String)coverage.get("pay_period");
                    String string3 = StrUtils.isNull((Object)((String)coverage.get("pay_year"))) ? "" : (String)coverage.get("pay_year");
                    String endPeriod = StrUtils.isNull((Object)((String)coverage.get("payout_duration_mode"))) ? "" : (String)coverage.get("payout_duration_mode");
                    Integer endYear = null;
                    if (!Objects.isNull(coverage.get("payout_duration")) && !StrUtils.isNull(coverage.get("payout_duration"))) {
                        endYear = Integer.valueOf(StrUtils.trimStr(coverage.get("payout_duration")));
                    }
                    String payEnsure = StrUtils.isNull((Object)((String)coverage.get("pay_ensure"))) ? "" : (String)coverage.get("pay_ensure");
                    String payType = StrUtils.isNull((Object)((String)coverage.get("payout_type"))) ? "" : (String)coverage.get("payout_type");
                    validateDate = StrUtils.isNull(coverage.get("start_date")) ? "" : dateFmt.format(coverage.get("start_date"));
                    String calcWay = StrUtils.isNull((Object)((String)coverage.get("count_way"))) ? "" : (String)coverage.get("count_way");
                    String insType = StrUtils.isNull((Object)((String)coverage.get("is_main_risk"))) ? "" : (String)coverage.get("is_main_risk");
                    String isWaiver = insType.equals("W") ? "Y" : "N";
                    Integer unit = null;
                    if (!Objects.isNull(coverage.get("intial_number_of_units")) && !coverage.get("intial_number_of_units").equals("")) {
                        unit = Integer.valueOf((String)coverage.get("intial_number_of_units"));
                    }
                    Double amount = null;
                    if (!Objects.isNull(coverage.get("cvr_amount")) && !coverage.get("cvr_amount").equals("")) {
                        amount = Double.valueOf((String)coverage.get("cvr_amount"));
                    }
                    Double premium = null;
                    if (!Objects.isNull(coverage.get("initial_premium")) && !coverage.get("initial_premium").equals("")) {
                        premium = Double.valueOf((String)coverage.get("initial_premium"));
                    }
                    Integer premiumYear = null;
                    if (!Objects.isNull(coverage.get("payment_duration")) && !coverage.get("payment_duration").equals("")) {
                        premiumYear = Integer.valueOf((String)coverage.get("payment_duration"));
                    }
                    String chargePeriod = StrUtils.isNull((Object)((String)coverage.get("payment_duration_mode"))) ? "" : (String)coverage.get("payment_duration_mode");
                    Integer chargeYear = null;
                    if (!Objects.isNull(coverage.get("payment_duration")) && !coverage.get("payment_duration").equals("")) {
                        chargeYear = Integer.valueOf((String)coverage.get("payment_duration"));
                    }
                    String coveragePeriod = StrUtils.isNull((Object)((String)coverage.get("benefit_duration_mode"))) ? "" : (String)coverage.get("benefit_duration_mode");
                    Integer coverageYear = null;
                    if (!Objects.isNull(coverage.get("benefit_duration")) && !coverage.get("benefit_duration").equals("")) {
                        coverageYear = Integer.valueOf((String)coverage.get("benefit_duration"));
                    }
                    Integer chargeType = null;
                    if (!Objects.isNull(coverage.get("charge_type")) && !coverage.get("charge_type").equals("")) {
                        chargeType = Integer.valueOf((String)coverage.get("charge_type"));
                    }
                    Integer benefitLevel = null;
                    if (!Objects.isNull(coverage.get("scheme")) && !coverage.get("scheme").equals("")) {
                        benefitLevel = Integer.valueOf((String)coverage.get("scheme"));
                    }
                    Integer renewal = 1;
                    if (!Objects.isNull(coverage.get("renewal")) && !coverage.get("renewal").equals("")) {
                        renewal = Integer.valueOf((String)coverage.get("renewal"));
                    }
                    String socialSecurity = StrUtils.isNull((Object)((String)coverage.get("social_security"))) ? "" : (String)coverage.get("social_security");
                    String nodeSeq = StrUtils.isNull((Object)((String)coverage.get("node_seq"))) ? "" : (String)coverage.get("node_seq");
                    String[] nodeList = nodeSeq.split(",");
                    List<String> nodeIdList = Arrays.asList(nodeList);
                    BigDecimal payRateInt = null;
                    BigDecimal payRate = null;
                    if (!Objects.isNull(coverage.get("pay_rate")) && !coverage.get("pay_rate").equals("")) {
                        payRateInt = new BigDecimal((String)coverage.get("pay_rate"));
                        payRate = payRateInt.divide(BigDecimal.valueOf(100L));
                    }
                    Integer insuredNum = null;
                    if (!Objects.isNull(coverage.get("insured_num")) && !coverage.get("insured_num").equals("")) {
                        insuredNum = Integer.valueOf((String)coverage.get("insured_num"));
                    }
                    String waiverPartyUuid = StrUtils.isNull((Object)((String)coverage.get("waiver_party_uuid"))) ? "" : (String)coverage.get("waiver_party_uuid");
                    String itemId = null;
                    itemId = !StrUtils.isNull((Object)waiverPartyUuid) && !waiverPartyUuid.equals("") ? string2 + "," + nodeIdList.get(1) + "," + waiverPartyUuid : (riskType.equals("A") ? string2 + "," + nodeIdList.get(1) + "," + idbbr : string2 + "," + idbbr);
                    BigDecimal exceptValue = null;
                    if (!Objects.isNull(coverage.get("except_value")) && !coverage.get("except_value").equals("")) {
                        exceptValue = new BigDecimal((String)coverage.get("except_value"));
                    }
                    String internalIdmas = "";
                    if (!insType.equals("M")) {
                        internalIdmas = nodeIdList.get(1);
                        for (Map map3 : coverages) {
                            String riskcode = (String)map3.get("internalId");
                            if (!internalIdmas.equals(riskcode)) continue;
                            masterId = (String)map3.get("itemId");
                        }
                    }
                    String waivedItem = "";
                    String string4 = "";
                    if (isWaiver.equals("Y")) {
                        int index = nodeIdList.indexOf(string2);
                        if (index != -1) {
                            String string5 = nodeIdList.get(index - 1);
                        }
                        for (Map map4 : coverages) {
                            void var69_99;
                            String riskcode = (String)map4.get("internalId");
                            if (!var69_99.equals(riskcode)) continue;
                            waivedItem = (String)map4.get("itemId");
                            String upRiskType = (String)map4.get("risk_type");
                            if (!upRiskType.equals("A")) continue;
                            itemId = itemId + "," + (String)var69_99 + "," + (String)map4.get("party_uuid");
                        }
                    }
                    HashMap<String, Object> cov = new HashMap<String, Object>((Map<String, Object>)coverage);
                    cov.put("payPeriod", payPeriod);
                    cov.put("payYear", string3);
                    cov.put("endPeriod", endPeriod);
                    cov.put("payEnsure", payEnsure);
                    if (!StrUtils.isNull((Object)string3) && !StrUtils.isNull((Object)payEnsure)) {
                        int payEnsure2 = Integer.valueOf(StrUtils.trimStr((Object)payEnsure)) - Integer.valueOf(StrUtils.trimStr((Object)string3));
                        if (!StrUtils.isNull((Object)payEnsure2) && payEnsure2 > 0) {
                            cov.put("payEnsure", String.valueOf(payEnsure2));
                        } else {
                            cov.put("payEnsure", payEnsure);
                        }
                    } else {
                        cov.put("payEnsure", payEnsure);
                    }
                    cov.put("payType", payType);
                    cov.put("validateDate", validateDate);
                    cov.put("calcWay", calcWay.equals("3") ? "4" : calcWay);
                    cov.put("insType", insType.equals("M") ? 1 : 2);
                    cov.put("isWaiver", isWaiver);
                    cov.put("unit", unit);
                    cov.put("amount", amount);
                    cov.put("premium", premium);
                    cov.put("premiumYear", premiumYear);
                    cov.put("chargePeriod", chargePeriod);
                    cov.put("chargeYear", chargeYear);
                    cov.put("coveragePeriod", coveragePeriod);
                    cov.put("coverageYear", coverageYear);
                    cov.put("chargeType", chargeType);
                    cov.put("itemId", itemId);
                    cov.put("masterId", masterId);
                    cov.put("renewal", renewal);
                    cov.put("socialSecurity", socialSecurity);
                    cov.put("applyDate", dateFmt.format(now));
                    cov.put("internalId", string2);
                    cov.put("payRate", payRate);
                    cov.put("benefitLevel", benefitLevel);
                    cov.put("insuredNum", insuredNum);
                    cov.put("waivedItem", waivedItem);
                    cov.put("exceptValue", exceptValue);
                    cov.put("ismerge", ismerge);
                    cov.put("bbr", idbbr);
                    cov.put("endYear", endYear);
                    if (!StrUtils.isNull((Object)ismerge) && !ismerge.equals("") && ismerge.equals("Y") && n == 100 && covlate != null) {
                        List insureds = new ArrayList();
                        insureds = (List)covlate.get("insureds");
                        cov.put("insureds", insureds);
                        coverages.remove(covlate);
                        coverages.add(cov);
                        continue;
                    }
                    HashMap<String, Object> customersbbrjob = new HashMap<String, Object>();
                    String string6 = "";
                    if (!StrUtils.isNull((Object)jobType) && !jobType.equals("")) {
                        void var72_115;
                        if (!StrUtils.isNull((Object)waiverPartyUuid)) {
                            String string7 = waiverPartyUuid + com.uniapis.utils.UUID.shortUUID();
                        } else {
                            String string8 = idbbr + com.uniapis.utils.UUID.shortUUID();
                        }
                        Integer agejob = (Integer)customer.get("age");
                        customersbbrjob.put("age", agejob);
                        customersbbrjob.put("gender", customer.get("sex"));
                        customersbbrjob.put("birthDate", customer.get("birthdate"));
                        customersbbrjob.put("socialSecurity", customer.get("social_security"));
                        customersbbrjob.put("customerId", var72_115);
                        customersbbrjob.put("jobCate", customer.get(mapjob.get(jobType)));
                        customers.add(customersbbrjob);
                    }
                    ArrayList insureds = new ArrayList();
                    HashMap<String, Object> insured = new HashMap<String, Object>();
                    if (customersbbrjob != null && customersbbrjob.size() > 0) {
                        void var72_116;
                        insured.put("customerId", var72_116);
                    } else if (!StrUtils.isNull((Object)waiverPartyUuid)) {
                        insured.put("customerId", waiverPartyUuid);
                    } else {
                        insured.put("customerId", idbbr);
                    }
                    insured.put("insuredSeq", "1");
                    insureds.add(insured);
                    cov.put("insureds", insureds);
                    coverages.add(cov);
                }
            }
            if (coverages.size() > 0) {
                List isWaiverList = coverages.stream().filter(p -> p.get("isWaiver").equals("Y")).collect(Collectors.toList());
                coverages = coverages.stream().filter(p -> !p.get("isWaiver").equals("Y")).collect(Collectors.toList());
                if (isWaiverList.size() > 0) {
                    if (deWeight.equals("N")) {
                        isWaiverList = isWaiverList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(map -> map.get("itemId"), Function.identity(), (existing, replacement) -> existing), map -> new ArrayList(map.values())));
                    } else {
                        ArrayList deleteWaiverList = new ArrayList();
                        for (Map riskWaiver : isWaiverList) {
                            String itemId1 = (String)riskWaiver.get("itemId");
                            String ismerge1 = (String)riskWaiver.get("ismerge");
                            String partyUuid1 = (String)riskWaiver.get("bbr");
                            for (Map riskWaiver2 : isWaiverList) {
                                Object coverage;
                                String itemId2 = (String)riskWaiver2.get("itemId");
                                String ismerge2 = (String)riskWaiver2.get("ismerge");
                                String partyUuid2 = (String)riskWaiver2.get("bbr");
                                if (!itemId1.equals(itemId2) || partyUuid1.equals(partyUuid2)) continue;
                                if (!StrUtils.isNull((Object)ismerge1) && !ismerge1.equals("") && ismerge1.equals("Y")) {
                                    deleteWaiverList.add(riskWaiver2);
                                    continue;
                                }
                                int countWaiver = 0;
                                coverage = deleteWaiverList.iterator();
                                while (coverage.hasNext()) {
                                    Map risk = (Map)coverage.next();
                                    String itemIdWaiver = (String)risk.get("itemId");
                                    if (!itemId1.equals(itemIdWaiver)) continue;
                                    ++countWaiver;
                                }
                                if (countWaiver <= 0) continue;
                                deleteWaiverList.add(riskWaiver2);
                            }
                        }
                        if (deleteWaiverList != null && deleteWaiverList.size() > 0) {
                            Iterator iterator = deleteWaiverList.iterator();
                            while (iterator.hasNext()) {
                                Map waiverrisk = (Map)iterator.next();
                                isWaiverList.remove(waiverrisk);
                            }
                        }
                    }
                    coverages.addAll(isWaiverList);
                }
                for (Map map5 : coverages) {
                    void var34_51;
                    String riskcode;
                    String mergeCalcFlag = StrUtils.isNull((Object)((String)map5.get("merge_calc_flag"))) ? "" : (String)map5.get("merge_calc_flag");
                    List insureds = new ArrayList();
                    insureds = (List)map5.get("insureds");
                    Integer insuredsum = insureds.size();
                    if (mergeCalcFlag.equals("Y") && insuredsum == 2) {
                        Map insured1 = (Map)insureds.get(0);
                        Map insured2 = (Map)insureds.get(1);
                        String id1 = (String)insured1.get("customerId");
                        String id2 = (String)insured2.get("customerId");
                        Map id1patry = customers.stream().filter(map -> id1.equals(map.get("customerId"))).findFirst().orElse(null);
                        Map id2patry = customers.stream().filter(map -> id2.equals(map.get("customerId"))).findFirst().orElse(null);
                        String gender1 = (String)id1patry.get("gender");
                        String gender2 = (String)id2patry.get("gender");
                        Integer age1 = (Integer)id1patry.get("age");
                        Integer age2 = (Integer)id2patry.get("age");
                        if (!gender1.equals(gender2)) {
                            if (gender1.equals("F")) {
                                insured1.put("insuredSeq", "1");
                                insured2.put("insuredSeq", "2");
                            } else {
                                insured1.put("insuredSeq", "2");
                                insured2.put("insuredSeq", "1");
                            }
                        } else if (age1 < age2) {
                            insured1.put("insuredSeq", "1");
                            insured2.put("insuredSeq", "2");
                        } else {
                            insured1.put("insuredSeq", "2");
                            insured2.put("insuredSeq", "1");
                        }
                    }
                    String isWaiver = StrUtils.isNull((Object)((String)map5.get("isWaiver"))) ? "" : (String)map5.get("isWaiver");
                    String internalId = StrUtils.isNull((Object)((String)map5.get("internalId"))) ? "" : (String)map5.get("internalId");
                    String partyUuid = StrUtils.isNull((Object)((String)map5.get("party_uuid"))) ? "" : (String)map5.get("party_uuid");
                    Integer insType = (Integer)map5.get("insType");
                    String internalIdwai = "";
                    String waivedItem = "";
                    String nodeSeq = StrUtils.isNull((Object)((String)map5.get("node_seq"))) ? "" : (String)map5.get("node_seq");
                    String[] nodeList = nodeSeq.split(",");
                    List<String> nodeIdList = Arrays.asList(nodeList);
                    int index = nodeIdList.indexOf(internalId);
                    if (isWaiver.equals("Y")) {
                        if (index != -1) {
                            internalIdwai = nodeIdList.get(index - 1);
                        }
                        for (Map map6 : coverages) {
                            String string;
                            String isWaiver2 = StrUtils.isNull((Object)((String)map6.get("isWaiver"))) ? "" : (String)map6.get("isWaiver");
                            String string9 = string = StrUtils.isNull((Object)((String)map6.get("risk_type"))) ? "" : (String)map6.get("risk_type");
                            if (isWaiver2.equals("Y")) continue;
                            riskcode = (String)map6.get("internalId");
                            String string10 = (String)map6.get("party_uuid");
                            if (internalIdwai.equals(riskcode) && !string.equals("A")) {
                                waivedItem = (String)map6.get("itemId");
                                continue;
                            }
                            if (!internalIdwai.equals(riskcode) || !string.equals("A") || !partyUuid.equals(string10)) continue;
                            waivedItem = (String)map6.get("itemId");
                        }
                        map5.put("waivedItem", waivedItem);
                    }
                    if (!mergeCalcFlag.equals("Y") || insuredsum != 2) continue;
                    String internalIdmas = "";
                    String string = "";
                    if (!insType.equals(1)) {
                        internalIdmas = nodeIdList.get(1);
                        for (Map map7 : coverages) {
                            riskcode = (String)map7.get("internalId");
                            if (!internalIdmas.equals(riskcode)) continue;
                            String string11 = (String)map7.get("itemId");
                        }
                    }
                    map5.put("masterId", var34_51);
                }
                policy.put("customers", customers);
                policy.put("coverages", coverages);
                policy.put("applyDate", dateFmt.format(now));
                policy.put("validateDate", validateDate);
                bodyMap.put("policy", policy);
                bodyMap.put("requestTime", now);
                bodyMap.put("calcType", "1");
                bodyMap.put("needStream", "Y");
                bodyMap.put("requestId", UUID.randomUUID());
                String resultStr = "";
                SysTradeLog sysTradeLog = new SysTradeLog();
                String transno = com.uniapis.utils.UUID.shortUUID();
                sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentBFJS.getType());
                sysTradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
                sysTradeLog.setParamData(JsonUtils.toJson(bodyMap));
                sysTradeLog.setTransNo(transno);
                sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
                this.insertSysETradeLog(sysTradeLog);
                sysTradeLog.setParamData(JsonUtils.toJson((Object)mp));
                this.insertSysETradeLog(sysTradeLog);
                Ulog.info((String)("\u4fdd\u8d39\u8ba1\u7b97\u63a5\u53e3\u8c03\u4ea7\u54c1\u5de5\u5382\u5f00\u59cb" + idtbr));
                resultStr = HttpUtils.jsonPost((String)this.caclUrl, (String)JsonUtils.toJson(bodyMap));
                Ulog.info((String)("\u4fdd\u8d39\u8ba1\u7b97\u63a5\u53e3\u8c03\u4ea7\u54c1\u5de5\u5382\u7ed3\u675f" + idtbr));
                sysTradeLog.setParamData(resultStr);
                sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
                this.insertSysETradeLog(sysTradeLog);
                Map result = JsonUtils.json2Map((String)resultStr);
                boolean success = (Boolean)result.get("success");
                if (!success) {
                    List messages = new ArrayList();
                    messages = (List)result.get("messages");
                    ArrayList<Message> fail = new ArrayList<Message>();
                    for (String o : messages) {
                        Message m = new Message();
                        m.setMsgRemark(o);
                        fail.add(m);
                    }
                    msg.setFailMsg(fail);
                    return msg.msg();
                }
                Map date = (Map)result.get("result");
                List rescoverages = new ArrayList();
                Map respolicy = new HashMap();
                respolicy = (Map)date.get("policy");
                rescoverages = (List)respolicy.get("coverages");
                for (Map custom : bbr) {
                    String idbbr = (String)custom.get("party_uuid");
                    Map riskMap = (Map)custom.get("riskMap");
                    if (StrUtils.isNull((Object)riskMap)) continue;
                    List riskList = (List)riskMap.get("value");
                    for (Map peizhi : riskList) {
                        String string;
                        String riskType;
                        String internalId = StrUtils.isNull((Object)((String)peizhi.get("policy_id"))) ? "" : (String)peizhi.get("policy_id");
                        String string12 = StrUtils.isNull((Object)((String)peizhi.get("duty_type"))) ? "" : (String)peizhi.get("duty_type");
                        String string13 = riskType = StrUtils.isNull((Object)((String)peizhi.get("risk_type"))) ? "" : (String)peizhi.get("risk_type");
                        if (string12.equals("WN")) continue;
                        String string14 = string = StrUtils.isNull((Object)((String)peizhi.get("node_seq"))) ? "" : (String)peizhi.get("node_seq");
                        if (!StrUtils.isNull((Object)riskType) && !riskType.equals("") && riskType.equals("P")) continue;
                        String[] nodeListWai = string.split(",");
                        List<String> list = Arrays.asList(nodeListWai);
                        String internalIdmas = "";
                        internalIdmas = list.get(1);
                        String waiverPartyUuid = StrUtils.isNull((Object)((String)peizhi.get("waiver_party_uuid"))) ? "" : (String)peizhi.get("waiver_party_uuid");
                        String parentNodeSeq = StrUtils.isNull((Object)((String)peizhi.get("parent_node_seq"))) ? "" : (String)peizhi.get("parent_node_seq");
                        String[] nodeList = parentNodeSeq.split(",");
                        List<String> nodeIdList = Arrays.asList(nodeList);
                        String internalIdwai = nodeIdList.get(nodeIdList.size() - 1);
                        for (Map factory : rescoverages) {
                            String riskno = StrUtils.isNull((Object)((String)factory.get("internalId"))) ? "" : (String)factory.get("internalId");
                            String waivedItem = StrUtils.isNull((Object)((String)factory.get("waivedItem"))) ? "" : (String)factory.get("waivedItem");
                            String itemId = StrUtils.isNull((Object)((String)factory.get("itemId"))) ? "" : (String)factory.get("itemId");
                            String[] itemIdList = itemId.split(",");
                            List<String> itemIdIdList = Arrays.asList(itemIdList);
                            String patryUuid2 = itemIdIdList.get(itemIdIdList.size() - 1);
                            String upRisk = itemIdIdList.get(1);
                            List insureds = (List)factory.get("insureds");
                            for (Map insured : insureds) {
                                String customeridchu = (String)insured.get("customerId");
                                Integer cuslength = 0;
                                List<Object> topList = new ArrayList();
                                Map top = new HashMap();
                                String risknoTop = "";
                                Integer insType = null;
                                if (!StrUtils.isNull((Object)waiverPartyUuid)) {
                                    cuslength = waiverPartyUuid.length();
                                    if (!StrUtils.isNull((Object)waivedItem)) {
                                        topList = rescoverages.stream().filter(p -> p.get("itemId").equals(waivedItem)).collect(Collectors.toList());
                                        top = (Map)topList.get(0);
                                        risknoTop = StrUtils.isNull((Object)((String)top.get("internalId"))) ? "" : (String)top.get("internalId");
                                        insType = StrUtils.isNull(top.get("insType")) ? null : (Integer)top.get("insType");
                                    }
                                } else {
                                    cuslength = idbbr.length();
                                }
                                String customerid = null;
                                customerid = customeridchu.length() >= cuslength ? customeridchu.substring(0, cuslength) : customeridchu;
                                if (!StrUtils.isNull((Object)riskno) && !riskno.equals("") && StrUtils.isNull((Object)waiverPartyUuid) && internalId.equals(riskno) && customerid.equals(idbbr) && !riskType.equals("A")) {
                                    peizhi.put("initial_premium", factory.get("premium"));
                                    peizhi.put("cvr_amount", factory.get("amount"));
                                    continue;
                                }
                                if (!StrUtils.isNull((Object)riskno) && !riskno.equals("") && StrUtils.isNull((Object)waiverPartyUuid) && internalId.equals(riskno) && customerid.equals(idbbr) && riskType.equals("A") && internalIdmas.equals(upRisk)) {
                                    peizhi.put("initial_premium", factory.get("premium"));
                                    peizhi.put("cvr_amount", factory.get("amount"));
                                    continue;
                                }
                                if (!StrUtils.isNull((Object)riskno) && !riskno.equals("") && !StrUtils.isNull((Object)waiverPartyUuid) && internalId.equals(riskno) && customerid.equals(waiverPartyUuid) && internalIdwai.equals(risknoTop) && insType.equals(1)) {
                                    peizhi.put("initial_premium", factory.get("premium"));
                                    peizhi.put("cvr_amount", factory.get("amount"));
                                    continue;
                                }
                                if (StrUtils.isNull((Object)riskno) || riskno.equals("") || StrUtils.isNull((Object)waiverPartyUuid) || !internalId.equals(riskno) || !customerid.equals(waiverPartyUuid) || !internalIdwai.equals(risknoTop) || insType.equals(1) || !patryUuid2.equals(idbbr)) continue;
                                peizhi.put("initial_premium", factory.get("premium"));
                                peizhi.put("cvr_amount", factory.get("amount"));
                            }
                        }
                    }
                    this.sumPremiumFactory(riskList);
                }
            }
            msg.setDataList(bbr);
        }
        Ulog.info((String)("\u4fdd\u8d39\u8ba1\u7b97\u63a5\u53e3\u7ed3\u675f" + (String)tbr.get("party_uuid")));
        return msg.msg();
    }

    private void maxAmount() {
    }

    private void sumPremiumFactory(List<Map<String, Object>> riskList) {
        riskList.stream().collect(Collectors.groupingBy(map -> StrUtils.trimStr(map.get("polCode")))).forEach((polCode, listMap) -> {
            Map risks = listMap.stream().reduce(new HashMap(), (map1, map2) -> {
                HashMap<String, String> map = new HashMap<String, String>();
                Object map1Prem = Stream.of(map1.get("initial_premium"), "0").filter(v -> !StrUtils.isNull((Object)v)).findFirst().get();
                Object map2Prem = Stream.of(map2.get("initial_premium"), "0").filter(v -> !StrUtils.isNull((Object)v)).findFirst().get();
                BigDecimal a = new BigDecimal(map1Prem.toString());
                BigDecimal b = new BigDecimal(map2Prem.toString());
                map.put("premium", a.add(b).toString());
                String cvrAmount = Stream.of(StrUtils.trimStr(map1.get("cvr_amount")), StrUtils.trimStr(map2.get("cvr_amount")), "0").filter(v -> !StrUtils.isNull((Object)v)).max(Comparator.comparing(Double::parseDouble)).get();
                map.put("cvrAmount", cvrAmount);
                return map;
            });
            HashMap mainRisk = new HashMap();
            mainRisk.put("mainRiskCode", risks.get("mainRiskCode"));
            mainRisk.put("totalAmnt", risks.get("cvrAmount"));
            mainRisk.put("totalPrem", risks.get("premium"));
            mainRisk.put("polCode", risks.get("polCode"));
            riskList.add(mainRisk);
        });
    }

    private void sumPremium(List<Map<String, Object>> riskList) {
        riskList.stream().collect(Collectors.groupingBy(map -> StrUtils.trimStr(map.get("polCode")))).forEach((polCode, listMap) -> {
            Map risks = listMap.stream().reduce(new HashMap(), (map1, map2) -> {
                HashMap<String, String> map = new HashMap<String, String>();
                Object map1Prem = Stream.of(map1.get("premium"), map1.get("initial_premium"), "0").filter(v -> !StrUtils.isNull((Object)v)).findFirst().get();
                Object map2Prem = Stream.of(map2.get("premium"), map2.get("initial_premium"), "0").filter(v -> !StrUtils.isNull((Object)v)).findFirst().get();
                BigDecimal a = new BigDecimal(map1Prem.toString());
                BigDecimal b = new BigDecimal(map2Prem.toString());
                map.put("premium", a.add(b).toString());
                String faceAmnt = Stream.of(StrUtils.trimStr(map1.get("faceAmnt")), StrUtils.trimStr(map1.get("insured_amount")), StrUtils.trimStr(map2.get("faceAmnt")), StrUtils.trimStr(map2.get("insured_amount")), "0").filter(v -> !StrUtils.isNull((Object)v)).max(Comparator.comparing(Double::parseDouble)).get();
                map.put("faceAmnt", faceAmnt);
                return map;
            });
            HashMap mainRisk = new HashMap();
            mainRisk.put("mainRiskCode", risks.get("mainRiskCode"));
            mainRisk.put("totalAmnt", risks.get("faceAmnt"));
            mainRisk.put("totalPrem", risks.get("premium"));
            mainRisk.put("polCode", risks.get("polCode"));
            riskList.add(mainRisk);
        });
    }

    private List<Rule> queryInsuranceRule(String riskUuid) {
        DsnStructure xianZhongXinXi = new DsnStructure(true);
        xianZhongXinXi.setNodeNo(riskUuid);
        xianZhongXinXi = (DsnStructure)this.dao.findOne((AbsModel)xianZhongXinXi);
        DsnStructure xianZhongGuiZe = this.findNode4UpNode(xianZhongXinXi.getUpNode(), "n_rule");
        List structureRulesList = this.dao.findAll(DsnStructureRules.n().where().addEq(DsnStructureRules.NODE_NO, (Object)xianZhongGuiZe.getNodeNo()).addEq(DsnStructureRules.STATUS, (Object)"1").addEq(DsnStructureRules.EVENT_TYPE, (Object)"fee_rule").model());
        ArrayList<DsnRules> ruleList = new ArrayList<DsnRules>();
        for (DsnStructureRules guiZe : structureRulesList) {
            String ruleId = "Y".equals(guiZe.getIsQuote()) ? guiZe.getQuoteRuleId() : guiZe.getRuleId();
            ReturnMsg msg = this.ruleUsedService.queryRuleInfoByRuleId(ruleId);
            if (!msg.isSuccessflag()) {
                throw new BusinessException((Message)msg.getMsgList().get(0));
            }
            DsnRules dsnRules = (DsnRules)msg.getDataTable().get("dsn_rules");
            String ruleInfo = dsnRules.getRuleInfo().replaceAll(",\\[null\\]", "");
            dsnRules.setRuleInfo(ruleInfo);
            if (!"rearEnd".equals(guiZe.getUseScene())) continue;
            ruleList.add(dsnRules);
        }
        ArrayList<Rule> retList = new ArrayList<Rule>();
        ruleList.forEach(aRule -> {
            List list2 = JsonUtils.json2List((String)aRule.getRuleInfo(), Map.class);
            String ruleInfo = JsonUtils.toJson(list2.get(0));
            Map<String, Object> ruleMap = this.cutDownRule(ruleInfo);
            aRule.getOtherProperty().putAll(ruleMap);
            aRule.setRuleInfo("");
            retList.add(new Rule(JsonUtils.toJson((Object)aRule)));
        });
        CacheManager.put((String)(INSURANCE_RULE + "." + riskUuid), (Object)JsonUtils.toJson(retList));
        return retList;
    }

    private List<DsnStructureRules> filterRulesByOrgan(List<DsnStructureRules> structureRulesList) {
        User user = ThreadLocalContext.get().getUser();
        String branchID = user.getBranchID();
        String organId = user.getOrganId();
        structureRulesList = structureRulesList.stream().filter(p -> {
            String[] organArr = p.getOrganId().split(",");
            boolean isCurOrgan = false;
            String[] stringArray = organArr;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String organConf;
                String organConfTemp = organConf = stringArray[i];
                while (organConfTemp.length() >= 2 && "00".equals(organConfTemp.substring(organConfTemp.length() - 2))) {
                    organConfTemp = organConfTemp.substring(organConfTemp.length() - 2);
                }
                if (!organId.startsWith(organConfTemp)) continue;
                isCurOrgan = true;
            }
            List collect = Arrays.asList(p.getChannelNo().split(",")).stream().filter(q -> branchID.equals(q)).collect(Collectors.toList());
            return isCurOrgan && collect.size() > 0;
        }).collect(Collectors.toList());
        return structureRulesList;
    }

    private Map<String, Object> cutDownRule(String ruleInfo) {
        Map ruleMap = JsonUtils.json2Map((String)ruleInfo);
        return this.copyKey(ruleMap);
    }

    private Map<String, Object> copyKey(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!this.keySet.contains(entry.getKey())) continue;
            if (entry.getValue() instanceof Map) {
                newMap.put(entry.getKey(), this.copyKey((Map)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof List) {
                ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>();
                List list = (List)entry.getValue();
                for (Object o : list) {
                    if (o instanceof Map) {
                        Map no = (Map)o;
                        newList.add(this.copyKey(no));
                        continue;
                    }
                    newList.add((Map<String, Object>)o);
                }
                newMap.put(entry.getKey(), newList);
                continue;
            }
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    private DsnStructure findNode4UpNode(String upNode, String nodeType) {
        DsnStructure node = new DsnStructure(true);
        node.setUpNode(upNode);
        node.setNodeType(nodeType);
        return (DsnStructure)this.dao.findOne((AbsModel)node);
    }

    private List<DsnStructure> findNodeList4UpNode(String upNode, String nodeType) {
        DsnStructure node = new DsnStructure(true);
        node.setUpNode(upNode);
        node.setNodeType(nodeType);
        return this.dao.findAll((AbsModel)node);
    }

    static {
        if (mappre == null) {
            mappre = new HashMap<String, String>();
            mappre.put("M", "1");
            mappre.put("A", "2");
        }
        if (mapjob == null) {
            mapjob = new HashMap<String, String>();
            mapjob.put("1", "lCls");
            mapjob.put("2", "hCls");
            mapjob.put("3", "mCls");
            mapjob.put("4", "eCls");
        }
        INSURANCE_RULE = PremiumCalcServiceImpl.class.getName() + "." + "queryInsuranceRule";
    }
}

