/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.rms.resource.servers.impl;

import com.uniapis.cache.CacheManager;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.callback.RowCallback;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.rms.component.AuthComponent;
import com.uniapis.rms.config.RmsConfig;
import com.uniapis.rms.model.RmsResources;
import com.uniapis.rms.model.RmsResourcesAuth;
import com.uniapis.rms.model.RmsResourcesData;
import com.uniapis.rms.param.ResourceParam;
import com.uniapis.rms.param.RmsLimitVo;
import com.uniapis.rms.resource.servers.IResourceService;
import com.uniapis.rms.resource.servers.IResourcesData;
import com.uniapis.utils.HttpUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ResourceServiceImpl
implements IResourceService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private RmsConfig nacosConfig;
    @Autowired
    private AuthComponent authComponent;

    public ReturnMsg addResource(RmsResources res) {
        this.setMappint(res);
        Return msg = res.checkValue();
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        List resList = this.dao.findAll((AbsModel)RmsResources.n((boolean)true).setResourceType(res.getResourceType()));
        if (!CollectionUtils.isEmpty((Collection)resList)) {
            msg.setFailMsg("\u8d44\u6e90\u7c7b\u578b\u5df2\u5b58\u5728");
            return msg.msg();
        }
        this.dao.save((AbsModel)res);
        return msg.msg();
    }

    private void setMappint(RmsResources res) {
        if ("HANDIWORK".equals(res.getResourceSource())) {
            res.setMappingTab("rms_resources_data");
            res.setMappingId("data_id");
            res.setMappingName("data_name");
            res.setMappingParent("up_data");
        }
    }

    public ReturnMsg delResource(String resourceType) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)resourceType)) {
            msg.setFailMsg("\u8d44\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        this.dao.delete((AbsModel)RmsResources.n((boolean)true).setResourceType(resourceType));
        this.dao.delete((AbsModel)RmsResourcesData.n((boolean)true).setResourceType(resourceType));
        this.dao.delete((AbsModel)RmsResourcesAuth.n((boolean)true).setResourceType(resourceType));
        return msg.msg();
    }

    public ReturnMsg queryResource(ResourceParam param) {
        RmsResources res = new RmsResources();
        if (!StrUtils.isNull((Object)param.getResourceName())) {
            res.where().addLike(RmsResources.RESOURCE_NAME, (Object)param.getResourceName());
        }
        if (!StrUtils.isNull((Object)param.getResourceType())) {
            res.where().addEq(RmsResources.RESOURCE_TYPE, (Object)param.getResourceType());
        }
        res.where().setCheckWhere(false);
        res.where().addCallback((RowCallback & Serializable)(row, data, index) -> {
            switch (row.getResourceSource()) {
                case "HANDIWORK": {
                    row.putOtherProperty("resource_source_name", (Object)"\u624b\u5de5\u7ef4\u62a4");
                    break;
                }
                case "MAPPING": {
                    row.putOtherProperty("resource_source_name", (Object)"\u6620\u5c04");
                }
            }
            switch (row.getMappingType()) {
                case "TABLE": {
                    row.putOtherProperty("mapping_type_name", (Object)"\u8868\u6620\u5c04");
                    break;
                }
                case "CLASS": {
                    row.putOtherProperty("mapping_type_name", (Object)"\u7c7b\u6620\u5c04");
                    break;
                }
                case "URL": {
                    row.putOtherProperty("mapping_type_name", (Object)"\u8bf7\u6c42\u6620\u5c04");
                    break;
                }
                case "HANDWORK": {
                    row.putOtherProperty("mapping_type_name", (Object)"\u624b\u5de5\u7ef4\u62a4");
                }
            }
        });
        List resList = this.dao.findAll((AbsModel)res, Boolean.valueOf(true));
        Return msg = new Return();
        msg.setDataList(resList, RmsResources.class);
        return msg.msg();
    }

    public ReturnMsg mdfResource(RmsResources res) {
        this.setMappint(res);
        Return msg = res.checkValue();
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        res.where().addEq(RmsResources.RESOURCE_TYPE, (Object)res.getResourceType());
        res.where().getChangeColumn().remove(RmsResources.RESOURCE_TYPE);
        this.dao.update((AbsModel)res);
        CacheManager.remove((String)("RESOURCE_TYPE_" + res.getResourceType()));
        return msg.msg();
    }

    public ReturnMsg loadResource(String resourceType) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)resourceType)) {
            msg.setFailMsg("\u8d44\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        List<Map> cacheMapList = (List<Map>)CacheManager.get((String)("RESOURCE_TYPE_" + resourceType));
        if (!CollectionUtils.isEmpty((Collection)cacheMapList)) {
            msg.setDataList((List)cacheMapList);
            return msg.msg();
        }
        RmsResources res = (RmsResources)this.dao.findOne((AbsModel)RmsResources.n((boolean)true).setResourceType(resourceType));
        if (res == null) {
            msg.setFailMsg("\u8d44\u6e90\u7c7b\u578b\u4e0d\u5b58\u5728");
            return msg.msg();
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        switch (res.getMappingType()) {
            case "TABLE": 
            case "HANDWORK": {
                datas.addAll(this.table(res));
                break;
            }
            case "CLASS": {
                datas.addAll(this.clazz(res));
                break;
            }
            case "URL": {
                datas.addAll(this.url(res));
            }
        }
        Map<String, List<Map>> groupByMenu = datas.stream().collect(Collectors.groupingBy(m -> StrUtils.trimStr(m.get(res.getMappingParent()))));
        datas.forEach(data -> {
            data.put("key", data.get(res.getMappingId()));
            data.put("title", data.get(res.getMappingName()));
            data.put("data_id", data.get(res.getMappingId()));
            data.put("data_name", data.get(res.getMappingName()));
            data.put("up_data", data.get(res.getMappingParent()));
        });
        datas.stream().filter(o -> groupByMenu.containsKey(o.get("data_id"))).forEach(data -> {
            data.put("children", groupByMenu.get(data.get(res.getMappingId())));
            System.out.println(data.get("key"));
        });
        cacheMapList = !CollectionUtils.isEmpty((Collection)groupByMenu.get("root")) ? groupByMenu.get("root") : groupByMenu.get("");
        msg.setDataList(cacheMapList);
        return msg.msg();
    }

    private List<Map<String, Object>> table(RmsResources res) {
        RmsLimitVo limitVo;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT  ").append(res.getMappingId()).append(",").append(res.getMappingName());
        if (!StrUtils.isNull((Object)res.getMappingParent())) {
            sql.append(",").append(res.getMappingParent());
        }
        if (!StrUtils.isNull((Object)res.getMappingOrder())) {
            sql.append(",").append(res.getMappingOrder());
        }
        sql.append(" FROM " + res.getMappingTab() + " WHERE 1 = 1 ");
        AbsModelRepository.Args args = this.dao.args(new Object[0]);
        if (!StrUtils.isNull((Object)res.getMappingRule())) {
            Map param = JsonUtils.json2Map((String)JsonUtils.toJson((Object)res));
            param.putAll(JsonUtils.json2Map((String)JsonUtils.toJson((Object)ThreadLocalContext.get().getUser())));
            sql.append(" AND " + this.replaceParam(res.getMappingRule(), param, args));
        }
        String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
        if (!Objects.equals(this.nacosConfig.getAdminAccount(), pkUuid) && Objects.nonNull(limitVo = (RmsLimitVo)CacheManager.get((String)("USER_LIMIT_" + pkUuid))) && MapUtils.isNotEmpty((Map)limitVo.getResourceLimitMap())) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)limitVo.getResourceLimitMap().get(res.getResourceType())))) {
                List<String> dataIds = ((List)limitVo.getResourceLimitMap().get(res.getResourceType())).stream().map(o -> String.valueOf(o.get("data_id"))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(dataIds)) {
                    sql.append("AND ").append(res.getMappingId()).append(" in (");
                    dataIds.forEach(o -> sql.append("'").append((String)o).append("',"));
                    sql.replace(sql.length() - 1, sql.length(), "");
                    sql.append(")");
                }
            } else {
                sql.append("AND 1=2");
            }
        }
        if (!StrUtils.isNull((Object)res.getMappingOrder())) {
            sql.append(" order by ").append(res.getMappingOrder());
        } else {
            sql.append(" order by crt_date desc");
        }
        return this.dao.findAll(sql + " \uff03NOTCHECK", Boolean.valueOf(false), new AbsModelRepository.Args[]{args});
    }

    private List<Map<String, Object>> clazz(RmsResources res) {
        IResourcesData resData = (IResourcesData)SpringContext.getBean((String)res.getMappingTab(), IResourcesData.class);
        Map param = JsonUtils.json2Map((String)JsonUtils.toJson((Object)res));
        param.putAll(JsonUtils.json2Map((String)JsonUtils.toJson((Object)ThreadLocalContext.get().getUser())));
        return resData.queryData(param);
    }

    private List<Map<String, Object>> url(RmsResources res) {
        Map param = JsonUtils.json2Map((String)JsonUtils.toJson((Object)res));
        param.putAll(JsonUtils.json2Map((String)JsonUtils.toJson((Object)ThreadLocalContext.get().getUser())));
        String retMsg = HttpUtils.jsonPost((String)res.getMappingTab(), (String)JsonUtils.toJson((Object)param));
        return JsonUtils.json2List((String)retMsg);
    }

    private String replaceParam(String text, Map<String, Object> param, AbsModelRepository.Args args) {
        Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher m = p.matcher(text);
        while (m.find()) {
            text = text.replace(m.group(0), " ? ");
            args.args().add(param.get(m.group(1)));
        }
        return text;
    }
}

