/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.uniapis.utils.CodecUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

public class TreeComparator {
    private static final String[] baseClmList = new String[]{"serno", "crt_user", "crt_date", "mdf_user", "mdf_date", "rn"};
    private static final Set<String> baseClmSet = new HashSet<String>(Arrays.asList("serno", "crt_user", "crt_date", "mdf_user", "mdf_date", "rn"));
    private static final String JSON_PATTERN = "^\\{.*\\}$";

    public static TreeNode buildDiffTree(final TreeNode node1, final TreeNode node2, List<Map<String, Object>> diffData) {
        if (node1 == null && node2 == null) {
            return null;
        }
        if (node1 == null || node2 == null) {
            final TreeNode tempNode = node1 == null ? node2 : node1;
            String uuid = tempNode.getValue();
            if (uuid.length() > 64) {
                uuid = UUID.uuid();
            }
            TreeNode treeNode = new TreeNode(uuid, node1 == null ? node2.getLabel() : node1.getLabel());
            treeNode.setTag(node1 == null ? node2.getTag() : node1.getTag());
            if (node1 != null) {
                final String finalUuid = uuid;
                diffData.add((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("link_uuid", finalUuid);
                        this.put("origin", tempNode.getValue());
                        this.put("status", CompareEnum.Status.D.getType());
                    }
                });
                treeNode.setStatus(CompareEnum.Status.D.getType());
                return treeNode;
            }
            treeNode.setStatus(CompareEnum.Status.A.getType());
            if (CollectionUtils.isEmpty(node2.getChildren())) {
                final String finalUuid = uuid;
                diffData.add((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("link_uuid", finalUuid);
                        this.put("new", tempNode.getValue());
                        this.put("status", CompareEnum.Status.A.getType());
                    }
                });
                return treeNode;
            }
            TreeComparator.recursiveAddTree(node2, treeNode, diffData);
            return treeNode;
        }
        if (!TreeComparator.getMd5(node1.getValue()).equals(TreeComparator.getMd5(node2.getValue()))) {
            TreeNode tempNode = node1 == null ? node2 : node1;
            String uuid = tempNode.getValue();
            if (uuid.length() > 64) {
                uuid = UUID.uuid();
            }
            final String finalUuid = uuid;
            diffData.add((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("link_uuid", finalUuid);
                    this.put("origin", node1.getValue());
                    this.put("new", node2.getValue());
                    this.put("status", CompareEnum.Status.M.getType());
                }
            });
            TreeNode diffNode = new TreeNode(node2.getFieldId(), uuid, node2.getLabel(), node2.getTag(), CompareEnum.Status.M.getType());
            List mergedList = Stream.concat(node1.getChildren().stream(), node2.getChildren().stream()).collect(Collectors.toMap(TreeNode::getFieldId, Function.identity(), (existing, replacement) -> existing)).values().stream().sorted(Comparator.comparing(TreeNode::getDisplayOrder)).collect(Collectors.toList());
            for (int i = 0; i < mergedList.size(); ++i) {
                List collect2;
                TreeNode child2;
                int finalI = i;
                List collect1 = node1.getChildren().stream().filter(p -> p.getFieldId().equals(((TreeNode)mergedList.get(finalI)).getFieldId())).collect(Collectors.toList());
                TreeNode child1 = collect1.isEmpty() ? null : (TreeNode)collect1.get(0);
                TreeNode childDiff = TreeComparator.buildDiffTree(child1, child2 = (collect2 = node2.getChildren().stream().filter(p -> p.getFieldId().equals(((TreeNode)mergedList.get(finalI)).getFieldId())).collect(Collectors.toList())).isEmpty() ? null : (TreeNode)collect2.get(0), diffData);
                if (childDiff == null) continue;
                diffNode.getChildren().add(childDiff);
            }
            return diffNode.getChildren().isEmpty() && node1.getValue().equals(node2.getValue()) ? null : diffNode;
        }
        ArrayList<TreeNode> diffChildren = new ArrayList<TreeNode>();
        List mergedList = Stream.concat(node1.getChildren().stream(), node2.getChildren().stream()).collect(Collectors.toMap(TreeNode::getFieldId, Function.identity(), (existing, replacement) -> existing)).values().stream().sorted(Comparator.comparing(TreeNode::getDisplayOrder)).collect(Collectors.toList());
        for (int i = 0; i < mergedList.size(); ++i) {
            List collect2;
            TreeNode child2;
            int finalI = i;
            List collect1 = node1.getChildren().stream().filter(p -> p.getFieldId().equals(((TreeNode)mergedList.get(finalI)).getFieldId())).collect(Collectors.toList());
            TreeNode child1 = collect1.isEmpty() ? null : (TreeNode)collect1.get(0);
            TreeNode childDiff = TreeComparator.buildDiffTree(child1, child2 = (collect2 = node2.getChildren().stream().filter(p -> p.getFieldId().equals(((TreeNode)mergedList.get(finalI)).getFieldId())).collect(Collectors.toList())).isEmpty() ? null : (TreeNode)collect2.get(0), diffData);
            if (childDiff == null) continue;
            diffChildren.add(childDiff);
        }
        if (!diffChildren.isEmpty()) {
            TreeNode pathNode = new TreeNode(node1.getValue(), node1.getLabel());
            pathNode.setChildren(diffChildren);
            return pathNode;
        }
        return null;
    }

    public static void printTree(TreeNode node, int indent) {
        if (node != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                sb.append("  ");
            }
            String spaces = sb.toString();
            System.out.println(spaces + node.getValue());
            for (TreeNode child : node.getChildren()) {
                TreeComparator.printTree(child, indent + 1);
            }
        }
    }

    public static void recursiveAddTree(TreeNode originTree, TreeNode diffTree, List<Map<String, Object>> diffData) {
        for (final TreeNode child : originTree.getChildren()) {
            String uuid = child.getValue();
            if (uuid.length() > 64) {
                uuid = UUID.uuid();
            }
            if (CollectionUtils.isEmpty(child.getChildren())) {
                final String finalUuid = uuid;
                diffData.add((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("link_uuid", finalUuid);
                        this.put("new", child.getValue());
                        this.put("status", CompareEnum.Status.A.getType());
                    }
                });
            }
            TreeNode childDiff = new TreeNode(child.getFieldId(), uuid, child.getLabel(), child.getTag(), CompareEnum.Status.A.getType());
            diffTree.getChildren().add(childDiff);
            TreeComparator.recursiveAddTree(child, childDiff, diffData);
        }
    }

    public static String getMd5(String jsonString) {
        if (!jsonString.matches(JSON_PATTERN)) {
            return jsonString;
        }
        String json = TreeComparator.removeFieldFromJson(jsonString);
        return CodecUtils.md5((String)json);
    }

    public static String removeFieldFromJson(String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode rootNode = mapper.readTree(jsonString);
            if (rootNode.isObject()) {
                for (String removeField : baseClmList) {
                    ((ObjectNode)rootNode).remove(removeField);
                }
                ((ObjectNode)rootNode).fieldNames().forEachRemaining(key -> TreeComparator.removeFieldRecursively(rootNode.get(key)));
                return mapper.writeValueAsString((Object)rootNode);
            }
            return jsonString;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid JSON string: " + jsonString, e);
        }
    }

    private static void removeFieldRecursively(JsonNode node) {
        if (node.isObject()) {
            for (String removeField : baseClmList) {
                ((ObjectNode)node).remove(removeField);
            }
            ((ObjectNode)node).fieldNames().forEachRemaining(key -> TreeComparator.removeFieldRecursively(node.get(key)));
        } else if (node.isArray()) {
            node.forEach(childNode -> TreeComparator.removeFieldRecursively(childNode));
        }
    }

    public static void main(String[] args) {
        String jsonString = "{\"serno\":\"422520269456707584\",\"collection\":\"\",\"fmNodeList\":\"\",\"fmNodeTemplateList\":\"\",\"fmRouterList\":\"\",\"fmTemplateList\":\"\",\"scpzMaterialTagsRelationList\":[{\"serno\":\"456542070696218624\",\"scpzTags\":{\"serno\":\"376782786886799360\",\"crt_user\":\"login_user\",\"mdf_user\":\"login_user\",\"crt_date\":\"2025-06-03 10:24:46\",\"mdf_date\":\"2025-06-03 10:24:46\",\"data_flag\":\"1\",\"patch_memo\":\"\",\"tag_categories\":\"eTong\",\"tag_id\":\"VOydYgCP\",\"tag_name\":\"178\",\"rn\":1},\"crt_user\":\"login_user\",\"mdf_user\":\"login_user\",\"crt_date\":\"2025-06-03 10:24:03\",\"mdf_date\":\"2025-06-03 10:24:03\",\"data_flag\":\"1\",\"patch_memo\":\"\",\"relation_field\":\"flow_uuid\",\"relation_fk\":\"21ca8fed33f14b7c8705e97d6dd6d7b6\",\"relation_tab\":\"fm_flow\",\"relation_uuid\":\"81bf1c712dd94fc7ac7b3163a686369c\",\"tag_belongs\":\"flow\",\"tag_id\":\"VOydYgCP\",\"rn\":1}],\"wtIssueList\":\"\",\"tags\":\"\",\"fmFlowRelations\":\"\",\"childFmFlows\":\"\",\"crt_user\":\"login_user\",\"mdf_user\":\"login_user\",\"crt_date\":\"2024-08-13 18:24:42\",\"mdf_date\":\"2025-06-03 10:23:59\",\"data_flag\":\"1\",\"channel\":\"1\",\"coll_id\":\"59952bce85644bbb86aa37b0d2cf6eab\",\"flow_desc\":\"\",\"flow_name\":\"\u4e3b\u6d41\u7a0b-master\",\"flow_no\":\"1\",\"flow_url\":\"staticData/flow/2025/04/18/1744966798462.png\",\"flow_uuid\":\"21ca8fed33f14b7c8705e97d6dd6d7b6\",\"patch_memo\":\"\",\"delivery_platform\":\"eTong\",\"is_master\":\"Y\",\"is_enable\":\"N\"}";
        System.out.println(jsonString.matches(JSON_PATTERN));
        String json = TreeComparator.removeFieldFromJson(jsonString);
        System.out.println(json);
    }
}

