/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.utils;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.nms.sip.model.DsnAttributeOption;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.DsnStructureRules;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductUpdateUtils {
    @Autowired
    AbsModelRepository dao;

    public void update(AbsModel model) {
        if (model == null) {
            return;
        }
        String name = model.getClass().getName();
        UpdateFlag updateFlag = (UpdateFlag)((Object)model.getOtherProperty("update_flag", UpdateFlag.class));
        if (updateFlag == null) {
            return;
        }
        switch (updateFlag) {
            case I: {
                DsnRules rules;
                int delete = 0;
                if (!(model instanceof DsnRules)) {
                    delete = this.dao.delete(model.getSerno(), model.getClass());
                }
                if (model instanceof DsnRules) {
                    rules = (DsnRules)model;
                    rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesConst) {
                    rules = (DsnRulesConst)model;
                    rules.where().addEq(DsnRulesConst.CONST_MAPPING, (Object)rules.getConstMapping());
                    rules.where().addEq(DsnRulesConst.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesParam) {
                    rules = (DsnRulesParam)model;
                    rules.where().addEq(DsnRulesParam.PARAM_ID, (Object)rules.getParamId());
                    rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnStructureRules) {
                    DsnStructureRules dsnStructureRules = (DsnStructureRules)model;
                    dsnStructureRules.where().addEq(DsnStructureRules.RULE_ID, (Object)dsnStructureRules.getRuleId());
                    this.dao.delete((AbsModel)dsnStructureRules);
                }
                this.deleteOtherdata(model);
                this.dao.save(model);
                break;
            }
            case U: {
                this.dao.update(model.getSerno(), model);
                break;
            }
            case D: {
                DsnRules rules;
                if (!(model instanceof DsnRules)) {
                    this.dao.delete(model.getSerno(), model.getClass());
                }
                if (model instanceof DsnRules) {
                    rules = (DsnRules)model;
                    rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesConst) {
                    rules = (DsnRulesConst)model;
                    rules.where().addEq(DsnRulesConst.CONST_MAPPING, (Object)rules.getConstMapping());
                    rules.where().addEq(DsnRulesConst.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesParam) {
                    rules = (DsnRulesParam)model;
                    rules.where().addEq(DsnRulesParam.PARAM_ID, (Object)rules.getParamId());
                    rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (!(model instanceof DsnStructureRules)) break;
                DsnStructureRules dsnStructureRules = (DsnStructureRules)model;
                dsnStructureRules.where().addEq(DsnStructureRules.RULE_ID, (Object)dsnStructureRules.getRuleId());
                this.dao.delete((AbsModel)dsnStructureRules);
                break;
            }
        }
    }

    private void deleteOtherdata(AbsModel model) {
        if (model instanceof DsnAttributeOption) {
            DsnAttributeOption opt = (DsnAttributeOption)model;
            opt.where().addEq(DsnAttributeOption.ATTR_UUID, (Object)opt.getAttrUuid());
            opt.where().addEq(DsnAttributeOption.OPTION_NO, (Object)opt.getOptionNo());
            opt.where().addEq(DsnAttributeOption.OPTION_NAME, (Object)opt.getOptionName());
            this.dao.delete((AbsModel)opt);
        }
        if (model instanceof DsnBizAttribute) {
            DsnBizAttribute biz = (DsnBizAttribute)model;
            biz.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)biz.getBizUuid());
            this.dao.delete((AbsModel)biz);
        }
        if (model instanceof DsnBizAttributeOption) {
            DsnBizAttributeOption bizOption = (DsnBizAttributeOption)model;
            bizOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizOption.getBizUuid());
            bizOption.where().addEq(DsnBizAttributeOption.OPTION_NO, (Object)bizOption.getOptionNo());
            bizOption.where().addEq(DsnBizAttributeOption.OPTION_VALUE, (Object)bizOption.getOptionValue());
            int delete = this.dao.delete((AbsModel)bizOption);
            if (delete == 0) {
                bizOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizOption.getBizUuid());
                bizOption.where().addEq(DsnBizAttributeOption.OPTION_NAME, (Object)bizOption.getOptionName());
                int delNum = this.dao.delete((AbsModel)bizOption);
                if (delNum == 0) {
                    bizOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizOption.getBizUuid());
                    bizOption.where().addEq(DsnBizAttributeOption.OPTION_VALUE, (Object)bizOption.getOptionValue());
                    this.dao.delete((AbsModel)bizOption);
                }
            }
        }
        if (model instanceof SipRisks) {
            SipRisks sipRisks = (SipRisks)model;
            sipRisks.where().addEq(SipRisks.RISK_UUID, (Object)sipRisks.getRiskUuid());
            this.dao.delete((AbsModel)sipRisks);
        }
        if (model instanceof DsnRules) {
            DsnRules rules = (DsnRules)model;
            rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
            this.dao.delete((AbsModel)rules);
        }
        if (model instanceof SipRiskRelation) {
            SipRiskRelation riskRelation = (SipRiskRelation)model;
            riskRelation.where().addEq(SipRiskRelation.MAIN_RISK, (Object)riskRelation.getMainRisk());
            riskRelation.where().addEq(SipRiskRelation.RISK_UUID, (Object)riskRelation.getRiskUuid());
            this.dao.delete((AbsModel)riskRelation);
        }
        if (model instanceof DsnStructure) {
            DsnStructure dsnStructure = (DsnStructure)model;
            dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)dsnStructure.getNodeNo());
            dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)dsnStructure.getUpNode());
            this.dao.delete((AbsModel)dsnStructure);
        }
        if (model instanceof SipProductRisks) {
            SipProductRisks sipProductRisks = (SipProductRisks)model;
            sipProductRisks.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)sipProductRisks.getProductUuid());
            sipProductRisks.where().addEq(SipProductRisks.RISK_UUID, (Object)sipProductRisks.getRiskUuid());
            this.dao.delete((AbsModel)sipProductRisks);
        }
    }

    public String getProductImage(String productNo) {
        SipProducts product = new SipProducts();
        product.where().addEq(SipProducts.PRODUCT_NO, (Object)productNo);
        SipProducts one = (SipProducts)this.dao.findOne((AbsModel)product);
        return one == null ? "" : one.getProductImage();
    }

    public static enum UpdateFlag {
        I,
        U,
        D;

    }
}

