/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.utils;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.nms.sip.model.DsnAttribute;
import com.newtouch.nms.sip.model.DsnAttributeOption;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.DsnStructureRules;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.product.transfer.utils.ModelMd5Callback;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
@CacheConfig(cacheNames={"productQueryUtils"})
public class ProductQueryUtils {
    @Autowired
    AbsModelRepository dao;
    private final ModelMd5Callback<AbsModel> md5Callback = new ModelMd5Callback();

    public DsnStructure queryStructure(String nodeNo) {
        DsnStructure danStructure = new DsnStructure();
        danStructure.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        danStructure.where().addCallback(this.md5Callback);
        danStructure = (DsnStructure)this.dao.findOne((AbsModel)danStructure);
        if (danStructure == null || StrUtils.isNull((Object)danStructure.getSerno())) {
            return null;
        }
        return danStructure;
    }

    public DsnStructure queryStructure(String upNode, String nodeType) {
        DsnStructure danStructure = new DsnStructure();
        danStructure.where().addEq(DsnStructure.UP_NODE, (Object)upNode);
        danStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)nodeType);
        danStructure.where().addCallback(this.md5Callback);
        danStructure = (DsnStructure)this.dao.findOne((AbsModel)danStructure);
        if (danStructure == null) {
            return null;
        }
        String serno = danStructure.getSerno();
        if (StrUtils.isNull((Object)serno)) {
            return null;
        }
        return danStructure;
    }

    public List<DsnStructure> queryStructureList(String upNode, String nodeType) {
        DsnStructure danStructure = new DsnStructure();
        danStructure.where().addEq(DsnStructure.UP_NODE, (Object)upNode);
        danStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)nodeType);
        danStructure.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)danStructure);
    }

    public List<DsnStructure> queryStructures(String upNode) {
        DsnStructure danStructure = new DsnStructure();
        danStructure.where().addEq(DsnStructure.UP_NODE, (Object)upNode);
        danStructure.where().addCallback(this.md5Callback);
        danStructure.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
        return this.dao.findAll((AbsModel)danStructure);
    }

    public DsnDynamicData queryDynamic(String nodeNo) {
        DsnDynamicData data = new DsnDynamicData();
        data.where().addEq(DsnDynamicData.RELATE_FK, (Object)nodeNo);
        data.where().addCallback(this.md5Callback);
        return (DsnDynamicData)this.dao.findOne((AbsModel)data);
    }

    public List<DsnStructure> queryPrpStructures(String upNode) {
        DsnStructure danStructure = new DsnStructure();
        danStructure.where().addEq(DsnStructure.UP_NODE, (Object)upNode);
        danStructure.where().addCallback(this.md5Callback);
        danStructure.where().addNotIn(DsnStructure.NODE_NAME, new String[]{"\u4ea7\u54c1\u56fe\u7247", "\u5efa\u8bae\u4e66\u7ed3\u675f\u65f6\u95f4", "\u5efa\u8bae\u4e66\u5f00\u59cb\u65f6\u95f4"});
        danStructure.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
        return this.dao.findAll((AbsModel)danStructure);
    }

    public SipProducts queryProduct(String prdUuid) {
        SipProducts sipProduct = new SipProducts();
        sipProduct.where().addEq(SipProducts.PRODUCT_UUID, (Object)prdUuid);
        sipProduct.where().addCallback(this.md5Callback);
        sipProduct = (SipProducts)this.dao.findOne((AbsModel)sipProduct);
        if (sipProduct == null || StrUtils.isNull((Object)sipProduct.getSerno())) {
            return null;
        }
        return sipProduct;
    }

    public DsnBizAttribute queryBizAttribute(String nodeNo) {
        DsnBizAttribute dsnBizAttribute = new DsnBizAttribute();
        dsnBizAttribute.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)nodeNo);
        dsnBizAttribute.where().addCallback(this.md5Callback);
        dsnBizAttribute = (DsnBizAttribute)this.dao.findOne((AbsModel)dsnBizAttribute);
        if (dsnBizAttribute == null || StrUtils.isNull((Object)dsnBizAttribute.getSerno())) {
            return null;
        }
        return dsnBizAttribute;
    }

    public List<DsnBizAttributeOption> queryBizAttributeOption(String bizUuid) {
        DsnBizAttributeOption dsnBizAttributeOption = new DsnBizAttributeOption();
        dsnBizAttributeOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizUuid);
        dsnBizAttributeOption.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)dsnBizAttributeOption);
    }

    public DsnAttribute queryAttribute(String attrUuid) {
        DsnAttribute danAttribute = new DsnAttribute();
        danAttribute.where().addEq(DsnAttribute.ATTR_UUID, (Object)attrUuid);
        danAttribute.where().addCallback(this.md5Callback);
        danAttribute = (DsnAttribute)this.dao.findOne((AbsModel)danAttribute);
        if (danAttribute == null || StrUtils.isNull((Object)danAttribute.getSerno())) {
            return null;
        }
        return danAttribute;
    }

    public List<DsnAttributeOption> queryAttributeOption(String attrUuid) {
        DsnAttributeOption danAttributeOption = new DsnAttributeOption();
        danAttributeOption.where().addEq(DsnAttributeOption.ATTR_UUID, (Object)attrUuid);
        danAttributeOption.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)danAttributeOption);
    }

    public DsnRules queryRule(String nodeNo) {
        DsnRules danRules = new DsnRules();
        danRules.where().addEq(DsnRules.RELATE_FK, (Object)nodeNo);
        danRules.where().addCallback(this.md5Callback);
        danRules = (DsnRules)this.dao.findOne((AbsModel)danRules);
        if (danRules == null || StrUtils.isNull((Object)danRules.getSerno())) {
            return null;
        }
        return danRules;
    }

    public List<DsnStructureRules> queryStructureRules(String nodeNo) {
        DsnStructureRules dsnStructureRules = new DsnStructureRules();
        dsnStructureRules.where().addEq(DsnStructureRules.NODE_NO, (Object)nodeNo);
        dsnStructureRules.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)dsnStructureRules);
    }

    public List<DsnRulesConst> queryRuleConst(String ruleId) {
        DsnRulesConst danRulesConst = new DsnRulesConst();
        danRulesConst.where().addEq(DsnRulesConst.RULE_ID, (Object)ruleId);
        danRulesConst.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)danRulesConst);
    }

    public List<DsnRulesParam> queryRuleParam(String ruleId) {
        DsnRulesParam dsnRulesParam = new DsnRulesParam();
        dsnRulesParam.where().addEq(DsnRulesConst.RULE_ID, (Object)ruleId);
        dsnRulesParam.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)dsnRulesParam);
    }

    public SipRiskRelation queryRiskRelation(String mainRisk, String riskUuid) {
        SipRiskRelation sipRiskRelation = new SipRiskRelation();
        sipRiskRelation.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRisk);
        sipRiskRelation.where().addEq(SipRiskRelation.RISK_UUID, (Object)riskUuid);
        sipRiskRelation.where().addCallback(this.md5Callback);
        sipRiskRelation = (SipRiskRelation)this.dao.findOne((AbsModel)sipRiskRelation);
        if (sipRiskRelation == null) {
            return null;
        }
        String serno = sipRiskRelation.getSerno();
        if (StrUtils.isNull((Object)serno)) {
            return null;
        }
        return sipRiskRelation;
    }

    public SipProductRisks queryProductRelation(String prdUuid, String riskUuid) {
        SipProductRisks sipProductRisks = new SipProductRisks();
        sipProductRisks.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)prdUuid);
        sipProductRisks.where().addEq(SipProductRisks.RISK_UUID, (Object)riskUuid);
        sipProductRisks.where().addCallback(this.md5Callback);
        sipProductRisks = (SipProductRisks)this.dao.findOne((AbsModel)sipProductRisks);
        if (sipProductRisks == null) {
            return null;
        }
        String serno = sipProductRisks.getSerno();
        if (StrUtils.isNull((Object)serno)) {
            return null;
        }
        return sipProductRisks;
    }

    public SipRisks queryRisk(String riskUuid) {
        SipRisks sipRisk = new SipRisks();
        sipRisk.where().addEq(SipRisks.RISK_UUID, (Object)riskUuid);
        sipRisk.where().addCallback(this.md5Callback);
        sipRisk = (SipRisks)this.dao.findOne((AbsModel)sipRisk);
        if (sipRisk == null) {
            return null;
        }
        String serno = sipRisk.getSerno();
        if (StrUtils.isNull((Object)serno)) {
            return null;
        }
        return sipRisk;
    }

    public List<DsnRules> queryRules(String nodeNo) {
        DsnRules dsnRules = new DsnRules();
        dsnRules.where().addEq(DsnRules.RELATE_FK, (Object)nodeNo);
        dsnRules.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)dsnRules);
    }

    public DsnRules queryRuleByRuleId(String ruleId) {
        DsnRules dsnRules = new DsnRules();
        dsnRules.where().addEq(DsnRules.RULE_ID, (Object)ruleId);
        dsnRules.where().addCallback(this.md5Callback);
        dsnRules = (DsnRules)this.dao.findOne((AbsModel)dsnRules);
        if (dsnRules == null) {
            return null;
        }
        String serno = dsnRules.getSerno();
        if (StrUtils.isNull((Object)serno)) {
            return null;
        }
        return dsnRules;
    }

    @CacheEvict(allEntries=true)
    public void clearProductUtilsCache() {
    }
}

