/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.services.impl;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.nms.sip.model.SipProductsChannel;
import com.newtouch.nms.sip.product.rate.services.IRateService;
import com.newtouch.nms.sip.product.transfer.domain.product.Product;
import com.newtouch.nms.sip.product.transfer.services.IProductTransferAsyncService;
import com.newtouch.nms.sip.product.transfer.services.IProductTransferService;
import com.newtouch.nms.sip.product.transfer.services.impl.ProductTransferServiceImpl;
import com.newtouch.nms.sip.product.transfer.utils.FileHttpUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.utils.EasyExcelUtil;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Env;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;

@Service
@EnableAsync
public class ProductTransferServiceAsyncImpl
implements IProductTransferAsyncService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IRateService rateService;
    @Value(value="${gradedOpBasicUrl}")
    private String gradedOpBasicUrl;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private HWYObsSDKUtis hwyObsSDKUtis;

    @Override
    @Async
    public void transProductAsync(List<Map<String, Object>> productList, String taskType, User user) {
        ThreadLocalContext.get().setUser(user);
        IProductTransferService productTransferService = (IProductTransferService)SpringContext.getBean(IProductTransferService.class);
        ReturnMsg msg = productTransferService.exportProduct(productList);
        ((ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class)).clearProductUtilsCache();
        String zipPath = (String)msg.getDataTable().get("zipPath");
        File file = new File(zipPath);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("md5", (Object)"");
        jsonObject.put("taskType", (Object)taskType);
        try {
            FileHttpUtils.sendHttpPostRequest(this.gradedOpBasicUrl + "/importProduct.do", jsonObject, file);
        }
        catch (IOException e) {
            e.printStackTrace();
            Ulog.info((String)("\u8bf7\u6c42\u8fd0\u8425\u5e73\u53f0\u670d\u52a1\u5931\u8d25" + e.getMessage()));
            for (Map<String, Object> product : productList) {
                SipProductSyncTask task = new SipProductSyncTask();
                task.setProductUuid(StrUtils.trimStr((Object)product.get("product_uuid")));
                task.setTaskType(taskType);
                task.setFinishDate(new Date());
                task.setTaskState("N");
                task.setErrorInfo(e.getMessage());
                this.dao.save((AbsModel)task);
            }
        }
    }

    @Override
    public void importSingleProductAsync(List<File> fileList, List<File> rateExcelList, List<File> publishList, String prdUuid, String serno) {
        try {
            Object node;
            String result;
            String line;
            Throwable throwable;
            BufferedReader reader2;
            FileInputStream inputStream;
            StringBuffer buffer;
            String pdrUuid;
            ThreadLocalContext.get().setRqstSource("insure");
            for (File aProduct : fileList) {
                pdrUuid = aProduct.getName().substring(0, aProduct.getName().lastIndexOf("."));
                if (!prdUuid.equals(pdrUuid)) continue;
                buffer = new StringBuffer();
                try {
                    inputStream = new FileInputStream(aProduct);
                    Throwable throwable2 = null;
                    try {
                        reader2 = new BufferedReader(new InputStreamReader(inputStream));
                        throwable = null;
                        try {
                            line = reader2.readLine();
                            while (line != null) {
                                buffer.append(line);
                                line = reader2.readLine();
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (reader2 != null) {
                                if (throwable != null) {
                                    try {
                                        reader2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    reader2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable reader2) {
                        throwable2 = reader2;
                        throw reader2;
                    }
                    finally {
                        if (inputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    ((InputStream)inputStream).close();
                                }
                                catch (Throwable reader2) {
                                    throwable2.addSuppressed(reader2);
                                }
                            } else {
                                ((InputStream)inputStream).close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                result = "";
                result = new String(buffer.toString().getBytes(), StandardCharsets.UTF_8);
                Product importProduct = (Product)JsonUtils.json2Class((String)result, Product.class);
                String imports = JsonUtils.toJson((Object)importProduct);
                System.out.println("\u5bfc\u5165\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + imports);
                Product dbProduct = new Product();
                dbProduct.load(pdrUuid);
                String dbPrd = JsonUtils.toJson((Object)dbProduct);
                System.out.println("\u67e5\u8be2\u51fa\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
                dbProduct.merge(importProduct);
                dbPrd = JsonUtils.toJson((Object)dbProduct);
                System.out.println("merger\u540e\u7684\u7684\u4ea7\u54c1\u4fe1\u606f\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\uff1a" + dbPrd);
                dbProduct.save();
            }
            if (CollectionUtils.isNotEmpty(rateExcelList)) {
                for (File rateExcel : rateExcelList) {
                    String[] split = rateExcel.getName().substring(0, rateExcel.getName().lastIndexOf(".")).split("-");
                    String tableName = split[0];
                    String pdrUuid2 = split[1];
                    String nodeNo = split[2];
                    if (!prdUuid.equals(pdrUuid2)) continue;
                    node = new DsnStructure();
                    node.setNodeNo(nodeNo);
                    this.rateService.rateDetailQuery((DsnStructure)node);
                    List<Map<String, Object>> maps = EasyExcelUtil.readExcel(rateExcel);
                    ProductTransferServiceImpl productTransferService = (ProductTransferServiceImpl)SpringContext.getBean(ProductTransferServiceImpl.class);
                    productTransferService.importData(maps, tableName);
                }
            }
            for (File aProduct : publishList) {
                pdrUuid = aProduct.getName().substring(0, aProduct.getName().lastIndexOf("_publish"));
                if (!prdUuid.equals(pdrUuid)) continue;
                buffer = new StringBuffer();
                try {
                    inputStream = new FileInputStream(aProduct);
                    node = null;
                    try {
                        reader2 = new BufferedReader(new InputStreamReader(inputStream));
                        throwable = null;
                        try {
                            line = reader2.readLine();
                            while (line != null) {
                                buffer.append(line);
                                line = reader2.readLine();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (reader2 != null) {
                                if (throwable != null) {
                                    try {
                                        reader2.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    reader2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        node = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (inputStream != null) {
                            if (node != null) {
                                try {
                                    ((InputStream)inputStream).close();
                                }
                                catch (Throwable throwable8) {
                                    ((Throwable)node).addSuppressed(throwable8);
                                }
                            } else {
                                ((InputStream)inputStream).close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                result = "";
                result = new String(buffer.toString().getBytes(), StandardCharsets.UTF_8);
                List organProductsList = JsonUtils.json2List((String)result, SipProductsChannel.class);
                this.dao.delete(SipProductsChannel.n().where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)prdUuid).model());
                this.dao.save(organProductsList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SipProductSyncTask task = new SipProductSyncTask();
            task.setTaskState("FAIL");
            task.setFinishDate(new Date());
            task.setSerno(serno);
            task.where().addEq(SipProductSyncTask.SERNO, (Object)serno);
            this.updateSyncTask(task, ThreadLocalContext.get().getUser());
            throw new BusinessException(e.getMessage());
        }
    }

    @Override
    @Async
    public void importProductAsync(List<File> fileList, List<File> rateExcelList, List<File> publishList, User user, String serno, String basePath) {
        ThreadLocalContext.get().setUser(user);
        Set prdSet = fileList.stream().map(p -> p.getName().substring(0, p.getName().lastIndexOf("."))).collect(Collectors.toSet());
        for (String prdUuid : prdSet) {
            this.importSingleProductAsync(fileList, rateExcelList, publishList, prdUuid, serno);
        }
        FileUtil.del((String)basePath);
        SipProductSyncTask task = new SipProductSyncTask();
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        task.setSerno(serno);
        task.where().addEq(SipProductSyncTask.SERNO, (Object)serno);
        this.dao.update((AbsModel)task);
    }

    @Async
    public void saveSyncTask(SipProductSyncTask task, User user) {
        ThreadLocalContext.get().setUser(user);
        this.dao.save((AbsModel)task);
    }

    @Async
    public void updateSyncTask(SipProductSyncTask task, User user) {
        ThreadLocalContext.get().setUser(user);
        this.dao.update((AbsModel)task);
    }

    @Override
    @Async
    public void exportProductAsync(List<Map<String, Object>> products, User user) {
        ThreadLocalContext.get().setUser(user);
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String basePath = Env.env().baseDir() + "product/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        for (Map<String, Object> prdMap : products) {
            Product p = new Product();
            String prdUuid = (String)prdMap.get("product_uuid");
            p.load(prdUuid);
            ArrayList<String> list = new ArrayList<String>();
            list.add(JsonUtils.toJson((Object)p));
            FileUtils.writeFile((String)(basePath + "/" + prdUuid + ".json"), list);
            ProductTransferServiceImpl productTransferService = (ProductTransferServiceImpl)SpringContext.getBean(ProductTransferServiceImpl.class);
            productTransferService.loadRateExcel(basePath + "/", prdUuid);
        }
        String fileName = "export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ".zip";
        String target = Env.env().baseDir() + "product/" + fileName;
        Ulog.info((String)("basePath----" + basePath));
        Ulog.info((String)("target----" + target));
        String zip = FileUtils.zip((String)basePath, (String)target, (String[])new String[]{".json", ".xlsx"});
        FileUtil.del((String)basePath);
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFinishDate(new Date());
        task.setTaskState("FINISH");
        task.setZipPath(target);
        task.where().addEq(SipProductSyncTask.SERNO, (Object)StrUtils.trimStr((Object)products.get(0).get("serno")));
        this.dao.update((AbsModel)task);
    }
}

