/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.propose.BenefitDemo;
import com.newtouch.nms.sip.product.transfer.domain.propose.RateGroup;
import com.newtouch.nms.sip.product.transfer.domain.risk.AccyRisk;
import com.newtouch.nms.sip.product.transfer.domain.risk.AccyRiskNode;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;

public class MainRisk
extends AccyRisk {
    private AccyRiskNode accyRiskNode;
    private RateGroup rateGroup;
    private BenefitDemo benefitDemo;
    private SipProductRisks sipProductRisks;
    private String productUuid;

    @Override
    public MainRisk load(DsnStructure riskNode) {
        super.load(riskNode);
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.accyRiskNode = new AccyRiskNode();
        this.accyRiskNode.setRisk(this.getBaseRisk());
        this.accyRiskNode.load(this.getRiskNode().getNodeNo());
        this.rateGroup = new RateGroup();
        this.rateGroup.load(this.getRiskNode().getNodeNo());
        this.benefitDemo = new BenefitDemo();
        this.benefitDemo.load(this.getRiskNode().getNodeNo());
        String riskUuid = this.detailNode().getNodeNo();
        this.sipProductRisks = utils.queryProductRelation(this.productUuid, riskUuid);
        return this;
    }

    public void merge(MainRisk mainRisk) {
        super.merge(mainRisk);
        this.accyRiskNode = ProductEqualsUtils.merge(this.accyRiskNode, mainRisk.getAccyRiskNode(), AccyRiskNode.class);
        this.sipProductRisks = ProductEqualsUtils.merge(this.sipProductRisks, mainRisk.getSipProductRisks());
        this.benefitDemo = ProductEqualsUtils.merge(this.benefitDemo, mainRisk.getBenefitDemo(), BenefitDemo.class);
        this.rateGroup = ProductEqualsUtils.merge(null, mainRisk.getRateGroup(), RateGroup.class);
        this.productUuid = mainRisk.getProductUuid();
    }

    @Override
    public void save() {
        super.save();
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.accyRiskNode != null) {
            this.accyRiskNode.save();
        }
        if (this.sipProductRisks != null && "insure".equals(source)) {
            update.update((AbsModel)this.sipProductRisks);
        }
        if (this.benefitDemo != null) {
            this.benefitDemo.save();
        }
        if (this.rateGroup != null) {
            this.rateGroup.save();
        }
    }

    @Override
    public TreeNode fetchTreeNode() {
        TreeNode treeNode = super.fetchTreeNode();
        if (this.accyRiskNode != null) {
            treeNode.getChildren().add(this.accyRiskNode.fetchTreeNode());
        }
        if (this.sipProductRisks != null) {
            treeNode.getChildren().add(new TreeNode(this.sipProductRisks.getSerno(), this.sipProductRisks, CompareEnum.NodeType.PRODUCT_MAIN_RISK));
        }
        return treeNode;
    }

    @Override
    public String detailNodeType() {
        return NodeType.N_RISK_DETAIL.code();
    }

    public AccyRiskNode getAccyRiskNode() {
        return this.accyRiskNode;
    }

    public void setAccyRiskNode(AccyRiskNode accyRiskNode) {
        this.accyRiskNode = accyRiskNode;
    }

    public SipProductRisks getSipProductRisks() {
        return this.sipProductRisks;
    }

    public void setSipProductRisks(SipProductRisks sipProductRisks) {
        this.sipProductRisks = sipProductRisks;
    }

    public String getProductUuid() {
        return this.productUuid;
    }

    public void setProductUuid(String productUuid) {
        this.productUuid = productUuid;
    }

    @Override
    public RateGroup getRateGroup() {
        return this.rateGroup;
    }

    @Override
    public void setRateGroup(RateGroup rateGroup) {
        this.rateGroup = rateGroup;
    }

    @Override
    public BenefitDemo getBenefitDemo() {
        return this.benefitDemo;
    }

    @Override
    public void setBenefitDemo(BenefitDemo benefitDemo) {
        this.benefitDemo = benefitDemo;
    }
}

