/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.propose;

import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;

public class RateDetail {
    private DsnStructure rateNode;
    private List<DsnStructure> rateDsnStructures;
    private List<DsnBizAttribute> rateBizAttributes;

    public RateDetail load(DsnStructure riskNode, String type) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.rateNode = utils.queryStructure(riskNode.getNodeNo(), type);
        this.rateBizAttributes = new ArrayList<DsnBizAttribute>();
        if (!StrUtils.isNull((Object)this.rateNode)) {
            this.rateDsnStructures = utils.queryStructures(this.rateNode.getNodeNo());
            for (DsnStructure dsn : this.rateDsnStructures) {
                this.rateBizAttributes.add(utils.queryBizAttribute(dsn.getRelateFk()));
            }
        }
        return this;
    }

    public void merge(RateDetail rateDetail) {
        this.rateBizAttributes = ProductEqualsUtils.merge(this.rateBizAttributes, rateDetail.getRateBizAttributes());
        this.rateNode = ProductEqualsUtils.merge(this.rateNode, rateDetail.getRateNode());
        this.rateDsnStructures = ProductEqualsUtils.merge(this.rateDsnStructures, rateDetail.getRateDsnStructures());
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        if (this.rateBizAttributes != null) {
            this.rateBizAttributes.forEach(m -> update.update((AbsModel)m));
        }
        if (this.rateNode != null) {
            update.update((AbsModel)this.rateNode);
        }
        if (this.rateDsnStructures != null) {
            this.rateDsnStructures.forEach(n -> update.update((AbsModel)n));
        }
    }

    public TreeNode fetchTreeNode(String type) {
        CompareEnum.NodeType nodeType = CompareEnum.NodeType.INPUT;
        if (type.equals(CompareEnum.NodeType.OUTPUT.getTag())) {
            nodeType = CompareEnum.NodeType.OUTPUT;
        }
        TreeNode node = new TreeNode(nodeType.getLable(), nodeType.getLable());
        if (this.rateNode != null) {
            node.getChildren().add(new TreeNode(this.rateNode.getSerno(), this.rateNode, CompareEnum.NodeType.STRUCTURE));
        }
        if (this.rateDsnStructures != null && this.rateDsnStructures.size() > 0) {
            TreeNode paramArray = new TreeNode(CompareEnum.NodeType.PARAM_ARRAY.getLable(), CompareEnum.NodeType.PARAM_ARRAY.getLable());
            node.getChildren().add(paramArray);
            for (DsnStructure dsnStructure : this.rateDsnStructures) {
                paramArray.getChildren().add(new TreeNode(dsnStructure.getSerno(), dsnStructure, CompareEnum.NodeType.PARAM_ITEM));
            }
        }
        if (this.rateBizAttributes != null && this.rateBizAttributes.size() > 0) {
            TreeNode bizArray = new TreeNode(CompareEnum.NodeType.BIZ_ATTRIBUTE_ARRAY.getLable(), CompareEnum.NodeType.BIZ_ATTRIBUTE_ARRAY.getLable());
            node.getChildren().add(bizArray);
            for (DsnBizAttribute dsnBizAttribute : this.rateBizAttributes) {
                bizArray.getChildren().add(new TreeNode(dsnBizAttribute.getSerno(), dsnBizAttribute, CompareEnum.NodeType.BIZ_ATTRIBUTE));
            }
        }
        return node;
    }

    public DsnStructure getRateNode() {
        return this.rateNode;
    }

    public void setRateNode(DsnStructure rateNode) {
        this.rateNode = rateNode;
    }

    public List<DsnStructure> getRateDsnStructures() {
        return this.rateDsnStructures;
    }

    public void setRateDsnStructures(List<DsnStructure> rateDsnStructures) {
        this.rateDsnStructures = rateDsnStructures;
    }

    public List<DsnBizAttribute> getRateBizAttributes() {
        return this.rateBizAttributes;
    }

    public void setRateBizAttributes(List<DsnBizAttribute> rateBizAttributes) {
        this.rateBizAttributes = rateBizAttributes;
    }
}

