/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.attribute;

import com.newtouch.nms.sip.model.DsnAttribute;
import com.newtouch.nms.sip.model.DsnAttributeOption;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.rule.Rule;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.List;

public class Attribute
implements Comparable {
    private DsnStructure attrStructure;
    private DsnBizAttribute bizAttribute;
    private List<DsnBizAttributeOption> bizAttributeOptions;
    private DsnAttribute attribute;
    private List<DsnAttributeOption> attributeOptions;
    private Rule rule;

    public Attribute load(String nodeNo) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.load(utils.queryStructure(nodeNo));
        return this;
    }

    public Attribute load(DsnStructure attrStructure) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        if (attrStructure == null || StrUtils.isNull((Object)attrStructure.getNodeNo())) {
            return this;
        }
        this.attrStructure = attrStructure;
        this.bizAttribute = utils.queryBizAttribute(this.attrStructure.getNodeNo());
        if (this.bizAttribute != null) {
            this.bizAttributeOptions = utils.queryBizAttributeOption(this.bizAttribute.getBizUuid());
            this.attributeOptions = utils.queryAttributeOption(this.bizAttribute.getAttrUuid());
        }
        this.rule = new Rule();
        this.rule.load(attrStructure.getNodeNo(), NodeType.N_RULE.code());
        return this;
    }

    public void merge(Attribute attr) {
        this.attrStructure = ProductEqualsUtils.merge(this.attrStructure, attr.getAttrStructure());
        this.bizAttribute = ProductEqualsUtils.merge(this.bizAttribute, attr.getBizAttribute());
        this.bizAttributeOptions = ProductEqualsUtils.merge(this.bizAttributeOptions, attr.getBizAttributeOptions());
        this.attribute = ProductEqualsUtils.merge(this.attribute, attr.getAttribute());
        this.attributeOptions = ProductEqualsUtils.merge(this.attributeOptions, attr.getAttributeOptions());
        this.rule = ProductEqualsUtils.merge(this.rule, attr.getRule(), Rule.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.attrStructure);
            update.update((AbsModel)this.bizAttribute);
            if (this.bizAttributeOptions != null) {
                this.bizAttributeOptions.forEach(a -> update.update((AbsModel)a));
            }
            update.update((AbsModel)this.attribute);
            if (this.attributeOptions != null) {
                this.attributeOptions.forEach(a -> update.update((AbsModel)a));
            }
        }
        if (this.rule != null) {
            this.rule.save();
        }
    }

    public TreeNode fetchTreeNode() {
        if (this.attrStructure == null) {
            return null;
        }
        TreeNode node = new TreeNode(CompareEnum.NodeType.ATTRIBUTE.getTag() + this.attrStructure.getSerno(), this.bizAttribute.getAttrName());
        node.getChildren().add(new TreeNode(this.attrStructure.getSerno(), this.attrStructure, CompareEnum.NodeType.STRUCTURE));
        if (this.bizAttribute != null) {
            node.getChildren().add(new TreeNode(this.bizAttribute.getSerno(), this.bizAttribute, CompareEnum.NodeType.BIZ_ATTRIBUTE));
        }
        if (this.bizAttributeOptions != null && this.bizAttributeOptions.size() > 0 && this.bizAttribute != null) {
            TreeNode bizAttributeOptions = new TreeNode(CompareEnum.NodeType.BIZ_ATTRIBUTE_PARAM_ARRAY.getTag() + this.bizAttribute.getSerno(), CompareEnum.NodeType.BIZ_ATTRIBUTE_PARAM_ARRAY.getLable());
            node.getChildren().add(bizAttributeOptions);
            this.bizAttributeOptions.forEach(a -> bizAttributeOptions.getChildren().add(new TreeNode(a.getSerno(), a, CompareEnum.NodeType.BIZ_ATTRIBUTE_PARAM)));
        }
        if (this.attribute != null) {
            node.getChildren().add(new TreeNode(this.attribute.getSerno(), this.attribute, CompareEnum.NodeType.ALL_ATTRIBUTE));
        }
        if (this.attributeOptions != null && this.attributeOptions.size() > 0 && this.attribute != null) {
            TreeNode attributeOptions = new TreeNode(CompareEnum.NodeType.ALL_ATTRIBUTE_PARAM_ARRAY.getTag() + this.attribute.getSerno(), CompareEnum.NodeType.ALL_ATTRIBUTE_PARAM_ARRAY.getLable());
            node.getChildren().add(attributeOptions);
            this.attributeOptions.forEach(a -> attributeOptions.getChildren().add(new TreeNode(a.getSerno(), a, CompareEnum.NodeType.ALL_ATTRIBUTE_PARAM)));
        }
        if (this.rule != null) {
            node.getChildren().add(this.rule.fetchTreeNode());
        }
        return node;
    }

    public DsnStructure getAttrStructure() {
        return this.attrStructure;
    }

    public void setAttrStructure(DsnStructure attrStructure) {
        this.attrStructure = attrStructure;
    }

    public DsnBizAttribute getBizAttribute() {
        return this.bizAttribute;
    }

    public void setBizAttribute(DsnBizAttribute bizAttribute) {
        this.bizAttribute = bizAttribute;
    }

    public List<DsnBizAttributeOption> getBizAttributeOptions() {
        return this.bizAttributeOptions;
    }

    public void setBizAttributeOptions(List<DsnBizAttributeOption> bizAttributeOptions) {
        this.bizAttributeOptions = bizAttributeOptions;
    }

    public DsnAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(DsnAttribute attribute) {
        this.attribute = attribute;
    }

    public List<DsnAttributeOption> getAttributeOptions() {
        return this.attributeOptions;
    }

    public void setAttributeOptions(List<DsnAttributeOption> attributeOptions) {
        this.attributeOptions = attributeOptions;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public int hashCode() {
        return this.attrStructure.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        if (!(o instanceof Attribute)) {
            return 1;
        }
        Attribute attr = (Attribute)o;
        ProductUpdateUtils.UpdateFlag thisFlag = (ProductUpdateUtils.UpdateFlag)((Object)this.getAttrStructure().getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        ProductUpdateUtils.UpdateFlag oFlag = (ProductUpdateUtils.UpdateFlag)((Object)attr.getAttrStructure().getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        System.out.println("====" + this.attrStructure.getNodeName() + "  " + (Object)((Object)thisFlag) + "   " + this.attrStructure.getOtherProperty("md5"));
        if (thisFlag == ProductUpdateUtils.UpdateFlag.D && oFlag != ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (thisFlag == ProductUpdateUtils.UpdateFlag.U && oFlag == ProductUpdateUtils.UpdateFlag.I) {
            return -1;
        }
        if (thisFlag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

