/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.structure.service.imp;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.structure.service.IStructureSearchService;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureSearchService
implements IStructureSearchService {
    @Autowired(required=false)
    private AbsModelRepository dao;

    @Override
    public DsnStructure getOneDsnBySerno(String serno) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.SERNO, (Object)serno);
        return (DsnStructure)this.dao.findOne((AbsModel)dsn);
    }

    @Override
    public DsnStructure getNodeInfo(String nodeNo) {
        DsnStructure dsnStructure4Query = new DsnStructure();
        dsnStructure4Query.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure4Query);
        return null == dsnStructure4Result ? null : dsnStructure4Result;
    }

    @Override
    public String getCurrentInfo(String nodeNo, String nodeType) {
        DsnStructure dsnStructure3Query = new DsnStructure();
        dsnStructure3Query.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure3Query.where().addEq(DsnStructure.NODE_TYPE, (Object)nodeType);
        DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure3Query);
        return null == dsnStructure4Result ? null : dsnStructure4Result.getNodeNo();
    }

    @Override
    public DsnStructure getOneDsnByNodeNo(String nodeNo) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        List queryList = this.dao.findAll((AbsModel)dsn);
        return (DsnStructure)queryList.get(0);
    }

    @Override
    public String getRiskuuidByNode(DsnStructure riskNode) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.UP_NODE, (Object)riskNode.getNodeNo());
        dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code());
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            return null;
        }
        return ((DsnStructure)queryList.get(0)).getNodeNo();
    }
}

