/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.publish.services.impl;

import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipProductsChannel;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.SysEnumConf;
import com.newtouch.nms.sip.product.main.services.IProductListQueryService;
import com.newtouch.nms.sip.product.publish.services.IProductPublishService;
import com.newtouch.nms.sip.vo.CancelPublishVo;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.util.date.DateUtil;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductPublishServiceImpl
implements IProductPublishService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IProductListQueryService productListQueryService;

    @Override
    public ReturnMsg channelList() {
        SysEnumConf sysEnum = new SysEnumConf();
        sysEnum.where().addEq(SysEnumConf.UP_ENUM, (Object)"channel_type");
        sysEnum.setOrderBy(new Sort.Order[]{SysEnumConf.ENUM_ORDER.asc()});
        List channelList = this.dao.findAll4Map((AbsModel)sysEnum);
        Return msg = new Return();
        msg.setDataList4includes(channelList, new String[]{"enum_no", "enum_name", "enum_code"});
        return msg.msg();
    }

    @Override
    public ReturnMsg publish(String productUuid, String channelNo, String startTime, String endTime, String deliveryPlatform) {
        Return msg = new Return();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channel_no", channelNo);
        param.put("start_time", startTime);
        param.put("delivery_platform", deliveryPlatform);
        Return check = this.checkParam(param);
        if (!check.isSuccessflag()) {
            return check.msg();
        }
        String[] channelContainArray = channelNo.split(",");
        String[] deliveryPlatformContainArray = deliveryPlatform.split(",");
        for (String channelContain : channelContainArray) {
            for (String deliveryContain : deliveryPlatformContainArray) {
                SipProductsChannel channel = (SipProductsChannel)SipProductsChannel.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
                channel.where().addEq(SipProductsChannel.CHANNEL_NO, (Object)channelContain);
                channel.where().addEq(SipProductsChannel.DELIVERY_PLATFORM, (Object)deliveryContain);
                channel.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)productUuid);
                channel.where().addGT(SipProductsChannel.END_DATE, startTime);
                List productsChannelsList = this.dao.findAll((AbsModel)channel);
                if (!productsChannelsList.isEmpty()) {
                    msg.setFailMsg("\u8be5\u4ea7\u54c1\u5df2\u7ecf\u5728\u9009\u62e9\u7684\u6e20\u9053\u4e2d\u53d1\u5e03,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                    return msg.msg();
                }
                SipProducts sipProducts = new SipProducts();
                sipProducts.setState("S");
                sipProducts.where().addEq(SipProducts.PRODUCT_UUID, (Object)productUuid);
                this.dao.update((AbsModel)sipProducts);
                SipProductsChannel sipProductsChannel = new SipProductsChannel();
                sipProductsChannel.setPrdChanlUuid(UUID.shortUUID());
                sipProductsChannel.setChannelNo(channelNo);
                sipProductsChannel.setProductUuid(productUuid);
                sipProductsChannel.setDeliveryPlatform(deliveryContain);
                sipProductsChannel.setStartDate(DateUtil.string2Date((Object)startTime));
                sipProductsChannel.setEndDate(DateUtil.string2Date((Object)endTime));
                SipProductsChannel channel2 = (SipProductsChannel)SipProductsChannel.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
                channel2.where().addEq(SipProductsChannel.CHANNEL_NO, (Object)channelContain);
                channel2.where().addEq(SipProductsChannel.DELIVERY_PLATFORM, (Object)deliveryContain);
                channel2.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)productUuid);
                List productsChannelsList2 = this.dao.findAll((AbsModel)channel2);
                if (!productsChannelsList2.isEmpty()) {
                    this.dao.delete(SipProductsChannel.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").addEq(SipProductsChannel.CHANNEL_NO, (Object)channelContain).addEq(SipProductsChannel.DELIVERY_PLATFORM, (Object)deliveryContain).addEq(SipProductsChannel.PRODUCT_UUID, (Object)productUuid).model());
                }
                this.dao.save((AbsModel)sipProductsChannel);
            }
        }
        return msg.msg();
    }

    private Return checkParam(Map<String, Object> param) {
        Return msg = new Return();
        String channelNo = StrUtils.trimStr((Object)param.get("channel_no"));
        String startTime = StrUtils.trimStr((Object)param.get("start_time"));
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        if (StrUtils.isNull((Object)channelNo)) {
            msg.setFailMsg("\u4ea7\u54c1\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!startTime.equals(DateUtil.date2String((Date)DateUtil.sysDate())) && DateUtil.dateBetween((Date)DateUtil.string2Date((Object)startTime), (Date)DateUtil.sysDate(), (DateUtil.DateType)DateUtil.DateType.DAY) == -1) {
            msg.setFailMsg("\u53d1\u5e03\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\uff01");
        }
        if (StrUtils.isNull((Object)deliveryPlatform)) {
            msg.setFailMsg("\u6295\u653e\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return msg;
    }

    private Return saveChannelInfo(String productUuid, String channelNo, String startTime, String endTime, String deliveryPlatform) {
        Return msg = new Return();
        SipProductsChannel sipProductsChannel = new SipProductsChannel();
        sipProductsChannel.setPrdChanlUuid(UUID.shortUUID());
        sipProductsChannel.setChannelNo(channelNo);
        sipProductsChannel.setProductUuid(productUuid);
        sipProductsChannel.setDeliveryPlatform(deliveryPlatform);
        sipProductsChannel.setStartDate(DateUtil.string2Date((Object)startTime));
        sipProductsChannel.setEndDate(DateUtil.string2Date((Object)endTime));
        if (!this.dao.findAll((AbsModel)sipProductsChannel).isEmpty()) {
            this.dao.delete((AbsModel)sipProductsChannel);
        }
        this.dao.save((AbsModel)sipProductsChannel);
        return msg;
    }

    @Override
    public ReturnMsg cancelPublish(CancelPublishVo cancelPublishVo) {
        Return msg = new Return();
        SipProductsChannel sip = new SipProductsChannel();
        String cancelDate = cancelPublishVo.getCancelDate();
        sip.setEndDate(DateUtil.string2Date((Object)cancelDate));
        sip.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)cancelPublishVo.getProductUuid());
        sip.where().addEq(SipProductsChannel.CHANNEL_NO, (Object)cancelPublishVo.getChannelNo());
        sip.where().addEq(SipProductsChannel.START_DATE, (Object)cancelPublishVo.getStartDate());
        if (!StrUtils.isNull((Object)cancelPublishVo.getDeliveryPlatform())) {
            sip.where().addEq(SipProductsChannel.DELIVERY_PLATFORM, (Object)cancelPublishVo.getDeliveryPlatform());
        }
        this.dao.update((AbsModel)sip);
        return msg.msg();
    }

    @Override
    public ReturnMsg publishList(String product_uuid, String deliveryPlatform) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)product_uuid)) {
            msg.setFailMsg("\u4ea7\u54c1\u7f16\u7801\u6216\u8005\u6295\u653e\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        Date date = new Date();
        String sql = "SELECT sys_enum_conf.enum_name, sip_products_channel.start_date, sip_products_channel.end_date, sip_products_channel.channel_no, sip_products_channel.delivery_platform from sys_enum_conf LEFT JOIN sip_products_channel on sys_enum_conf.enum_code = sip_products_channel.channel_no WHERE (sip_products_channel.product_uuid = ? ";
        ArrayList<String> searchParam = new ArrayList<String>();
        searchParam.add(product_uuid);
        if (!StrUtils.isNull((Object)deliveryPlatform)) {
            sql = sql + " and  sip_products_channel.delivery_platform = ? ";
            searchParam.add(deliveryPlatform);
        }
        sql = sql + ") and sys_enum_conf.up_enum = ? and sip_products_channel.end_date > ? ";
        searchParam.add("channel_type");
        searchParam.add(DateUtil.date2String((Date)date));
        List proList = this.dao.findAll(sql, SipProductsChannel.class, Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(searchParam)});
        msg.setDataList4includes(proList, SipProductsChannel.class, new String[]{"enum_name", "start_date", "channel_no", "delivery_platform"});
        return msg.msg();
    }

    @Override
    public ReturnMsg publishHistory(String product_uuid) {
        Return msg = new Return();
        Date date = new Date();
        SipProductsChannel sip = new SipProductsChannel();
        sip.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)product_uuid);
        sip.where().addLT(SipProductsChannel.END_DATE, DateUtils.date2String((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        List proList = this.dao.findAll((AbsModel)sip, Boolean.valueOf(true));
        ArrayList resultList = new ArrayList();
        proList.stream().forEach(productList -> {
            LinkedHashMap<String, Object> mapMainQuery = new LinkedHashMap<String, Object>();
            SysEnumConf sipChannel = new SysEnumConf();
            sipChannel.where().addEq(SysEnumConf.ENUM_CODE, (Object)productList.getChannelNo());
            sipChannel.where().addEq(SysEnumConf.UP_ENUM, (Object)"channel_type");
            SysEnumConf channelList = (SysEnumConf)this.dao.findOne((AbsModel)sipChannel);
            mapMainQuery.put("enum_name", channelList.getEnumName());
            mapMainQuery.put("start_date", productList.getStartDate());
            mapMainQuery.put("end_date", productList.getEndDate());
            mapMainQuery.put("delivery_platform", productList.getDeliveryPlatform());
            resultList.add(mapMainQuery);
        });
        msg.setDataList(resultList);
        return msg.msg();
    }
}

