/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.main.services.impl;

import com.newtouch.nms.sip.design.product.utils.NodeSeqUtils;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductDeleteServiceImpl {
    @Autowired
    private AbsModelRepository dao;

    public ReturnMsg deleteProducts(List<String> prdUuidList) {
        for (String string : prdUuidList) {
        }
        return null;
    }

    private ReturnMsg delPrd(String prdUuid) {
        return null;
    }

    private void queryChildNodeAndCopy(String upNode, String targetUpNodeSeq, Map<String, String> riskName) {
        List nodeList = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNode).model());
        if (nodeList.isEmpty()) {
            return;
        }
        for (DsnStructure node : nodeList) {
            String nodeNo = UUID.shortUUID();
            DsnStructure newNode = this.copyDsnStructure(node, nodeNo, riskName.get(node.getNodeNo()), targetUpNodeSeq + nodeNo + ".");
            switch (NodeType.valueOf((String)newNode.getNodeType().toUpperCase())) {
                case ATTR: 
                case ATTR_DETAIL: 
                case ATTR4RATE: {
                    ProductDeleteServiceImpl.dnsBizAttribute(node.getNodeNo(), null, newNode, this.dao);
                    break;
                }
                case MAIN_RISKS: {
                    newNode.setRelateTab("sip_product_risks");
                    newNode.setRelateField("serno");
                    newNode.setRelateFk(newNode.getSerno());
                    break;
                }
                case N_RISK_DETAIL: {
                    this.sipRisks(newNode);
                    break;
                }
                case ACCY_RISKS: 
                case SUB_RISKS: 
                case EXEMPT: {
                    this.sipRiskRelation(nodeNo, newNode);
                    break;
                }
                case RULE: {
                    newNode.setRelateTab("dsn_rules");
                    newNode.setRelateField("node_no");
                    newNode.setRelateFk(nodeNo);
                    break;
                }
                case N_RULE: {
                    break;
                }
                case N_RATE: {
                    break;
                }
                case N_BENEFIT: {
                    break;
                }
                case PRD_DETAIL: {
                    break;
                }
                case N_RISK: {
                    break;
                }
                case N_RISK_ATTR: {
                    break;
                }
                case N_ACCY_RISKS: {
                    break;
                }
                case N_EXEMPT: {
                    break;
                }
                case N_SUB_RISKS: {
                    break;
                }
                case N_TBR: {
                    break;
                }
                case N_BBR: {
                    break;
                }
                case N_SYR: {
                    break;
                }
            }
            this.dao.save((AbsModel)newNode);
            this.queryChildNodeAndCopy(node.getNodeNo(), newNode.getNodeSeq(), riskName);
        }
    }

    private void sipRisks(DsnStructure newNode) {
        newNode.setRelateTab("sip_risks");
        newNode.setRelateField("risk_uuid");
        newNode.setRelateFk(newNode.getNodeNo());
        SipRisks risk = new SipRisks();
        risk.setRiskUuid(newNode.getNodeNo());
        risk.setRiskName(newNode.getNodeName());
        this.dao.save((AbsModel)risk);
        ProductDeleteServiceImpl.saveRiskRelation(newNode, this.dao);
    }

    public static void saveRiskRelation(DsnStructure node, AbsModelRepository dao) {
        List relationList = dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)node.getUpNode()).model());
        SipRiskRelation srr = SipRiskRelation.n();
        HashMap<String, Object> nodeSernoMap = new HashMap<String, Object>();
        for (Object ds : relationList) {
            nodeSernoMap.put(ds.getSerno(), ds);
            srr.where().addIn(SipRiskRelation.SERNO, new String[]{ds.getSerno()});
        }
        List srrList = dao.findAll((AbsModel)srr);
        for (SipRiskRelation aSrr : srrList) {
            nodeSernoMap.remove(aSrr.getSerno());
        }
        Collection dsnList = nodeSernoMap.values();
        for (DsnStructure dsn : dsnList) {
            node.setNodeNo(dsn.getNodeSeq() + node.getNodeNo() + ".");
            ProductDeleteServiceImpl.saveRelation(dsn.getSerno(), node, dao);
        }
    }

    private static void saveRelation(String serno, DsnStructure node, AbsModelRepository dao) {
        boolean isMainRiks;
        String[] nodeSeqArray = node.getNodeSeq().split("\\.");
        boolean bl = isMainRiks = nodeSeqArray.length == 4;
        if (isMainRiks) {
            SipProductRisks spr = SipProductRisks.n();
            spr.setSerno(serno);
            spr.setProductUuid(NodeSeqUtils.getProductUuid(node.getNodeSeq()));
            spr.setRiskUuid(node.getNodeNo());
            dao.save((AbsModel)spr);
            return;
        }
        SipRiskRelation srr = SipRiskRelation.n();
        srr.setSerno(serno);
        srr.setRiskUuid(nodeSeqArray[nodeSeqArray.length - 1]);
        String mainRiks = NodeSeqUtils.getMainRiskUuid4DetailNode(node.getNodeSeq());
        String relationType = NodeSeqUtils.getRelationType(node.getNodeSeq());
        if (relationType.equals("EXEMPT4ACC")) {
            mainRiks = NodeSeqUtils.getAccyRiskUuid(node.getNodeSeq());
        }
        srr.setMainRisk(mainRiks);
        srr.setRelationType(relationType);
        dao.save((AbsModel)srr);
    }

    public static void dnsBizAttribute(String bizUuid, String attrUuid, DsnStructure newNode, AbsModelRepository dao) {
        newNode.setRelateTab("dsn_biz_attribute");
        newNode.setRelateField("biz_uuid");
        newNode.setRelateFk(newNode.getNodeNo());
        DsnBizAttribute attrWhere = DsnBizAttribute.n();
        if (!StrUtils.isNull((Object)bizUuid)) {
            attrWhere.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)bizUuid);
        }
        if (!StrUtils.isNull((Object)attrUuid)) {
            attrWhere.where().addEq(DsnBizAttribute.ATTR_UUID, (Object)attrUuid);
        }
        DsnBizAttribute attr = (DsnBizAttribute)dao.findOne((AbsModel)attrWhere);
        String oldBizUuid = attr.getBizUuid();
        attr.setSerno(null);
        attr.setBizUuid(newNode.getNodeNo());
        dao.save((AbsModel)attr);
        List optionList = dao.findAll(DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)oldBizUuid).model());
        optionList.forEach(opt -> {
            opt.setSerno(null);
            opt.setBizUuid(attr.getBizUuid());
        });
        dao.save(optionList);
    }

    private void sipRiskRelation(String nodeNo, DsnStructure newNode) {
        newNode.setRelateTab("sip_risk_relation");
        newNode.setRelateField("serno");
        newNode.setRelateFk(newNode.getSerno());
    }

    private DsnStructure copyDsnStructure(DsnStructure source, String nodeNo, String nodeName, String nodeSeq) {
        DsnStructure target = DsnStructure.n();
        BeanUtils.copyProperties((Object)source, (Object)target);
        target.setSerno(UUID.shortUUID());
        if (!StrUtils.isNull((Object)nodeNo)) {
            target.setNodeNo(nodeNo);
        }
        if (!StrUtils.isNull((Object)nodeName)) {
            target.setNodeName(nodeName);
        }
        if (!StrUtils.isNull((Object)nodeSeq)) {
            target.setNodeSeq(nodeSeq);
        }
        return target;
    }
}

