/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.main.services.impl;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.main.services.IProductAddService;
import com.newtouch.nms.sip.product.main.services.IProductCopyService;
import com.newtouch.nms.sys.model.SysTreeMenu;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductAddServiceImpl
implements IProductAddService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IProductCopyService copyService;

    @Override
    public ReturnMsg addTemplate(String productName) {
        DsnStructure structure = new DsnStructure();
        structure.setNodeName(productName);
        String node_no = UUID.shortUUID();
        structure.setNodeNo(node_no);
        structure.setNodeType("prd");
        structure.setUpNode("prd_root");
        structure.setNodeSeq(node_no + ".");
        DsnStructure newStructure = new DsnStructure();
        newStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)"prd");
        newStructure.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.desc()});
        List dsnList = this.dao.findAll((AbsModel)newStructure);
        String display_order = "0";
        if (null != dsnList && !dsnList.isEmpty()) {
            display_order = StrUtils.trimStr((Object)((DsnStructure)dsnList.get(0)).getDisplayOrder());
        }
        int display = Integer.parseInt(display_order);
        structure.setDisplayOrder(Integer.valueOf(++display));
        this.dao.save((AbsModel)structure);
        SipProducts product = new SipProducts();
        product.setProductUuid(node_no);
        product.setProductNo("");
        product.setProductName(productName);
        product.setState("S");
        product.setIsMaster("Y");
        this.dao.save((AbsModel)product);
        Return r = this.saveChildNode(structure);
        r.getDataTable().put("node_no", node_no);
        return r.msg();
    }

    private Return saveChildNode(DsnStructure ds) {
        Return r = new Return();
        List<DsnStructure> nextNodeList = this.queryChildNode(ds.getNodeType(), ds.getNodeNo(), ds.getNodeSeq());
        if (!nextNodeList.isEmpty()) {
            this.dao.save(nextNodeList);
            for (DsnStructure dsNew : nextNodeList) {
                r = this.saveChildNode(dsNew);
            }
        }
        return r;
    }

    private List<DsnStructure> queryChildNode(String node_type, String node_no, String node_seq) {
        SysTreeMenu queryNode = new SysTreeMenu();
        queryNode.where().addEq(SysTreeMenu.UP_MENU, (Object)node_type);
        queryNode.where().addEq(SysTreeMenu.MENU_TYPE, (Object)"node");
        queryNode.setOrderBy(new Sort.Order[]{SysTreeMenu.DISPLAY_ORDER.asc()});
        List<DsnStructure> nextNodeList = this.dao.findAll((AbsModel)queryNode, Boolean.valueOf(false)).stream().map(node -> {
            DsnStructure nextNode = new DsnStructure();
            nextNode.setNodeNo(UUID.shortUUID());
            nextNode.setNodeName(node.getMenuName());
            nextNode.setNodeType(node.getNodeType());
            nextNode.setUpNode(node_no);
            nextNode.setDisplayOrder(node.getDisplayOrder());
            nextNode.setNodeSeq(node_seq + nextNode.getNodeNo() + ".");
            return nextNode;
        }).collect(Collectors.toList());
        return nextNodeList;
    }

    @Override
    public ReturnMsg addProduct4Template(String sourceNodeNo, String targetPrdName, Map<String, String> riskName) {
        SipProducts products = this.copyService.copyProduct(sourceNodeNo, targetPrdName, riskName);
        Return msg = new Return();
        String nodeNo = "";
        if (products != null) {
            nodeNo = products.getProductUuid();
        }
        msg.getDataTable().put("node_no", nodeNo);
        return msg.msg();
    }

    @Override
    public ReturnMsg addMainRisk4Template(String addType, String sourceNodeNo, String targetPrdName, Map<String, String> riskName, String mainRiskUuid, String accyRisksNodeNo) {
        SipRisks sipRisks = this.copyService.copyRisk(addType, sourceNodeNo, targetPrdName, riskName, mainRiskUuid, accyRisksNodeNo);
        Return msg = new Return();
        String nodeNo = "";
        if (sipRisks != null) {
            nodeNo = sipRisks.getRiskUuid();
        }
        msg.getDataTable().put("node_no", nodeNo);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRisksName(String nodeNo) {
        Return r = new Return();
        List mainRiskList = this.dao.findAll((AbsModel)((DsnStructure)DsnStructure.n().where().addLikeR(DsnStructure.NODE_SEQ, (Object)nodeNo).addLikeR(DsnStructure.NODE_TYPE, (Object)"main_risks").model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
        if (mainRiskList.isEmpty()) {
            return r.msg();
        }
        String main_risks_name = "";
        String accy_risks_name = "";
        String exempt_risks_name1 = "";
        String exempt_risks_name2 = "";
        for (DsnStructure mainRisk : mainRiskList) {
            main_risks_name = main_risks_name + mainRisk.getNodeName() + ",";
            String no = mainRisk.getNodeNo();
            List<DsnStructure> accyRiskList = this.queryRisk(mainRisk.getNodeNo(), "accy_risks");
            for (DsnStructure accyRisk : accyRiskList) {
                accy_risks_name = accy_risks_name + accyRisk.getNodeName() + ",";
                List<DsnStructure> exemptRiskList = this.queryRisk(accyRisk.getNodeNo(), "n_main_exempt");
                for (DsnStructure exemptRisk : exemptRiskList) {
                    exempt_risks_name1 = exempt_risks_name1 + exemptRisk.getNodeName() + ",";
                }
            }
            List<DsnStructure> exemptRiskList = this.queryRisk(mainRisk.getNodeNo(), "n_main_exempt");
            for (DsnStructure exemptRisk : exemptRiskList) {
                String[] nodeSeqs = exemptRisk.getNodeSeq().split("\\.");
                if (nodeSeqs.length != 5) continue;
                exempt_risks_name2 = exempt_risks_name2 + exemptRisk.getNodeName() + ",";
            }
        }
        if (!StrUtils.isNull((Object)main_risks_name)) {
            r.getDataTable().put("main_risks_name", main_risks_name.subSequence(0, main_risks_name.length() - 1));
        }
        if (!StrUtils.isNull((Object)accy_risks_name)) {
            r.getDataTable().put("accy_risks_name", accy_risks_name.subSequence(0, accy_risks_name.length() - 1));
        }
        if (!StrUtils.isNull((Object)exempt_risks_name1)) {
            r.getDataTable().put("exempt_risks_name1", exempt_risks_name1.subSequence(0, exempt_risks_name1.length() - 1));
        }
        if (!StrUtils.isNull((Object)exempt_risks_name2)) {
            r.getDataTable().put("exempt_risks_name2", exempt_risks_name2.subSequence(0, exempt_risks_name2.length() - 1));
        }
        return r.msg();
    }

    private List<DsnStructure> queryRisk(String nodeNo, String nodeType) {
        return this.dao.findAll((AbsModel)((DsnStructure)DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)nodeNo).addEq(DsnStructure.NODE_TYPE, (Object)nodeType).model()).setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()}));
    }

    @Override
    public ReturnMsg queryProductName(String productName) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.NODE_NAME, (Object)productName);
        dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.PRD.code());
        dsn.setOrderBy(new Sort.Order[]{DsnStructure.DISPLAY_ORDER.asc()});
        List dsnList = this.dao.findAll((AbsModel)dsn);
        Return r = new Return();
        if (dsnList != null && !dsnList.isEmpty()) {
            r.setFailMsg("\u8be5\u4ea7\u54c1\u540d\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u5f55\u5165");
        }
        if (productName.length() > 32) {
            r.setFailMsg("\u4ea7\u54c1\u540d\u79f0\u5df2\u8d85\u8fc732\u4e2a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
        }
        return r.msg();
    }
}

